/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsButCurrentAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseCurrentSQLResultTabAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleCurrentSQLResultTabStickyAction;
import net.sourceforge.squirrel_sql.client.session.event.IResultTabListener;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.event.ResultTabEvent;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecuter;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultFrame;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTabListener;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetMetaDataDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeClob;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IntegerIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLExecutionException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLResultExecuterPanel
extends JPanel
implements ISQLResultExecuter {
    static final long serialVersionUID = 6961615570741567740L;
    private static final ILogger s_log = LoggerController.createLogger(SQLResultExecuterPanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLResultExecuterPanel.class);
    private ISession _session;
    private MyPropertiesListener _propsListener;
    private JTabbedPane _tabbedExecutionsPanel;
    private Map<IIdentifier, ResultTabInfo> _allTabs = new HashMap<IIdentifier, ResultTabInfo>();
    private ArrayList<ResultTabInfo> _usedTabs = new ArrayList();
    private EventListenerList _listeners = new EventListenerList();
    private IntegerIdentifierFactory _idFactory = new IntegerIdentifierFactory();
    private IResultTab _stickyTab;
    private SquirrelPreferences _prefs = null;
    private SQLExecuterTask _executer;

    public SQLResultExecuterPanel(ISession session) {
        this.setSession(session);
        this.createGUI();
        this.propertiesHaveChanged(null);
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("SQLResultExecuterPanel.title");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public synchronized void setSession(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this.sessionClosing();
        this._session = session;
        this._prefs = this._session.getApplication().getSquirrelPreferences();
        this._propsListener = new MyPropertiesListener();
        this._session.getProperties().addPropertyChangeListener(this._propsListener);
    }

    public ISession getSession() {
        return this._session;
    }

    public synchronized void addSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLExecutionListener == null");
        }
        this._listeners.add(ISQLExecutionListener.class, lis);
    }

    public synchronized void removeSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLExecutionListener == null");
        }
        this._listeners.remove(ISQLExecutionListener.class, lis);
    }

    public synchronized void addResultTabListener(IResultTabListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("IResultTabListener == null");
        }
        this._listeners.add(IResultTabListener.class, lis);
    }

    public synchronized void removeResultTabListener(IResultTabListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("IResultTabListener == null");
        }
        this._listeners.remove(IResultTabListener.class, lis);
    }

    @Override
    public void execute(ISQLEntryPanel sqlPanel) {
        String sql = sqlPanel.getSQLToBeExecuted();
        if (sql != null && sql.length() > 0) {
            this.executeSQL(sql);
        } else {
            String msg = s_stringMgr.getString("SQLResultExecuterPanel.nosqlselected");
            this._session.showErrorMessage(msg);
        }
    }

    public void executeSQL(String sql) {
        if (sql != null && sql.trim().length() > 0) {
            String origSQL = sql;
            if ((sql = this.fireSQLToBeExecutedEvent(sql)) == null) {
                s_log.info((Object)("executeSQL: An ISQLExecutionListener veto'd execution of the following SQL: " + origSQL));
                return;
            }
            ISQLExecutionListener[] executionListeners = (ISQLExecutionListener[])this._listeners.getListeners(ISQLExecutionListener.class);
            SQLExecutionHandler handler = new SQLExecutionHandler(null);
            this._executer = new SQLExecuterTask(this._session, sql, handler, executionListeners);
            if (this._prefs.getLargeScriptStmtCount() > 0 && this._executer.getQueryCount() > this._prefs.getLargeScriptStmtCount()) {
                this._executer.setExecutionListeners(new ISQLExecutionListener[0]);
                handler.setLargeScript(true);
            }
            this._session.getApplication().getThreadPool().addTask((Runnable)this._executer);
        }
    }

    private void onRerunSQL(String sql, IResultTab resultTab) {
        this._executer = new SQLExecuterTask(this._session, sql, new SQLExecutionHandler(resultTab), new ISQLExecutionListener[0]);
        this._session.getApplication().getThreadPool().addTask((Runnable)this._executer);
    }

    public synchronized void closeAllSQLResultFrames() {
        ArrayList<ResultTabInfo> tabs = new ArrayList<ResultTabInfo>(this._usedTabs);
        for (ResultTabInfo ti : tabs) {
            if (ti._resultFrame == null) continue;
            ti._resultFrame.dispose();
            ti._resultFrame = null;
        }
    }

    public synchronized void closeAllSQLResultTabs() {
        ArrayList<ResultTabInfo> tabs = new ArrayList<ResultTabInfo>(this._usedTabs);
        for (ResultTabInfo ti : tabs) {
            if (ti._resultFrame != null) continue;
            this.closeTab(ti._tab);
        }
    }

    public synchronized void closeAllButCurrentResultTabs() {
        Component selectedTab = this._tabbedExecutionsPanel.getSelectedComponent();
        ArrayList<ResultTabInfo> tabs = new ArrayList<ResultTabInfo>(this._usedTabs);
        for (ResultTabInfo ti : tabs) {
            if (ti._tab.equals(selectedTab) || ti._resultFrame != null) continue;
            this.closeTab(ti._tab);
        }
    }

    public synchronized void toggleCurrentSQLResultTabSticky() {
        if (null != this._stickyTab) {
            if (this._stickyTab.equals(this._tabbedExecutionsPanel.getSelectedComponent())) {
                this._stickyTab = null;
                this._tabbedExecutionsPanel.setIconAt(this._tabbedExecutionsPanel.getSelectedIndex(), null);
                return;
            }
            int indexOfStickyTab = this.getIndexOfTab(this._stickyTab);
            if (-1 != indexOfStickyTab) {
                this._tabbedExecutionsPanel.setIconAt(indexOfStickyTab, null);
            }
            this._stickyTab = null;
        }
        if (!(this._tabbedExecutionsPanel.getSelectedComponent() instanceof IResultTab)) {
            String msg = s_stringMgr.getString("SQLResultExecuterPanel.nonStickyPanel");
            JOptionPane.showMessageDialog(this._session.getApplication().getMainFrame(), msg);
            return;
        }
        this._stickyTab = (IResultTab)((Object)this._tabbedExecutionsPanel.getSelectedComponent());
        int selectedIndex = this._tabbedExecutionsPanel.getSelectedIndex();
        ImageIcon icon = this.getStickyIcon();
        this._tabbedExecutionsPanel.setIconAt(selectedIndex, icon);
    }

    private ImageIcon getStickyIcon() {
        ActionCollection actionCollection = this._session.getApplication().getActionCollection();
        ImageIcon icon = (ImageIcon)actionCollection.get(ToggleCurrentSQLResultTabStickyAction.class).getValue("SmallIcon");
        return icon;
    }

    private int getIndexOfTab(IResultTab resultTab) {
        if (null == resultTab) {
            return -1;
        }
        for (int i = 0; i < this._tabbedExecutionsPanel.getTabCount(); ++i) {
            if (!resultTab.equals(this._tabbedExecutionsPanel.getComponentAt(i))) continue;
            return i;
        }
        return -1;
    }

    public synchronized void closeCurrentResultTab() {
        Component selectedTab = this._tabbedExecutionsPanel.getSelectedComponent();
        ArrayList<ResultTabInfo> tabs = new ArrayList<ResultTabInfo>(this._usedTabs);
        for (ResultTabInfo ti : tabs) {
            if (!ti._tab.equals(selectedTab) || ti._resultFrame != null) continue;
            this.closeTab(ti._tab);
        }
    }

    void sessionClosing() {
        if (this._propsListener != null) {
            this._session.getProperties().removePropertyChangeListener(this._propsListener);
            this._propsListener = null;
        }
        this.closeAllSQLResultFrames();
    }

    public void closeTab(ResultTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null ResultTab passed");
        }
        s_log.debug((Object)("SQLPanel.closeTab(" + tab.getIdentifier().toString() + ")"));
        tab.clear();
        this._tabbedExecutionsPanel.remove(tab);
        ResultTabInfo tabInfo = this._allTabs.get(tab.getIdentifier());
        this._usedTabs.remove(tabInfo);
        tabInfo._resultFrame = null;
        this.fireTabRemovedEvent(tab);
    }

    public void gotoNextResultsTab() {
        int tabCount = this._tabbedExecutionsPanel.getTabCount();
        if (tabCount > 1) {
            int nextTabIdx = this._tabbedExecutionsPanel.getSelectedIndex() + 1;
            if (nextTabIdx >= tabCount) {
                nextTabIdx = 0;
            }
            this._tabbedExecutionsPanel.setSelectedIndex(nextTabIdx);
        }
    }

    public void gotoPreviousResultsTab() {
        int tabCount = this._tabbedExecutionsPanel.getTabCount();
        if (tabCount > 1) {
            int prevTabIdx = this._tabbedExecutionsPanel.getSelectedIndex() - 1;
            if (prevTabIdx < 0) {
                prevTabIdx = tabCount - 1;
            }
            this._tabbedExecutionsPanel.setSelectedIndex(prevTabIdx);
        }
    }

    protected void fireTabAddedEvent(IResultTab tab) {
        Object[] listeners = this._listeners.getListenerList();
        ResultTabEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IResultTabListener.class) continue;
            if (evt == null) {
                evt = new ResultTabEvent(this._session, tab);
            }
            ((IResultTabListener)listeners[i + 1]).resultTabAdded(evt);
        }
    }

    protected void fireTabRemovedEvent(IResultTab tab) {
        Object[] listeners = this._listeners.getListenerList();
        ResultTabEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IResultTabListener.class) continue;
            if (evt == null) {
                evt = new ResultTabEvent(this._session, tab);
            }
            ((IResultTabListener)listeners[i + 1]).resultTabRemoved(evt);
        }
    }

    protected void fireTabTornOffEvent(IResultTab tab) {
        Object[] listeners = this._listeners.getListenerList();
        ResultTabEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IResultTabListener.class) continue;
            if (evt == null) {
                evt = new ResultTabEvent(this._session, tab);
            }
            ((IResultTabListener)listeners[i + 1]).resultTabTornOff(evt);
        }
    }

    protected void fireTornOffResultTabReturned(IResultTab tab) {
        Object[] listeners = this._listeners.getListenerList();
        ResultTabEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IResultTabListener.class) continue;
            if (evt == null) {
                evt = new ResultTabEvent(this._session, tab);
            }
            ((IResultTabListener)listeners[i + 1]).tornOffResultTabReturned(evt);
        }
    }

    protected String fireSQLToBeExecutedEvent(String sql) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0 && (listeners[i] != ISQLExecutionListener.class || (sql = ((ISQLExecutionListener)listeners[i + 1]).statementExecuting(sql)) != null); i -= 2) {
        }
        return sql;
    }

    public void createWindow(ResultTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null ResultTab passed");
        }
        s_log.debug((Object)("SQLPanel.createWindow(" + tab.getIdentifier().toString() + ")"));
        this._tabbedExecutionsPanel.remove(tab);
        ResultFrame frame = new ResultFrame(this._session, tab);
        ResultTabInfo tabInfo = this._allTabs.get(tab.getIdentifier());
        tabInfo._resultFrame = frame;
        this._session.getApplication().getMainFrame().addWidget(frame);
        frame.setLayer(JLayeredPane.PALETTE_LAYER);
        this.fireTabTornOffEvent(tab);
        if (!this._session.getApplication().getDesktopStyle().supportsLayers()) {
            frame.pack();
            DialogWidget.centerWithinDesktop(frame);
        }
        frame.setVisible(true);
        frame.toFront();
        frame.requestFocus();
    }

    public void returnToTabbedPane(ResultTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null ResultTab passed");
        }
        s_log.debug((Object)("SQLPanel.returnToTabbedPane(" + tab.getIdentifier().toString() + ")"));
        ResultTabInfo tabInfo = this._allTabs.get(tab.getIdentifier());
        if (tabInfo._resultFrame != null) {
            this.addResultsTab(tab, null);
            this.fireTornOffResultTabReturned(tab);
            tabInfo._resultFrame = null;
        }
    }

    @Override
    public IResultTab getSelectedResultTab() {
        return (IResultTab)((Object)this._tabbedExecutionsPanel.getSelectedComponent());
    }

    public void reRunSelectedResultTab(boolean readFully) {
        boolean clobReadOrigVal = DataTypeClob.getReadCompleteClob();
        if (readFully) {
            DataTypeClob.setReadCompleteClob((boolean)true);
        }
        IResultTab rt = (IResultTab)((Object)this._tabbedExecutionsPanel.getSelectedComponent());
        rt.reRunSQL();
        if (readFully) {
            DataTypeClob.setReadCompleteClob((boolean)clobReadOrigVal);
        }
    }

    private void addResultsTab(final SQLExecutionInfo exInfo, final ResultSetDataSet rsds, final ResultSetMetaDataDataSet mdds, final JPanel cancelPanel, final IDataSetUpdateableTableModel creator, final IResultTab resultTabToReplace) {
        final ResultTabListener resultTabListener = new ResultTabListener(){

            @Override
            public void rerunSQL(String sql, IResultTab resultTab) {
                SQLResultExecuterPanel.this.onRerunSQL(sql, resultTab);
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ResultTab tab = new ResultTab(SQLResultExecuterPanel.this._session, SQLResultExecuterPanel.this, SQLResultExecuterPanel.this._idFactory.createIdentifier(), exInfo, creator, resultTabListener);
                    ResultTabInfo ti = new ResultTabInfo(tab);
                    SQLResultExecuterPanel.this._allTabs.put(tab.getIdentifier(), ti);
                    SQLResultExecuterPanel.this._usedTabs.add(ti);
                    s_log.debug((Object)("Created new tab " + tab.getIdentifier().toString() + " for results."));
                    tab.showResults(rsds, mdds, exInfo);
                    SQLResultExecuterPanel.this._tabbedExecutionsPanel.remove(cancelPanel);
                    SQLResultExecuterPanel.this.addResultsTab(tab, resultTabToReplace);
                    SQLResultExecuterPanel.this._tabbedExecutionsPanel.setSelectedComponent(tab);
                    SQLResultExecuterPanel.this.fireTabAddedEvent(tab);
                }
                catch (Throwable t) {
                    SQLResultExecuterPanel.this._session.showErrorMessage(t);
                }
            }
        });
    }

    private void addResultsTab(ResultTab tab, IResultTab resultTabToReplace) {
        if (null == resultTabToReplace && null == this._stickyTab) {
            this._tabbedExecutionsPanel.addTab(tab.getTitle(), null, tab, tab.getViewableSqlString());
            this.checkResultTabLimit();
        } else {
            TableState sortableTableState;
            if (null != resultTabToReplace && this._session.getProperties().getKeepTableLayoutOnRerun() && null != (sortableTableState = resultTabToReplace.getResultSortableTableState())) {
                tab.applyResultSortableTableState(sortableTableState);
            }
            int indexToReplace = -1;
            ImageIcon tabIcon = null;
            if (null != resultTabToReplace && this._stickyTab != resultTabToReplace) {
                indexToReplace = this.getIndexOfTab(resultTabToReplace);
            } else {
                indexToReplace = this.getIndexOfTab(this._stickyTab);
                if (-1 == indexToReplace) {
                    this._stickyTab = null;
                } else {
                    tabIcon = this.getStickyIcon();
                    this._stickyTab = tab;
                }
            }
            if (-1 == indexToReplace) {
                this.addResultsTab(tab, null);
                return;
            }
            this.closeResultTabAt(indexToReplace);
            this._tabbedExecutionsPanel.insertTab(tab.getTitle(), tabIcon, tab, tab.getViewableSqlString(), indexToReplace);
        }
    }

    private void checkResultTabLimit() {
        SessionProperties props = this._session.getProperties();
        while (props.getLimitSQLResultTabs() && props.getSqlResultTabLimit() < this._tabbedExecutionsPanel.getTabCount()) {
            this.closeResultTabAt(0);
        }
    }

    private void closeResultTabAt(int index) {
        Component selectedTab = this._tabbedExecutionsPanel.getComponentAt(index);
        ArrayList<ResultTabInfo> tabs = new ArrayList<ResultTabInfo>(this._usedTabs);
        for (ResultTabInfo ti : tabs) {
            if (!ti._tab.equals(selectedTab) || ti._resultFrame != null) continue;
            this.closeTab(ti._tab);
        }
    }

    private void propertiesHaveChanged(String propName) {
        SessionProperties props = this._session.getProperties();
        if (propName == null || propName.equals("autoCommit")) {
            SetAutoCommitTask task = new SetAutoCommitTask();
            if (SwingUtilities.isEventDispatchThread()) {
                this._session.getApplication().getThreadPool().addTask((Runnable)task);
            } else {
                task.run();
            }
        }
        if (propName == null || propName.equals("sqlExecutionTabPlacement")) {
            this._tabbedExecutionsPanel.setTabPlacement(props.getSQLExecutionTabPlacement());
        }
    }

    private void createGUI() {
        SessionProperties props = this._session.getProperties();
        this._tabbedExecutionsPanel = UIFactory.getInstance().createTabbedPane(props.getSQLExecutionTabPlacement());
        this.createTabPopup();
        this.setLayout(new BorderLayout());
        this.add((Component)this._tabbedExecutionsPanel, "Center");
    }

    private void createTabPopup() {
        final JPopupMenu popup = new JPopupMenu();
        String closeLabel = s_stringMgr.getString("SQLResultExecuterPanel.close");
        JMenuItem mnuClose = new JMenuItem(closeLabel);
        this.initAccelerator(CloseCurrentSQLResultTabAction.class, mnuClose);
        mnuClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLResultExecuterPanel.this.closeCurrentResultTab();
            }
        });
        popup.add(mnuClose);
        String cabtLabel = s_stringMgr.getString("SQLResultExecuterPanel.closeAllButThis");
        JMenuItem mnuCloseAllButThis = new JMenuItem(cabtLabel);
        this.initAccelerator(CloseAllSQLResultTabsButCurrentAction.class, mnuCloseAllButThis);
        mnuCloseAllButThis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLResultExecuterPanel.this.closeAllButCurrentResultTabs();
            }
        });
        popup.add(mnuCloseAllButThis);
        String caLabel = s_stringMgr.getString("SQLResultExecuterPanel.closeAll");
        JMenuItem mnuCloseAll = new JMenuItem(caLabel);
        this.initAccelerator(CloseAllSQLResultTabsAction.class, mnuCloseAll);
        mnuCloseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLResultExecuterPanel.this.closeAllSQLResultTabs();
            }
        });
        popup.add(mnuCloseAll);
        String tsLabel = s_stringMgr.getString("SQLResultExecuterPanel.toggleSticky");
        JMenuItem mnuToggleSticky = new JMenuItem(tsLabel);
        this.initAccelerator(ToggleCurrentSQLResultTabStickyAction.class, mnuToggleSticky);
        mnuToggleSticky.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLResultExecuterPanel.this.toggleCurrentSQLResultTabSticky();
            }
        });
        popup.add(mnuToggleSticky);
        this._tabbedExecutionsPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SQLResultExecuterPanel.this.maybeShowPopup(e, popup);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SQLResultExecuterPanel.this.maybeShowPopup(e, popup);
            }
        });
    }

    private void initAccelerator(Class<? extends Action> actionClass, JMenuItem mnuItem) {
        Action action = this._session.getApplication().getActionCollection().get(actionClass);
        String accel = (String)action.getValue("SQuirreLAcceleratorString");
        if (null != accel && 0 != accel.trim().length()) {
            mnuItem.setAccelerator(KeyStroke.getKeyStroke(accel));
        }
    }

    private void maybeShowPopup(MouseEvent e, JPopupMenu popup) {
        int tab;
        if (e.isPopupTrigger() && -1 != (tab = this._tabbedExecutionsPanel.getUI().tabForCoordinate(this._tabbedExecutionsPanel, e.getX(), e.getY()))) {
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private SQLType getSQLType(String sql) {
        SQLType result = SQLType.UNKNOWN;
        if (sql.toLowerCase().startsWith("insert")) {
            result = SQLType.INSERT;
        }
        if (sql.toLowerCase().startsWith("update")) {
            result = SQLType.UPDATE;
        }
        if (sql.toLowerCase().startsWith("select")) {
            result = SQLType.SELECT;
        }
        if (sql.toLowerCase().startsWith("delete")) {
            result = SQLType.DELETE;
        }
        return result;
    }

    private static final class ResultTabInfo {
        final ResultTab _tab;
        ResultFrame _resultFrame;

        ResultTabInfo(ResultTab tab) {
            if (tab == null) {
                throw new IllegalArgumentException("Null ResultTab passed");
            }
            this._tab = tab;
        }
    }

    private class MyPropertiesListener
    implements PropertyChangeListener {
        private boolean _listening = true;

        private MyPropertiesListener() {
        }

        void stopListening() {
            this._listening = false;
        }

        void startListening() {
            this._listening = true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this._listening) {
                SQLResultExecuterPanel.this.propertiesHaveChanged(evt.getPropertyName());
            }
        }
    }

    private class SQLExecutionHandler
    implements ISQLExecuterHandler {
        private CancelPanel _cancelPanel = new CancelPanel();
        private ResultSetDataSet rsds = null;
        private String sqlToBeExecuted = null;
        private SQLType sqlType = null;
        private IResultTab _resultTabToReplace;
        private boolean _largeScript = false;
        private double _scriptTotalTime = 0.0;
        private double _scriptQueryTime = 0.0;
        private double _scriptOutptutTime = 0.0;
        private int _scriptRowsInserted = 0;
        private int _scriptRowsSelected = 0;
        private int _scriptRowsUpdated = 0;
        private int _scriptRowsDeleted = 0;

        public SQLExecutionHandler(IResultTab resultTabToReplace) {
            this._resultTabToReplace = resultTabToReplace;
            this.setCancelPanel(this._cancelPanel);
        }

        public void setLargeScript(boolean aBoolean) {
            this._largeScript = aBoolean;
        }

        private boolean shouldRenderSQL(int current, int total) {
            if (!this._largeScript) {
                return true;
            }
            boolean result = true;
            if (total > 200 && current > 100 && current % 10 != 0) {
                result = false;
            }
            if (total > 1000 && current > 500 && current % 50 != 0) {
                result = false;
            }
            if (total > 2000 && current > 1000 && current % 100 != 0) {
                result = false;
            }
            return result;
        }

        @Override
        public void sqlToBeExecuted(String sql) {
            String cleanSQL;
            this._cancelPanel.incCurrentQueryIndex();
            int currentStmtCount = this._cancelPanel.getCurrentQueryIndex();
            if (!this.shouldRenderSQL(currentStmtCount, this._cancelPanel.getTotalCount())) {
                return;
            }
            this.sqlToBeExecuted = cleanSQL = StringUtilities.cleanString((String)sql);
            this.sqlType = SQLResultExecuterPanel.this.getSQLType(cleanSQL);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SQLExecutionHandler.this._cancelPanel.setSQL(SQLExecutionHandler.this.sqlToBeExecuted);
                    String status = s_stringMgr.getString("SQLResultExecuterPanel.execStatus");
                    SQLExecutionHandler.this._cancelPanel.setStatusLabel(status);
                }
            });
        }

        @Override
        public void sqlExecutionComplete(SQLExecutionInfo exInfo, int processedStatementCount, int statementCount) {
            double executionLength = (double)exInfo.getSQLExecutionElapsedMillis() / 1000.0;
            double outputLength = (double)exInfo.getResultsProcessingElapsedMillis() / 1000.0;
            double totalLength = executionLength + outputLength;
            Integer numberResultRowsRead = exInfo.getNumberResultRowsRead();
            if (this._largeScript) {
                this._scriptQueryTime += executionLength;
                this._scriptOutptutTime += outputLength;
                this._scriptTotalTime += totalLength;
                if (statementCount == processedStatementCount) {
                    this.printScriptExecDetails(statementCount, this._scriptQueryTime, this._scriptOutptutTime, this._scriptTotalTime);
                }
            } else {
                this.printStatementExecTime(processedStatementCount, statementCount, numberResultRowsRead, executionLength, outputLength, totalLength);
            }
        }

        private void printScriptExecDetails(int statementCount, double executionLength, double outputLength, double totalLength) {
            NumberFormat nbrFmt = NumberFormat.getNumberInstance();
            Object[] args = new Object[]{statementCount, nbrFmt.format(totalLength), nbrFmt.format(executionLength), nbrFmt.format(outputLength)};
            String stats = s_stringMgr.getString("SQLResultExecuterPanel.scriptQueryStatistics", args);
            String[] counts = new String[]{Integer.toString(this._scriptRowsInserted), Integer.toString(this._scriptRowsSelected), Integer.toString(this._scriptRowsUpdated), Integer.toString(this._scriptRowsDeleted)};
            String msg = s_stringMgr.getString("SQLResultExecuterPanel.scriptStmtCounts", counts);
            SQLResultExecuterPanel.this.getSession().showMessage(msg);
            SQLResultExecuterPanel.this.getSession().showMessage(stats);
        }

        private void printStatementExecTime(int processedStatementCount, int statementCount, Integer numberResultRowsRead, double executionLength, double outputLength, double totalLength) {
            NumberFormat nbrFmt = NumberFormat.getNumberInstance();
            Object[] args = new Object[]{processedStatementCount, statementCount, numberResultRowsRead == null ? 0 : numberResultRowsRead, nbrFmt.format(totalLength), nbrFmt.format(executionLength), nbrFmt.format(outputLength)};
            String stats = s_stringMgr.getString("SQLResultExecuterPanel.queryStatistics", args);
            SQLResultExecuterPanel.this.getSession().showMessage(stats);
        }

        @Override
        public void sqlExecutionCancelled() {
            if (this.rsds != null) {
                this.rsds.cancelProcessing();
            }
        }

        @Override
        public void sqlDataUpdated(int updateCount) {
            Integer count = updateCount;
            String msg = "";
            switch (this.sqlType) {
                case INSERT: {
                    if (this._largeScript) {
                        ++this._scriptRowsInserted;
                        break;
                    }
                    msg = s_stringMgr.getString("SQLResultExecuterPanel.rowsInserted", new Object[]{count});
                    break;
                }
                case SELECT: {
                    if (this._largeScript) {
                        ++this._scriptRowsSelected;
                        break;
                    }
                    msg = s_stringMgr.getString("SQLResultExecuterPanel.rowsSelected", new Object[]{count});
                    break;
                }
                case UPDATE: {
                    if (this._largeScript) {
                        ++this._scriptRowsUpdated;
                        break;
                    }
                    msg = s_stringMgr.getString("SQLResultExecuterPanel.rowsUpdated", new Object[]{count});
                    break;
                }
                case DELETE: {
                    if (this._largeScript) {
                        ++this._scriptRowsDeleted;
                        break;
                    }
                    msg = s_stringMgr.getString("SQLResultExecuterPanel.rowsDeleted", new Object[]{count});
                }
            }
            if (this._largeScript) {
                return;
            }
            SQLResultExecuterPanel.this.getSession().showMessage(msg);
        }

        @Override
        public void sqlResultSetAvailable(ResultSet rs, SQLExecutionInfo info, IDataSetUpdateableTableModel model) throws DataSetException {
            String outputStatus = s_stringMgr.getString("SQLResultExecuterPanel.outputStatus");
            this._cancelPanel.setStatusLabel(outputStatus);
            this.rsds = new ResultSetDataSet();
            SessionProperties props = SQLResultExecuterPanel.this.getSession().getProperties();
            ResultSetMetaDataDataSet rsmdds = null;
            if (props.getShowResultsMetaData()) {
                rsmdds = new ResultSetMetaDataDataSet(rs);
            }
            DialectType dialectType = DialectFactory.getDialectType((ISQLDatabaseMetaData)SQLResultExecuterPanel.this.getSession().getMetaData());
            info.setNumberResultRowsRead(this.rsds.setResultSet(rs, dialectType));
            SQLResultExecuterPanel.this.addResultsTab(info, this.rsds, rsmdds, this._cancelPanel, model, this._resultTabToReplace);
            this.rsds = null;
        }

        @Override
        public void sqlExecutionWarning(SQLWarning warn) {
            SQLResultExecuterPanel.this.getSession().showMessage(warn);
        }

        @Override
        public void sqlStatementCount(int statementCount) {
            this._cancelPanel.setQueryCount(statementCount);
        }

        @Override
        public void sqlCloseExecutionHandler() {
            this.removeCancelPanel(this._cancelPanel);
            SQLResultExecuterPanel.this._executer = null;
        }

        @Override
        public void sqlExecutionException(Throwable th, String postErrorString) {
            SQLExecutionException ex = new SQLExecutionException(th, postErrorString);
            String message = SQLResultExecuterPanel.this.getSession().formatException((Throwable)ex);
            SQLResultExecuterPanel.this.getSession().showErrorMessage(message);
            if (SQLResultExecuterPanel.this.getSession().getProperties().getWriteSQLErrorsToLog()) {
                s_log.info((Object)message);
            }
        }

        private void removeCancelPanel(final JPanel cancelPanel) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SQLResultExecuterPanel.this._tabbedExecutionsPanel.remove(cancelPanel);
                    int indexToSelect = -1;
                    indexToSelect = null == SQLExecutionHandler.this._resultTabToReplace ? SQLResultExecuterPanel.this.getIndexOfTab(SQLResultExecuterPanel.this._stickyTab) : SQLResultExecuterPanel.this.getIndexOfTab(SQLExecutionHandler.this._resultTabToReplace);
                    if (-1 != indexToSelect) {
                        SQLResultExecuterPanel.this._tabbedExecutionsPanel.setSelectedIndex(indexToSelect);
                    }
                }
            });
        }

        private void setCancelPanel(final JPanel panel) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SQLResultExecuterPanel.this._tabbedExecutionsPanel.addTab(i18n.EXEC_SQL_MSG, null, panel, i18n.CANCEL_SQL_MSG);
                    SQLResultExecuterPanel.this._tabbedExecutionsPanel.setSelectedComponent(panel);
                }
            });
        }

        private final class CancelPanel
        extends JPanel
        implements ActionListener {
            private static final long serialVersionUID = 1L;
            private JLabel _sqlLbl;
            private JLabel _currentStatusLbl;
            private int _queryCount;
            private int _currentQueryIndex;

            private CancelPanel() {
                super(new GridBagLayout());
                this._sqlLbl = new JLabel();
                this._currentStatusLbl = new JLabel();
                this._currentQueryIndex = 0;
                String label = s_stringMgr.getString("SQLResultExecuterPanel.cancelButtonLabel");
                JButton cancelBtn = new JButton(label);
                cancelBtn.addActionListener(this);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.insets = new Insets(5, 10, 5, 10);
                gbc.gridx = 0;
                gbc.gridy = 0;
                label = s_stringMgr.getString("SQLResultExecuterPanel.sqlLabel");
                this.add((Component)new JLabel(label), gbc);
                gbc.weightx = 1.0;
                ++gbc.gridx;
                this.add((Component)this._sqlLbl, gbc);
                gbc.weightx = 0.0;
                gbc.gridx = 0;
                ++gbc.gridy;
                label = s_stringMgr.getString("SQLResultExecuterPanel.statusLabel");
                this.add((Component)new JLabel(label), gbc);
                ++gbc.gridx;
                this.add((Component)this._currentStatusLbl, gbc);
                gbc.gridx = 0;
                ++gbc.gridy;
                gbc.fill = 0;
                this.add((Component)cancelBtn, gbc);
            }

            public void incCurrentQueryIndex() {
                ++this._currentQueryIndex;
            }

            public void setSQL(String sql) {
                String label = s_stringMgr.getString("SQLResultExecuterPanel.currentSQLLabel", new Object[]{String.valueOf(this._currentQueryIndex), String.valueOf(this._queryCount), sql});
                this._sqlLbl.setText(label);
            }

            public void setStatusLabel(String text) {
                this._currentStatusLbl.setText(text);
            }

            public void setQueryCount(int value) {
                this._queryCount = value;
                this._currentQueryIndex = 0;
            }

            public int getTotalCount() {
                return this._queryCount;
            }

            public int getCurrentQueryIndex() {
                return this._currentQueryIndex;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (SQLResultExecuterPanel.this._executer != null) {
                        SQLResultExecuterPanel.this._executer.cancel();
                    }
                }
                catch (Throwable th) {
                    s_log.error((Object)"Error occured cancelling SQL", th);
                }
            }
        }
    }

    private class SetAutoCommitTask
    implements Runnable {
        private SetAutoCommitTask() {
        }

        @Override
        public void run() {
            ISQLConnection conn = SQLResultExecuterPanel.this._session.getSQLConnection();
            SessionProperties props = SQLResultExecuterPanel.this._session.getProperties();
            if (conn != null) {
                boolean auto = true;
                try {
                    auto = conn.getAutoCommit();
                }
                catch (SQLException ex) {
                    s_log.error((Object)"Error with transaction control", (Throwable)ex);
                    SQLResultExecuterPanel.this._session.showErrorMessage(ex);
                }
                try {
                    conn.setAutoCommit(props.getAutoCommit());
                }
                catch (SQLException ex) {
                    props.setAutoCommit(auto);
                    SQLResultExecuterPanel.this._session.showErrorMessage(ex);
                }
            }
        }
    }

    private static enum SQLType {
        INSERT,
        SELECT,
        UPDATE,
        DELETE,
        UNKNOWN;

    }

    static interface i18n {
        public static final String EXEC_SQL_MSG = SQLResultExecuterPanel.access$000().getString("SQLResultExecuterPanel.exec");
        public static final String CANCEL_SQL_MSG = SQLResultExecuterPanel.access$000().getString("SQLResultExecuterPanel.cancelMsg");
    }
}

