/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeModel;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ObjectTreeCellRenderer
extends DefaultTreeCellRenderer {
    private ObjectTreeModel _model;
    private ISession _session;
    private JPanel _pnlFilterRootNodeRendererComponent;
    private JLabel _filterHint;
    GridBagConstraints _gbcLeft = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
    GridBagConstraints _gbcRight = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);

    public ObjectTreeCellRenderer(ObjectTreeModel model, ISession session) {
        this._model = model;
        this._session = session;
        this._session.getProperties().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ObjectTreeCellRenderer.this.onPropertyChanged(evt);
            }
        });
        this.initFilter();
        this._pnlFilterRootNodeRendererComponent = new JPanel(new GridBagLayout());
    }

    private void onPropertyChanged(PropertyChangeEvent evt) {
        if ("objectFilterInclude".equals(evt.getPropertyName()) || "objectFilterExclude".equals(evt.getPropertyName())) {
            this.initFilter();
        }
    }

    private void initFilter() {
        String objectFilterInclude = this._session.getProperties().getObjectFilterInclude();
        String objectFilterExclude = this._session.getProperties().getObjectFilterExclude();
        String filterhint = "";
        if (!StringUtilities.isEmpty((String)objectFilterInclude)) {
            filterhint = filterhint + "Inc:" + objectFilterInclude;
        }
        if (!StringUtilities.isEmpty((String)objectFilterExclude)) {
            filterhint = 0 == filterhint.length() ? filterhint + "Exc:" + objectFilterExclude : filterhint + "; Exc:" + objectFilterExclude;
        }
        if (0 < filterhint.length()) {
            this._filterHint = new JLabel(filterhint);
            SquirrelResources rsrc = this._session.getApplication().getResources();
            ImageIcon icon = rsrc.getIcon("filter");
            this._filterHint.setIcon(icon);
        } else {
            this._filterHint = null;
        }
        this._model.nodeChanged(this._model.getRootObjectTreeNode());
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel ret = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (null != this._filterHint && this._model.isRootNode(value)) {
            this._pnlFilterRootNodeRendererComponent.removeAll();
            this._pnlFilterRootNodeRendererComponent.setBackground(new Color(255, 204, 204));
            this._pnlFilterRootNodeRendererComponent.add((Component)ret, this._gbcLeft);
            this._pnlFilterRootNodeRendererComponent.add(ret);
            this._pnlFilterRootNodeRendererComponent.add((Component)this._filterHint, this._gbcRight);
            this._pnlFilterRootNodeRendererComponent.add(this._filterHint);
            return this._pnlFilterRootNodeRendererComponent;
        }
        return ret;
    }
}

