/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.IndexParentInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.IndexInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class IndexParentExpander
implements INodeExpander {
    private static final ILogger s_log = LoggerController.createLogger(IndexParentExpander.class);
    private ITableIndexExtractor extractor = null;

    public void setTableIndexExtractor(ITableIndexExtractor extractor) {
        this.extractor = extractor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        IDatabaseObjectInfo tableInfo = ((IndexParentInfo)parentDbinfo).getTableInfo();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = this.extractor.getTableIndexQuery();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Running query for index extraction: " + query));
            }
            pstmt = conn.prepareStatement(query);
            this.extractor.bindParamters(pstmt, tableInfo);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString(1);
                String cat = parentDbinfo.getCatalogName();
                String schema = parentDbinfo.getSchemaName();
                String tableName = tableInfo.getSimpleName();
                String columnName = null;
                boolean nonUnique = true;
                String indexQualifier = null;
                IndexInfo.IndexType indexType = null;
                short ordinalPosition = 0;
                IndexInfo.SortOrder sortOrder = null;
                int cardinality = 0;
                int pages = 0;
                String filterCondition = null;
                IndexInfo doi = new IndexInfo(cat, schema, indexName, tableName, columnName, nonUnique, indexQualifier, indexType, ordinalPosition, sortOrder, cardinality, pages, filterCondition, (ISQLDatabaseMetaData)md);
                childNodes.add(new ObjectTreeNode(session, (IDatabaseObjectInfo)doi));
            }
        }
        catch (SQLException e) {
            try {
                session.showErrorMessage(e);
                s_log.error((Object)("Unexpected exception while extracting indexes for parent dbinfo: " + parentDbinfo), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs, (boolean)true);
                throw throwable;
            }
            SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
        }
        SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
        return childNodes;
    }
}

