/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;

public class ProcedureTypeExpander
implements INodeExpander {
    @Override
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        String catalogName = parentDbinfo.getCatalogName();
        String schemaName = parentDbinfo.getSchemaName();
        return this.createProcedureNodes(session, catalogName, schemaName);
    }

    private List<ObjectTreeNode> createProcedureNodes(ISession session, String catalogName, String schemaName) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        session.getSchemaInfo().waitTillStoredProceduresLoaded();
        IProcedureInfo[] procs = session.getSchemaInfo().getStoredProceduresInfos(catalogName, schemaName, new ObjFilterMatcher(session.getProperties()));
        for (int i = 0; i < procs.length; ++i) {
            ObjectTreeNode child = new ObjectTreeNode(session, (IDatabaseObjectInfo)procs[i]);
            childNodes.add(child);
        }
        return childNodes;
    }
}

