/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TableTypeExpander
implements INodeExpander {
    private static ILogger s_log = LoggerController.createLogger(TableTypeExpander.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        Statement stmt = null;
        try {
            String[] stringArray;
            IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
            ISQLConnection conn = session.getSQLConnection();
            String catalogName = parentDbinfo.getCatalogName();
            String schemaName = parentDbinfo.getSchemaName();
            String tableType = parentDbinfo.getSimpleName();
            if (tableType != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = tableType;
            } else {
                stringArray = null;
            }
            String[] types = stringArray;
            session.getSchemaInfo().waitTillTablesLoaded();
            ITableInfo[] tables = session.getSchemaInfo().getITableInfos(catalogName, schemaName, new ObjFilterMatcher(session.getProperties()), types);
            if (session.getProperties().getShowRowCount()) {
                stmt = conn.createStatement();
            }
            for (int i = 0; i < tables.length; ++i) {
                ObjectTreeNode child = new ObjectTreeNode(session, (IDatabaseObjectInfo)tables[i]);
                child.setUserObject(this.getNodeDisplayText(stmt, (IDatabaseObjectInfo)tables[i]));
                childNodes.add(child);
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeStatement(stmt);
            throw throwable;
        }
        SQLUtilities.closeStatement((Statement)stmt);
        return childNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNodeDisplayText(Statement rowCountStmt, IDatabaseObjectInfo dbinfo) {
        if (rowCountStmt != null) {
            String string;
            ResultSet rs = rowCountStmt.executeQuery("select count(*) from " + dbinfo.getQualifiedName());
            try {
                long nbrRows = 0L;
                if (rs.next()) {
                    nbrRows = rs.getLong(1);
                }
                StringBuilder buf = new StringBuilder(dbinfo.getSimpleName());
                buf.append(" (").append(nbrRows).append(")");
                string = buf.toString();
            }
            catch (Throwable throwable) {
                try {
                    SQLUtilities.closeResultSet((ResultSet)rs);
                    throw throwable;
                }
                catch (SQLException ex) {
                    s_log.error((Object)("Error retrieving row count for: " + dbinfo.getQualifiedName()), (Throwable)ex);
                    return dbinfo.getSimpleName();
                }
            }
            SQLUtilities.closeResultSet((ResultSet)rs);
            return string;
        }
        return dbinfo.getSimpleName();
    }
}

