/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs;

import java.awt.Component;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseObjectTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetScrollingPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class BaseDataSetTab
extends BaseObjectTab {
    private static final ILogger s_log = LoggerController.createLogger(BaseDataSetTab.class);
    private DataSetScrollingPanel _comp;

    @Override
    public synchronized Component getComponent() {
        if (this._comp == null) {
            try {
                IDataSetUpdateableModel modelReference = null;
                try {
                    if (Class.forName("net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel").isAssignableFrom(this.getClass())) {
                        modelReference = (IDataSetUpdateableModel)this;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._comp = new DataSetScrollingPanel(this.getDestinationClassName(), modelReference);
            }
            catch (Exception ex) {
                s_log.error((Object)"Error", (Throwable)ex);
            }
        }
        return this._comp;
    }

    @Override
    public void rebuild() {
        super.rebuild();
        this._comp = null;
    }

    @Override
    public void clear() {
        ((DataSetScrollingPanel)this.getComponent()).clear();
    }

    @Override
    public synchronized void refreshComponent() throws DataSetException {
        ISession session = this.getSession();
        if (session == null) {
            throw new IllegalStateException("Null ISession");
        }
        this._app.getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                try {
                    ((DataSetScrollingPanel)BaseDataSetTab.this.getComponent()).load(BaseDataSetTab.this.createDataSet());
                }
                catch (DataSetException e) {
                    s_log.error((Object)"", (Throwable)e);
                }
            }
        });
    }

    protected abstract IDataSet createDataSet() throws DataSetException;

    protected String getDestinationClassName() {
        return this.getSession().getProperties().getMetaDataOutputClassName();
    }
}

