/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourcePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.LineNumber;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class BaseSourceTab
extends BaseObjectTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(BaseSourceTab.class);
    private static final ILogger s_log = LoggerController.createLogger(BaseSourceTab.class);
    private final String _hint;
    private String _title;
    private BaseSourcePanel _comp;
    private JScrollPane _scroller;

    public BaseSourceTab(String hint) {
        this(null, hint);
    }

    public BaseSourceTab(String title, String hint) {
        this._title = title != null ? title : s_stringMgr.getString("BaseSourceTab.title");
        this._hint = hint != null ? hint : this._title;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public String getHint() {
        return this._hint;
    }

    @Override
    public void clear() {
    }

    @Override
    public Component getComponent() {
        if (this._scroller == null) {
            if (this._comp == null) {
                this._comp = new DefaultSourcePanel();
            }
            this._scroller = new JScrollPane(this._comp);
            LineNumber lineNumber = new LineNumber(this._comp);
            this._scroller.setRowHeaderView(lineNumber);
            this._scroller.getVerticalScrollBar().setUnitIncrement(10);
        }
        return this._scroller;
    }

    public void setSourcePanel(BaseSourcePanel panel) {
        this._comp = panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshComponent() {
        ISession session = this.getSession();
        if (session == null) {
            throw new IllegalStateException("Null ISession");
        }
        try {
            PreparedStatement pstmt = this.createStatement();
            try {
                this._comp.load(this.getSession(), pstmt);
            }
            finally {
                SQLUtilities.closeStatement((Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            s_log.error((Object)ex);
            session.showErrorMessage(ex);
        }
    }

    protected abstract PreparedStatement createStatement() throws SQLException;

    private final class DefaultSourcePanel
    extends BaseSourcePanel {
        private static final long serialVersionUID = 1L;
        private JTextArea _ta;

        DefaultSourcePanel() {
            super(new BorderLayout());
            this.createUserInterface();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(ISession session, PreparedStatement stmt) {
            this._ta.setText("");
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery();
                StringBuffer buf = new StringBuffer(4096);
                while (rs.next()) {
                    buf.append(rs.getString(1));
                }
                this._ta.setText(buf.toString());
                this._ta.setCaretPosition(0);
            }
            catch (SQLException ex) {
                session.showErrorMessage(ex);
            }
            finally {
                SQLUtilities.closeResultSet((ResultSet)rs);
            }
        }

        private void createUserInterface() {
            this._ta = new JTextArea();
            this._ta.setEditable(false);
            this.add((Component)this._ta, "Center");
        }
    }
}

