/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourcePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourceTab;
import net.sourceforge.squirrel_sql.fw.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.fw.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.fw.codereformat.ICodeReformator;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class FormattedSourceTab
extends BaseSourceTab {
    private static final ILogger s_log = LoggerController.createLogger(FormattedSourceTab.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FormattedSourceTab.class);
    private ICodeReformator formatter = null;
    private boolean compressWhitespace = true;
    private CommentSpec[] commentSpecs = new CommentSpec[]{new CommentSpec("/*", "*/"), new CommentSpec("--", "\n")};
    protected String statementSeparator = null;
    protected boolean appendSeparator = true;

    public FormattedSourceTab(String hint) {
        super(hint);
        super.setSourcePanel(new FormattedSourcePanel());
    }

    protected void setupFormatter(String stmtSep, CommentSpec[] commentSpecs) {
        if (commentSpecs != null) {
            this.commentSpecs = commentSpecs;
        }
        this.statementSeparator = stmtSep;
        this.formatter = new CodeReformator(stmtSep, this.commentSpecs);
    }

    protected void setupFormatter(ICodeReformator codeReformator, String stmtSep, CommentSpec[] commentSpecs) {
        if (commentSpecs != null) {
            this.commentSpecs = commentSpecs;
        }
        this.statementSeparator = stmtSep;
        this.formatter = codeReformator;
    }

    protected void setCompressWhitespace(boolean compressWhitespace) {
        this.compressWhitespace = compressWhitespace;
    }

    protected String processResult(StringBuilder buf) {
        return buf.toString();
    }

    private String format(String toFormat) {
        String result = toFormat;
        try {
            result = this.formatter.reformat(toFormat);
        }
        catch (IllegalStateException e) {
            s_log.error((Object)("format: Formatting SQL failed: " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    @Override
    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        ISQLConnection conn = session.getSQLConnection();
        String sqlStatement = this.getSqlStatement();
        String[] bindValues = this.getBindValues();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Running SQL for index source tab: " + sqlStatement));
            s_log.debug((Object)"With the following bind variable values: ");
            int parameterIndex = 1;
            for (String bindValue : bindValues) {
                s_log.debug((Object)("[" + parameterIndex++ + "] => '" + bindValue + "'"));
            }
        }
        PreparedStatement pstmt = conn.prepareStatement(sqlStatement);
        int parameterIndex = 1;
        for (String bindValue : bindValues) {
            pstmt.setString(parameterIndex++, bindValue);
        }
        return pstmt;
    }

    protected abstract String getSqlStatement();

    protected String[] getBindValues() {
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        return new String[]{doi.getSchemaName(), doi.getSimpleName()};
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private final class FormattedSourcePanel
    extends BaseSourcePanel {
        private static final long serialVersionUID = 1L;
        private JTextArea _ta;

        FormattedSourcePanel() {
            super(new BorderLayout());
            this._ta = new JTextArea();
            this._ta.setEditable(false);
            this.add((Component)this._ta, "Center");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(ISession session, PreparedStatement stmt) {
            this._ta.setText("");
            this._ta.setWrapStyleWord(true);
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery();
                StringBuilder buf = new StringBuilder(4096);
                while (rs.next()) {
                    String line = rs.getString(1);
                    if (line == null) {
                        s_log.debug((Object)"load: Null object source line; skipping...");
                        continue;
                    }
                    if (FormattedSourceTab.this.compressWhitespace) {
                        buf.append(line.trim() + " ");
                        continue;
                    }
                    buf.append(line);
                }
                if (FormattedSourceTab.this.appendSeparator) {
                    buf.append("\n");
                    buf.append(FormattedSourceTab.this.statementSeparator);
                }
                String processedResult = FormattedSourceTab.this.processResult(buf);
                if (FormattedSourceTab.this.formatter != null && buf.length() != 0) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Object source code before formatting: " + processedResult));
                    }
                    this._ta.setText(FormattedSourceTab.this.format(processedResult));
                } else {
                    if (buf.length() == 0) {
                        buf.append(i18n.NO_SOURCE_AVAILABLE);
                    }
                    this._ta.setText(processedResult);
                }
                this._ta.setCaretPosition(0);
                this._ta.setTabSize(4);
            }
            catch (Exception ex) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Unexpected exception while formatting object source code", (Throwable)ex);
                }
                session.showErrorMessage(ex);
            }
            finally {
                SQLUtilities.closeResultSet((ResultSet)rs);
            }
        }
    }

    static interface i18n {
        public static final String NO_SOURCE_AVAILABLE = FormattedSourceTab.access$000().getString("FormatterSourceTab.noSourceAvailable");
    }
}

