/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database;

import java.sql.Connection;
import java.util.Date;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseDataSetTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.JavabeanDataSet;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ConnectionStatusTab
extends BaseDataSetTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConnectionStatusTab.class);

    @Override
    public String getTitle() {
        return s_stringMgr.getString("ConnectionStatusTab.title");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("ConnectionStatusTab.hint");
    }

    @Override
    protected IDataSet createDataSet() throws DataSetException {
        ISession session = this.getSession();
        ISQLConnection conn = session.getSQLConnection();
        return new JavabeanDataSet((Object)new ConnectionInfo(conn, session));
    }

    public static final class ConnectionInfo {
        private String _catalog;
        private boolean _isReadOnly;
        private boolean _isClosed;
        private boolean _autoCommit;
        private Date _timeOpened;
        private String _transIsol;

        ConnectionInfo(ISQLConnection conn, ISession session) {
            Connection jdbcConn = conn.getConnection();
            try {
                this._isClosed = jdbcConn.isClosed();
            }
            catch (Throwable th) {
                session.showErrorMessage(th);
            }
            try {
                this._isReadOnly = jdbcConn.isReadOnly();
            }
            catch (Throwable th) {
                session.showErrorMessage(th);
            }
            try {
                this._catalog = conn.getCatalog();
            }
            catch (Throwable th) {
                session.showErrorMessage(th);
            }
            try {
                this._autoCommit = conn.getAutoCommit();
            }
            catch (Throwable th) {
                session.showErrorMessage(th);
            }
            try {
                int isol = jdbcConn.getTransactionIsolation();
                switch (isol) {
                    case 0: {
                        this._transIsol = "TRANSACTION_NONE";
                        break;
                    }
                    case 2: {
                        this._transIsol = "TRANSACTION_READ_COMMITTED";
                        break;
                    }
                    case 1: {
                        this._transIsol = "TRANSACTION_READ_UNCOMMITTED";
                        break;
                    }
                    case 4: {
                        this._transIsol = "TRANSACTION_REPEATABLE_READ";
                        break;
                    }
                    case 8: {
                        this._transIsol = "TRANSACTION_SERIALIZABLE";
                        break;
                    }
                    default: {
                        this._transIsol = "Unknown: " + isol;
                        break;
                    }
                }
            }
            catch (Throwable th) {
                session.showErrorMessage(th);
            }
            this._timeOpened = conn.getTimeOpened();
        }

        public String getCatalog() {
            return this._catalog;
        }

        public boolean isReadOnly() {
            return this._isReadOnly;
        }

        public boolean isClosed() {
            return this._isClosed;
        }

        public boolean getAutoCommit() {
            return this._autoCommit;
        }

        public Date getTimeOpened() {
            return this._timeOpened;
        }

        public String getTransactionisolationLevel() {
            return this._transIsol;
        }
    }
}

