/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTableCellEditor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTableModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTablePopupHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.gui.SortableTable;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;

public class DataScaleTable
extends SortableTable {
    private List<Object[]> _allRows;
    private ColumnDisplayDefinition[] _columnDefinitions;
    private DataScaleTable _parent;
    private DataScaleTable _kid;
    private DataSetViewerTablePanel _kidSimpleTable;

    public DataScaleTable(DataScaleTableModel dataScaleTableModel, List<Object[]> allRows, ColumnDisplayDefinition[] columnDefinitions) {
        super((TableModel)dataScaleTableModel);
        this._allRows = allRows;
        this._columnDefinitions = columnDefinitions;
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
        new DataScaleTablePopupHandler(this);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        String headerValue = (String)this.getColumnModel().getColumn(column).getHeaderValue();
        if (DataScaleTableModel.COL_NAME_COLUMN.equals(headerValue)) {
            return super.getCellRenderer(row, column);
        }
        DataScaleTableModel model = this.getDataScaleTableModel();
        return this.createScaleDataCellRenderer(model);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        String headerValue = (String)this.getColumnModel().getColumn(column).getHeaderValue();
        if (DataScaleTableModel.COL_NAME_COLUMN.equals(headerValue)) {
            return super.getCellEditor(row, column);
        }
        DataScaleTableModel model = this.getDataScaleTableModel();
        SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
        return new DataScaleTableCellEditor(model.getDataScaleAt(sortableTableModel.transfromToModelRow(row)));
    }

    DataScaleTableModel getDataScaleTableModel() {
        TableModel ret = ((SortableTableModel)this.getModel()).getActualModel();
        while (ret instanceof SortableTableModel) {
            ret = ((SortableTableModel)ret).getActualModel();
        }
        return (DataScaleTableModel)ret;
    }

    private TableCellRenderer createScaleDataCellRenderer(final DataScaleTableModel dataScaleTableModel) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                SortableTableModel sortableTableModel = (SortableTableModel)DataScaleTable.this.getModel();
                return dataScaleTableModel.getDataScaleAt(sortableTableModel.transfromToModelRow(row)).getPanel();
            }
        };
    }

    public List<Object[]> getAllRows() {
        return this._allRows;
    }

    public ColumnDisplayDefinition[] getColumnDisplayDefinitions() {
        return this._columnDefinitions;
    }

    public void setParentScaleTable(DataScaleTable parent) {
        TableState st = new TableState((JTable)((Object)parent));
        st.apply((JTable)((Object)this));
        this._parent = parent;
        this._parent.setKidScaleTable(this);
    }

    public void setKidScaleTable(DataScaleTable kid) {
        this._kid = kid;
        this._kidSimpleTable = null;
    }

    public DataScaleTable getKidScaleTable() {
        return this._kid;
    }

    public DataScaleTable getParentScaleTable() {
        return this._parent;
    }

    public void setKidSimpleTable(DataSetViewerTablePanel simpleTable) {
        this._kidSimpleTable = simpleTable;
        this._kid = null;
    }

    public DataSetViewerTablePanel getKidSimpleTable() {
        return this._kidSimpleTable;
    }

    public void saveColumnWidths() {
        int wColumn = 100;
        int wData = 1000;
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            if (DataScaleTableModel.COL_NAME_COLUMN.equals(this.getColumnModel().getColumn(i).getHeaderValue())) {
                wColumn = this.getColumnModel().getColumn(i).getWidth();
            } else if (DataScaleTableModel.COL_NAME_DATA.equals(this.getColumnModel().getColumn(i).getHeaderValue())) {
                wData = this.getColumnModel().getColumn(i).getWidth();
            }
            DataScaleTableModel.saveColumWidhts(wColumn, wData);
        }
    }
}

