/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.util.Comparator;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Calculator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.NoIx;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;

public class DoubleIndexedColumn
extends IndexedColumn {
    private DoubleRange _doubleRange = new DoubleRange();

    public DoubleIndexedColumn(List<Object[]> rows, int colIx, ColumnDisplayDefinition colDef) {
        super(rows, colIx, colDef);
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object ix1, Object ix2) {
                if (ix1 instanceof NoIx && ix2 instanceof NoIx) {
                    return DoubleIndexedColumn.this.compareDouble(((NoIx)ix1).get(), ((NoIx)ix2).get());
                }
                if (ix1 instanceof NoIx) {
                    return DoubleIndexedColumn.this.compareDouble(((NoIx)ix1).get(), DoubleIndexedColumn.this.getRow((Integer)ix2));
                }
                if (ix2 instanceof NoIx) {
                    return DoubleIndexedColumn.this.compareDouble(DoubleIndexedColumn.this.getRow((Integer)ix1), ((NoIx)ix2).get());
                }
                return DoubleIndexedColumn.this.compareDouble(DoubleIndexedColumn.this.getRow((Integer)ix1), DoubleIndexedColumn.this.getRow((Integer)ix2));
            }
        };
        this._doubleRange.beginInit();
        this.sortIx(comparator);
        this._doubleRange.endInit();
    }

    private int compareDouble(Object o1, Object o2) {
        Double d1 = null;
        if (null != o1) {
            d1 = ((Number)o1).doubleValue();
        }
        Double d2 = null;
        if (null != o2) {
            d2 = ((Number)o2).doubleValue();
        }
        this._doubleRange.init(d1);
        this._doubleRange.init(d2);
        if (d1 == null && d2 != null) {
            return -1;
        }
        if (d1 != null && d2 == null) {
            return 1;
        }
        if (d1 == null && d2 == null) {
            return 0;
        }
        return d1.compareTo(d2);
    }

    @Override
    public Calculator getCalculator() {
        return new Calculator(){

            public Object getMid(Object min, Object max) {
                return DoubleIndexedColumn.this.onGetMid(min, max);
            }
        };
    }

    private Object onGetMid(Object min, Object max) {
        Double doubleMin = null == min ? Double.valueOf(this._doubleRange.getMin() - 1.0) : Double.valueOf(((Number)min).doubleValue());
        Double doubleMax = null == max ? Double.valueOf(this._doubleRange.getMin() - 1.0) : Double.valueOf(((Number)max).doubleValue());
        return doubleMin + (doubleMax - doubleMin) / 2.0;
    }

    private static class DoubleRange {
        private double _max = 0.0;
        private double _min = 0.0;
        private boolean _initializing;
        private boolean _isInit;

        private DoubleRange() {
        }

        public void init(Double d) {
            if (!this._initializing) {
                return;
            }
            if (null == d) {
                return;
            }
            if (!this._isInit) {
                this._min = d;
                this._max = d;
                this._isInit = true;
            }
            this._min = Math.min(this._min, d);
            this._max = Math.max(this._max, d);
        }

        public double getMin() {
            return this._min;
        }

        void beginInit() {
            this._initializing = true;
        }

        void endInit() {
            this._initializing = false;
        }
    }
}

