/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.util.List;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumn;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class Interval {
    private IndexedColumn _indexedColumn;
    private int _firstIx;
    private int _lastIx;
    private Object _beginData;
    private Object _endData;
    private String _label;
    private String _tooltip;

    public Interval(IndexedColumn indexedColumn, int firstIx, int lastIx, Object beginData, Object endData) {
        this._indexedColumn = indexedColumn;
        this._firstIx = firstIx;
        this._lastIx = lastIx;
        this._beginData = beginData;
        this._endData = endData;
        Object firstVal = this._indexedColumn.get(firstIx);
        Object lastVal = this._indexedColumn.get(lastIx);
        String firstValRendered = this._indexedColumn.renderObject(firstVal);
        String lastValRendered = this._indexedColumn.renderObject(lastVal);
        this._label = this.hasDifferentValues() ? firstValRendered + " - " + lastValRendered : firstValRendered;
        this._tooltip = "<html>" + this.escapeHtmlChars(this._label) + "<br><br>" + "row count = " + this.getLen() + "; percentage = " + 100.0 * this.getWight() + "%<br>" + "first value = " + this.escapeHtmlChars(firstValRendered) + "<br>" + "last value = " + this.escapeHtmlChars(lastValRendered) + "<br>" + "first index = " + this._firstIx + "; last index = " + this._lastIx + "<br>" + "data interval = " + this.getIntervalOpeningBracket() + this.escapeHtmlChars(this._indexedColumn.renderObject(beginData)) + ", " + this.escapeHtmlChars(this._indexedColumn.renderObject(endData)) + this.getIntervalClosingBracket() + "<br>" + "complete row count = " + this._indexedColumn.size() + "</html>";
    }

    private String getIntervalOpeningBracket() {
        if (0 == this._indexedColumn.compareObjects(this._indexedColumn.get(this._firstIx), this._beginData)) {
            return "[";
        }
        return "]";
    }

    private String getIntervalClosingBracket() {
        if (0 == this._indexedColumn.compareObjects(this._indexedColumn.get(this._lastIx), this._endData)) {
            return "]";
        }
        return "[";
    }

    public int getLen() {
        return this._lastIx - this._firstIx + 1;
    }

    private String escapeHtmlChars(String sql) {
        String buf = sql.replaceAll("&", "&amp;");
        buf = buf.replaceAll("<", "&lt;");
        buf = buf.replaceAll("<", "&gt;");
        buf = buf.replaceAll("\"", "&quot;");
        return buf;
    }

    private boolean hasDifferentValues() {
        Object lastVal;
        Object firstVal = this._indexedColumn.get(this._firstIx);
        return false == Utilities.equalsRespectNull((Object)firstVal, (Object)(lastVal = this._indexedColumn.get(this._lastIx)));
    }

    public double getWight() {
        return (double)this.getLen() / (double)this._indexedColumn.size();
    }

    public String getLabel() {
        return this._label;
    }

    public String getToolTip() {
        return this._tooltip;
    }

    public List<Object[]> getResultRows() {
        return this._indexedColumn.getResultRows(this._firstIx, this._lastIx);
    }

    public boolean containsAllRows() {
        return this.getLen() == this._indexedColumn.size();
    }
}

