/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.BitSet;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ErrorStream;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.Token;

public class Scanner {
    private static final char EOF = '\u0000';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final int noSym = 103;
    private static final int[] start = new int[]{23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 1, 1, 0, 0, 5, 7, 22, 11, 15, 21, 12, 2, 14, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 13, 9, 16, 10, 19, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0};
    private static BitSet ignore = new BitSet(128);
    ErrorStream err;
    private Buffer buf;
    protected Token t;
    protected char strCh;
    protected char ch;
    protected char lastCh;
    protected int pos;
    protected int line;
    protected int lineStart;

    public Scanner(Buffer buff, ErrorStream e) {
        this.buf = buff;
        this.init(e, "");
    }

    private void init(ErrorStream e, String eName) {
        this.err = e;
        this.err.fileName = eName;
        this.pos = -1;
        this.line = 1;
        this.lineStart = 0;
        this.lastCh = '\u0000';
        this.NextCh();
    }

    void setPos(int position) {
        this.buf.setIndex(position);
    }

    private void NextCh() {
        this.lastCh = this.ch;
        this.strCh = this.buf.read();
        ++this.pos;
        this.ch = Character.toUpperCase(this.strCh);
        if (this.ch == '\uffff') {
            this.ch = '\u0000';
        } else if (this.ch == '\r') {
            ++this.line;
            this.lineStart = this.pos + 1;
        } else if (this.ch == '\n') {
            if (this.lastCh != '\r') {
                ++this.line;
            }
            this.lineStart = this.pos + 1;
        } else if (this.ch > '\u007f') {
            this.err.StoreError(0, this.line, this.pos - this.lineStart + 1, "invalid character in source file");
            ++this.err.count;
            this.ch = (char)32;
        }
    }

    private final boolean Comment0() {
        int level = 1;
        int line0 = this.line;
        int lineStart0 = this.lineStart;
        this.NextCh();
        if (this.ch == '-') {
            this.NextCh();
            while (true) {
                if (this.ch == '\n') {
                    if (--level == 0) {
                        this.NextCh();
                        return true;
                    }
                    this.NextCh();
                    continue;
                }
                if (this.ch == '\u0000') {
                    return false;
                }
                this.NextCh();
            }
        }
        if (this.ch == '\r' || this.ch == '\n') {
            --this.line;
            this.lineStart = lineStart0;
        }
        this.pos -= 2;
        this.setPos(this.pos + 1);
        this.NextCh();
        return false;
    }

    private final boolean Comment1() {
        int level = 1;
        int line0 = this.line;
        int lineStart0 = this.lineStart;
        this.NextCh();
        if (this.ch == '*') {
            this.NextCh();
            while (true) {
                if (this.ch == '*') {
                    this.NextCh();
                    if (this.ch != '/') continue;
                    if (--level == 0) {
                        this.NextCh();
                        return true;
                    }
                    this.NextCh();
                    continue;
                }
                if (this.ch == '/') {
                    this.NextCh();
                    if (this.ch != '*') continue;
                    ++level;
                    this.NextCh();
                    continue;
                }
                if (this.ch == '\u0000') {
                    return false;
                }
                this.NextCh();
            }
        }
        if (this.ch == '\r' || this.ch == '\n') {
            --this.line;
            this.lineStart = lineStart0;
        }
        this.pos -= 2;
        this.setPos(this.pos + 1);
        this.NextCh();
        return false;
    }

    private void CheckLiteral(StringBuffer buf) {
        this.t.val = buf.toString().toUpperCase();
        switch (this.t.val.charAt(0)) {
            case 'A': {
                if (this.t.val.equals("ACTION")) {
                    this.t.kind = 90;
                    break;
                }
                if (this.t.val.equals("ADD")) {
                    this.t.kind = 97;
                    break;
                }
                if (this.t.val.equals("ALL")) {
                    this.t.kind = 11;
                    break;
                }
                if (this.t.val.equals("ALTER")) {
                    this.t.kind = 98;
                    break;
                }
                if (this.t.val.equals("AND")) {
                    this.t.kind = 57;
                    break;
                }
                if (this.t.val.equals("AS")) {
                    this.t.kind = 23;
                    break;
                }
                if (this.t.val.equals("ASC")) {
                    this.t.kind = 51;
                    break;
                }
                if (!this.t.val.equals("AVG")) break;
                this.t.kind = 48;
                break;
            }
            case 'B': {
                if (this.t.val.equals("BETWEEN")) {
                    this.t.kind = 67;
                    break;
                }
                if (!this.t.val.equals("BY")) break;
                this.t.kind = 36;
                break;
            }
            case 'C': {
                if (this.t.val.equals("CASCADE")) {
                    this.t.kind = 88;
                    break;
                }
                if (this.t.val.equals("CHAR")) {
                    this.t.kind = 72;
                    break;
                }
                if (this.t.val.equals("CHARACTER")) {
                    this.t.kind = 73;
                    break;
                }
                if (this.t.val.equals("CASE")) {
                    this.t.kind = -1000;
                    break;
                }
                if (this.t.val.equals("CHECK")) {
                    this.t.kind = 92;
                    break;
                }
                if (this.t.val.equals("COMMIT")) {
                    this.t.kind = 69;
                    break;
                }
                if (this.t.val.equals("CONSTRAINT")) {
                    this.t.kind = 99;
                    break;
                }
                if (this.t.val.equals("COUNT")) {
                    this.t.kind = 44;
                    break;
                }
                if (this.t.val.equals("CREATE")) {
                    this.t.kind = 93;
                    break;
                }
                if (!this.t.val.equals("CROSS")) break;
                this.t.kind = 25;
                break;
            }
            case 'D': {
                if (this.t.val.equals("DATE")) {
                    this.t.kind = 79;
                    break;
                }
                if (this.t.val.equals("DEFAULT")) {
                    this.t.kind = 81;
                    break;
                }
                if (this.t.val.equals("DELETE")) {
                    this.t.kind = 18;
                    break;
                }
                if (this.t.val.equals("DESC")) {
                    this.t.kind = 50;
                    break;
                }
                if (this.t.val.equals("DISTINCT")) {
                    this.t.kind = 21;
                    break;
                }
                if (!this.t.val.equals("DROP")) break;
                this.t.kind = 96;
                break;
            }
            case 'E': {
                if (this.t.val.equals("ELSE")) {
                    this.t.kind = -1003;
                    break;
                }
                if (this.t.val.equals("END")) {
                    this.t.kind = -1004;
                    break;
                }
                if (this.t.val.equals("ESCAPE")) {
                    this.t.kind = 60;
                    break;
                }
                if (!this.t.val.equals("EXCEPT")) break;
                this.t.kind = 8;
                break;
            }
            case 'F': {
                if (this.t.val.equals("FOREIGN")) {
                    this.t.kind = 84;
                    break;
                }
                if (this.t.val.equals("FROM")) {
                    this.t.kind = 19;
                    break;
                }
                if (!this.t.val.equals("FULL")) break;
                this.t.kind = 28;
                break;
            }
            case 'G': {
                if (!this.t.val.equals("GROUP")) break;
                this.t.kind = 35;
                break;
            }
            case 'H': {
                if (!this.t.val.equals("HAVING")) break;
                this.t.kind = 37;
                break;
            }
            case 'I': {
                if (this.t.val.equals("IN")) {
                    this.t.kind = 68;
                    break;
                }
                if (this.t.val.equals("INDEX")) {
                    this.t.kind = 100;
                    break;
                }
                if (this.t.val.equals("INNER")) {
                    this.t.kind = 27;
                    break;
                }
                if (this.t.val.equals("INSERT")) {
                    this.t.kind = 15;
                    break;
                }
                if (this.t.val.equals("INT")) {
                    this.t.kind = 76;
                    break;
                }
                if (this.t.val.equals("INTEGER")) {
                    this.t.kind = 75;
                    break;
                }
                if (this.t.val.equals("INTERSECT")) {
                    this.t.kind = 9;
                    break;
                }
                if (this.t.val.equals("INTO")) {
                    this.t.kind = 16;
                    break;
                }
                if (!this.t.val.equals("IS")) break;
                this.t.kind = 61;
                break;
            }
            case 'J': {
                if (!this.t.val.equals("JOIN")) break;
                this.t.kind = 24;
                break;
            }
            case 'K': {
                if (!this.t.val.equals("KEY")) break;
                this.t.kind = 83;
                break;
            }
            case 'L': {
                if (this.t.val.equals("LEFT")) {
                    this.t.kind = 29;
                    break;
                }
                if (!this.t.val.equals("LIKE")) break;
                this.t.kind = 59;
                break;
            }
            case 'M': {
                if (this.t.val.equals("MATCH")) {
                    this.t.kind = 86;
                    break;
                }
                if (this.t.val.equals("MAX")) {
                    this.t.kind = 46;
                    break;
                }
                if (this.t.val.equals("MIN")) {
                    this.t.kind = 47;
                    break;
                }
                if (this.t.val.equals("MINUS")) {
                    this.t.kind = 10;
                    break;
                }
                if (!this.t.val.equals("MONTH")) break;
                this.t.kind = 42;
                break;
            }
            case 'N': {
                if (this.t.val.equals("NATURAL")) {
                    this.t.kind = 26;
                    break;
                }
                if (this.t.val.equals("NO")) {
                    this.t.kind = 89;
                    break;
                }
                if (this.t.val.equals("NOT")) {
                    this.t.kind = 54;
                    break;
                }
                if (this.t.val.equals("NULL")) {
                    this.t.kind = 49;
                    break;
                }
                if (!this.t.val.equals("NUMERIC")) break;
                this.t.kind = 78;
                break;
            }
            case 'O': {
                if (this.t.val.equals("ON")) {
                    this.t.kind = 32;
                    break;
                }
                if (this.t.val.equals("OR")) {
                    this.t.kind = 58;
                    break;
                }
                if (this.t.val.equals("ORDER")) {
                    this.t.kind = 38;
                    break;
                }
                if (!this.t.val.equals("OUTER")) break;
                this.t.kind = 31;
                break;
            }
            case 'P': {
                if (this.t.val.equals("PARTIAL")) {
                    this.t.kind = 87;
                    break;
                }
                if (!this.t.val.equals("PRIMARY")) break;
                this.t.kind = 82;
                break;
            }
            case 'R': {
                if (this.t.val.equals("REFERENCES")) {
                    this.t.kind = 85;
                    break;
                }
                if (this.t.val.equals("RESTRICT")) {
                    this.t.kind = 95;
                    break;
                }
                if (this.t.val.equals("RIGHT")) {
                    this.t.kind = 30;
                    break;
                }
                if (!this.t.val.equals("ROLLBACK")) break;
                this.t.kind = 70;
                break;
            }
            case 'S': {
                if (this.t.val.equals("SELECT")) {
                    this.t.kind = 20;
                    break;
                }
                if (this.t.val.equals("SET")) {
                    this.t.kind = 13;
                    break;
                }
                if (this.t.val.equals("SMALLINT")) {
                    this.t.kind = 77;
                    break;
                }
                if (!this.t.val.equals("SUM")) break;
                this.t.kind = 45;
                break;
            }
            case 'T': {
                if (this.t.val.equals("TABLE")) {
                    this.t.kind = 94;
                    break;
                }
                if (this.t.val.equals("THEN")) {
                    this.t.kind = -1002;
                    break;
                }
                if (this.t.val.equals("TIME")) {
                    this.t.kind = 80;
                    break;
                }
                if (!this.t.val.equals("TIMESTAMP")) break;
                this.t.kind = 40;
                break;
            }
            case 'U': {
                if (this.t.val.equals("UNION")) {
                    this.t.kind = 7;
                    break;
                }
                if (this.t.val.equals("UNIQUE")) {
                    this.t.kind = 91;
                    break;
                }
                if (this.t.val.equals("UPDATE")) {
                    this.t.kind = 12;
                    break;
                }
                if (this.t.val.equals("UPPER")) {
                    this.t.kind = 41;
                    break;
                }
                if (!this.t.val.equals("USING")) break;
                this.t.kind = 33;
                break;
            }
            case 'V': {
                if (this.t.val.equals("VALUES")) {
                    this.t.kind = 17;
                    break;
                }
                if (this.t.val.equals("VARCHAR")) {
                    this.t.kind = 74;
                    break;
                }
                if (!this.t.val.equals("VIEW")) break;
                this.t.kind = -1005;
                break;
            }
            case 'W': {
                if (this.t.val.equals("WHERE")) {
                    this.t.kind = 34;
                    break;
                }
                if (this.t.val.equals("WHEN")) {
                    this.t.kind = -1001;
                    break;
                }
                if (!this.t.val.equals("WORK")) break;
                this.t.kind = 71;
                break;
            }
            case 'Y': {
                if (!this.t.val.equals("YEAR")) break;
                this.t.kind = 43;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    Token Scan() {
        while (ignore.get(this.ch)) {
            this.NextCh();
        }
        if (this.ch == '-' && this.Comment0() || this.ch == '/' && this.Comment1()) {
            return this.Scan();
        }
        this.t = new Token();
        this.t.pos = this.pos;
        this.t.col = this.pos - this.lineStart + 1;
        this.t.line = this.line;
        StringBuffer buf = new StringBuffer();
        int state = start[this.ch];
        boolean apx = false;
        block27: while (true) {
            buf.append(this.strCh);
            this.NextCh();
            switch (state) {
                case 0: {
                    this.t.kind = 103;
                    break block27;
                }
                case 1: {
                    if (this.ch == '!' || this.ch >= '#' && this.ch <= '$' || this.ch >= '0' && this.ch <= '9' || this.ch >= '@' && this.ch <= '{' || this.ch >= '}') break;
                    this.t.kind = 1;
                    this.CheckLiteral(buf);
                    break block27;
                }
                case 2: {
                    if (this.ch >= '0' && this.ch <= '9') {
                        state = 3;
                        break;
                    }
                    this.t.kind = 22;
                    break block27;
                }
                case 3: {
                    if (this.ch >= '0' && this.ch <= '9') break;
                    this.t.kind = 3;
                    break block27;
                }
                case 4: {
                    if (this.ch >= ' ' && this.ch <= '!' || this.ch >= '#') break;
                    if (this.ch == '\"') {
                        state = 6;
                        break;
                    }
                    this.t.kind = 103;
                    break block27;
                }
                case 5: {
                    if (this.ch >= ' ' && this.ch <= '&' || this.ch >= '(') break;
                    if (this.ch == '\'') {
                        state = 6;
                        break;
                    }
                    this.t.kind = 103;
                    break block27;
                }
                case 6: {
                    this.t.kind = 4;
                    break block27;
                }
                case 7: {
                    this.t.kind = 5;
                    break block27;
                }
                case 8: {
                    if (this.ch >= '0' && this.ch <= '9') break;
                    if (this.ch == '.') {
                        state = 2;
                        break;
                    }
                    this.t.kind = 2;
                    break block27;
                }
                case 9: {
                    this.t.kind = 6;
                    break block27;
                }
                case 10: {
                    this.t.kind = 14;
                    break block27;
                }
                case 11: {
                    this.t.kind = 39;
                    break block27;
                }
                case 12: {
                    this.t.kind = 52;
                    break block27;
                }
                case 13: {
                    this.t.kind = 53;
                    break block27;
                }
                case 14: {
                    this.t.kind = 55;
                    break block27;
                }
                case 15: {
                    this.t.kind = 56;
                    break block27;
                }
                case 16: {
                    if (this.ch == '>') {
                        state = 17;
                        break;
                    }
                    if (this.ch == '=') {
                        state = 18;
                        break;
                    }
                    this.t.kind = 63;
                    break block27;
                }
                case 17: {
                    this.t.kind = 62;
                    break block27;
                }
                case 18: {
                    this.t.kind = 64;
                    break block27;
                }
                case 19: {
                    if (this.ch == '=') {
                        state = 20;
                        break;
                    }
                    this.t.kind = 65;
                    break block27;
                }
                case 20: {
                    this.t.kind = 66;
                    break block27;
                }
                case 21: {
                    this.t.kind = 101;
                    break block27;
                }
                case 22: {
                    this.t.kind = 102;
                    break block27;
                }
                case 23: {
                    this.t.kind = 0;
                    break block27;
                }
            }
        }
        this.t.str = buf.toString();
        this.t.val = this.t.str.toUpperCase();
        return this.t;
    }

    static {
        ignore.set(1);
        ignore.set(2);
        ignore.set(3);
        ignore.set(4);
        ignore.set(5);
        ignore.set(6);
        ignore.set(7);
        ignore.set(8);
        ignore.set(9);
        ignore.set(10);
        ignore.set(11);
        ignore.set(12);
        ignore.set(13);
        ignore.set(14);
        ignore.set(15);
        ignore.set(16);
        ignore.set(17);
        ignore.set(18);
        ignore.set(19);
        ignore.set(20);
        ignore.set(21);
        ignore.set(22);
        ignore.set(23);
        ignore.set(24);
        ignore.set(25);
        ignore.set(26);
        ignore.set(27);
        ignore.set(28);
        ignore.set(29);
        ignore.set(30);
        ignore.set(31);
        ignore.set(32);
    }

    static class SBuffer
    extends Buffer {
        String chars;

        SBuffer(String string) {
            this._bufLen = string.length();
            this.chars = string;
            this._pos = 0;
        }

        @Override
        protected char read() {
            if (this._pos < this._bufLen) {
                return this.chars.charAt(this._pos++);
            }
            return '\uffff';
        }
    }

    static class FBuffer
    extends Buffer {
        static char[] buf;

        FBuffer(File file) throws IOException {
            this._bufLen = (int)file.length();
            FileReader fr = new FileReader(file);
            buf = new char[this._bufLen];
            fr.read(buf);
            this._pos = 0;
        }

        @Override
        protected char read() {
            if (this._pos < this._bufLen) {
                return buf[this._pos++];
            }
            return '\uffff';
        }
    }

    public static abstract class Buffer {
        public static final char eof = '\uffff';
        int _bufLen;
        int _pos;

        protected void setIndex(int position) {
            if (position < 0) {
                position = 0;
            } else if (position >= this._bufLen) {
                position = this._bufLen;
            }
            this._pos = position;
        }

        protected abstract char read();
    }
}

