/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerEditableTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTextPanel;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.util.ISessionProperties;
import net.sourceforge.squirrel_sql.fw.util.PropertyChangeReporter;

public class SessionProperties
implements Cloneable,
Serializable,
ISessionProperties {
    private static final FontInfo DEFAULT_FONT_INFO = new FontInfo(new Font("Monospaced", 0, 12));
    private transient PropertyChangeReporter _propChgReporter;
    private boolean _autoCommit = true;
    private int _contentsNbrRowsToShow = 100;
    private int _sqlNbrRowsToShow = 100;
    private boolean _commitOnClosingConnection = false;
    private boolean _contentsLimitRows = true;
    private boolean _sqlLimitRows = true;
    private boolean _loadSchemasCatalogs = true;
    private String _schemaFilterInclude = "";
    private String _catalogFilterInclude = "";
    private String _objectFilterInclude = "";
    private String _schemaFilterExclude = "";
    private String _catalogFilterExclude = "";
    private String _objectFilterExclude = "";
    private boolean _showResultsMetaData = true;
    private String _metaDataOutputClassName = IDataSetDestinations.READ_ONLY_TABLE;
    private String _tableContentsClassName = IDataSetDestinations.READ_ONLY_TABLE;
    private String _sqlResultsOutputClassName = IDataSetDestinations.READ_ONLY_TABLE;
    private boolean _showRowCount = false;
    private boolean _showToolbar = true;
    private String _sqlStmtSep = ";";
    private String _solComment = "--";
    private boolean _removeMultiLineComment = true;
    private FontInfo _fi = (FontInfo)DEFAULT_FONT_INFO.clone();
    private boolean _limitSqlEntryHistorySize = true;
    private boolean _sqlShareHistory = true;
    private int _sqlEntryHistorySize = 100;
    private int _mainTabPlacement = 1;
    private int _objectTabPlacement = 1;
    private int _sqlExecutionTabPlacement = 1;
    private int _sqlResultsTabPlacement = 1;
    private boolean _abortOnError = true;
    private boolean _writeSQLErrorsToLog;
    private boolean _loadColumnsInBackground;
    private boolean _limitSqlResultTabs = true;
    private boolean _keepTableLayoutOnRerun;
    private int _sqlResultTabLimit = 15;
    private int _sqlFetchSize = 50;
    private boolean _sqlUseFetchSize;

    public Object clone() {
        try {
            SessionProperties props = (SessionProperties)super.clone();
            props._propChgReporter = null;
            if (this._fi != null) {
                props.setFontInfo((FontInfo)this._fi.clone());
            }
            return props;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public String getReadOnlyTableOutputClassName() {
        return IDataSetDestinations.READ_ONLY_TABLE;
    }

    public String getEditableTableOutputClassName() {
        return IDataSetDestinations.EDITABLE_TABLE;
    }

    public String getReadOnlySQLResultsOutputClassName() {
        if (this._sqlResultsOutputClassName.equals(IDataSetDestinations.EDITABLE_TABLE)) {
            return IDataSetDestinations.READ_ONLY_TABLE;
        }
        return this._sqlResultsOutputClassName;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().removePropertyChangeListener(listener);
    }

    public String getMetaDataOutputClassName() {
        return this._metaDataOutputClassName;
    }

    public void setMetaDataOutputClassName(String value) {
        if (value == null) {
            value = "";
        }
        if (!this._metaDataOutputClassName.equals(value)) {
            String oldValue = this._metaDataOutputClassName;
            this._metaDataOutputClassName = value;
            this.getPropertyChangeReporter().firePropertyChange("metaDataOutputClassName", (Object)oldValue, (Object)this._metaDataOutputClassName);
        }
    }

    public String getTableContentsOutputClassName() {
        return this._tableContentsClassName;
    }

    public void setTableContentsOutputClassName(String value) {
        if (value == null) {
            value = "";
        }
        if (!this._tableContentsClassName.equals(value)) {
            String oldValue = this._tableContentsClassName;
            this._tableContentsClassName = value;
            this.getPropertyChangeReporter().firePropertyChange("tableContentsOutputClassName", (Object)oldValue, (Object)this._tableContentsClassName);
        }
    }

    public String getSQLResultsOutputClassName() {
        return this._sqlResultsOutputClassName;
    }

    public void setSQLResultsOutputClassName(String value) {
        if (value == null) {
            value = "";
        }
        if (!this._sqlResultsOutputClassName.equals(value)) {
            String oldValue = this._sqlResultsOutputClassName;
            this._sqlResultsOutputClassName = value;
            this.getPropertyChangeReporter().firePropertyChange("sqlResultsOutputClassName", (Object)oldValue, (Object)this._sqlResultsOutputClassName);
        }
    }

    public boolean getAutoCommit() {
        return this._autoCommit;
    }

    public void setAutoCommit(boolean value) {
        if (this._autoCommit != value) {
            this._autoCommit = value;
            this.getPropertyChangeReporter().firePropertyChange("autoCommit", !this._autoCommit, this._autoCommit);
        }
    }

    public boolean getAbortOnError() {
        return this._abortOnError;
    }

    public void setAbortOnError(boolean value) {
        if (this._abortOnError != value) {
            this._abortOnError = value;
            this.getPropertyChangeReporter().firePropertyChange("abortOnError", !this._abortOnError, this._abortOnError);
        }
    }

    public boolean getWriteSQLErrorsToLog() {
        return this._writeSQLErrorsToLog;
    }

    public void setWriteSQLErrorsToLog(boolean value) {
        if (this._writeSQLErrorsToLog != value) {
            this._writeSQLErrorsToLog = value;
            this.getPropertyChangeReporter().firePropertyChange("writeSQLErrorsToLog", !this._writeSQLErrorsToLog, this._writeSQLErrorsToLog);
        }
    }

    public boolean getLoadColumnsInBackground() {
        return this._loadColumnsInBackground;
    }

    public void setLoadColumnsInBackground(boolean value) {
        if (this._loadColumnsInBackground != value) {
            this._loadColumnsInBackground = value;
            this.getPropertyChangeReporter().firePropertyChange("loadColumnsInBackground", !this._loadColumnsInBackground, this._loadColumnsInBackground);
        }
    }

    public boolean getLimitSQLResultTabs() {
        return this._limitSqlResultTabs;
    }

    public void setLimitSQLResultTabs(boolean data) {
        boolean oldValue = this._limitSqlResultTabs;
        this._limitSqlResultTabs = data;
        this.getPropertyChangeReporter().firePropertyChange("limitSqlResultTabs", oldValue, this._limitSqlResultTabs);
    }

    public int getSqlResultTabLimit() {
        return this._sqlResultTabLimit;
    }

    public void setSqlResultTabLimit(int value) {
        if (this._sqlResultTabLimit != value) {
            int oldValue = this._sqlResultTabLimit;
            this._sqlResultTabLimit = value;
            this.getPropertyChangeReporter().firePropertyChange("sqlResultTabLimit", oldValue, this._sqlResultTabLimit);
        }
    }

    public boolean getShowToolBar() {
        return this._showToolbar;
    }

    public void setShowToolBar(boolean value) {
        if (this._showToolbar != value) {
            this._showToolbar = value;
            this.getPropertyChangeReporter().firePropertyChange("showToolBar", !this._showToolbar, this._showToolbar);
        }
    }

    public int getContentsNbrRowsToShow() {
        return this._contentsNbrRowsToShow;
    }

    public void setContentsNbrRowsToShow(int value) {
        if (this._contentsNbrRowsToShow != value) {
            int oldValue = this._contentsNbrRowsToShow;
            this._contentsNbrRowsToShow = value;
            this.getPropertyChangeReporter().firePropertyChange("contentsNbrOfRowsToShow", oldValue, this._contentsNbrRowsToShow);
        }
    }

    public int getSQLNbrRowsToShow() {
        return this._sqlNbrRowsToShow;
    }

    public void setSQLNbrRowsToShow(int value) {
        if (this._sqlNbrRowsToShow != value) {
            int oldValue = this._sqlNbrRowsToShow;
            this._sqlNbrRowsToShow = value;
            this.getPropertyChangeReporter().firePropertyChange("sqlNbrOfRowsToShow", oldValue, this._sqlNbrRowsToShow);
        }
    }

    public boolean getContentsLimitRows() {
        return this._contentsLimitRows;
    }

    public void setContentsLimitRows(boolean value) {
        if (this._contentsLimitRows != value) {
            boolean oldValue = this._contentsLimitRows;
            this._contentsLimitRows = value;
            this.getPropertyChangeReporter().firePropertyChange("contentsLimitRows", oldValue, this._contentsLimitRows);
        }
    }

    public boolean getSQLLimitRows() {
        return this._sqlLimitRows;
    }

    public void setSQLLimitRows(boolean value) {
        if (this._sqlLimitRows != value) {
            boolean oldValue = this._sqlLimitRows;
            this._sqlLimitRows = value;
            this.getPropertyChangeReporter().firePropertyChange("sqlLimitRows", oldValue, this._sqlLimitRows);
        }
    }

    public void setSQLFetchSize(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("FetchSize must be >= 0. fetchSize=" + value);
        }
        if (this._sqlFetchSize != value) {
            int oldValue = this._sqlFetchSize;
            this._sqlFetchSize = value;
            this.getPropertyChangeReporter().firePropertyChange("sqlFetchSize", oldValue, this._sqlFetchSize);
        }
    }

    public void setSQLUseFetchSize(boolean value) {
        if (this._sqlUseFetchSize != value) {
            boolean oldValue = this._sqlUseFetchSize;
            this._sqlUseFetchSize = value;
            this.getPropertyChangeReporter().firePropertyChange("sqlUseFetchSize", oldValue, this._sqlUseFetchSize);
        }
    }

    public String getSQLStatementSeparator() {
        return this._sqlStmtSep;
    }

    public void setSQLStatementSeparator(String value) {
        if (null == value || 0 == value.trim().length()) {
            value = ";";
        }
        if (!this._sqlStmtSep.equals(value)) {
            String oldValue = this._sqlStmtSep;
            this._sqlStmtSep = value;
            this.getPropertyChangeReporter().firePropertyChange("sqlStatementSeparatorString", (Object)oldValue, (Object)this._sqlStmtSep);
        }
    }

    public boolean getCommitOnClosingConnection() {
        return this._commitOnClosingConnection;
    }

    public synchronized void setCommitOnClosingConnection(boolean data) {
        boolean oldValue = this._commitOnClosingConnection;
        this._commitOnClosingConnection = data;
        this.getPropertyChangeReporter().firePropertyChange("commitOnClosingConnection", oldValue, this._commitOnClosingConnection);
    }

    public boolean getShowRowCount() {
        return this._showRowCount;
    }

    public synchronized void setShowRowCount(boolean data) {
        boolean oldValue = this._showRowCount;
        this._showRowCount = data;
        this.getPropertyChangeReporter().firePropertyChange("showRowCount", oldValue, this._showRowCount);
    }

    public String getStartOfLineComment() {
        return this._solComment;
    }

    public synchronized void setStartOfLineComment(String data) {
        String oldValue = this._solComment;
        this._solComment = data;
        this.getPropertyChangeReporter().firePropertyChange("sqlStartOfLineComment", (Object)oldValue, (Object)this._solComment);
    }

    public boolean getRemoveMultiLineComment() {
        return this._removeMultiLineComment;
    }

    public synchronized void setRemoveMultiLineComment(boolean data) {
        boolean oldValue = this._removeMultiLineComment;
        this._removeMultiLineComment = data;
        this.getPropertyChangeReporter().firePropertyChange("removeMultiLineComment", oldValue, this._removeMultiLineComment);
    }

    public FontInfo getFontInfo() {
        return this._fi;
    }

    public void setFontInfo(FontInfo data) {
        if (this._fi == null || !this._fi.equals((Object)data)) {
            FontInfo oldValue = this._fi;
            this._fi = data != null ? data : (FontInfo)DEFAULT_FONT_INFO.clone();
            this.getPropertyChangeReporter().firePropertyChange("fontInfo", (Object)oldValue, (Object)this._fi);
        }
    }

    public boolean getLimitSQLEntryHistorySize() {
        return this._limitSqlEntryHistorySize;
    }

    public void setLimitSQLEntryHistorySize(boolean data) {
        boolean oldValue = this._limitSqlEntryHistorySize;
        this._limitSqlEntryHistorySize = data;
        this.getPropertyChangeReporter().firePropertyChange("limitSqlEntryHistorySize", oldValue, this._limitSqlEntryHistorySize);
    }

    public boolean getSQLShareHistory() {
        return this._sqlShareHistory;
    }

    public void setSQLShareHistory(boolean data) {
        boolean oldValue = this._sqlShareHistory;
        this._sqlShareHistory = data;
        this.getPropertyChangeReporter().firePropertyChange("sqlShareHistory", oldValue, this._sqlShareHistory);
    }

    public int getSQLEntryHistorySize() {
        return this._sqlEntryHistorySize;
    }

    public void setSQLEntryHistorySize(int data) {
        int oldValue = this._sqlEntryHistorySize;
        this._sqlEntryHistorySize = data;
        this.getPropertyChangeReporter().firePropertyChange("sqlEntryHistorySize", oldValue, this._sqlEntryHistorySize);
    }

    public int getMainTabPlacement() {
        return this._mainTabPlacement;
    }

    public void setMainTabPlacement(int value) {
        if (this._mainTabPlacement != value) {
            int oldValue = this._mainTabPlacement;
            this._mainTabPlacement = value;
            this.getPropertyChangeReporter().firePropertyChange("mainTabPlacement", oldValue, this._mainTabPlacement);
        }
    }

    public int getObjectTabPlacement() {
        return this._objectTabPlacement;
    }

    public void setObjectTabPlacement(int value) {
        if (this._objectTabPlacement != value) {
            int oldValue = this._objectTabPlacement;
            this._objectTabPlacement = value;
            this.getPropertyChangeReporter().firePropertyChange("objectTabPlacement", oldValue, this._objectTabPlacement);
        }
    }

    public int getSQLExecutionTabPlacement() {
        return this._sqlExecutionTabPlacement;
    }

    public void setSQLExecutionTabPlacement(int value) {
        if (this._sqlExecutionTabPlacement != value) {
            int oldValue = this._sqlExecutionTabPlacement;
            this._sqlExecutionTabPlacement = value;
            this.getPropertyChangeReporter().firePropertyChange("sqlExecutionTabPlacement", oldValue, this._sqlExecutionTabPlacement);
        }
    }

    public int getSQLResultsTabPlacement() {
        return this._sqlResultsTabPlacement;
    }

    public void setSQLResultsTabPlacement(int value) {
        if (this._sqlResultsTabPlacement != value) {
            int oldValue = this._sqlResultsTabPlacement;
            this._sqlResultsTabPlacement = value;
            this.getPropertyChangeReporter().firePropertyChange("sqlResultsTabPlacement", oldValue, this._sqlResultsTabPlacement);
        }
    }

    public String getCatalogFilterInclude() {
        return this._catalogFilterInclude;
    }

    public String getSchemaFilterInclude() {
        return this._schemaFilterInclude;
    }

    public String getObjectFilterInclude() {
        return this._objectFilterInclude;
    }

    public synchronized void setCatalogFilterInclude(String data) {
        String oldValue = this._catalogFilterInclude;
        this._catalogFilterInclude = data;
        this.getPropertyChangeReporter().firePropertyChange("catalogFilterInclude", (Object)oldValue, (Object)this._catalogFilterInclude);
    }

    public synchronized void setSchemaFilterInclude(String data) {
        String oldValue = this._schemaFilterInclude;
        this._schemaFilterInclude = data;
        this.getPropertyChangeReporter().firePropertyChange("schemaFilterInclude", (Object)oldValue, (Object)this._schemaFilterInclude);
    }

    public synchronized void setObjectFilterInclude(String data) {
        String oldValue = this._objectFilterInclude;
        this._objectFilterInclude = data;
        this.getPropertyChangeReporter().firePropertyChange("objectFilterInclude", (Object)oldValue, (Object)this._objectFilterInclude);
    }

    public String getCatalogFilterExclude() {
        return this._catalogFilterExclude;
    }

    public String getSchemaFilterExclude() {
        return this._schemaFilterExclude;
    }

    public String getObjectFilterExclude() {
        return this._objectFilterExclude;
    }

    public boolean getKeepTableLayoutOnRerun() {
        return this._keepTableLayoutOnRerun;
    }

    public synchronized void setKeepTableLayoutOnRerun(boolean data) {
        boolean oldValue = this._keepTableLayoutOnRerun;
        this._keepTableLayoutOnRerun = data;
        this.getPropertyChangeReporter().firePropertyChange("keepTableLayoutOnRerun", oldValue, this._keepTableLayoutOnRerun);
    }

    public synchronized void setCatalogFilterExclude(String data) {
        String oldValue = this._catalogFilterExclude;
        this._catalogFilterExclude = data;
        this.getPropertyChangeReporter().firePropertyChange("catalogFilterExclude", (Object)oldValue, (Object)this._catalogFilterExclude);
    }

    public synchronized void setSchemaFilterExclude(String data) {
        String oldValue = this._schemaFilterExclude;
        this._schemaFilterExclude = data;
        this.getPropertyChangeReporter().firePropertyChange("schemaFilterExclude", (Object)oldValue, (Object)this._schemaFilterExclude);
    }

    public synchronized void setObjectFilterExclude(String data) {
        String oldValue = this._objectFilterExclude;
        this._objectFilterExclude = data;
        this.getPropertyChangeReporter().firePropertyChange("objectFilterExclude", (Object)oldValue, (Object)this._objectFilterExclude);
    }

    public boolean getLoadSchemasCatalogs() {
        return this._loadSchemasCatalogs;
    }

    public synchronized void setLoadSchemasCatalogs(boolean data) {
        boolean oldValue = this._loadSchemasCatalogs;
        this._loadSchemasCatalogs = data;
        this.getPropertyChangeReporter().firePropertyChange("loadCatalogsSchemas", oldValue, this._loadSchemasCatalogs);
    }

    public synchronized void setShowResultsMetaData(boolean data) {
        boolean oldValue = this._showResultsMetaData;
        this._showResultsMetaData = data;
        this.getPropertyChangeReporter().firePropertyChange("showResultsMetaData", oldValue, this._showResultsMetaData);
    }

    public boolean getShowResultsMetaData() {
        return this._showResultsMetaData;
    }

    private synchronized PropertyChangeReporter getPropertyChangeReporter() {
        if (this._propChgReporter == null) {
            this._propChgReporter = new PropertyChangeReporter((Object)this);
        }
        return this._propChgReporter;
    }

    public int getSQLFetchSize() {
        return this._sqlFetchSize;
    }

    public boolean getSQLUseFetchSize() {
        return this._sqlUseFetchSize;
    }

    public static interface IPropertyNames {
        public static final String SQL_RESULT_TAB_LIMIT = "sqlResultTabLimit";
        public static final String ABORT_ON_ERROR = "abortOnError";
        public static final String WRITE_SQL_ERRORS_TO_LOG = "writeSQLErrorsToLog";
        public static final String LOAD_COLUMNS_IN_BACKGROUND = "loadColumnsInBackground";
        public static final String AUTO_COMMIT = "autoCommit";
        public static final String CATALOG_FILTER_INCLUDE = "catalogFilterInclude";
        public static final String SCHEMA_FILTER_INCLUDE = "schemaFilterInclude";
        public static final String OBJECT_FILTER_INCLUDE = "objectFilterInclude";
        public static final String CATALOG_FILTER_EXCLUDE = "catalogFilterExclude";
        public static final String SCHEMA_FILTER_EXCLUDE = "schemaFilterExclude";
        public static final String OBJECT_FILTER_EXCLUDE = "objectFilterExclude";
        public static final String COMMIT_ON_CLOSING_CONNECTION = "commitOnClosingConnection";
        public static final String CONTENTS_LIMIT_ROWS = "contentsLimitRows";
        public static final String CONTENTS_NBR_ROWS_TO_SHOW = "contentsNbrOfRowsToShow";
        public static final String FONT_INFO = "fontInfo";
        public static final String LARGE_RESULT_SET_OBJECT_INFO = "largeResultSetObjectInfo";
        public static final String LIMIT_SQL_ENTRY_HISTORY_SIZE = "limitSqlEntryHistorySize";
        public static final String LOAD_SCHEMAS_CATALOGS = "loadCatalogsSchemas";
        public static final String MAIN_TAB_PLACEMENT = "mainTabPlacement";
        public static final String META_DATA_OUTPUT_CLASS_NAME = "metaDataOutputClassName";
        public static final String OBJECT_TAB_PLACEMENT = "objectTabPlacement";
        public static final String SQL_ENTRY_HISTORY_SIZE = "sqlEntryHistorySize";
        public static final String SHOW_RESULTS_META_DATA = "showResultsMetaData";
        public static final String SHOW_ROW_COUNT = "showRowCount";
        public static final String SHOW_TOOL_BAR = "showToolBar";
        public static final String SQL_SHARE_HISTORY = "sqlShareHistory";
        public static final String SQL_EXECUTION_TAB_PLACEMENT = "sqlExecutionTabPlacement";
        public static final String SQL_RESULTS_TAB_PLACEMENT = "sqlResultsTabPlacement";
        public static final String SQL_LIMIT_ROWS = "sqlLimitRows";
        public static final String SQL_NBR_ROWS_TO_SHOW = "sqlNbrOfRowsToShow";
        public static final String SQL_RESULTS_OUTPUT_CLASS_NAME = "sqlResultsOutputClassName";
        public static final String SQL_START_OF_LINE_COMMENT = "sqlStartOfLineComment";
        public static final String SQL_STATEMENT_SEPARATOR_STRING = "sqlStatementSeparatorString";
        public static final String TABLE_CONTENTS_OUTPUT_CLASS_NAME = "tableContentsOutputClassName";
        public static final String KEEP_TABLE_LAYOUT_ON_RERUN = "keepTableLayoutOnRerun";
        public static final String LIMIT_SQL_RESULT_TABS = "limitSqlResultTabs";
        public static final String REMOVE_MULTI_LINE_COMMENT = "removeMultiLineComment";
        public static final String SQL_USE_FETCH_SIZE = "sqlUseFetchSize";
        public static final String SQL_FETCH_SIZE = "sqlFetchSize";
    }

    public static interface IDataSetDestinations {
        public static final String TEXT = DataSetViewerTextPanel.class.getName();
        public static final String READ_ONLY_TABLE = DataSetViewerTablePanel.class.getName();
        public static final String EDITABLE_TABLE = DataSetViewerEditableTablePanel.class.getName();
    }
}

