/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.INewSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.ISessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.FontChooser;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.TokenizerSessPropsInteractions;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SessionSQLPropertiesPanel
implements INewSessionPropertiesPanel,
ISessionPropertiesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionSQLPropertiesPanel.class);
    private final IApplication _app;
    private final SQLPropertiesPanel _myPanel;
    private final JScrollPane _scrolledMyPanel;
    private SessionProperties _props;

    public SessionSQLPropertiesPanel(IApplication app, ISession session) throws IllegalArgumentException {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this._app = app;
        this._myPanel = new SQLPropertiesPanel(app, session);
        this._scrolledMyPanel = new JScrollPane(this._myPanel);
    }

    @Override
    public void initialize(IApplication app) {
        this._props = this._app.getSquirrelPreferences().getSessionProperties();
        this._myPanel.loadData(this._props);
    }

    @Override
    public void initialize(IApplication app, ISession session) throws IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this._props = session.getProperties();
        this._myPanel.loadData(this._props);
    }

    @Override
    public Component getPanelComponent() {
        return this._scrolledMyPanel;
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("SessionSQLPropertiesPanel.sql");
    }

    @Override
    public String getHint() {
        return this.getTitle();
    }

    @Override
    public void applyChanges() {
        this._myPanel.applyChanges(this._props);
    }

    private static final class SQLPropertiesPanel
    extends JPanel {
        private JCheckBox _abortOnErrorChk = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.abortonerror"));
        private JCheckBox _writeSQLErrorsToLogChk = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.writesqlerrorstolog"));
        private JCheckBox _loadColumsInBackgroundChk = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.loadColumsInBackground"));
        private JCheckBox _autoCommitChk = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.autocommit"));
        private JCheckBox _commitOnClose = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.commitonclose"));
        private IntegerField _sqlNbrRowsToShowField = new IntegerField(5);
        private JCheckBox _sqlLimitRowsChk = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.limitrows"));
        private JCheckBox _sqlFetchSizeChk = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.fetchSize"));
        private IntegerField _sqlFetchSizeField = new IntegerField(5);
        private JTextField _stmtSepField = new JTextField(5);
        private JTextField _solCommentField = new JTextField(2);
        private JCheckBox _removeMultiLineComment = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.removeMultiLineComment"));
        private JCheckBox _limitSQLResultTabsChk = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.limitsqlresulttabs"));
        private IntegerField _limitSQLResultTabsField = new IntegerField(5);
        private JLabel _fontLbl = new JLabel();
        private FontButton _fontBtn = new FontButton(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.font"), this._fontLbl);
        private JCheckBox _shareSQLHistoryChk = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.sharesqlhistory"));
        private JCheckBox _limitSQLHistoryComboSizeChk = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.limitsqlhistorysize"));
        private IntegerField _limitSQLHistoryComboSizeField = new IntegerField(5);
        private JCheckBox _showResultsMetaChk = new JCheckBox(SessionSQLPropertiesPanel.access$000().getString("SessionSQLPropertiesPanel.showresultsmd"));
        private final ControlMediator _controlMediator = new ControlMediator();
        private ISession _session;

        SQLPropertiesPanel(IApplication app, ISession session) {
            this._session = session;
            this.createGUI();
        }

        void loadData(SessionProperties props) {
            this._abortOnErrorChk.setSelected(props.getAbortOnError());
            this._writeSQLErrorsToLogChk.setSelected(props.getWriteSQLErrorsToLog());
            this._loadColumsInBackgroundChk.setSelected(props.getLoadColumnsInBackground());
            this._autoCommitChk.setSelected(props.getAutoCommit());
            this._commitOnClose.setSelected(props.getCommitOnClosingConnection());
            this._sqlNbrRowsToShowField.setInt(props.getSQLNbrRowsToShow());
            this._sqlLimitRowsChk.setSelected(props.getSQLLimitRows());
            this._sqlFetchSizeChk.setSelected(props.getSQLUseFetchSize());
            this._sqlFetchSizeField.setInt(props.getSQLFetchSize());
            if (null != this._session) {
                IQueryTokenizer queryTokenizer = this._session.getQueryTokenizer();
                TokenizerSessPropsInteractions qtp = queryTokenizer.getTokenizerSessPropsInteractions();
                if (qtp.isTokenizerDefinesStatementSeparator()) {
                    this._stmtSepField.setText(queryTokenizer.getSQLStatementSeparator());
                    this._stmtSepField.setEditable(false);
                } else {
                    this._stmtSepField.setText(props.getSQLStatementSeparator());
                    this._stmtSepField.setEditable(true);
                }
                if (qtp.isTokenizerDefinesStartOfLineComment()) {
                    this._solCommentField.setText(queryTokenizer.getLineCommentBegin());
                    this._solCommentField.setEditable(false);
                } else {
                    this._solCommentField.setText(props.getStartOfLineComment());
                    this._solCommentField.setEditable(true);
                }
                if (qtp.isTokenizerDefinesStatementSeparator()) {
                    this._removeMultiLineComment.setSelected(queryTokenizer.isRemoveMultiLineComment());
                    this._removeMultiLineComment.setEnabled(false);
                } else {
                    this._removeMultiLineComment.setSelected(props.getRemoveMultiLineComment());
                    this._removeMultiLineComment.setEnabled(true);
                }
            } else {
                this._stmtSepField.setText(props.getSQLStatementSeparator());
                this._solCommentField.setText(props.getStartOfLineComment());
                this._removeMultiLineComment.setSelected(props.getRemoveMultiLineComment());
            }
            this._shareSQLHistoryChk.setSelected(props.getSQLShareHistory());
            this._limitSQLHistoryComboSizeChk.setSelected(props.getLimitSQLEntryHistorySize());
            this._limitSQLHistoryComboSizeField.setInt(props.getSQLEntryHistorySize());
            this._limitSQLResultTabsChk.setSelected(props.getLimitSQLResultTabs());
            this._limitSQLResultTabsField.setInt(props.getSqlResultTabLimit());
            this._showResultsMetaChk.setSelected(props.getShowResultsMetaData());
            FontInfo fi = props.getFontInfo();
            if (fi == null) {
                fi = new FontInfo(UIManager.getFont("TextArea.font"));
            }
            this._fontLbl.setText(fi.toString());
            this._fontBtn.setSelectedFont(fi.createFont());
            this.updateControlStatus();
        }

        void applyChanges(SessionProperties props) {
            props.setAbortOnError(this._abortOnErrorChk.isSelected());
            props.setWriteSQLErrorsToLog(this._writeSQLErrorsToLogChk.isSelected());
            props.setLoadColumnsInBackground(this._loadColumsInBackgroundChk.isSelected());
            props.setAutoCommit(this._autoCommitChk.isSelected());
            props.setCommitOnClosingConnection(this._commitOnClose.isSelected());
            props.setSQLNbrRowsToShow(this._sqlNbrRowsToShowField.getInt());
            props.setSQLLimitRows(this._sqlLimitRowsChk.isSelected());
            props.setSQLFetchSize(this._sqlFetchSizeField.getInt());
            props.setSQLUseFetchSize(this._sqlFetchSizeChk.isSelected());
            props.setSQLStatementSeparator(this._stmtSepField.getText());
            props.setStartOfLineComment(this._solCommentField.getText());
            props.setRemoveMultiLineComment(this._removeMultiLineComment.isSelected());
            props.setFontInfo(this._fontBtn.getFontInfo());
            props.setSQLShareHistory(this._shareSQLHistoryChk.isSelected());
            props.setLimitSQLEntryHistorySize(this._limitSQLHistoryComboSizeChk.isSelected());
            props.setSQLEntryHistorySize(this._limitSQLHistoryComboSizeField.getInt());
            props.setLimitSQLResultTabs(this._limitSQLResultTabsChk.isSelected());
            if (0 >= this._limitSQLResultTabsField.getInt()) {
                props.setSqlResultTabLimit(15);
            } else {
                props.setSqlResultTabLimit(this._limitSQLResultTabsField.getInt());
            }
            props.setShowResultsMetaData(this._showResultsMetaChk.isSelected());
        }

        private void updateControlStatus() {
            this._commitOnClose.setEnabled(!this._autoCommitChk.isSelected());
            this._sqlNbrRowsToShowField.setEnabled(this._sqlLimitRowsChk.isSelected());
            this._sqlFetchSizeField.setEnabled(this._sqlFetchSizeChk.isSelected());
            this._limitSQLResultTabsField.setEnabled(this._limitSQLResultTabsChk.isSelected());
            boolean shareSQLHistory = this._shareSQLHistoryChk.isSelected();
        }

        private void createGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)this.createSQLPanel(), gbc);
            ++gbc.gridy;
            this.add((Component)this.createFontPanel(), gbc);
            ++gbc.gridy;
            this.add((Component)this.createSQLHistoryPanel(), gbc);
        }

        private JPanel createSQLPanel() {
            TokenizerSessPropsInteractions tep;
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SessionSQLPropertiesPanel.sql")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 10;
            this._autoCommitChk.addChangeListener(this._controlMediator);
            this._sqlLimitRowsChk.addChangeListener(this._controlMediator);
            this._sqlFetchSizeChk.addChangeListener(this._controlMediator);
            this._sqlNbrRowsToShowField.setColumns(5);
            this._stmtSepField.setColumns(5);
            this._limitSQLResultTabsChk.addChangeListener(this._controlMediator);
            this._limitSQLResultTabsField.setColumns(5);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            pnl.add((Component)this._autoCommitChk, gbc);
            gbc.gridx += 2;
            gbc.gridwidth = 0;
            pnl.add((Component)this._commitOnClose, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 3;
            pnl.add((Component)this._showResultsMetaChk, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            pnl.add((Component)this._sqlLimitRowsChk, gbc);
            gbc.gridwidth = 1;
            gbc.gridx += 2;
            pnl.add((Component)this._sqlNbrRowsToShowField, gbc);
            ++gbc.gridx;
            gbc.gridwidth = 0;
            pnl.add((Component)new JLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.rows")), gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            pnl.add((Component)this._sqlFetchSizeChk, gbc);
            gbc.gridwidth = 1;
            gbc.gridx += 2;
            pnl.add((Component)this._sqlFetchSizeField, gbc);
            ++gbc.gridx;
            gbc.gridwidth = 0;
            pnl.add((Component)new JLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.rows")), gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            pnl.add((Component)this._limitSQLResultTabsChk, gbc);
            gbc.gridwidth = 1;
            gbc.gridx += 2;
            pnl.add((Component)this._limitSQLResultTabsField, gbc);
            ++gbc.gridx;
            gbc.gridwidth = 0;
            pnl.add((Component)new JLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.tabs")), gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 0;
            pnl.add((Component)this._abortOnErrorChk, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 0;
            pnl.add((Component)this._writeSQLErrorsToLogChk, gbc);
            Insets defaultInsets = gbc.insets;
            gbc.insets = (Insets)defaultInsets.clone();
            gbc.insets.bottom = 0;
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 0;
            String loadColsInBackgroundDescription = s_stringMgr.getString("SessionSQLPropertiesPanel.loadColsInBackgroundDescription");
            pnl.add((Component)new MultipleLineLabel(loadColsInBackgroundDescription), gbc);
            gbc.insets = (Insets)defaultInsets.clone();
            gbc.insets.top = 0;
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 0;
            pnl.add((Component)this._loadColumsInBackgroundChk, gbc);
            gbc.insets = defaultInsets;
            if (null != this._session && ((tep = this._session.getQueryTokenizer().getTokenizerSessPropsInteractions()).isTokenizerDefinesRemoveMultiLineComment() || tep.isTokenizerDefinesStartOfLineComment() || tep.isTokenizerDefinesStatementSeparator())) {
                ++gbc.gridy;
                gbc.gridwidth = 4;
                MultipleLineLabel lbl = new MultipleLineLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.tokenizerNotEditableMsg"));
                lbl.setForeground(Color.red);
                pnl.add((Component)lbl, gbc);
                gbc.gridwidth = 1;
            }
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            pnl.add((Component)new JLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.stmtsep")), gbc);
            ++gbc.gridx;
            pnl.add((Component)this._stmtSepField, gbc);
            ++gbc.gridx;
            pnl.add((Component)new RightLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.solcomment")), gbc);
            ++gbc.gridx;
            pnl.add((Component)this._solCommentField, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 4;
            pnl.add((Component)this._removeMultiLineComment, gbc);
            return pnl;
        }

        private JPanel createFontPanel() {
            JPanel pnl = new JPanel();
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SessionSQLPropertiesPanel.sqlentryarea")));
            pnl.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this._fontBtn.addActionListener(new FontButtonListener());
            gbc.gridx = 0;
            gbc.gridy = 0;
            pnl.add((Component)this._fontBtn, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            pnl.add((Component)this._fontLbl, gbc);
            return pnl;
        }

        private JPanel createSQLHistoryPanel() {
            this._shareSQLHistoryChk.addChangeListener(this._controlMediator);
            this._limitSQLHistoryComboSizeChk.addChangeListener(this._controlMediator);
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SessionSQLPropertiesPanel.sqlhistory")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            pnl.add((Component)this._shareSQLHistoryChk, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._limitSQLHistoryComboSizeChk, gbc);
            ++gbc.gridx;
            pnl.add((Component)this._limitSQLHistoryComboSizeField, gbc);
            return pnl;
        }

        private final class ControlMediator
        implements ChangeListener,
        ActionListener {
            private ControlMediator() {
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                SQLPropertiesPanel.this.updateControlStatus();
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLPropertiesPanel.this.updateControlStatus();
            }
        }

        private static final class FontButtonListener
        implements ActionListener {
            private FontButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() instanceof FontButton) {
                    FontButton btn = (FontButton)evt.getSource();
                    FontInfo fi = btn.getFontInfo();
                    Font font = null;
                    if (fi != null) {
                        font = fi.createFont();
                    }
                    if ((font = new FontChooser().showDialog(font)) != null) {
                        btn.setSelectedFont(font);
                        btn._lbl.setText(new FontInfo(font).toString());
                    }
                }
            }
        }

        private static final class FontButton
        extends JButton {
            private FontInfo _fi;
            private JLabel _lbl;
            private Font _font;

            FontButton(String text, JLabel lbl) {
                super(text);
                this._lbl = lbl;
            }

            FontInfo getFontInfo() {
                return this._fi;
            }

            Font getSelectedFont() {
                return this._font;
            }

            void setSelectedFont(Font font) {
                this._font = font;
                if (this._fi == null) {
                    this._fi = new FontInfo(font);
                } else {
                    this._fi.setFont(font);
                }
            }
        }

        private static final class RightLabel
        extends JLabel {
            RightLabel(String title) {
                super(title, 4);
            }
        }
    }
}

