/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.schemainfo;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.SchemaLoadInfo;
import net.sourceforge.squirrel_sql.client.gui.db.SchemaNameLoadInfo;
import net.sourceforge.squirrel_sql.client.session.ExtendedColumnInfo;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.client.session.schemainfo.CaseInsensitiveString;
import net.sourceforge.squirrel_sql.client.session.schemainfo.DefaultKeywords;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfoCache;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfoCacheSerializer;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfoUpdateListener;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SessionStartupTimeHintController;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DataTypeInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBack;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBackAdaptor;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SchemaInfo {
    public static final int TABLE_EXT_NOT_A_TABLE = 0;
    public static final int TABLE_EXT_COLS_LOADED_IN_THIS_CALL = 1;
    public static final int TABLE_EXT_COLS_LOADED_BEFORE = 2;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SchemaInfo.class);
    private boolean _loading = false;
    private boolean _loaded = false;
    private SQLDatabaseMetaData _dmd;
    ISession _session = null;
    private static final ILogger s_log = LoggerController.createLogger(SchemaInfo.class);
    private SessionAdapter _sessionListener;
    private static final int LOAD_METHODS_COUNT = 7;
    private static final int MAX_PROGRESS = 100;
    final HashMap<CaseInsensitiveString, CaseInsensitiveString> _tablesLoadingColsInBackground = new HashMap();
    private SchemaInfoCache _schemaInfoCache;
    private Vector<SchemaInfoUpdateListener> _listeners = new Vector();
    private boolean _inInitialLoad;
    private long _initalLoadBeginTime;
    private boolean _sessionStartupTimeHintShown;
    private boolean _schemasAndCatalogsLoaded;
    private boolean _tablesLoaded;
    private boolean _storedProceduresLoaded;

    public SchemaInfo(IApplication app) {
        this._sessionListener = new SessionAdapter(){

            @Override
            public void connectionClosedForReconnect(SessionEvent evt) {
                if (null != SchemaInfo.this._session && SchemaInfo.this._session.getIdentifier().equals(evt.getSession().getIdentifier())) {
                    SchemaInfo.this._dmd = null;
                }
            }

            @Override
            public void reconnected(SessionEvent evt) {
                if (null != SchemaInfo.this._session && SchemaInfo.this._session.getIdentifier().equals(evt.getSession().getIdentifier())) {
                    SchemaInfo.this._dmd = SchemaInfo.this._session.getSQLConnection().getSQLMetaData();
                    if (null != SchemaInfo.this._dmd) {
                        s_log.info((Object)s_stringMgr.getString("SchemaInfo.SuccessfullyRestoredDatabaseMetaData"));
                    }
                }
            }

            @Override
            public void sessionClosing(SessionEvent evt) {
                SchemaInfoCacheSerializer.store(SchemaInfo.this._session, SchemaInfo.this._schemaInfoCache);
            }
        };
        if (app != null) {
            app.getSessionManager().addSessionListener(this._sessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialLoad(ISession session) {
        this._session = session;
        this.breathing();
        this._schemaInfoCache = SchemaInfoCacheSerializer.load(this._session);
        try {
            this._inInitialLoad = true;
            this._initalLoadBeginTime = System.currentTimeMillis();
            this.privateLoadAll();
        }
        finally {
            this._inInitialLoad = false;
            this._schemaInfoCache.initialLoadDone();
        }
    }

    public void reloadAll() {
        this.reloadAll(true);
    }

    void reloadAll(boolean fireSchemaInfoUpdate) {
        this._schemaInfoCache.clearAll();
        this.privateLoadAll();
        if (fireSchemaInfoUpdate) {
            GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SchemaInfo.this.fireSchemaInfoUpdate();
                }
            });
        }
    }

    public void reloadAllTables() {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SchemaInfo.this._session.getSessionSheet().setStatusBarProgress(i18n.LOADING_TABLES_MSG, 0, 100, 50);
            }
        });
        this.breathing();
        this._schemaInfoCache.clearAllTableData();
        this.loadTables(null, null, null, null, 0);
        this.notifyTablesLoaded();
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SchemaInfo.this.fireSchemaInfoUpdate();
                SchemaInfo.this._session.getSessionSheet().setStatusBarProgressFinished();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privateLoadAll() {
        SchemaInfo schemaInfo = this;
        synchronized (schemaInfo) {
            if (this._loading) {
                return;
            }
            this._loading = true;
            this._schemasAndCatalogsLoaded = false;
            this._tablesLoaded = false;
            this._storedProceduresLoaded = false;
        }
        this.breathing();
        long mstart = System.currentTimeMillis();
        long mfinish = 0L;
        try {
            int beginProgress;
            ISQLConnection conn = this._session.getSQLConnection();
            this._dmd = conn.getSQLMetaData();
            this._dmd.clearCache();
            int progress = 0;
            progress = this.loadCatalogs(progress);
            progress = this.loadSchemas(progress);
            this.notifySchemasAndCatalogsLoad();
            long start = 0L;
            long finish = 0L;
            try {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)i18n.LOADING_KEYWORDS_MSG);
                    start = System.currentTimeMillis();
                }
                beginProgress = this.getLoadMethodProgress(progress++);
                this.setProgress(i18n.LOADING_KEYWORDS_MSG, beginProgress);
                this.loadKeywords(i18n.LOADING_KEYWORDS_MSG, beginProgress);
                if (s_log.isDebugEnabled()) {
                    finish = System.currentTimeMillis();
                    s_log.debug((Object)("Keywords loaded in " + (finish - start) + " ms"));
                }
            }
            catch (Exception ex) {
                s_log.error((Object)"Error loading keywords", (Throwable)ex);
            }
            try {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)i18n.LOADING_DATATYPES_MSG);
                    start = System.currentTimeMillis();
                }
                beginProgress = this.getLoadMethodProgress(progress++);
                this.setProgress(i18n.LOADING_DATATYPES_MSG, beginProgress);
                this.loadDataTypes(i18n.LOADING_DATATYPES_MSG, beginProgress);
                if (s_log.isDebugEnabled()) {
                    finish = System.currentTimeMillis();
                    s_log.debug((Object)("Data types loaded in " + (finish - start) + " ms"));
                }
            }
            catch (Exception ex) {
                s_log.error((Object)"Error loading data types", (Throwable)ex);
            }
            try {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)i18n.LOADING_FUNCTIONS_MSG);
                    start = System.currentTimeMillis();
                }
                int beginProgress2 = this.getLoadMethodProgress(progress++);
                this.setProgress(i18n.LOADING_FUNCTIONS_MSG, beginProgress2);
                this.loadGlobalFunctions(i18n.LOADING_FUNCTIONS_MSG, beginProgress2);
                if (s_log.isDebugEnabled()) {
                    finish = System.currentTimeMillis();
                    s_log.debug((Object)("Functions loaded in " + (finish - start) + " ms"));
                }
            }
            catch (Exception ex) {
                s_log.error((Object)"Error loading functions", (Throwable)ex);
            }
            progress = this.loadTables(null, null, null, null, progress);
            this.notifyTablesLoaded();
            progress = this.loadStoredProcedures(null, null, null, progress);
            this.notifyStoredProceduresLoaded();
        }
        finally {
            if (this._session != null && this._session.getSessionSheet() != null) {
                this._session.getSessionSheet().setStatusBarProgressFinished();
            }
            this._loading = false;
            this._loaded = true;
        }
        if (s_log.isDebugEnabled()) {
            mfinish = System.currentTimeMillis();
            s_log.debug((Object)("SchemaInfo.load took " + (mfinish - mstart) + " ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStoredProceduresLoaded() {
        SchemaInfo schemaInfo = this;
        synchronized (schemaInfo) {
            this._storedProceduresLoaded = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTablesLoaded() {
        SchemaInfo schemaInfo = this;
        synchronized (schemaInfo) {
            this._tablesLoaded = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySchemasAndCatalogsLoad() {
        SchemaInfo schemaInfo = this;
        synchronized (schemaInfo) {
            this._schemasAndCatalogsLoaded = true;
            this.notifyAll();
        }
    }

    private int loadStoredProcedures(String catalog, String schema, String procNamePattern, int progress) {
        long start = 0L;
        long finish = 0L;
        try {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)i18n.LOADING_PROCS_MSG);
                start = System.currentTimeMillis();
            }
            int beginProgress = this.getLoadMethodProgress(progress++);
            this.setProgress(i18n.LOADING_PROCS_MSG, beginProgress);
            this.privateLoadStoredProcedures(catalog, schema, procNamePattern, i18n.LOADING_PROCS_MSG, beginProgress);
            if (s_log.isDebugEnabled()) {
                finish = System.currentTimeMillis();
                s_log.debug((Object)("stored procedures loaded in " + (finish - start) + " ms"));
            }
        }
        catch (Exception ex) {
            s_log.error((Object)"Error loading stored procedures", (Throwable)ex);
        }
        return progress;
    }

    private int loadTables(String catalog, String schema, String tableNamePattern, String[] types, int progress) {
        long start = 0L;
        long finish = 0L;
        try {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)i18n.LOADING_TABLES_MSG);
                start = System.currentTimeMillis();
            }
            int beginProgress = this.getLoadMethodProgress(progress++);
            this.setProgress(i18n.LOADING_TABLES_MSG, beginProgress);
            this.privateLoadTables(catalog, schema, tableNamePattern, types, i18n.LOADING_TABLES_MSG, beginProgress);
            if (s_log.isDebugEnabled()) {
                finish = System.currentTimeMillis();
                s_log.debug((Object)("Tables loaded in " + (finish - start) + " ms"));
            }
        }
        catch (Exception ex) {
            s_log.error((Object)"Error loading tables", (Throwable)ex);
        }
        return progress;
    }

    private int loadSchemas(int progress) {
        long start = 0L;
        long finish = 0L;
        try {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)i18n.LOADING_SCHEMAS_MSG);
                start = System.currentTimeMillis();
            }
            int beginProgress = this.getLoadMethodProgress(progress++);
            this.setProgress(i18n.LOADING_SCHEMAS_MSG, beginProgress);
            this.privateLoadSchemas();
            if (s_log.isDebugEnabled()) {
                finish = System.currentTimeMillis();
                s_log.debug((Object)("Schemas loaded in " + (finish - start) + " ms"));
            }
        }
        catch (Exception ex) {
            s_log.error((Object)"Error loading schemas", (Throwable)ex);
        }
        return progress;
    }

    private int loadCatalogs(int progress) {
        long start = 0L;
        long finish = 0L;
        try {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)i18n.LOADING_CATALOGS_MSG);
                start = System.currentTimeMillis();
            }
            int beginProgress = this.getLoadMethodProgress(progress++);
            this.setProgress(i18n.LOADING_CATALOGS_MSG, beginProgress);
            this.privateLoadCatalogs();
            if (s_log.isDebugEnabled()) {
                finish = System.currentTimeMillis();
                s_log.debug((Object)("Catalogs loaded in " + (finish - start) + " ms"));
            }
        }
        catch (Exception ex) {
            s_log.error((Object)"Error loading catalogs", (Throwable)ex);
        }
        return progress;
    }

    private int getLoadMethodProgress(int progress) {
        return (int)((double)progress / 7.0 * 100.0);
    }

    private void setProgress(String note, int value) {
        this.breathing();
        if (this._session == null || this._session.getSessionSheet() == null) {
            return;
        }
        this._session.getSessionSheet().setStatusBarProgress(note, 0, 100, value);
        if (this._inInitialLoad && !this._sessionStartupTimeHintShown && !this._session.getAlias().getSchemaProperties().isCacheSchemaIndependentMetaData() && 0 == this._session.getAlias().getSchemaProperties().getGlobalState() && this._session.getApplication().getSquirrelPreferences().getShowSessionStartupTimeHint() && System.currentTimeMillis() - this._initalLoadBeginTime > 3000L) {
            this._sessionStartupTimeHintShown = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new SessionStartupTimeHintController(SchemaInfo.this._session);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void breathing() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"breathing: ignoring request to sleep the event dispatch thread");
            }
            return;
        }
        SchemaInfo schemaInfo = this;
        synchronized (schemaInfo) {
            block7: {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    if (!s_log.isInfoEnabled()) break block7;
                    s_log.info((Object)"breathing: Interrupted", (Throwable)e);
                }
            }
        }
    }

    private void privateLoadStoredProcedures(String catalog, String schema, String procNamePattern, final String msg, final int beginProgress) {
        try {
            ProgressCallBackAdaptor pcb = new ProgressCallBackAdaptor(){

                public void currentlyLoading(String simpleName) {
                    SchemaInfo.this.setProgress(msg + " (" + simpleName + ")", beginProgress);
                }
            };
            SchemaLoadInfo[] schemaLoadInfos = this._schemaInfoCache.getMatchingSchemaLoadInfos(schema);
            for (int i = 0; i < schemaLoadInfos.length; ++i) {
                if (!schemaLoadInfos[i].loadProcedures) continue;
                IProcedureInfo[] procedures = this._dmd.getProcedures(catalog, schemaLoadInfos[i].schemaName, procNamePattern, (ProgressCallBack)pcb);
                for (int j = 0; j < procedures.length; ++j) {
                    this._schemaInfoCache.writeToProcedureCache(procedures[j]);
                }
            }
        }
        catch (Throwable th) {
            s_log.error((Object)"Failed to load stored procedures", th);
        }
    }

    private void privateLoadCatalogs() {
        try {
            if (!this._schemaInfoCache.loadSchemaIndependentMetaData()) {
                return;
            }
            this._schemaInfoCache.writeCatalogs(this._dmd.getCatalogs());
        }
        catch (Throwable th) {
            s_log.error((Object)"failed to load catalog names", th);
        }
    }

    private void privateLoadSchemas() {
        try {
            String[] schemasToWrite;
            this._session.getApplication().getSessionManager().clearAllowedSchemaCache(this._session);
            SchemaNameLoadInfo schemaNameLoadInfo = this._schemaInfoCache.getSchemaNameLoadInfo();
            if (0 == schemaNameLoadInfo.state) {
                return;
            }
            if (1 == schemaNameLoadInfo.state) {
                schemasToWrite = this._session.getApplication().getSessionManager().getAllowedSchemas(this._session);
            } else if (2 == schemaNameLoadInfo.state) {
                schemasToWrite = schemaNameLoadInfo.schemaNames;
            } else {
                throw new IllegalArgumentException("Unknown SchemaNameLoadInfo.state = " + schemaNameLoadInfo.state);
            }
            this._schemaInfoCache.writeSchemas(schemasToWrite);
        }
        catch (Throwable th) {
            s_log.error((Object)"failed to load schema names", th);
        }
    }

    public boolean isKeyword(String data) {
        return this.isKeyword(new CaseInsensitiveString(data));
    }

    public boolean isKeyword(CaseInsensitiveString data) {
        if (!this._loading && data != null) {
            return this._schemaInfoCache.getKeywordsForReadOnly().containsKey(data);
        }
        return false;
    }

    public boolean isDataType(String data) {
        return this.isDataType(new CaseInsensitiveString(data));
    }

    public boolean isDataType(CaseInsensitiveString data) {
        if (!this._loading && data != null) {
            return this._schemaInfoCache.getDataTypesForReadOnly().containsKey(data);
        }
        return false;
    }

    public boolean isFunction(String data) {
        return this.isFunction(new CaseInsensitiveString(data));
    }

    public boolean isFunction(CaseInsensitiveString data) {
        if (!this._loading && data != null) {
            return this._schemaInfoCache.getFunctionsForReadOnly().containsKey(data);
        }
        return false;
    }

    public boolean isTable(String data) {
        return this.isTable(new CaseInsensitiveString(data));
    }

    public boolean isTable(CaseInsensitiveString data) {
        int tableExtRes = this.isTableExt(data);
        return 1 == tableExtRes || 2 == tableExtRes;
    }

    public int isTableExt(CaseInsensitiveString data) {
        if (!this._loading && data != null && this._schemaInfoCache.getTableNamesForReadOnly().containsKey(data)) {
            if (this.loadColumns(data)) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public boolean isColumn(String data) {
        return this.isColumn(new CaseInsensitiveString(data));
    }

    public boolean isColumn(CaseInsensitiveString data) {
        if (!this._loading && data != null) {
            return this._schemaInfoCache.getExtColumnInfosByColumnNameForReadOnly().containsKey(data);
        }
        return false;
    }

    public String getCaseSensitiveTableName(String data) {
        if (!this._loading && data != null) {
            return this._schemaInfoCache.getTableNamesForReadOnly().get(new CaseInsensitiveString(data));
        }
        return null;
    }

    public String getCaseSensitiveProcedureName(String data) {
        if (!this._loading && data != null) {
            return this._schemaInfoCache.getProcedureNamesForReadOnly().get(new CaseInsensitiveString(data));
        }
        return null;
    }

    private void loadKeywords(String msg, int beginProgress) {
        try {
            if (!this._schemaInfoCache.loadSchemaIndependentMetaData()) {
                return;
            }
            this.setProgress(msg + " (default keywords)", beginProgress);
            Hashtable<CaseInsensitiveString, String> keywordsBuf = new Hashtable<CaseInsensitiveString, String>();
            for (int i = 0; i < DefaultKeywords.KEY_WORDS.length; ++i) {
                String kw = DefaultKeywords.KEY_WORDS[i];
                keywordsBuf.put(new CaseInsensitiveString(kw), kw);
            }
            if (this._dmd != null) {
                String procedureTerm;
                String schemaTerm;
                this.setProgress(msg + " (DB specific keywords)", beginProgress);
                String[] sqlKeywords = this._dmd.getSQLKeywords();
                for (int i = 0; i < sqlKeywords.length; ++i) {
                    keywordsBuf.put(new CaseInsensitiveString(sqlKeywords[i]), sqlKeywords[i]);
                }
                String catalogTerm = this._dmd.getCatalogTerm();
                if (catalogTerm != null) {
                    keywordsBuf.put(new CaseInsensitiveString(catalogTerm), catalogTerm);
                }
                if ((schemaTerm = this._dmd.getSchemaTerm()) != null) {
                    keywordsBuf.put(new CaseInsensitiveString(schemaTerm), schemaTerm);
                }
                if ((procedureTerm = this._dmd.getProcedureTerm()) != null) {
                    keywordsBuf.put(new CaseInsensitiveString(procedureTerm), procedureTerm);
                }
            }
            this._schemaInfoCache.writeKeywords(keywordsBuf);
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error occured creating keyword collection", ex);
        }
    }

    private void loadDataTypes(String msg, int beginProgress) {
        try {
            if (!this._schemaInfoCache.loadSchemaIndependentMetaData()) {
                return;
            }
            Hashtable<CaseInsensitiveString, String> dataTypesBuf = new Hashtable<CaseInsensitiveString, String>();
            DataTypeInfo[] infos = this._dmd.getDataTypes();
            for (int i = 0; i < infos.length; ++i) {
                String typeName = infos[i].getSimpleName();
                dataTypesBuf.put(new CaseInsensitiveString(typeName), typeName);
                if (0 != i % 100) continue;
                this.setProgress(msg + " (" + typeName + ")", beginProgress);
            }
            this._schemaInfoCache.writeDataTypes(dataTypesBuf);
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error occured creating data types collection", ex);
        }
    }

    private void loadGlobalFunctions(String msg, int beginProgress) {
        if (!this._schemaInfoCache.loadSchemaIndependentMetaData()) {
            return;
        }
        ArrayList<String> buf = new ArrayList<String>();
        try {
            this.setProgress(msg + " (numeric functions)", beginProgress);
            buf.addAll(Arrays.asList(this._dmd.getNumericFunctions()));
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error", ex);
        }
        try {
            this.setProgress(msg + " (string functions)", beginProgress);
            buf.addAll(Arrays.asList(this._dmd.getStringFunctions()));
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error", ex);
        }
        try {
            this.setProgress(msg + " (time/date functions)", beginProgress);
            buf.addAll(Arrays.asList(this._dmd.getTimeDateFunctions()));
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error", ex);
        }
        Hashtable<CaseInsensitiveString, String> functionsBuf = new Hashtable<CaseInsensitiveString, String>();
        for (int i = 0; i < buf.size(); ++i) {
            String func = (String)buf.get(i);
            if (func.length() <= 0) continue;
            functionsBuf.put(new CaseInsensitiveString(func), func);
        }
        this._schemaInfoCache.writeFunctions(functionsBuf);
    }

    public String[] getKeywords() {
        return this._schemaInfoCache.getKeywordsForReadOnly().values().toArray(new String[this._schemaInfoCache.getKeywordsForReadOnly().size()]);
    }

    public String[] getDataTypes() {
        return this._schemaInfoCache.getDataTypesForReadOnly().values().toArray(new String[this._schemaInfoCache.getDataTypesForReadOnly().size()]);
    }

    public String[] getFunctions() {
        return this._schemaInfoCache.getFunctionsForReadOnly().values().toArray(new String[this._schemaInfoCache.getFunctionsForReadOnly().size()]);
    }

    public String[] getTables() {
        return this._schemaInfoCache.getTableNamesForReadOnly().values().toArray(new String[this._schemaInfoCache.getTableNamesForReadOnly().size()]);
    }

    public String[] getCatalogs() {
        return this._schemaInfoCache.getCatalogsForReadOnly().toArray(new String[this._schemaInfoCache.getCatalogsForReadOnly().size()]);
    }

    public String[] getSchemas() {
        return this._schemaInfoCache.getSchemasForReadOnly().toArray(new String[this._schemaInfoCache.getSchemasForReadOnly().size()]);
    }

    public ITableInfo[] getITableInfos() {
        return this.getITableInfos(null, null);
    }

    public ITableInfo[] getITableInfos(String catalog, String schema) {
        return this.getITableInfos(catalog, schema, null);
    }

    public ITableInfo[] getITableInfos(String catalog, String schema, String simpleName) {
        return this.getITableInfos(catalog, schema, new ObjFilterMatcher(simpleName), null);
    }

    public ITableInfo[] getITableInfos(String catalog, String schema, ObjFilterMatcher filterMatcher, String[] types) {
        ArrayList<ITableInfo> ret = new ArrayList<ITableInfo>();
        if (null != types) {
            ITableInfo[] tableInfosForUncachedTypes = this.getTableInfosForUncachedTypes(catalog, schema, filterMatcher, types);
            ret.addAll(Arrays.asList(tableInfosForUncachedTypes));
        }
        List<ITableInfo> tis = this._schemaInfoCache.getITableInfosForReadOnly();
        for (ITableInfo iTableInfo : tis) {
            if (null != catalog && !catalog.equalsIgnoreCase(iTableInfo.getCatalogName()) && !this.fulfillsPlatformDependendMatches(iTableInfo, catalog) || null != schema && !schema.equalsIgnoreCase(iTableInfo.getSchemaName()) || !SchemaInfoCache.containsType(types, iTableInfo.getType()) || !filterMatcher.matches(iTableInfo.getSimpleName())) continue;
            ret.add(iTableInfo);
        }
        return ret.toArray(new ITableInfo[ret.size()]);
    }

    private boolean fulfillsPlatformDependendMatches(ITableInfo iTableInfo, String catalog) {
        if (SQLDatabaseMetaData.DriverMatch.isComHttxDriver((ISQLConnection)this._session.getSQLConnection())) {
            return iTableInfo.getCatalogName() == null && "\".\"".equals(catalog);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITableInfo[] getTableInfosForUncachedTypes(String catalog, String schema, ObjFilterMatcher filterMatcher, String[] types) {
        block6: {
            ArrayList<String> missingTypes = new ArrayList<String>();
            for (int i = 0; i < types.length; ++i) {
                if (this._schemaInfoCache.isCachedTableType(types[i])) continue;
                missingTypes.add(types[i]);
            }
            if (0 >= missingTypes.size()) break block6;
            try {
                String[] buf = missingTypes.toArray(new String[missingTypes.size()]);
                ProgressCallBackAdaptor pcb = new ProgressCallBackAdaptor(){

                    public void currentlyLoading(String simpleName) {
                        StringBuilder tmp = new StringBuilder(i18n.LOADING_TABLES_MSG);
                        tmp.append(" (");
                        tmp.append(simpleName);
                        tmp.append(")");
                        SchemaInfo.this.setProgress(tmp.toString(), 1);
                    }
                };
                ITableInfo[] iTableInfoArray = this._dmd.getTables(catalog, schema, filterMatcher.getMetaDataMatchString(), buf, (ProgressCallBack)pcb);
                this._session.getSessionSheet().setStatusBarProgressFinished();
                return iTableInfoArray;
            }
            catch (Throwable throwable) {
                try {
                    this._session.getSessionSheet().setStatusBarProgressFinished();
                    throw throwable;
                }
                catch (SQLException e) {
                    s_log.error((Object)"Error loading uncached tables", (Throwable)e);
                }
            }
        }
        return new ITableInfo[0];
    }

    public IProcedureInfo[] getStoredProceduresInfos(String catalog, String schema) {
        return this.getStoredProceduresInfos(catalog, schema, new ObjFilterMatcher());
    }

    public IProcedureInfo[] getStoredProceduresInfos(String catalog, String schema, ObjFilterMatcher filterMatcher) {
        ArrayList<IProcedureInfo> ret = new ArrayList<IProcedureInfo>();
        for (IProcedureInfo iProcInfo : this._schemaInfoCache.getIProcedureInfosForReadOnly().keySet()) {
            boolean toAdd = true;
            if (null != catalog && !catalog.equalsIgnoreCase(iProcInfo.getCatalogName())) {
                toAdd = false;
            }
            if (null != schema && !schema.equalsIgnoreCase(iProcInfo.getSchemaName())) {
                toAdd = false;
            }
            if (!filterMatcher.matches(iProcInfo.getSimpleName())) {
                toAdd = false;
            }
            if (!toAdd) continue;
            ret.add(iProcInfo);
        }
        return ret.toArray(new IProcedureInfo[ret.size()]);
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    private void privateLoadTables(String catalog, String schema, String tableNamePattern, String[] types, final String msg, final int beginProgress) {
        try {
            ProgressCallBackAdaptor pcb = new ProgressCallBackAdaptor(){

                public void currentlyLoading(String simpleName) {
                    SchemaInfo.this.setProgress(msg + " (" + simpleName + ")", beginProgress);
                }
            };
            SchemaLoadInfo[] schemaLoadInfos = this._schemaInfoCache.getMatchingSchemaLoadInfos(schema, types);
            for (int i = 0; i < schemaLoadInfos.length; ++i) {
                ITableInfo[] infos = this._dmd.getTables(catalog, schemaLoadInfos[i].schemaName, tableNamePattern, schemaLoadInfos[i].tableTypes, (ProgressCallBack)pcb);
                this._schemaInfoCache.writeToTableCache(infos);
            }
        }
        catch (Throwable th) {
            s_log.error((Object)"failed to load table names", th);
        }
    }

    private boolean loadColumns(CaseInsensitiveString tableName) {
        try {
            if (this._schemaInfoCache.didTryLoadingColumns(tableName)) {
                return false;
            }
            if (this._session.getProperties().getLoadColumnsInBackground()) {
                if (this._tablesLoadingColsInBackground.containsKey(tableName)) {
                    return false;
                }
                final CaseInsensitiveString imutableString = new CaseInsensitiveString(tableName.toString());
                this._tablesLoadingColsInBackground.put(imutableString, imutableString);
                this._session.getApplication().getThreadPool().addTask(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            SchemaInfo.this.accessDbToLoadColumns(imutableString);
                        }
                        catch (Throwable th) {
                            s_log.error((Object)"failed to load columns", th);
                        }
                        finally {
                            SchemaInfo.this._tablesLoadingColsInBackground.remove(imutableString);
                        }
                    }
                });
            } else {
                this.accessDbToLoadColumns(tableName);
            }
        }
        catch (Throwable th) {
            s_log.error((Object)"failed to load table names", th);
        }
        return true;
    }

    private void accessDbToLoadColumns(CaseInsensitiveString tableName) throws SQLException {
        if (null == this._dmd) {
            s_log.warn((Object)s_stringMgr.getString("SchemaInfo.UnableToLoadColumns", new Object[]{tableName}));
            return;
        }
        String name = this.getCaseSensitiveTableName(tableName.toString());
        TableInfo ti = new TableInfo(null, null, name, "TABLE", null, (ISQLDatabaseMetaData)this._dmd);
        try {
            TableColumnInfo[] infos = this._dmd.getColumnInfo((ITableInfo)ti);
            this._schemaInfoCache.writeColumsToCache(infos, tableName);
        }
        catch (Throwable th) {
            this._schemaInfoCache.writeColumsNotAccessible(th, tableName);
        }
    }

    public ExtendedColumnInfo[] getExtendedColumnInfos(String tableName) {
        return this.getExtendedColumnInfos(null, null, tableName);
    }

    public ExtendedColumnInfo[] getExtendedColumnInfos(String catalog, String schema, String tableName) {
        CaseInsensitiveString cissTableName = new CaseInsensitiveString(tableName);
        this.loadColumns(cissTableName);
        List<ExtendedColumnInfo> extColInfo = this._schemaInfoCache.getExtendedColumnInfosForReadOnly(cissTableName);
        if (null == extColInfo) {
            return new ExtendedColumnInfo[0];
        }
        if (null == catalog && null == schema) {
            return extColInfo.toArray(new ExtendedColumnInfo[extColInfo.size()]);
        }
        ArrayList<ExtendedColumnInfo> ret = new ArrayList<ExtendedColumnInfo>();
        for (int i = 0; i < extColInfo.size(); ++i) {
            ExtendedColumnInfo extendedColumnInfo = extColInfo.get(i);
            boolean toAdd = true;
            if (null != catalog && null != extendedColumnInfo.getCatalog() && !catalog.equalsIgnoreCase(extendedColumnInfo.getCatalog())) {
                toAdd = false;
            }
            if (null != schema && null != extendedColumnInfo.getSchema() && !schema.equalsIgnoreCase(extendedColumnInfo.getSchema())) {
                toAdd = false;
            }
            if (!toAdd) continue;
            ret.add(extendedColumnInfo);
        }
        return ret.toArray(new ExtendedColumnInfo[ret.size()]);
    }

    public void dispose() {
        this._session.getApplication().getSessionManager().removeSessionListener(this._sessionListener);
    }

    public boolean isProcedure(CaseInsensitiveString data) {
        return this._schemaInfoCache.getProcedureNamesForReadOnly().containsKey(data);
    }

    public void reload(IDatabaseObjectInfo doi) {
        this.reload(doi, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload(IDatabaseObjectInfo doi, boolean fireSchemaInfoUpdate) {
        boolean doReloadAll = false;
        try {
            SchemaInfo schemaInfo = this;
            synchronized (schemaInfo) {
                block31: {
                    if (!this._loading) break block31;
                    return;
                }
                this._loading = true;
                this._schemasAndCatalogsLoaded = false;
                this._tablesLoaded = false;
                this._storedProceduresLoaded = false;
            }
            if (doi instanceof ITableInfo) {
                ITableInfo ti = (ITableInfo)doi;
                DatabaseObjectType dot = ti.getDatabaseObjectType();
                String[] types = null;
                if (DatabaseObjectType.TABLE == dot) {
                    types = new String[]{"TABLE"};
                } else if (DatabaseObjectType.VIEW == dot) {
                    types = new String[]{"VIEW"};
                }
                this._schemaInfoCache.clearTables(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), types);
                this.loadTables(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), types, 1);
            } else if (doi instanceof IProcedureInfo) {
                IProcedureInfo pi = (IProcedureInfo)doi;
                this._schemaInfoCache.clearStoredProcedures(pi.getCatalogName(), pi.getSchemaName(), pi.getSimpleName());
                this.loadStoredProcedures(pi.getCatalogName(), pi.getSchemaName(), pi.getSimpleName(), 1);
            } else if (DatabaseObjectType.TABLE_TYPE_DBO == doi.getDatabaseObjectType()) {
                this._schemaInfoCache.clearTables(doi.getCatalogName(), doi.getSchemaName(), null, null);
                this.loadTables(doi.getCatalogName(), doi.getSchemaName(), null, null, 0);
            } else if (DatabaseObjectType.TABLE == doi.getDatabaseObjectType()) {
                this._schemaInfoCache.clearTables(doi.getCatalogName(), doi.getSchemaName(), null, new String[]{"TABLE"});
                this.loadTables(doi.getCatalogName(), doi.getSchemaName(), null, new String[]{"TABLE"}, 1);
            } else if (DatabaseObjectType.VIEW == doi.getDatabaseObjectType()) {
                this._schemaInfoCache.clearTables(doi.getCatalogName(), doi.getSchemaName(), null, new String[]{"VIEW"});
                this.loadTables(doi.getCatalogName(), doi.getSchemaName(), null, new String[]{"VIEW"}, 1);
            } else if (DatabaseObjectType.PROCEDURE == doi.getDatabaseObjectType() || DatabaseObjectType.PROC_TYPE_DBO == doi.getDatabaseObjectType()) {
                this._schemaInfoCache.clearStoredProcedures(doi.getCatalogName(), doi.getSchemaName(), null);
                this.loadStoredProcedures(doi.getCatalogName(), doi.getSchemaName(), null, 1);
            } else if (DatabaseObjectType.SCHEMA == doi.getDatabaseObjectType()) {
                this._schemaInfoCache.clearTables(null, doi.getSchemaName(), null, null);
                int progress = this.loadTables(null, doi.getSchemaName(), null, null, 1);
                this._schemaInfoCache.clearStoredProcedures(null, doi.getSchemaName(), null);
                this.loadStoredProcedures(null, doi.getSchemaName(), null, progress);
            } else if (DatabaseObjectType.CATALOG == doi.getDatabaseObjectType()) {
                this._schemaInfoCache.clearTables(doi.getCatalogName(), null, null, null);
                int progress = this.loadTables(doi.getCatalogName(), null, null, null, 1);
                this._schemaInfoCache.clearStoredProcedures(doi.getCatalogName(), null, null);
                this.loadStoredProcedures(doi.getCatalogName(), null, null, progress);
            } else if (DatabaseObjectType.SESSION == doi.getDatabaseObjectType()) {
                doReloadAll = true;
            }
        }
        finally {
            this._session.getSessionSheet().setStatusBarProgressFinished();
            this._loading = false;
            this._schemasAndCatalogsLoaded = true;
            this._tablesLoaded = true;
            this._storedProceduresLoaded = true;
            this.notifySchemasAndCatalogsLoad();
            this.notifyTablesLoaded();
            this.notifyStoredProceduresLoaded();
            if (doReloadAll) {
                this.reloadAll(fireSchemaInfoUpdate);
            } else if (fireSchemaInfoUpdate) {
                this.fireSchemaInfoUpdate();
            }
        }
    }

    public void fireSchemaInfoUpdate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SchemaInfoUpdateListener[] listeners = SchemaInfo.this._listeners.toArray(new SchemaInfoUpdateListener[0]);
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].schemaInfoUpdated();
                }
            }
        });
    }

    public void addSchemaInfoUpdateListener(SchemaInfoUpdateListener l) {
        this._listeners.remove(l);
        this._listeners.add(l);
    }

    public void removeSchemaInfoUpdateListener(SchemaInfoUpdateListener l) {
        this._listeners.remove(l);
    }

    public void refershCacheForSimpleTableName(String simpleTableName) {
        this.refershCacheForSimpleTableName(simpleTableName, true);
    }

    void refershCacheForSimpleTableName(String simpleTableName, boolean fireSchemaInfoUpdate) {
        HashMap<String, String> caseSensitiveTableNames = new HashMap<String, String>();
        CaseInsensitiveString caseInsensitiveTableName = new CaseInsensitiveString(simpleTableName);
        String caseSensitiveTableName = this._schemaInfoCache.getTableNamesForReadOnly().get(caseInsensitiveTableName);
        caseSensitiveTableNames.put(caseSensitiveTableName, caseSensitiveTableName);
        for (String buf : caseSensitiveTableNames.keySet()) {
            TableInfo ti = new TableInfo(null, null, buf, null, null, (ISQLDatabaseMetaData)this._dmd);
            this.reload((IDatabaseObjectInfo)ti, fireSchemaInfoUpdate);
        }
    }

    public void refreshCacheForSimpleProcedureName(String simpleProcName) {
        this.refreshCacheForSimpleProcedureName(simpleProcName, true);
    }

    void refreshCacheForSimpleProcedureName(String simpleProcName, boolean fireSchemaInfoUpdate) {
        HashMap<String, String> caseSensitiveProcNames = new HashMap<String, String>();
        CaseInsensitiveString caseInsensitiveProcName = new CaseInsensitiveString(simpleProcName);
        String caseSensitiveProcName = this._schemaInfoCache.getProcedureNamesForReadOnly().remove(caseInsensitiveProcName);
        caseSensitiveProcNames.put(caseSensitiveProcName, caseSensitiveProcName);
        for (String buf : caseSensitiveProcNames.keySet()) {
            ProcedureInfo pi = new ProcedureInfo(null, null, buf, null, 0, this._dmd);
            this.reload((IDatabaseObjectInfo)pi, fireSchemaInfoUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillSchemasAndCatalogsLoaded() {
        try {
            SchemaInfo schemaInfo = this;
            synchronized (schemaInfo) {
                while (!this._schemasAndCatalogsLoaded) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillTablesLoaded() {
        try {
            SchemaInfo schemaInfo = this;
            synchronized (schemaInfo) {
                while (!this._tablesLoaded) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillStoredProceduresLoaded() {
        try {
            SchemaInfo schemaInfo = this;
            synchronized (schemaInfo) {
                while (!this._storedProceduresLoaded) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static interface i18n {
        public static final String LOADING_CATALOGS_MSG = SchemaInfo.access$000().getString("SchemaInfo.loadingCatalogs");
        public static final String LOADING_KEYWORDS_MSG = SchemaInfo.access$000().getString("SchemaInfo.loadingKeywords");
        public static final String LOADING_DATATYPES_MSG = SchemaInfo.access$000().getString("SchemaInfo.loadingDataTypes");
        public static final String LOADING_FUNCTIONS_MSG = SchemaInfo.access$000().getString("SchemaInfo.loadingFunctions");
        public static final String LOADING_TABLES_MSG = SchemaInfo.access$000().getString("SchemaInfo.loadingTables");
        public static final String LOADING_PROCS_MSG = SchemaInfo.access$000().getString("SchemaInfo.loadingStoredProcedures");
        public static final String LOADING_SCHEMAS_MSG = SchemaInfo.access$000().getString("SchemaInfo.loadingSchemas");
    }
}

