/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.schemainfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.squirrel_sql.client.session.ExtendedColumnInfo;
import net.sourceforge.squirrel_sql.client.session.schemainfo.CaseInsensitiveString;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SchemaInfoColumnCache
implements Serializable {
    private static final ILogger s_log = LoggerController.createLogger(SchemaInfoColumnCache.class);
    private Map<CaseInsensitiveString, List<ExtendedColumnInfo>> _extendedColumnInfosByTableName = Collections.synchronizedMap(new TreeMap());
    private Map<CaseInsensitiveString, List<ExtendedColumnInfo>> _extColumnInfosByColumnName = Collections.synchronizedMap(new TreeMap());
    private Set<CaseInsensitiveString> _tablesWithInaccessibleColumns = Collections.synchronizedSet(new HashSet());

    void writeColumsToCache(TableColumnInfo[] infos, CaseInsensitiveString simpleTableName) {
        ArrayList<ExtendedColumnInfo> ecisInTable = new ArrayList<ExtendedColumnInfo>();
        for (int i = 0; i < infos.length; ++i) {
            ExtendedColumnInfo eci = new ExtendedColumnInfo(infos[i], simpleTableName.toString());
            ecisInTable.add(eci);
            CaseInsensitiveString ciColName = new CaseInsensitiveString(eci.getColumnName());
            List<ExtendedColumnInfo> ecisInColName = this._extColumnInfosByColumnName.get(ciColName);
            if (null == ecisInColName) {
                ecisInColName = new ArrayList<ExtendedColumnInfo>();
                this._extColumnInfosByColumnName.put(ciColName, ecisInColName);
            }
            ecisInColName.add(eci);
        }
        CaseInsensitiveString imutableString = new CaseInsensitiveString(simpleTableName.toString());
        this._extendedColumnInfosByTableName.put(imutableString, ecisInTable);
    }

    void clearColumns() {
        this._tablesWithInaccessibleColumns.clear();
        this._extColumnInfosByColumnName.clear();
        this._extendedColumnInfosByTableName.clear();
    }

    public boolean didTryLoadingColumns(CaseInsensitiveString tableName) {
        return this._extendedColumnInfosByTableName.containsKey(tableName) || this._tablesWithInaccessibleColumns.contains(tableName);
    }

    Map<CaseInsensitiveString, List<ExtendedColumnInfo>> getExtColumnInfosByColumnNameForReadOnly() {
        return this._extColumnInfosByColumnName;
    }

    void clearColumns(CaseInsensitiveString ciSimpleTableName) {
        this._tablesWithInaccessibleColumns.remove(ciSimpleTableName);
        List<ExtendedColumnInfo> ecisInTable = this._extendedColumnInfosByTableName.remove(ciSimpleTableName);
        if (null == ecisInTable) {
            return;
        }
        for (ExtendedColumnInfo eci : ecisInTable) {
            CaseInsensitiveString ciColName = new CaseInsensitiveString(eci.getColumnName());
            this._extColumnInfosByColumnName.remove(ciColName);
        }
    }

    public void writeColumsNotAccessible(Throwable th, CaseInsensitiveString simpleTableName) {
        CaseInsensitiveString imutableString = new CaseInsensitiveString(simpleTableName.toString());
        this._tablesWithInaccessibleColumns.add(imutableString);
        s_log.error((Object)("Failed to load columns for table " + simpleTableName), th);
    }

    public List<ExtendedColumnInfo> getExtendedColumnInfosForReadOnly(CaseInsensitiveString cissTableName) {
        return this._extendedColumnInfosByTableName.get(cissTableName);
    }
}

