/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update;

public enum UpdateCheckFrequency {
    DAILY,
    WEEKLY,
    STARTUP;

    public long DAY_DURATION = 86400000L;
    public long WEEK_DURATION = 7L * this.DAY_DURATION;

    public boolean isTimeForUpdateCheck(long delta) {
        if (this == DAILY && delta > this.DAY_DURATION) {
            return true;
        }
        return this == WEEKLY && delta > this.WEEK_DURATION;
    }

    public static UpdateCheckFrequency getEnumForString(String value) {
        if ("daily".equalsIgnoreCase(value)) {
            return DAILY;
        }
        if ("startup".equalsIgnoreCase(value)) {
            return STARTUP;
        }
        if ("weekly".equalsIgnoreCase(value)) {
            return WEEKLY;
        }
        throw new IllegalArgumentException("Uknown update check frequency: " + value);
    }
}

