/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.client.plugin.IPluginManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.preferences.GlobalPreferencesActionListener;
import net.sourceforge.squirrel_sql.client.preferences.GlobalPreferencesSheet;
import net.sourceforge.squirrel_sql.client.preferences.IUpdateSettings;
import net.sourceforge.squirrel_sql.client.preferences.UpdatePreferencesPanel;
import net.sourceforge.squirrel_sql.client.update.DownloadStatusEventHandler;
import net.sourceforge.squirrel_sql.client.update.UpdateCheckFrequency;
import net.sourceforge.squirrel_sql.client.update.UpdateController;
import net.sourceforge.squirrel_sql.client.update.UpdateUtil;
import net.sourceforge.squirrel_sql.client.update.async.ReleaseFileUpdateCheckTask;
import net.sourceforge.squirrel_sql.client.update.async.UpdateCheckRunnableCallback;
import net.sourceforge.squirrel_sql.client.update.downloader.ArtifactDownloader;
import net.sourceforge.squirrel_sql.client.update.downloader.ArtifactDownloaderFactory;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactAction;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactStatus;
import net.sourceforge.squirrel_sql.client.update.gui.CheckUpdateListener;
import net.sourceforge.squirrel_sql.client.update.gui.UpdateManagerDialog;
import net.sourceforge.squirrel_sql.client.update.gui.UpdateSummaryDialog;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ChannelXmlBean;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.IJOptionPaneService;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.IProxySettings;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class UpdateControllerImpl
implements UpdateController,
CheckUpdateListener {
    public static final String TRANSLATION_JAR_PREFIX = "squirrel-sql_";
    private static final ILogger s_log = LoggerController.createLogger(UpdateControllerImpl.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(UpdateControllerImpl.class);
    private IApplication _app = null;
    private UpdateUtil _util = null;
    private ChannelXmlBean _currentChannelBean = null;
    private ChannelXmlBean _installedChannelBean = null;
    private static GlobalPrefsListener listener = null;
    private ArtifactDownloader _downloader = null;
    private ArtifactDownloaderFactory _downloaderFactory = null;
    private IJOptionPaneService _jOptionPaneService = null;
    private FileWrapperFactory fileWrapperFactory = null;

    public UpdateControllerImpl(IApplication app) {
        this._app = app;
        if (listener == null) {
            listener = new GlobalPrefsListener();
            GlobalPreferencesSheet.addGlobalPreferencesActionListener(listener);
        }
    }

    public void setArtifactDownloaderFactory(ArtifactDownloaderFactory factory) {
        Utilities.checkNull((String)"setArtifactDownloaderFactory", (Object[])new Object[]{"factory", factory});
        this._downloaderFactory = factory;
    }

    public void setUpdateUtil(UpdateUtil util) {
        Utilities.checkNull((String)"setUpdateUtil", (Object[])new Object[]{"util", util});
        this._util = util;
        this._util.setPluginManager(this._app.getPluginManager());
    }

    public void setJOptionPaneService(IJOptionPaneService jOptionPaneService) {
        Utilities.checkNull((String)"setJOptionPaneService", (Object[])new Object[]{"jOptionPaneService", jOptionPaneService});
        this._jOptionPaneService = jOptionPaneService;
    }

    public void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        Utilities.checkNull((String)"setFileWrapperFactory", (Object[])new Object[]{"fileWrapperFactory", fileWrapperFactory});
        this.fileWrapperFactory = fileWrapperFactory;
    }

    @Override
    public void showUpdateDialog() {
        final MainFrame parent = this._app.getMainFrame();
        final IUpdateSettings settings = this.getUpdateSettings();
        final boolean isRemoteUpdateSite = settings.isRemoteUpdateSite();
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateManagerDialog dialog = new UpdateManagerDialog(parent, isRemoteUpdateSite);
                if (isRemoteUpdateSite) {
                    dialog.setUpdateServerName(settings.getUpdateServer());
                    dialog.setUpdateServerPort(settings.getUpdateServerPort());
                    dialog.setUpdateServerPath(settings.getUpdateServerPath());
                    dialog.setUpdateServerChannel(settings.getUpdateServerChannel());
                } else {
                    dialog.setLocalUpdatePath(settings.getFileSystemUpdatePath());
                }
                dialog.addCheckUpdateListener(UpdateControllerImpl.this);
                dialog.setVisible(true);
            }
        });
    }

    public boolean isUpToDate() throws Exception {
        IUpdateSettings settings = this.getUpdateSettings();
        String releaseFilename = this._util.getLocalReleaseFile().getAbsolutePath();
        this._installedChannelBean = this._util.getLocalReleaseInfo(releaseFilename);
        if (settings.isRemoteUpdateSite()) {
            String channelName = this.getDesiredChannel(settings);
            StringBuilder releasePath = new StringBuilder("/");
            releasePath.append(this.getUpdateServerPath());
            releasePath.append("/");
            releasePath.append(channelName);
            releasePath.append("/");
            this._currentChannelBean = this._util.downloadCurrentRelease(this.getUpdateServerName(), this.getUpdateServerPortAsInt(), releasePath.toString(), "release.xml", (IProxySettings)this._app.getSquirrelPreferences().getProxySettings());
        } else {
            FileWrapper updateSiteReleaseXmlFilePath = this.fileWrapperFactory.create(settings.getFileSystemUpdatePath(), "release.xml");
            FileWrapper downloadReleaseXmlFile = this.fileWrapperFactory.create(this._util.getDownloadsDir(), "release.xml");
            this._util.copyFile(updateSiteReleaseXmlFilePath, downloadReleaseXmlFile);
            this._currentChannelBean = this._util.loadUpdateFromFileSystem(settings.getFileSystemUpdatePath());
        }
        settings.setLastUpdateCheckTimeMillis("" + System.currentTimeMillis());
        this.saveUpdateSettings(settings);
        return this._currentChannelBean.equals(this._installedChannelBean);
    }

    private String getDesiredChannel(IUpdateSettings settings) {
        String desiredChannel = settings.getUpdateServerChannel().toLowerCase();
        String currentChannelName = this._installedChannelBean.getName();
        if (!currentChannelName.equals(desiredChannel) && s_log.isInfoEnabled()) {
            s_log.info((Object)("getDesiredChannel: User is switching distribution channel from installed channel (" + currentChannelName + ") to new channel (" + desiredChannel + ")"));
        }
        return desiredChannel;
    }

    public Set<String> getInstalledPlugins() {
        PluginInfo[] infos;
        HashSet<String> result = new HashSet<String>();
        IPluginManager pmgr = this._app.getPluginManager();
        for (PluginInfo info : infos = pmgr.getPluginInformation()) {
            result.add(info.getInternalName());
        }
        return result;
    }

    public void pullDownUpdateFiles(List<ArtifactStatus> artifactStatusList, DownloadStatusEventHandler handler, boolean releaseVersionWillChange) {
        ArrayList<ArtifactStatus> newartifactsList = new ArrayList<ArtifactStatus>();
        for (ArtifactStatus status : artifactStatusList) {
            if (status.getArtifactAction() != ArtifactAction.INSTALL) continue;
            newartifactsList.add(status);
        }
        if (newartifactsList.size() > 0) {
            this._downloader = this._downloaderFactory.create(newartifactsList);
            this._downloader.setUtil(this._util);
            this._downloader.setProxySettings((IProxySettings)this._app.getSquirrelPreferences().getProxySettings());
            this._downloader.setIsRemoteUpdateSite(this.isRemoteUpdateSite());
            this._downloader.setHost(this.getUpdateServerName());
            this._downloader.setPort(Integer.parseInt(this.getUpdateServerPort()));
            this._downloader.setPath(this.getUpdateServerPath());
            this._downloader.setFileSystemUpdatePath(this.getUpdateSettings().getFileSystemUpdatePath());
            this._downloader.addDownloadStatusListener(handler);
            this._downloader.setReleaseVersionWillChange(releaseVersionWillChange);
            handler.setDownloader(this._downloader);
            this._downloader.setChannelName(this.getUpdateServerChannel().toLowerCase());
            this._downloader.start();
        } else {
            this.showMessage(i18n.CHANGES_RECORDED_TITLE, i18n.CHANGES_RECORDED_MSG);
        }
    }

    @Override
    public String getUpdateServerChannel() {
        return this.getUpdateSettings().getUpdateServerChannel();
    }

    @Override
    public String getUpdateServerName() {
        return this.getUpdateSettings().getUpdateServer();
    }

    @Override
    public boolean isRemoteUpdateSite() {
        return this.getUpdateSettings().isRemoteUpdateSite();
    }

    @Override
    public String getUpdateServerPath() {
        return this.getUpdateSettings().getUpdateServerPath();
    }

    @Override
    public String getUpdateServerPort() {
        return this.getUpdateSettings().getUpdateServerPort();
    }

    @Override
    public int getUpdateServerPortAsInt() {
        return Integer.parseInt(this.getUpdateServerPort());
    }

    @Override
    public boolean showConfirmMessage(String title, String msg) {
        int result = this._jOptionPaneService.showConfirmDialog((Component)this._app.getMainFrame(), (Object)msg, title, 0, 3);
        return result == 0;
    }

    @Override
    public void showMessage(String title, String msg) {
        this._jOptionPaneService.showMessageDialog((Component)this._app.getMainFrame(), (Object)msg, title, 1);
    }

    @Override
    public void showErrorMessage(String title, String msg, Exception e) {
        s_log.error((Object)msg, (Throwable)e);
        this._jOptionPaneService.showMessageDialog((Component)this._app.getMainFrame(), (Object)msg, title, 0);
    }

    @Override
    public void showErrorMessage(String title, String msg) {
        this.showErrorMessage(title, msg, null);
    }

    @Override
    public boolean isTimeToCheckForUpdates() {
        IUpdateSettings settings = this.getUpdateSettings();
        if (!settings.isEnableAutomaticUpdates()) {
            return false;
        }
        long lastCheckTime = Long.parseLong(settings.getLastUpdateCheckTimeMillis());
        long delta = System.currentTimeMillis() - lastCheckTime;
        UpdateCheckFrequency updateCheckFrequency = this._util.getUpdateCheckFrequency(settings);
        return updateCheckFrequency.isTimeForUpdateCheck(delta);
    }

    @Override
    public void promptUserToDownloadAvailableUpdates() {
        boolean userSaidYes = this.showConfirmMessage(i18n.PROMPT_TO_DOWNLOAD_AVAILABLE_UPDATES_TITLE, i18n.PROMPT_TO_DOWNLOAD_AVAILABLE_UPDATES_MSG);
        if (userSaidYes) {
            this.showUpdateDialog();
        } else {
            s_log.info((Object)("promptUserToDownloadAvailableUpdates: user decided not to download updates at this time (currentTimeMillis=" + System.currentTimeMillis() + ")"));
        }
    }

    @Override
    public void checkUpToDate() {
        UpdateCheckRunnableCallback callback = new UpdateCheckRunnableCallback(){

            @Override
            public void updateCheckComplete(final boolean isUpdateToDate, final ChannelXmlBean installedChannelXmlBean, final ChannelXmlBean currentChannelXmlBean) {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (isUpdateToDate) {
                            UpdateControllerImpl.this.showMessage(i18n.UPDATE_CHECK_TITLE, i18n.SOFTWARE_VERSION_CURRENT_MSG);
                        }
                        UpdateControllerImpl.this._currentChannelBean = currentChannelXmlBean;
                        UpdateControllerImpl.this._installedChannelBean = installedChannelXmlBean;
                        List<ArtifactStatus> artifactStatusItems = UpdateControllerImpl.this._util.getArtifactStatus(UpdateControllerImpl.this._currentChannelBean);
                        String installedVersion = UpdateControllerImpl.this._installedChannelBean.getCurrentRelease().getVersion();
                        String currentVersion = UpdateControllerImpl.this._currentChannelBean.getCurrentRelease().getVersion();
                        UpdateControllerImpl.this.showUpdateSummaryDialog(artifactStatusItems, installedVersion, currentVersion);
                    }
                });
            }

            @Override
            public void updateCheckFailed(Exception e) {
                if (e == null) {
                    UpdateControllerImpl.this.showErrorMessage(i18n.UPDATE_CHECK_FAILED_TITLE, i18n.RELEASE_FILE_DOWNLOAD_FAILED_MSG);
                } else if (e instanceof FileNotFoundException) {
                    String msg = s_stringMgr.getString("UpdateControllerImpl.localReleaseFileNotFound", new Object[]{UpdateControllerImpl.this._util.getSquirrelHomeDir() + "/" + "update" + "/" + "release.xml"});
                    UpdateControllerImpl.this.showErrorMessage(i18n.UPDATE_CHECK_FAILED_TITLE, msg);
                } else {
                    UpdateControllerImpl.this.showErrorMessage(i18n.UPDATE_CHECK_FAILED_TITLE, i18n.EXCEPTION_MSG + e.getClass().getName() + ":" + e.getMessage(), e);
                }
            }
        };
        ReleaseFileUpdateCheckTask runnable = new ReleaseFileUpdateCheckTask(callback, this.getUpdateSettings(), this._util, this._app);
        runnable.start();
    }

    private void showUpdateSummaryDialog(final List<ArtifactStatus> artifactStatusItems, final String installedVersion, final String currentVersion) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateSummaryDialog dialog = new UpdateSummaryDialog((Frame)UpdateControllerImpl.this._app.getMainFrame(), artifactStatusItems, UpdateControllerImpl.this);
                dialog.setInstalledVersion(installedVersion);
                dialog.setAvailableVersion(currentVersion);
                GUIUtils.centerWithinParent((Window)UpdateControllerImpl.this._app.getMainFrame());
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void applyChanges(List<ArtifactStatus> artifactStatusList, boolean releaseVersionWillChange) {
        try {
            this._util.saveChangeList(artifactStatusList);
            this.pullDownUpdateFiles(artifactStatusList, new DownloadStatusEventHandler(this), releaseVersionWillChange);
        }
        catch (Exception e) {
            this.showErrorMessage(i18n.UPDATE_CHECK_FAILED_TITLE, i18n.EXCEPTION_MSG + e.getClass().getName() + ":" + e.getMessage(), e);
        }
    }

    @Override
    public void showPreferences() {
        listener.setWaitingForOk(true);
        GlobalPreferencesSheet.showSheet(this._app, UpdatePreferencesPanel.class);
    }

    @Override
    public JFrame getMainFrame() {
        return this._app.getMainFrame();
    }

    private IUpdateSettings getUpdateSettings() {
        return this._app.getSquirrelPreferences().getUpdateSettings();
    }

    private void saveUpdateSettings(IUpdateSettings settings) {
        this._app.getSquirrelPreferences().setUpdateSettings(settings);
    }

    private class GlobalPrefsListener
    implements GlobalPreferencesActionListener {
        private boolean waitingForOk = false;

        private GlobalPrefsListener() {
        }

        @Override
        public void onDisplayGlobalPreferences() {
        }

        @Override
        public void onPerformClose() {
            this.showDialog();
        }

        @Override
        public void onPerformOk() {
            this.showDialog();
        }

        private void showDialog() {
            if (this.waitingForOk) {
                this.waitingForOk = false;
                UpdateControllerImpl.this.showUpdateDialog();
            }
        }

        public void setWaitingForOk(boolean waitingForOk) {
            this.waitingForOk = waitingForOk;
        }
    }

    static interface i18n {
        public static final String EXCEPTION_MSG = UpdateControllerImpl.access$000().getString("UpdateControllerImpl.exceptionMsg");
        public static final String UPDATE_CHECK_FAILED_TITLE = UpdateControllerImpl.access$000().getString("UpdateControllerImpl.updateCheckFailedTitle");
        public static final String SOFTWARE_VERSION_CURRENT_MSG = UpdateControllerImpl.access$000().getString("UpdateControllerImpl.softwareVersionCurrentMsg");
        public static final String UPDATE_CHECK_TITLE = UpdateControllerImpl.access$000().getString("UpdateControllerImpl.updateCheckTitle");
        public static final String CHANGES_RECORDED_TITLE = UpdateControllerImpl.access$000().getString("UpdateControllerImpl.changesRecordedTitle");
        public static final String CHANGES_RECORDED_MSG = UpdateControllerImpl.access$000().getString("UpdateControllerImpl.changesRecordedMsg");
        public static final String RELEASE_FILE_DOWNLOAD_FAILED_MSG = UpdateControllerImpl.access$000().getString("UpdateControllerImpl.releaseFileDownloadFailedMsg");
        public static final String PROMPT_TO_DOWNLOAD_AVAILABLE_UPDATES_MSG = UpdateControllerImpl.access$000().getString("UpdateControllerImpl.promptToDownloadAvailableUpdatesMsg");
        public static final String PROMPT_TO_DOWNLOAD_AVAILABLE_UPDATES_TITLE = UpdateControllerImpl.access$000().getString("UpdateControllerImpl.promptToDownloadAvailableUpdatesTitle");
    }
}

