/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.sourceforge.squirrel_sql.client.plugin.IPluginManager;
import net.sourceforge.squirrel_sql.client.preferences.IUpdateSettings;
import net.sourceforge.squirrel_sql.client.update.UpdateCheckFrequency;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactStatus;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ChangeListXmlBean;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ChannelXmlBean;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ReleaseXmlBean;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.IProxySettings;

public interface UpdateUtil {
    public static final String LOCAL_UPDATE_DIR_NAME = "update";
    public static final String BACKUP_ROOT_DIR_NAME = "backup";
    public static final String RELEASE_XML_FILENAME = "release.xml";
    public static final String CHANGE_LIST_FILENAME = "changeList.xml";
    public static final String DOWNLOADS_DIR_NAME = "downloads";
    public static final String CORE_ARTIFACT_ID = "core";
    public static final String PLUGIN_ARTIFACT_ID = "plugin";
    public static final String TRANSLATION_ARTIFACT_ID = "i18n";
    public static final String SQUIRREL_SQL_JAR_FILENAME = "squirrel-sql.jar";
    public static final String DOCS_ARCHIVE_FILENAME = "doc.zip";

    public ChannelXmlBean downloadCurrentRelease(String var1, int var2, String var3, String var4, IProxySettings var5) throws Exception;

    public ChannelXmlBean loadUpdateFromFileSystem(String var1);

    public String downloadHttpUpdateFile(String var1, int var2, String var3, String var4, long var5, long var7, IProxySettings var9) throws Exception;

    public boolean downloadLocalUpdateFile(String var1, String var2) throws FileNotFoundException, IOException;

    public void copyFile(FileWrapper var1, FileWrapper var2) throws FileNotFoundException, IOException;

    public void moveFiles(FileWrapper var1, String var2, boolean var3, FileWrapper var4) throws FileNotFoundException, IOException;

    public void copyDir(FileWrapper var1, FileWrapper var2) throws FileNotFoundException, IOException;

    public void copyDir(FileWrapper var1, String var2, boolean var3, FileWrapper var4) throws FileNotFoundException, IOException;

    public ChannelXmlBean getLocalReleaseInfo(String var1);

    public FileWrapper getSquirrelHomeDir();

    public FileWrapper getSquirrelPluginsDir();

    public FileWrapper getSquirrelLibraryDir();

    public FileWrapper getChangeListFile();

    public FileWrapper checkDir(FileWrapper var1, String var2);

    public void createZipFile(FileWrapper var1, FileWrapper ... var2) throws FileNotFoundException, IOException;

    public FileWrapper getSquirrelUpdateDir();

    public void saveChangeList(List<ArtifactStatus> var1) throws FileNotFoundException;

    public ChangeListXmlBean getChangeList() throws FileNotFoundException;

    public FileWrapper getLocalReleaseFile() throws FileNotFoundException;

    public List<ArtifactStatus> getArtifactStatus(ChannelXmlBean var1);

    public List<ArtifactStatus> getArtifactStatus(ReleaseXmlBean var1);

    public Set<String> getInstalledPlugins();

    public Set<String> getInstalledTranslations();

    public IPluginManager getPluginManager();

    public void setPluginManager(IPluginManager var1);

    public FileWrapper getDownloadsDir();

    public FileWrapper getCoreDownloadsDir();

    public FileWrapper getPluginDownloadsDir();

    public FileWrapper getI18nDownloadsDir();

    public FileWrapper getBackupDir();

    public FileWrapper getCoreBackupDir();

    public FileWrapper getPluginBackupDir();

    public FileWrapper getI18nBackupDir();

    public FileWrapper getInstalledSquirrelMainJarLocation();

    public ChangeListXmlBean getChangeList(FileWrapper var1) throws FileNotFoundException;

    public FileWrapper getFile(FileWrapper var1, String var2);

    public boolean deleteFile(FileWrapper var1);

    public void extractZipFile(FileWrapper var1, FileWrapper var2) throws IOException;

    public FileWrapper getDownloadFileLocation(ArtifactStatus var1);

    public boolean isPresentInDownloadsDirectory(ArtifactStatus var1);

    public long getCheckSum(FileWrapper var1);

    public UpdateCheckFrequency getUpdateCheckFrequency(IUpdateSettings var1);
}

