/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.plugin.IPluginManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.preferences.IUpdateSettings;
import net.sourceforge.squirrel_sql.client.update.UpdateCheckFrequency;
import net.sourceforge.squirrel_sql.client.update.UpdateUtil;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactStatus;
import net.sourceforge.squirrel_sql.client.update.util.PathUtils;
import net.sourceforge.squirrel_sql.client.update.util.PathUtilsImpl;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ArtifactXmlBean;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ChangeListXmlBean;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ChannelXmlBean;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ModuleXmlBean;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ReleaseXmlBean;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.UpdateXmlSerializer;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.UpdateXmlSerializerImpl;
import net.sourceforge.squirrel_sql.client.util.ApplicationFileWrappers;
import net.sourceforge.squirrel_sql.client.util.ApplicationFileWrappersImpl;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.fw.util.IProxySettings;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class UpdateUtilImpl
implements UpdateUtil {
    private static final ILogger s_log;
    private IPluginManager _pluginManager = null;
    public static final int ZIP_EXTRACTION_BUFFER_SIZE = 8192;
    private HashMap<String, Long> fileChecksumMap = new HashMap();
    private PathUtils _pathUtils = new PathUtilsImpl();
    private FileWrapperFactory _fileWrapperFactory = new FileWrapperFactoryImpl();
    private ApplicationFileWrappers _appFileWrappers = new ApplicationFileWrappersImpl();
    private IOUtilities _iou = new IOUtilitiesImpl();
    private UpdateXmlSerializer _serializer = new UpdateXmlSerializerImpl();

    public void setPathUtils(PathUtils pathUtils) {
        this._pathUtils = pathUtils;
    }

    public void setFileWrapperFactory(FileWrapperFactory factory) {
        this._fileWrapperFactory = factory;
    }

    public void setApplicationFileWrappers(ApplicationFileWrappers appFileWrappers) {
        this._appFileWrappers = appFileWrappers;
    }

    public void setIOUtilities(IOUtilities iou) {
        this._iou = iou;
    }

    public void setUpdateXmlSerializer(UpdateXmlSerializer serializer) {
        this._serializer = serializer;
    }

    @Override
    public long getCheckSum(FileWrapper f) {
        String absPath = f.getAbsolutePath();
        Long result = -1L;
        if (this.fileChecksumMap.containsKey(absPath)) {
            result = this.fileChecksumMap.get(absPath);
        } else {
            try {
                result = this._iou.getCheckSum(f);
            }
            catch (IOException e) {
                s_log.error((Object)("getCheckSum: failed to compute the checksum for file (" + f.getAbsolutePath() + "): " + e.getMessage()), (Throwable)e);
            }
            this.fileChecksumMap.put(absPath, result);
        }
        return result;
    }

    @Override
    public ChannelXmlBean downloadCurrentRelease(String host, int port, String path, String fileToGet, IProxySettings proxySettings) throws Exception {
        ChannelXmlBean result = null;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("downloadCurrentRelease: host=" + host + " port=" + port + " path=" + path + " fileToGet=" + fileToGet));
        }
        result = this.downloadCurrentReleaseHttp(host, port, path, fileToGet, proxySettings);
        return result;
    }

    @Override
    public ChannelXmlBean loadUpdateFromFileSystem(String path) {
        ChannelXmlBean result = null;
        try {
            FileWrapper f = this._fileWrapperFactory.create(path);
            if (!f.isDirectory()) {
                s_log.error((Object)("FileSystem path (" + path + ") is not a directory."));
            } else {
                f = this._fileWrapperFactory.create(f, "release.xml");
                result = this._serializer.readChannelBean(f);
            }
        }
        catch (IOException e) {
            s_log.error((Object)("Unexpected exception while attempting load updates from filesystem path (" + path + "): " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean downloadLocalUpdateFile(String fileToGet, String destDir) throws FileNotFoundException, IOException {
        boolean result = false;
        FileWrapper fromFile = this._fileWrapperFactory.create(fileToGet);
        if (fromFile.isFile() && fromFile.canRead()) {
            String filename = fromFile.getName();
            FileWrapper toFile = this._fileWrapperFactory.create(destDir, filename);
            this.copyFile(fromFile, toFile);
            result = true;
        } else {
            s_log.error((Object)("File " + fileToGet + " doesn't appear to be readable"));
        }
        return result;
    }

    @Override
    public void copyFile(FileWrapper from, FileWrapper to) throws FileNotFoundException, IOException {
        long toCheckSum;
        long fromCheckSum;
        if (!from.exists()) {
            s_log.error((Object)("Cannot copy from file (" + from.getAbsolutePath() + ") which doesn't appear to exist."));
            return;
        }
        FileWrapper toFile = to;
        if (to.isDirectory()) {
            toFile = this.getFile(to, from.getName());
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Copying from file (" + from.getAbsolutePath() + ") to file (" + toFile.getAbsolutePath() + ")"));
        }
        if (toFile.exists() && (fromCheckSum = this.getCheckSum(from)) == (toCheckSum = this.getCheckSum(toFile))) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("File to be copied(" + from.getAbsolutePath() + ") has the same checksum(" + fromCheckSum + ") as the file to copy to (" + toFile.getAbsolutePath() + "). Skipping copy."));
            }
            return;
        }
        this._iou.copyFile(from, toFile);
    }

    @Override
    public void moveFiles(FileWrapper fromDir, String filePattern, boolean matchPattern, FileWrapper toDir) throws FileNotFoundException, IOException {
        if (StringUtilities.isEmpty((String)filePattern)) {
            throw new IllegalArgumentException("filePattern arg cannot be empty or null");
        }
        if (!fromDir.isDirectory()) {
            throw new IllegalArgumentException("Expected fromDir(" + fromDir.getAbsolutePath() + ") to be a directory.");
        }
        if (!toDir.isDirectory()) {
            throw new IllegalArgumentException("Expected toDir(" + toDir.getAbsolutePath() + ") to be a directory.");
        }
        List<FileWrapper> filesToMove = this.getFilterFileList(fromDir, filePattern, matchPattern);
        for (FileWrapper file : filesToMove) {
            this.copyFile(file, toDir);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("moveFiles: Attempting to delete file " + file.getAbsolutePath()));
            }
            if (!file.delete()) continue;
            s_log.error((Object)("moveFiles: Unable to delete file " + file.getAbsolutePath()));
        }
    }

    @Override
    public void copyDir(FileWrapper fromDir, FileWrapper toDir) throws FileNotFoundException, IOException {
        this.verifyDirectory(fromDir, toDir);
        FileWrapper[] files = fromDir.listFiles();
        this.copyFiles(Arrays.asList(files), toDir);
    }

    private void verifyDirectory(FileWrapper fromDir, FileWrapper toDir) {
        if (!fromDir.isDirectory()) {
            throw new IllegalArgumentException("Expected fromDir(" + fromDir.getAbsolutePath() + ") to be a directory.");
        }
        if (!toDir.isDirectory()) {
            throw new IllegalArgumentException("Expected toDir(" + toDir.getAbsolutePath() + ") to be a directory.");
        }
    }

    @Override
    public void copyDir(FileWrapper fromDir, String filePattern, boolean matchPattern, FileWrapper toDir) throws FileNotFoundException, IOException {
        if (StringUtilities.isEmpty((String)filePattern)) {
            throw new IllegalArgumentException("filePattern arg cannot be empty or null");
        }
        this.verifyDirectory(fromDir, toDir);
        List<FileWrapper> filesToCopy = this.getFilterFileList(fromDir, filePattern, matchPattern);
        this.copyFiles(filesToCopy, toDir);
    }

    private List<FileWrapper> getFilterFileList(FileWrapper fromDir, String filePattern, boolean matchPattern) throws FileNotFoundException, IOException {
        FileWrapper[] files = fromDir.listFiles();
        ArrayList<FileWrapper> filesToCopy = new ArrayList<FileWrapper>();
        for (FileWrapper sourceFile : files) {
            boolean fileNameMatchesPattern = sourceFile.getName().matches(filePattern);
            if (matchPattern && fileNameMatchesPattern) {
                filesToCopy.add(sourceFile);
            }
            if (matchPattern || fileNameMatchesPattern) continue;
            filesToCopy.add(sourceFile);
        }
        return filesToCopy;
    }

    private void copyFiles(List<FileWrapper> files, FileWrapper toDir) throws FileNotFoundException, IOException {
        for (FileWrapper sourceFile : files) {
            this.copyFile(sourceFile, toDir);
        }
    }

    @Override
    public ChannelXmlBean getLocalReleaseInfo(String localReleaseFile) {
        ChannelXmlBean result = null;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Attempting to read local release file: " + localReleaseFile));
        }
        try {
            result = this._serializer.readChannelBean(localReleaseFile);
        }
        catch (IOException e) {
            s_log.error((Object)("Unable to read local release file: " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    @Override
    public FileWrapper getSquirrelHomeDir() {
        FileWrapper squirrelHomeDir = this._appFileWrappers.getSquirrelHomeDir();
        if (!squirrelHomeDir.isDirectory()) {
            s_log.error((Object)("SQuirreL Home Directory (" + squirrelHomeDir.getAbsolutePath() + " doesn't appear to be a directory"));
        }
        return squirrelHomeDir;
    }

    @Override
    public FileWrapper getInstalledSquirrelMainJarLocation() {
        return this._fileWrapperFactory.create(this.getSquirrelHomeDir(), "squirrel-sql.jar");
    }

    @Override
    public FileWrapper getSquirrelPluginsDir() {
        FileWrapper squirrelHomeDir = this._appFileWrappers.getPluginsDirectory();
        if (!squirrelHomeDir.isDirectory()) {
            s_log.error((Object)("SQuirreL Plugins Directory (" + squirrelHomeDir.getAbsolutePath() + " doesn't appear to be a directory"));
        }
        return squirrelHomeDir;
    }

    @Override
    public FileWrapper getSquirrelLibraryDir() {
        FileWrapper squirrelLibDir = this._appFileWrappers.getLibraryDirectory();
        if (!squirrelLibDir.isDirectory()) {
            s_log.error((Object)("SQuirreL Library Directory (" + squirrelLibDir.getAbsolutePath() + " doesn't appear to be a directory"));
        }
        return squirrelLibDir;
    }

    @Override
    public FileWrapper getSquirrelUpdateDir() {
        return this.getDir(this._appFileWrappers.getUpdateDirectory(), null, true);
    }

    @Override
    public FileWrapper getDownloadsDir() {
        return this.getDir(this.getSquirrelUpdateDir(), "downloads", true);
    }

    @Override
    public FileWrapper getCoreDownloadsDir() {
        return this.getDir(this.getDownloadsDir(), "core", true);
    }

    @Override
    public FileWrapper getPluginDownloadsDir() {
        return this.getDir(this.getDownloadsDir(), "plugin", true);
    }

    @Override
    public FileWrapper getI18nDownloadsDir() {
        return this.getDir(this.getDownloadsDir(), "i18n", true);
    }

    @Override
    public FileWrapper getBackupDir() {
        return this.getDir(this.getSquirrelUpdateDir(), "backup", false);
    }

    @Override
    public FileWrapper getCoreBackupDir() {
        return this.getDir(this.getBackupDir(), "core", false);
    }

    @Override
    public FileWrapper getI18nBackupDir() {
        return this.getDir(this.getBackupDir(), "i18n", false);
    }

    @Override
    public FileWrapper getPluginBackupDir() {
        return this.getDir(this.getBackupDir(), "plugin", false);
    }

    @Override
    public FileWrapper getChangeListFile() {
        FileWrapper updateDir = this.getSquirrelUpdateDir();
        FileWrapper changeListFile = this._fileWrapperFactory.create(updateDir, "changeList.xml");
        return changeListFile;
    }

    @Override
    public void saveChangeList(List<ArtifactStatus> changes) throws FileNotFoundException {
        ChangeListXmlBean changeBean = new ChangeListXmlBean();
        changeBean.setChanges(changes);
        this._serializer.write(changeBean, this.getChangeListFile());
    }

    @Override
    public ChangeListXmlBean getChangeList() throws FileNotFoundException {
        return this._serializer.readChangeListBean(this.getChangeListFile());
    }

    @Override
    public FileWrapper getLocalReleaseFile() throws FileNotFoundException {
        FileWrapper result = null;
        try {
            FileWrapper[] files;
            for (FileWrapper file : files = this.getSquirrelHomeDir().listFiles()) {
                FileWrapper[] updateFiles;
                if (!"update".equals(file.getName())) continue;
                for (FileWrapper updateFile : updateFiles = file.listFiles()) {
                    if (!"release.xml".equals(updateFile.getName())) continue;
                    result = updateFile;
                }
            }
        }
        catch (Exception e) {
            s_log.error((Object)"getLocalReleaseFile: Exception encountered while attempting to find release.xml file");
        }
        if (result == null) {
            throw new FileNotFoundException("File release.xml could not be found");
        }
        return result;
    }

    @Override
    public List<ArtifactStatus> getArtifactStatus(ChannelXmlBean channelXmlBean) {
        ReleaseXmlBean releaseXmlBean = channelXmlBean.getCurrentRelease();
        return this.getArtifactStatus(releaseXmlBean);
    }

    @Override
    public List<ArtifactStatus> getArtifactStatus(ReleaseXmlBean releaseXmlBean) {
        Set<String> installedPlugins = this.getInstalledPlugins();
        Set<String> installedTranslations = this.getInstalledTranslations();
        ArrayList<ArtifactStatus> result = new ArrayList<ArtifactStatus>();
        Set<ModuleXmlBean> currentModuleBeans = releaseXmlBean.getModules();
        for (ModuleXmlBean module : currentModuleBeans) {
            Set<ArtifactXmlBean> artifactBeans = module.getArtifacts();
            String moduleName = module.getName();
            for (ArtifactXmlBean artifact : artifactBeans) {
                ArtifactStatus status = new ArtifactStatus(artifact);
                status.setType(moduleName);
                if (status.isCoreArtifact()) {
                    status.setInstalled(true);
                }
                if (status.isPluginArtifact() && installedPlugins.contains(artifact.getName())) {
                    status.setInstalled(true);
                }
                if (status.isTranslationArtifact() && installedTranslations.contains(artifact.getName())) {
                    status.setInstalled(true);
                }
                result.add(status);
            }
        }
        return result;
    }

    @Override
    public Set<String> getInstalledPlugins() {
        HashSet<String> result = new HashSet<String>();
        for (PluginInfo info : this._pluginManager.getPluginInformation()) {
            result.add(info.getInternalName() + "-assembly.zip");
        }
        return result;
    }

    @Override
    public Set<String> getInstalledTranslations() {
        HashSet<String> result = new HashSet<String>();
        FileWrapper libDir = this.getSquirrelLibraryDir();
        for (String filename : libDir.list()) {
            if (!filename.startsWith("squirrel-sql_")) continue;
            result.add(filename);
        }
        return result;
    }

    @Override
    public IPluginManager getPluginManager() {
        return this._pluginManager;
    }

    @Override
    public void setPluginManager(IPluginManager manager) {
        this._pluginManager = manager;
    }

    @Override
    public FileWrapper checkDir(FileWrapper parent, String child) {
        FileWrapper dir = this._fileWrapperFactory.create(parent, child);
        if (!dir.exists() && !dir.mkdir()) {
            s_log.error((Object)("checkDir: Failed to mkdir - " + dir.getAbsolutePath()));
        }
        return dir;
    }

    @Override
    public void createZipFile(FileWrapper zipFile, FileWrapper ... sourceFiles) throws FileNotFoundException, IOException {
        ZipOutputStream os = new ZipOutputStream(new FileOutputStream(zipFile.getAbsolutePath()));
        this.zipFileOs(os, sourceFiles);
        os.close();
    }

    @Override
    public boolean deleteFile(FileWrapper path) {
        boolean result = true;
        if (path.exists()) {
            if (path.isFile()) {
                result = path.delete();
                if (s_log.isInfoEnabled()) {
                    if (result) {
                        s_log.info((Object)("deleteFile: successfully deleted file = " + path.getAbsolutePath()));
                    } else {
                        s_log.info((Object)("deleteFile: failed to delete file = " + path.getAbsolutePath()));
                    }
                }
            } else {
                FileWrapper[] files = path.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    result = result && this.deleteFile(files[i]);
                }
                result = result && path.delete();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractZipFile(FileWrapper zipFile, FileWrapper outputDirectory) throws IOException {
        if (!outputDirectory.isDirectory()) {
            s_log.error((Object)("Output directory specified (" + outputDirectory.getAbsolutePath() + ") doesn't appear to be a directory"));
            return;
        }
        FileInputStream fis = null;
        ZipInputStream zis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(zipFile.getAbsolutePath());
            zis = new ZipInputStream(fis);
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                String name = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    this.checkDir(outputDirectory, name);
                } else {
                    FileWrapper newFile = this._fileWrapperFactory.create(outputDirectory, name);
                    if (newFile.exists()) {
                        if (s_log.isInfoEnabled()) {
                            s_log.info((Object)("Deleting extraction file that already exists:" + newFile.getAbsolutePath()));
                        }
                        newFile.delete();
                    }
                    fos = new FileOutputStream(newFile.getAbsolutePath());
                    byte[] buffer = new byte[8192];
                    int n = 0;
                    while ((n = zis.read(buffer, 0, 8192)) > -1) {
                        fos.write(buffer, 0, n);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
        }
        finally {
            this._iou.closeOutputStream(fos);
            this._iou.closeInputStream((InputStream)fis);
            this._iou.closeInputStream((InputStream)zis);
        }
    }

    @Override
    public ChangeListXmlBean getChangeList(FileWrapper changeListFile) throws FileNotFoundException {
        return this._serializer.readChangeListBean(changeListFile);
    }

    @Override
    public FileWrapper getFile(FileWrapper installDir, String artifactName) {
        return this._fileWrapperFactory.create(installDir, artifactName);
    }

    @Override
    public String downloadHttpUpdateFile(String host, int port, String fileToGet, String destDir, long fileSize, long checksum, IProxySettings proxySettings) throws Exception {
        URL url = this._iou.constructHttpUrl(host, port, fileToGet);
        String result = null;
        FileWrapper resultFile = this._fileWrapperFactory.create(destDir, this._pathUtils.getFileFromPath(fileToGet));
        result = resultFile.getAbsolutePath();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("downloadHttpFile: writing http response body to file: " + resultFile));
        }
        int totalLength = this._iou.downloadHttpFile(url, resultFile, proxySettings);
        this.verifySize(url, fileSize, totalLength);
        return result;
    }

    @Override
    public FileWrapper getDownloadFileLocation(ArtifactStatus status) {
        FileWrapper result = null;
        if ("core".equals(status.getType())) {
            result = this.getFile(this.getCoreDownloadsDir(), status.getName());
        }
        if ("plugin".equals(status.getType())) {
            result = this.getFile(this.getPluginDownloadsDir(), status.getName());
        }
        if ("i18n".equals(status.getType())) {
            result = this.getFile(this.getI18nDownloadsDir(), status.getName());
        }
        return result;
    }

    @Override
    public boolean isPresentInDownloadsDirectory(ArtifactStatus status) {
        boolean result = false;
        FileWrapper downloadFile = this.getDownloadFileLocation(status);
        if (downloadFile.exists()) {
            long checkSum = this.getCheckSum(downloadFile);
            if (status.getChecksum() == checkSum && downloadFile.length() == status.getSize()) {
                result = true;
            }
        }
        return result;
    }

    private void verifySize(URL url, long expected, long actual) throws Exception {
        if (expected == -1L) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("verifySize: expected size was -1.  Skipping check for url: " + url.toString()));
            }
            return;
        }
        if (expected != actual) {
            throw new Exception("Attempt to get file contents from url (" + url.toString() + ") resulted in " + actual + " bytes downloaded, but " + expected + " bytes were expected.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipFileOs(ZipOutputStream os, FileWrapper[] sourceFiles) throws FileNotFoundException, IOException {
        for (FileWrapper file : sourceFiles) {
            if (file.isDirectory()) {
                this.zipFileOs(os, file.listFiles());
                continue;
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file.getAbsolutePath());
                os.putNextEntry(new ZipEntry(file.getPath()));
                this._iou.copyBytes((InputStream)fis, (OutputStream)os);
            }
            finally {
                this._iou.closeInputStream((InputStream)fis);
            }
        }
    }

    private FileWrapper getDir(FileWrapper parent, String dirName, boolean create) {
        FileWrapper result = null;
        result = dirName != null ? this._fileWrapperFactory.create(parent, dirName) : parent;
        if (!result.isDirectory()) {
            if (result.exists()) {
                s_log.error((Object)(dirName + " directory (" + result.getAbsolutePath() + ") doesn't appear to be a directory"));
            } else if (create) {
                result.mkdir();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelXmlBean downloadCurrentReleaseHttp(String host, int port, String path, String file, IProxySettings proxySettings) throws Exception {
        ChannelXmlBean result;
        block4: {
            result = null;
            InputStream is = null;
            try {
                String fileToGet = this._pathUtils.buildPath(true, path, file);
                String filename = this.downloadHttpUpdateFile(host, port, fileToGet, this.getDownloadsDir().getAbsolutePath(), -1L, -1L, proxySettings);
                FileWrapper releaseXmlFile = this._fileWrapperFactory.create(filename);
                if (releaseXmlFile.exists()) {
                    result = this._serializer.readChannelBean(releaseXmlFile);
                    break block4;
                }
                throw new FileNotFoundException("Current release file couldn't be downloaded");
            }
            finally {
                this._iou.closeInputStream(is);
            }
        }
        return result;
    }

    @Override
    public UpdateCheckFrequency getUpdateCheckFrequency(IUpdateSettings settings) {
        UpdateCheckFrequency result = UpdateCheckFrequency.STARTUP;
        String updateCheckFrequencyStr = settings.getUpdateCheckFrequency();
        if ("weekly".equalsIgnoreCase(updateCheckFrequencyStr)) {
            result = UpdateCheckFrequency.WEEKLY;
        }
        if ("daily".equalsIgnoreCase(updateCheckFrequencyStr)) {
            result = UpdateCheckFrequency.DAILY;
        }
        if ("startup".equalsIgnoreCase(updateCheckFrequencyStr)) {
            result = UpdateCheckFrequency.STARTUP;
        }
        return result;
    }

    static {
        ApplicationArguments.getInstance();
        s_log = LoggerController.createLogger(UpdateUtilImpl.class);
    }
}

