/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.downloader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.update.UpdateUtil;
import net.sourceforge.squirrel_sql.client.update.downloader.ArtifactDownloader;
import net.sourceforge.squirrel_sql.client.update.downloader.DefaultRetryStrategyImpl;
import net.sourceforge.squirrel_sql.client.update.downloader.RetryStrategy;
import net.sourceforge.squirrel_sql.client.update.downloader.event.DownloadEventType;
import net.sourceforge.squirrel_sql.client.update.downloader.event.DownloadStatusEvent;
import net.sourceforge.squirrel_sql.client.update.downloader.event.DownloadStatusListener;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactStatus;
import net.sourceforge.squirrel_sql.client.update.util.PathUtils;
import net.sourceforge.squirrel_sql.client.update.util.PathUtilsImpl;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.IProxySettings;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ArtifactDownloaderImpl
implements Runnable,
ArtifactDownloader {
    private static final ILogger s_log = LoggerController.createLogger(ArtifactDownloaderImpl.class);
    public static final String TRANSLATION_JAR_PREFIX_PATTERN = "squirrel-sql_.*";
    private List<ArtifactStatus> _artifactStatus = null;
    private volatile boolean _stopped = false;
    private boolean _isRemoteUpdateSite = true;
    private String _host = null;
    private String _path = null;
    private String _fileSystemUpdatePath = null;
    private List<DownloadStatusListener> listeners = new ArrayList<DownloadStatusListener>();
    Thread downloadThread = null;
    String _updatesDir = null;
    private int _port = 80;
    private String _channelName;
    private UpdateUtil _util = null;
    private PathUtils _pathUtils = new PathUtilsImpl();
    private IProxySettings _proxySettings = null;
    private boolean releaseVersionWillChange = false;
    private RetryStrategy _retryStrategy = new DefaultRetryStrategyImpl();

    public ArtifactDownloaderImpl(List<ArtifactStatus> artifactStatus) {
        this._artifactStatus = artifactStatus;
        this.downloadThread = new Thread((Runnable)this, "ArtifactDownloadThread");
    }

    @Override
    public void start() {
        this.downloadThread.start();
    }

    @Override
    public void run() {
        long totalBytesDownloaded = 0L;
        try {
            this.prepareDownloadsDirectory();
            this.sendDownloadStarted(this._artifactStatus.size());
            for (ArtifactStatus status : this._artifactStatus) {
                if (this._stopped) {
                    this.sendDownloadStopped();
                    return;
                }
                this.sendDownloadFileStarted(status.getName());
                String fileToGet = this._pathUtils.buildPath(true, this._path, this._channelName, status.getType(), status.getName());
                String destDir = this.getArtifactDownloadDestDir(status);
                if (this._util.isPresentInDownloadsDirectory(status)) {
                    if (s_log.isInfoEnabled()) {
                        s_log.info((Object)("run: Skipping download of file (" + fileToGet + ") which is already present " + "in the downloads directory."));
                    }
                    this.sendDownloadFileCompleted(status.getName());
                    continue;
                }
                boolean result = true;
                if (this._isRemoteUpdateSite) {
                    int count = 0;
                    boolean success = false;
                    while (this._retryStrategy.shouldTryAgain(count++) && !success) {
                        success = this.attemptFileDownload(fileToGet, destDir, status);
                        if (success) continue;
                        Utilities.sleep((long)this._retryStrategy.getTimeToWaitBeforeRetrying(count));
                    }
                    if (!success) {
                        this.sendDownloadFailed();
                        return;
                    }
                } else {
                    fileToGet = this._pathUtils.buildPath(false, this._fileSystemUpdatePath, status.getType(), status.getName());
                    result = this._util.downloadLocalUpdateFile(fileToGet, destDir);
                }
                if (!result) {
                    this.sendDownloadFailed();
                    return;
                }
                this.sendDownloadFileCompleted(status.getName());
                totalBytesDownloaded += status.getSize();
            }
        }
        catch (FileNotFoundException e) {
            s_log.error((Object)("run: Unexpected exception: " + e.getMessage()), (Throwable)e);
            this.sendDownloadFailed();
            return;
        }
        catch (IOException e) {
            s_log.error((Object)("run: Unexpected exception: " + e.getMessage()), (Throwable)e);
            this.sendDownloadFailed();
            return;
        }
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("run: Downloaded " + totalBytesDownloaded + " bytes total for all update files."));
        }
        this.sendDownloadComplete();
    }

    private void prepareDownloadsDirectory() throws FileNotFoundException, IOException {
        if (!this.releaseVersionWillChange) {
            this._util.copyDir(this._util.getSquirrelLibraryDir(), TRANSLATION_JAR_PREFIX_PATTERN, false, this._util.getCoreDownloadsDir());
            this._util.copyDir(this._util.getSquirrelLibraryDir(), TRANSLATION_JAR_PREFIX_PATTERN, true, this._util.getI18nDownloadsDir());
            this._util.copyFile(this._util.getInstalledSquirrelMainJarLocation(), this._util.getCoreDownloadsDir());
        }
        this._util.moveFiles(this._util.getCoreDownloadsDir(), TRANSLATION_JAR_PREFIX_PATTERN, true, this._util.getI18nDownloadsDir());
    }

    private boolean attemptFileDownload(String fileToGet, String destDir, ArtifactStatus status) {
        boolean success = true;
        try {
            this._util.downloadHttpUpdateFile(this._host, this._port, fileToGet, destDir, status.getSize(), status.getChecksum(), this._proxySettings);
        }
        catch (Exception e) {
            s_log.error((Object)("run: encountered exception while attempting to download file (" + fileToGet + "): " + e.getMessage()), (Throwable)e);
            success = false;
        }
        return success;
    }

    private String getArtifactDownloadDestDir(ArtifactStatus status) {
        FileWrapper destDir = this._util.getCoreDownloadsDir();
        if ("plugin".equals(status.getType())) {
            destDir = this._util.getPluginDownloadsDir();
        }
        if ("i18n".equals(status.getType())) {
            destDir = this._util.getI18nDownloadsDir();
        }
        return destDir.getAbsolutePath();
    }

    @Override
    public void stopDownload() {
        this._stopped = true;
    }

    @Override
    public List<ArtifactStatus> getArtifactStatus() {
        return this._artifactStatus;
    }

    @Override
    public void setArtifactStatus(List<ArtifactStatus> status) {
        this._artifactStatus = status;
    }

    @Override
    public boolean isRemoteUpdateSite() {
        return this._isRemoteUpdateSite;
    }

    @Override
    public void setIsRemoteUpdateSite(boolean remoteUpdateSite) {
        this._isRemoteUpdateSite = remoteUpdateSite;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public void setHost(String host) {
        this._host = host;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public void setPath(String path) {
        this._path = path;
    }

    @Override
    public UpdateUtil getUtil() {
        return this._util;
    }

    @Override
    public void addDownloadStatusListener(DownloadStatusListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDownloadListener(DownloadStatusListener listener) {
        this.listeners.remove(listener);
    }

    private void sendEvent(DownloadStatusEvent evt) {
        for (DownloadStatusListener listener : this.listeners) {
            listener.handleDownloadStatusEvent(evt);
        }
    }

    private void sendDownloadStarted(int totalFileCount) {
        DownloadStatusEvent evt = new DownloadStatusEvent(DownloadEventType.DOWNLOAD_STARTED);
        evt.setFileCountTotal(totalFileCount);
        this.sendEvent(evt);
    }

    private void sendDownloadStopped() {
        DownloadStatusEvent evt = new DownloadStatusEvent(DownloadEventType.DOWNLOAD_STOPPED);
        this.sendEvent(evt);
    }

    private void sendDownloadComplete() {
        DownloadStatusEvent evt = new DownloadStatusEvent(DownloadEventType.DOWNLOAD_COMPLETED);
        this.sendEvent(evt);
    }

    private void sendDownloadFailed() {
        DownloadStatusEvent evt = new DownloadStatusEvent(DownloadEventType.DOWNLOAD_FAILED);
        this.sendEvent(evt);
    }

    private void sendDownloadFileStarted(String filename) {
        DownloadStatusEvent evt = new DownloadStatusEvent(DownloadEventType.DOWNLOAD_FILE_STARTED);
        evt.setFilename(filename);
        this.sendEvent(evt);
    }

    private void sendDownloadFileCompleted(String filename) {
        DownloadStatusEvent evt = new DownloadStatusEvent(DownloadEventType.DOWNLOAD_FILE_COMPLETED);
        evt.setFilename(filename);
        this.sendEvent(evt);
    }

    @Override
    public String getFileSystemUpdatePath() {
        return this._fileSystemUpdatePath;
    }

    @Override
    public void setFileSystemUpdatePath(String systemUpdatePath) {
        this._fileSystemUpdatePath = systemUpdatePath;
    }

    @Override
    public void setPort(int updateServerPort) {
        this._port = updateServerPort;
    }

    @Override
    public void setChannelName(String name) {
        this._channelName = name;
    }

    @Override
    public void setUtil(UpdateUtil util) {
        this._util = util;
    }

    @Override
    public void setProxySettings(IProxySettings settings) {
        this._proxySettings = settings;
    }

    @Override
    public boolean isReleaseVersionWillChange() {
        return this.releaseVersionWillChange;
    }

    @Override
    public void setReleaseVersionWillChange(boolean releaseVersionWillChange) {
        this.releaseVersionWillChange = releaseVersionWillChange;
    }

    public void setRetryStrategy(RetryStrategy strategy) {
        this._retryStrategy = strategy;
    }
}

