/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.gui;

import java.io.Serializable;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactAction;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ArtifactXmlBean;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ArtifactStatus
implements Serializable {
    private static final transient long serialVersionUID = 3902196017013411091L;
    private static final transient StringManager s_stringMgr = StringManagerFactory.getStringManager(ArtifactStatus.class);
    private String name = null;
    private String type;
    private boolean installed;
    private String displayType;
    private ArtifactAction artifactAction = ArtifactAction.NONE;
    private long size;
    private long checksum;

    public ArtifactStatus() {
    }

    public ArtifactStatus(ArtifactXmlBean artifactXmlBean) {
        this.name = artifactXmlBean.getName();
        this.installed = artifactXmlBean.isInstalled();
        this.size = artifactXmlBean.getSize();
        this.checksum = artifactXmlBean.getChecksum();
        this.setType(artifactXmlBean.getType());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        if (type == null) {
            return;
        }
        if (type.equals("i18n")) {
            this.displayType = i18n.TRANSLATION_LABEL;
        }
        if (type.equals("core")) {
            this.displayType = i18n.CORE_LABEL;
        }
        if (type.equals("plugin")) {
            this.displayType = i18n.PLUGIN_LABEL;
        }
    }

    public boolean isCoreArtifact() {
        return "core".equals(this.type);
    }

    public boolean isPluginArtifact() {
        return "plugin".equals(this.type);
    }

    public boolean isTranslationArtifact() {
        return "i18n".equals(this.type);
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public ArtifactAction getArtifactAction() {
        return this.artifactAction;
    }

    public void setArtifactAction(ArtifactAction artifactAction) {
        this.artifactAction = artifactAction;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactStatus other = (ArtifactStatus)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        String TAB = "    ";
        String retValue = "";
        retValue = "ArtifactStatus ( " + super.toString() + "    " + "name = " + this.name + "    " + "type = " + this.type + "    " + "installed = " + this.installed + "    " + "displayType = " + this.displayType + "    " + "artifactAction = " + this.artifactAction + "    " + " )";
        return retValue;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public long getChecksum() {
        return this.checksum;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n
    extends Serializable {
        public static final String TRANSLATION_LABEL = ArtifactStatus.access$000().getString("ArtifactStatus.translationLabel");
        public static final String CORE_LABEL = ArtifactStatus.access$000().getString("ArtifactStatus.coreLabel");
        public static final String PLUGIN_LABEL = ArtifactStatus.access$000().getString("ArtifactStatus.pluginLabel");
    }
}

