/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.sourceforge.squirrel_sql.client.update.gui.CheckUpdateListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class UpdateManagerDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(UpdateManagerDialog.class);
    private JButton _checkBtn = null;
    private JButton _configBtn = null;
    private JButton _closeBtn = null;
    private JTextField _updateServerNameTF = null;
    private JTextField _updateServerPortTF = null;
    private JTextField _updateServerPathTF = null;
    private JTextField _updateServerChannelTF = null;
    private JTextField _localUpdatePath = null;
    private ArrayList<CheckUpdateListener> _checkUpdateListeners = new ArrayList();
    private boolean isRemoteUpdateSite = true;

    public UpdateManagerDialog(JFrame parent, boolean isRemoteUpdateSite) {
        super(parent, i18n.TITLE, true);
        this.setDefaultCloseOperation(1);
        this.isRemoteUpdateSite = isRemoteUpdateSite;
        this.init();
    }

    public void setUpdateServerName(String nameStr) {
        this._updateServerNameTF.setText(nameStr);
    }

    public void setUpdateServerPort(String portStr) {
        this._updateServerPortTF.setText(portStr);
    }

    public void setUpdateServerPath(String pathStr) {
        this._updateServerPathTF.setText(pathStr);
    }

    public void setUpdateServerChannel(String channelStr) {
        this._updateServerChannelTF.setText(channelStr);
    }

    public void setLocalUpdatePath(String path) {
        this._localUpdatePath.setText(path);
    }

    public void addCheckUpdateListener(CheckUpdateListener listener) {
        this._checkUpdateListeners.add(listener);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel locationPanel = null;
        locationPanel = this.isRemoteUpdateSite ? this.getRemoteLocationPanel() : this.getLocalUpdateSitePanel();
        this.add((Component)locationPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
        this.setSize(300, 200);
        GUIUtils.centerWithinParent((Window)this);
    }

    private JPanel getRemoteLocationPanel() {
        EmptyBorder border = new EmptyBorder(new Insets(5, 5, 5, 5));
        Dimension mediumField = new Dimension(200, 20);
        Dimension portField = new Dimension(50, 20);
        JPanel locationPanel = new JPanel();
        locationPanel.setBorder(new EmptyBorder(0, 0, 0, 10));
        locationPanel.setLayout(new GridBagLayout());
        int x = 0;
        int y = -1;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.anchor = 11;
        JLabel hostLabel = this.getBorderedLabel(i18n.HOST_LABEL, border);
        this._updateServerNameTF = this.getSizedTextField(mediumField);
        locationPanel.add((Component)hostLabel, this.getLabelConstraints(c));
        locationPanel.add((Component)this._updateServerNameTF, this.getFieldFillHorizontalConstaints(c));
        JLabel portLabel = this.getBorderedLabel(i18n.PORT_LABEL, border);
        this._updateServerPortTF = this.getSizedTextField(portField);
        locationPanel.add((Component)portLabel, this.getLabelConstraints(c));
        locationPanel.add((Component)this._updateServerPortTF, this.getFieldConstraints(c));
        JLabel pathLabel = this.getBorderedLabel(i18n.PATH_LABEL, border);
        this._updateServerPathTF = this.getSizedTextField(mediumField);
        locationPanel.add((Component)pathLabel, this.getLabelConstraints(c));
        locationPanel.add((Component)this._updateServerPathTF, this.getFieldFillHorizontalConstaints(c));
        JLabel channelLabel = this.getBorderedLabel(i18n.CHANNEL_LABEL, border);
        this._updateServerChannelTF = this.getSizedTextField(mediumField);
        locationPanel.add((Component)channelLabel, this.getLabelConstraints(c));
        locationPanel.add((Component)this._updateServerChannelTF, this.getFieldFillHorizontalConstaints(c));
        locationPanel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        return locationPanel;
    }

    private JPanel getLocalUpdateSitePanel() {
        EmptyBorder border = new EmptyBorder(new Insets(5, 5, 5, 5));
        Dimension mediumField = new Dimension(200, 20);
        JPanel locationPanel = new JPanel();
        locationPanel.setBorder(new EmptyBorder(0, 0, 0, 10));
        locationPanel.setLayout(new GridBagLayout());
        int x = 0;
        int y = -1;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.anchor = 11;
        JLabel localUpdatePathLabel = this.getBorderedLabel("Local Update Path:", border);
        this._localUpdatePath = this.getSizedTextField(mediumField);
        locationPanel.add((Component)localUpdatePathLabel, this.getLabelConstraints(c));
        locationPanel.add((Component)this._localUpdatePath, this.getFieldFillHorizontalConstaints(c));
        return locationPanel;
    }

    private JPanel getButtonPanel() {
        JPanel result = new JPanel();
        this._checkBtn = new JButton(i18n.CHECK_LABEL);
        this._checkBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateManagerDialog.this.setVisible(false);
                for (CheckUpdateListener listener : UpdateManagerDialog.this._checkUpdateListeners) {
                    try {
                        listener.checkUpToDate();
                    }
                    catch (Exception ex) {
                        listener.showErrorMessage("Unexpected Exception", "Update check failed with Exception: " + ex.getMessage(), ex);
                    }
                }
            }
        });
        this._configBtn = new JButton(i18n.SETTINGS_LABEL);
        this._configBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateManagerDialog.this.setVisible(false);
                for (CheckUpdateListener listener : UpdateManagerDialog.this._checkUpdateListeners) {
                    listener.showPreferences();
                }
            }
        });
        this._closeBtn = new JButton(i18n.CLOSE_LABEL);
        this._closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateManagerDialog.this.setVisible(false);
            }
        });
        result.add(this._checkBtn);
        result.add(this._configBtn);
        result.add(this._closeBtn);
        return result;
    }

    private GridBagConstraints getLabelConstraints(GridBagConstraints c) {
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 13;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        return c;
    }

    private GridBagConstraints getFieldFillHorizontalConstaints(GridBagConstraints c) {
        ++c.gridx;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 5);
        return c;
    }

    private GridBagConstraints getFieldConstraints(GridBagConstraints c) {
        ++c.gridx;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 0;
        return c;
    }

    private JLabel getBorderedLabel(String text, Border border) {
        JLabel result = new JLabel(text);
        result.setBorder(border);
        result.setPreferredSize(new Dimension(115, 20));
        result.setHorizontalAlignment(4);
        return result;
    }

    private JTextField getSizedTextField(Dimension preferredSize) {
        JTextField result = new JTextField();
        result.setPreferredSize(preferredSize);
        result.setMinimumSize(preferredSize);
        result.setEditable(false);
        return result;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String CHANNEL_LABEL = UpdateManagerDialog.access$000().getString("UpdateManagerDialog.channelLabel");
        public static final String CHECK_LABEL = UpdateManagerDialog.access$000().getString("UpdateManagerDialog.checkButtonLabel");
        public static final String CLOSE_LABEL = UpdateManagerDialog.access$000().getString("UpdateManagerDialog.closeLabel");
        public static final String HOST_LABEL = UpdateManagerDialog.access$000().getString("UpdateManagerDialog.hostLabel");
        public static final String LOCAL_UPDATE_PATH_LABEL = "Local Update Path:";
        public static final String LOCATION_TAB_LABEL = UpdateManagerDialog.access$000().getString("UpdateManagerDialog.repositoryTabLabel");
        public static final String PATH_LABEL = UpdateManagerDialog.access$000().getString("UpdateManagerDialog.pathLabel");
        public static final String PORT_LABEL = UpdateManagerDialog.access$000().getString("UpdateManagerDialog.portLabel");
        public static final String SETTINGS_LABEL = UpdateManagerDialog.access$000().getString("UpdateManagerDialog.settingsLabel");
        public static final String TITLE = UpdateManagerDialog.access$000().getString("UpdateManagerDialog.title");
    }
}

