/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.update.UpdateController;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactStatus;
import net.sourceforge.squirrel_sql.client.update.gui.UpdateSummaryTable;
import net.sourceforge.squirrel_sql.client.update.gui.UpdateSummaryTableModel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class UpdateSummaryDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(UpdateSummaryDialog.class);
    private UpdateSummaryTable _updateSummaryTable;
    private JLabel _installedVersionLabel = null;
    private JLabel _availableVersionLabel = null;
    private String _installedVersion = null;
    private String _availableVersion = null;

    public UpdateSummaryDialog(Frame owner, List<ArtifactStatus> artifactStatus, UpdateController updateController) {
        super(owner, i18n.TITLE);
        this.createGUI(artifactStatus, updateController);
    }

    public void setInstalledVersion(String installedVersion) {
        this._installedVersion = installedVersion;
        StringBuilder tmp = new StringBuilder(i18n.INSTALLED_VERSION_PREFIX);
        tmp.append(" ");
        tmp.append(installedVersion);
        this._installedVersionLabel.setText(tmp.toString());
        this.setReleaseVersionWillChangeFlag();
    }

    public void setAvailableVersion(String availableVersion) {
        this._availableVersion = availableVersion;
        StringBuilder tmp = new StringBuilder(i18n.AVAILABLE_VERSION_PREFIX);
        tmp.append(" ");
        tmp.append(availableVersion);
        this._availableVersionLabel.setText(tmp.toString());
        this.setReleaseVersionWillChangeFlag();
    }

    private void setReleaseVersionWillChangeFlag() {
        if (this._availableVersion == null || this._installedVersion == null) {
            return;
        }
        this._updateSummaryTable.setReleaseVersionWillChange(!this._availableVersion.equals(this._installedVersion));
    }

    private void createGUI(List<ArtifactStatus> artifactStatus, final UpdateController updateController) {
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this._installedVersionLabel = new JLabel();
        this._installedVersionLabel.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        this._availableVersionLabel = new JLabel();
        this._availableVersionLabel.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        JPanel labelPanel = new JPanel();
        labelPanel.add(this._installedVersionLabel);
        labelPanel.add(this._availableVersionLabel);
        contentPane.add((Component)labelPanel, "North");
        UpdateSummaryTableModel model = new UpdateSummaryTableModel(artifactStatus);
        this._updateSummaryTable = new UpdateSummaryTable(artifactStatus, model);
        contentPane.add((Component)new JScrollPane((Component)((Object)this._updateSummaryTable)), "Center");
        JPanel btnsPnl = new JPanel();
        JButton okBtn = new JButton(i18n.APPLY_LABEL);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                List<ArtifactStatus> changes = UpdateSummaryDialog.this._updateSummaryTable.getUserRequestedChanges();
                updateController.applyChanges(changes, UpdateSummaryDialog.this._updateSummaryTable.getReleaseVersionWillChange());
            }
        });
        btnsPnl.add(okBtn);
        JButton closeBtn = new JButton(i18n.CLOSE_LABEL);
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateSummaryDialog.this.dispose();
            }
        });
        btnsPnl.add(closeBtn);
        contentPane.add((Component)btnsPnl, "South");
        AbstractAction closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateSummaryDialog.this.setVisible(false);
                UpdateSummaryDialog.this.dispose();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this.getRootPane().getActionMap().put("CloseAction", closeAction);
        this.pack();
        this.setSize(655, 500);
        GUIUtils.centerWithinParent((Window)this);
        this.setResizable(true);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String APPLY_LABEL = UpdateSummaryDialog.access$000().getString("UpdateSummaryDialog.applyLabel");
        public static final String TITLE = UpdateSummaryDialog.access$000().getString("UpdateSummaryDialog.title");
        public static final String AVAILABLE_VERSION_PREFIX = UpdateSummaryDialog.access$000().getString("UpdateSummaryDialog.currentVersionPrefix");
        public static final String INSTALLED_VERSION_PREFIX = UpdateSummaryDialog.access$000().getString("UpdateSummaryDialog.installedVersionPrefix");
        public static final String CLOSE_LABEL = UpdateSummaryDialog.access$000().getString("UpdateSummaryDialog.close");
    }
}

