/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactAction;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactStatus;
import net.sourceforge.squirrel_sql.client.update.gui.UpdateSummaryTableActionItem;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class UpdateSummaryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<ArtifactStatus> _artifacts = new ArrayList<ArtifactStatus>();
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(UpdateSummaryTableModel.class);
    private static final Class<?>[] s_dataTypes = new Class[]{String.class, String.class, String.class, UpdateSummaryTableActionItem.class};
    private final String[] s_hdgs = new String[]{s_stringMgr.getString("UpdateSummaryTable.artifactNameLabel"), s_stringMgr.getString("UpdateSummaryTable.typeLabel"), s_stringMgr.getString("UpdateSummaryTable.installedLabel"), s_stringMgr.getString("UpdateSummaryTable.actionLabel")};
    private final int[] s_columnWidths = new int[]{150, 100, 100, 50};

    UpdateSummaryTableModel(List<ArtifactStatus> artifacts) {
        this._artifacts = artifacts;
    }

    @Override
    public Object getValueAt(int row, int col) {
        ArtifactStatus as = this._artifacts.get(row);
        switch (col) {
            case 0: {
                return as.getName();
            }
            case 1: {
                return as.getType();
            }
            case 2: {
                return as.isInstalled() ? i18n.YES_VAL : i18n.NO_VAL;
            }
            case 3: {
                if (as.isCoreArtifact()) {
                    return ArtifactAction.INSTALL;
                }
                return as.getArtifactAction();
            }
        }
        throw new IndexOutOfBoundsException("" + col);
    }

    @Override
    public int getRowCount() {
        return this._artifacts.size();
    }

    @Override
    public int getColumnCount() {
        return this.s_hdgs.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.s_hdgs[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return s_dataTypes[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 3;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        ArtifactStatus as = this._artifacts.get(row);
        ArtifactAction action = ArtifactAction.valueOf(value.toString());
        as.setArtifactAction(action);
    }

    public int getColumnWidth(int col) {
        return this.s_columnWidths[col];
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String YES_VAL = UpdateSummaryTableModel.access$000().getString("UpdateSummaryTable.yes");
        public static final String NO_VAL = UpdateSummaryTableModel.access$000().getString("UpdateSummaryTable.no");
    }
}

