/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.gui.installer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sourceforge.squirrel_sql.client.update.gui.installer.ProgressDialogController;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ProgressDialogControllerImpl
implements ProgressDialogController {
    private JDialog currentDialog = null;
    private JLabel currentMessage = null;
    private JLabel detailMessage = null;
    private JProgressBar currentProgressBar = null;
    private static ILogger s_log = LoggerController.createLogger(ProgressDialogControllerImpl.class);

    @Override
    public void hideProgressDialog() {
        s_log.info((Object)"Hiding dialog");
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressDialogControllerImpl.this.currentDialog.setVisible(false);
            }
        }, (boolean)true);
    }

    @Override
    public void incrementProgress() {
        s_log.info((Object)"incrementing progress");
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int currentValue = ProgressDialogControllerImpl.this.currentProgressBar.getValue();
                ProgressDialogControllerImpl.this.currentProgressBar.setValue(currentValue + 1);
            }
        }, (boolean)true);
    }

    @Override
    public void setDetailMessage(final String msg) {
        s_log.info((Object)("Setting detail message: " + msg));
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressDialogControllerImpl.this.detailMessage.setText(msg);
            }
        }, (boolean)true);
    }

    @Override
    public void showProgressDialog(final String title, final String msg, final int total) {
        s_log.info((Object)"showing progress dialog");
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressDialogControllerImpl.this.currentDialog = new JDialog((Frame)null, title);
                ProgressDialogControllerImpl.this.currentMessage = new JLabel(msg);
                ProgressDialogControllerImpl.this.detailMessage = new JLabel("...");
                ProgressDialogControllerImpl.this.currentProgressBar = new JProgressBar(0, total - 1);
                JPanel panel = new JPanel(new BorderLayout());
                JPanel messagePanel = new JPanel(new GridLayout(2, 1));
                messagePanel.add(ProgressDialogControllerImpl.this.currentMessage);
                messagePanel.add(ProgressDialogControllerImpl.this.detailMessage);
                panel.add((Component)messagePanel, "Center");
                panel.add((Component)ProgressDialogControllerImpl.this.currentProgressBar, "South");
                ProgressDialogControllerImpl.this.currentDialog.getContentPane().add(panel);
                ProgressDialogControllerImpl.this.currentDialog.setSize(300, 100);
                GUIUtils.centerWithinScreen((Window)ProgressDialogControllerImpl.this.currentDialog);
                ProgressDialogControllerImpl.this.currentDialog.setVisible(true);
            }
        }, (boolean)true);
    }

    @Override
    public void resetProgressDialog(final String title, final String msg, final int total) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressDialogControllerImpl.this.currentDialog.setTitle(title);
                ProgressDialogControllerImpl.this.currentMessage.setText(msg);
                ProgressDialogControllerImpl.this.currentProgressBar.setValue(0);
                ProgressDialogControllerImpl.this.currentProgressBar.setMinimum(0);
                ProgressDialogControllerImpl.this.currentProgressBar.setMaximum(total);
            }
        });
    }
}

