/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.gui.installer.event;

import net.sourceforge.squirrel_sql.client.update.gui.installer.ProgressDialogController;
import net.sourceforge.squirrel_sql.client.update.gui.installer.event.InstallEventType;
import net.sourceforge.squirrel_sql.client.update.gui.installer.event.InstallStatusEvent;
import net.sourceforge.squirrel_sql.client.update.gui.installer.event.InstallStatusListener;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class InstallStatusListenerImpl
implements InstallStatusListener {
    ProgressDialogController _progressDialogController = null;

    public InstallStatusListenerImpl(ProgressDialogController progressDialogFactory) {
        Utilities.checkNull((String)"InstallStatusListenerImpl.init", (Object[])new Object[]{"progressDialogFactory", progressDialogFactory});
        this._progressDialogController = progressDialogFactory;
    }

    @Override
    public void handleInstallStatusEvent(InstallStatusEvent evt) {
        if (evt.getType() == InstallEventType.INIT_CHANGELIST_STARTED) {
            this._progressDialogController.showProgressDialog("Initializing File Change List", "Processing file:", evt.getNumFilesToUpdate());
        }
        if (evt.getType() == InstallEventType.FILE_INIT_CHANGELIST_STARTED) {
            this._progressDialogController.setDetailMessage(evt.getArtifactName());
        }
        if (evt.getType() == InstallEventType.FILE_INIT_CHANGELIST_COMPLETE) {
            this._progressDialogController.incrementProgress();
        }
        if (evt.getType() == InstallEventType.INIT_CHANGELIST_COMPLETE) {
            this._progressDialogController.setDetailMessage("");
        }
        if (evt.getType() == InstallEventType.BACKUP_STARTED) {
            this._progressDialogController.resetProgressDialog("Backing up files to be updated", "Backing up file:", evt.getNumFilesToUpdate());
        }
        if (evt.getType() == InstallEventType.FILE_BACKUP_STARTED) {
            this._progressDialogController.setDetailMessage(evt.getArtifactName());
        }
        if (evt.getType() == InstallEventType.FILE_BACKUP_COMPLETE) {
            this._progressDialogController.incrementProgress();
        }
        if (evt.getType() == InstallEventType.BACKUP_COMPLETE) {
            this._progressDialogController.setDetailMessage("");
        }
        if (evt.getType() == InstallEventType.REMOVE_STARTED) {
            this._progressDialogController.resetProgressDialog("Removing file to be updated", "Removing file:", evt.getNumFilesToUpdate());
        }
        if (evt.getType() == InstallEventType.FILE_REMOVE_STARTED) {
            this._progressDialogController.setDetailMessage(evt.getArtifactName());
        }
        if (evt.getType() == InstallEventType.FILE_REMOVE_STARTED) {
            this._progressDialogController.incrementProgress();
        }
        if (evt.getType() == InstallEventType.REMOVE_COMPLETE) {
            this._progressDialogController.setDetailMessage("");
        }
        if (evt.getType() == InstallEventType.INSTALL_STARTED) {
            this._progressDialogController.resetProgressDialog("Installing updated files", "Installing file:", evt.getNumFilesToUpdate());
        }
        if (evt.getType() == InstallEventType.FILE_INSTALL_STARTED) {
            this._progressDialogController.setDetailMessage(evt.getArtifactName());
        }
        if (evt.getType() == InstallEventType.FILE_INSTALL_COMPLETE) {
            this._progressDialogController.incrementProgress();
        }
        if (evt.getType() == InstallEventType.INSTALL_COMPLETE) {
            this._progressDialogController.hideProgressDialog();
        }
    }
}

