/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.xmlbeans;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ModuleXmlBean;

public class ReleaseXmlBean
implements Serializable {
    private static final long serialVersionUID = -7311033877370497900L;
    private String name;
    private String version;
    private Date createTime;
    private Date lastModifiedTime;
    Set<ModuleXmlBean> modules = new HashSet<ModuleXmlBean>();
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'_'HH:mm:ss.SSSZ");

    public ReleaseXmlBean() {
        this.lastModifiedTime = this.createTime = new Date();
    }

    public ReleaseXmlBean(String name, String version) {
        this();
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.lastModifiedTime = new Date();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.lastModifiedTime = new Date();
    }

    public Set<ModuleXmlBean> getModules() {
        return this.modules;
    }

    public void setModules(Set<ModuleXmlBean> modules) {
        this.modules = modules;
        this.lastModifiedTime = new Date();
    }

    public void addmodule(ModuleXmlBean module) {
        if (module == null) {
            return;
        }
        this.modules.add(module);
        this.lastModifiedTime = new Date();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReleaseXmlBean other = (ReleaseXmlBean)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getCreateTime() {
        return this.dateFormat.format(this.createTime);
    }

    public void setCreateTime(Date createTime) {
        if (createTime == null) {
            return;
        }
        this.createTime = createTime;
    }

    public String getLastModifiedTime() {
        return this.dateFormat.format(this.lastModifiedTime);
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        if (lastModifiedTime == null) {
            return;
        }
        this.lastModifiedTime = lastModifiedTime;
    }

    public String toString() {
        String TAB = "    ";
        StringBuilder retValue = new StringBuilder();
        retValue.append("ReleaseXmlBean ( ").append(super.toString()).append("    ").append("name = ").append(this.name).append("    ").append("version = ").append(this.version).append("    ").append("createTime = ").append(this.createTime).append("    ").append("lastModifiedTime = ").append(this.lastModifiedTime).append("    ").append("modules = ").append(this.modules).append("    ").append("dateFormat = ").append(this.dateFormat).append("    ").append(" )");
        return retValue.toString();
    }
}

