/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.xslthl.Block;
import net.sf.xslthl.StyledBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharIter
implements Iterable<Character>,
Iterator<Character> {
    private String buffer;
    private int position = 0;
    private int length;
    private int mark = 0;
    private Matcher matcher;

    public CharIter(String string) {
        this.buffer = string;
        this.length = string.length();
    }

    public int getMark() {
        return this.mark;
    }

    public void setMark() {
        this.mark = this.position;
    }

    public void setMark(int n) {
        this.mark = n;
    }

    public boolean isMarked() {
        return this.mark < this.position;
    }

    public String getMarked() {
        if (this.position > this.length) {
            this.position = this.length;
        }
        return this.buffer.substring(this.mark, this.position);
    }

    public Block markedToBlock() {
        Block block = new Block(this.getMarked());
        this.setMark();
        return block;
    }

    public Block markedToStyledBlock(String string) {
        StyledBlock styledBlock = new StyledBlock(this.getMarked(), string);
        this.setMark();
        return styledBlock;
    }

    public void moveNext() {
        ++this.position;
    }

    public void moveNext(int n) {
        this.position += n;
    }

    public void moveNextAndMark() {
        this.moveNext();
        this.setMark();
    }

    public void moveToEnd() {
        this.position = this.length;
    }

    public boolean finished() {
        return this.position >= this.length;
    }

    public Character current() {
        return Character.valueOf(this.buffer.charAt(this.position));
    }

    @Override
    public Character next() {
        if (this.position + 1 < this.length) {
            return Character.valueOf(this.buffer.charAt(this.position + 1));
        }
        return null;
    }

    public Character next(int n) {
        if (this.position + n < this.length) {
            return Character.valueOf(this.buffer.charAt(this.position + n));
        }
        return null;
    }

    public Character prev() {
        if (this.position > 0) {
            return Character.valueOf(this.buffer.charAt(this.position - 1));
        }
        return null;
    }

    public Character prev(int n) {
        if (this.position - n >= 0) {
            return Character.valueOf(this.buffer.charAt(this.position - n));
        }
        return null;
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, false);
    }

    public boolean startsWith(String string, boolean bl) {
        return this.startsWith(string, 0, bl);
    }

    public boolean startsWith(String string, int n) {
        return this.startsWith(string, n, false);
    }

    public boolean startsWith(String string, int n, boolean bl) {
        if (bl) {
            int n2 = this.position + n + string.length();
            if (n2 >= this.length) {
                n2 = this.length - 1;
            }
            return this.buffer.substring(this.position + n, n2).equalsIgnoreCase(string);
        }
        return this.buffer.startsWith(string, this.position + n);
    }

    public Matcher createMatcher(Pattern pattern) {
        this.matcher = pattern.matcher(this.buffer);
        return this.matcher;
    }

    public int getPosition() {
        return this.position;
    }

    public int getLength() {
        return this.length;
    }

    public int remaining() {
        if (this.position < this.length) {
            return this.length - this.position;
        }
        return 0;
    }

    public int indexOf(String string) {
        int n = this.buffer.indexOf(string, this.position);
        return n < 0 ? -1 : n - this.position;
    }

    @Override
    public Iterator<Character> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return !this.finished();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

