/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.MainHighlighter;
import net.sf.xslthl.Params;
import net.sf.xslthl.Version;
import net.sf.xslthl.highlighters.AnnotationHighlighter;
import net.sf.xslthl.highlighters.HeredocHighlighter;
import net.sf.xslthl.highlighters.HexaDecimalHighlighter;
import net.sf.xslthl.highlighters.KeywordsHighlighter;
import net.sf.xslthl.highlighters.MultilineCommentHighlighter;
import net.sf.xslthl.highlighters.NestedMultilineCommentHighlighter;
import net.sf.xslthl.highlighters.NumberHighlighter;
import net.sf.xslthl.highlighters.OnelineCommentHighlighter;
import net.sf.xslthl.highlighters.RegexHighlighterEx;
import net.sf.xslthl.highlighters.StringHighlighter;
import net.sf.xslthl.highlighters.WordHighlighter;
import net.sf.xslthl.highlighters.XMLHighlighter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Config {
    public static final String CONFIG_PROPERTY = "xslthl.config";
    public static final String VERBOSE_LOADING_PROPERTY = "xslthl.config.verbose";
    public static final String NO_EXTERNAL_PROPERTY = "xslthl.noexternal";
    private static final Map<String, Config> instances = new HashMap<String, Config>();
    public static final Map<String, Class<? extends Highlighter>> highlighterClasses = new HashMap<String, Class<? extends Highlighter>>();
    protected String prefix = "http://xslthl.sf.net";
    protected String uri = "xslthl";
    protected Map<String, MainHighlighter> highlighters = new HashMap<String, MainHighlighter>();
    protected boolean verbose = Boolean.getBoolean("xslthl.config.verbose");

    public static Config getInstance() {
        return Config.getInstance(null);
    }

    public static Config getInstance(String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string;
        if (!instances.containsKey(string2)) {
            Config config = new Config(string);
            instances.put(string2, config);
        }
        return instances.get(string2);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public MainHighlighter getMainHighlighter(String string) {
        if (string != null && string.length() > 0 && !this.highlighters.containsKey(string) && !Boolean.getBoolean(NO_EXTERNAL_PROPERTY)) {
            Object object;
            String string2 = null;
            try {
                object = new URI(string);
                if (((URI)object).getScheme() != null) {
                    string2 = ((URI)object).toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (string2 == null) {
                object = new File(string);
                if (((File)object).getAbsoluteFile().exists()) {
                    string2 = ((File)object).getAbsoluteFile().toURI().toString();
                } else if (this.verbose) {
                    System.out.println(String.format("%s is not an known language id, valid URI, or existing file name", string));
                }
            }
            if (string2 != null) {
                try {
                    object = this.loadHl(string2);
                    this.highlighters.put(string, (MainHighlighter)object);
                    return object;
                }
                catch (Exception exception) {
                    System.err.println(String.format("Unable to load highlighter from %s: %s", string, exception.getMessage()));
                }
            }
        }
        return this.highlighters.get(string);
    }

    protected MainHighlighter loadHl(String string) throws Exception {
        MainHighlighter mainHighlighter = new MainHighlighter();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(string);
        this.createHighlighters(mainHighlighter, document.getDocumentElement().getElementsByTagName("highlighter"));
        this.createHighlighters(mainHighlighter, document.getDocumentElement().getElementsByTagName("wholehighlighter"));
        return mainHighlighter;
    }

    protected void createHighlighters(MainHighlighter mainHighlighter, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Params params = new Params(element);
            String string = element.getAttribute("type");
            try {
                Class<? extends Highlighter> clazz = highlighterClasses.get(string);
                if (clazz != null) {
                    Highlighter highlighter = clazz.newInstance();
                    highlighter.init(params);
                    mainHighlighter.add(highlighter);
                    continue;
                }
                System.err.println(String.format("Unknown highlighter: %s", string));
                continue;
            }
            catch (HighlighterConfigurationException highlighterConfigurationException) {
                System.err.println(String.format("Invalid configuration for highlighter %s: %s", string, highlighterConfigurationException.getMessage()));
                continue;
            }
            catch (InstantiationException instantiationException) {
                System.err.println(String.format("Error constructing highlighter %s: %s", string, instantiationException.getMessage()));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(String.format("IError constructing highlighter %s: %s", string, illegalAccessException.getMessage()));
            }
        }
    }

    protected Config() {
        this(null);
    }

    protected Config(String string) {
        Object object;
        if (this.verbose) {
            System.out.println("Initializing xslthl " + Version.getVersion());
        }
        try {
            Element element;
            object = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            if (string == null || "".equals(string)) {
                if (this.verbose) {
                    System.out.println("No config file specified, falling back to default behavior");
                }
                string = System.getProperty(CONFIG_PROPERTY) != null ? System.getProperty(CONFIG_PROPERTY) : "xslthl-config.xml";
            }
            System.out.println("Loading Xslthl configuration from " + string + "...");
            Document document = documentBuilder.parse(string);
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("highlighter");
            HashMap<String, MainHighlighter> hashMap = new HashMap<String, MainHighlighter>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2;
                String string3;
                element = (Element)nodeList.item(i);
                String string4 = element.getAttribute("id");
                if (this.highlighters.containsKey(string4)) {
                    System.out.println(String.format("Warning: highlighter with id '%s' already exists!", string4));
                }
                if (hashMap.containsKey(string3 = new URL(new URL(string), string2 = element.getAttribute("file")).toString())) {
                    if (this.verbose) {
                        System.out.println("Reusing loaded highlighter for " + string4 + " from " + string3 + "...");
                    }
                    this.highlighters.put(string4, (MainHighlighter)hashMap.get(string3));
                    continue;
                }
                if (this.verbose) {
                    System.out.print("Loading " + string4 + " highligter from " + string3 + "...");
                }
                try {
                    MainHighlighter mainHighlighter = this.loadHl(string3);
                    this.highlighters.put(string4, mainHighlighter);
                    if (!this.verbose) continue;
                    System.out.println(" OK");
                    hashMap.put(string3, mainHighlighter);
                    continue;
                }
                catch (Exception exception) {
                    if (this.verbose) {
                        System.out.println(" error: " + exception.getMessage());
                        continue;
                    }
                    System.err.println("Error loading highlighter from " + string3 + ": " + exception.getMessage());
                }
            }
            NodeList nodeList2 = document.getDocumentElement().getElementsByTagName("namespace");
            if (nodeList2.getLength() == 1) {
                element = (Element)nodeList2.item(0);
                this.prefix = element.getAttribute("prefix");
                this.uri = element.getAttribute("uri");
            }
        }
        catch (Exception exception) {
            System.err.println("XSLT Highlighter: Cannot read xslthl-config.xml, no custom highlighters will be available.");
        }
        if (!this.highlighters.containsKey("xml")) {
            object = new MainHighlighter();
            ((MainHighlighter)object).add(new XMLHighlighter());
            this.highlighters.put("xml", (MainHighlighter)object);
        }
    }

    static {
        highlighterClasses.put("multiline-comment", MultilineCommentHighlighter.class);
        highlighterClasses.put("nested-multiline-comment", NestedMultilineCommentHighlighter.class);
        highlighterClasses.put("oneline-comment", OnelineCommentHighlighter.class);
        highlighterClasses.put("string", StringHighlighter.class);
        highlighterClasses.put("heredoc", HeredocHighlighter.class);
        highlighterClasses.put("keywords", KeywordsHighlighter.class);
        highlighterClasses.put("annotation", AnnotationHighlighter.class);
        highlighterClasses.put("regex", RegexHighlighterEx.class);
        highlighterClasses.put("word", WordHighlighter.class);
        highlighterClasses.put("number", NumberHighlighter.class);
        highlighterClasses.put("hexnumber", HexaDecimalHighlighter.class);
        highlighterClasses.put("xml", XMLHighlighter.class);
    }
}

