/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import com.icl.saxon.Context;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.Builder;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tree.AttributeCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.Config;
import net.sf.xslthl.MainHighlighter;
import net.sf.xslthl.StyledBlock;
import org.xml.sax.Attributes;

public class ConnectorSaxon6 {
    private static void blockToSaxon6Node(Block block, Builder builder, NamePool namePool, Config config) throws Exception {
        if (block.isStyled()) {
            AttributeCollection attributeCollection = new AttributeCollection(namePool);
            int n = namePool.allocate(config.prefix, config.uri, ((StyledBlock)block).getStyle());
            builder.startElement(n, (Attributes)attributeCollection, new int[0], 0);
            builder.characters(block.getText().toCharArray(), 0, block.getText().length());
            builder.endElement(n);
        } else {
            builder.characters(block.getText().toCharArray(), 0, block.getText().length());
        }
    }

    public static NodeEnumeration highlight(Context context, String string, NodeEnumeration nodeEnumeration) throws Exception {
        return ConnectorSaxon6.highlight(context, string, nodeEnumeration, null);
    }

    public static NodeEnumeration highlight(Context context, String string, NodeEnumeration nodeEnumeration, String string2) throws Exception {
        try {
            Config config = Config.getInstance(string2);
            MainHighlighter mainHighlighter = config.getMainHighlighter(string);
            NamePool namePool = context.getController().getNamePool();
            ArrayList<NodeInfo> arrayList = new ArrayList<NodeInfo>();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                AxisEnumeration axisEnumeration = nodeInfo.getEnumeration((byte)3, (NodeTest)AnyNodeTest.getInstance());
                while (axisEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo2 = axisEnumeration.nextElement();
                    if (nodeInfo2.getNodeType() == 3) {
                        if (mainHighlighter != null) {
                            Block block2;
                            Builder builder = context.getController().makeBuilder();
                            builder.startDocument();
                            List<Block> list = mainHighlighter.highlight(nodeInfo2.getStringValue());
                            for (Block block2 : list) {
                                ConnectorSaxon6.blockToSaxon6Node(block2, builder, namePool, config);
                            }
                            builder.endDocument();
                            DocumentInfo documentInfo = builder.getCurrentDocument();
                            block2 = documentInfo.getEnumeration((byte)3, (NodeTest)AnyNodeTest.getInstance());
                            while (block2.hasMoreElements()) {
                                arrayList.add(block2.nextElement());
                            }
                            continue;
                        }
                        arrayList.add(nodeInfo2);
                        continue;
                    }
                    arrayList.add(nodeInfo2);
                }
            }
            return new NodeEnumerationIterator(arrayList.iterator());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodeEnumerationIterator
    implements NodeEnumeration {
        protected Iterator<NodeInfo> it;

        NodeEnumerationIterator(Iterator<NodeInfo> iterator) {
            this.it = iterator;
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public boolean isPeer() {
            return true;
        }

        public boolean isReverseSorted() {
            return false;
        }

        public boolean isSorted() {
            return true;
        }

        public NodeInfo nextElement() throws XPathException {
            return this.it.next();
        }
    }
}

