/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Highlighter {
    protected String styleName;

    public static final boolean isNewLine(Character c) {
        return '\n' == c.charValue() || '\r' == c.charValue();
    }

    public void init(Params params) throws HighlighterConfigurationException {
        this.styleName = params == null ? this.getDefaultStyle() : params.getParam("style", this.getDefaultStyle());
        if (this.styleName == null || this.styleName.length() == 0) {
            throw new HighlighterConfigurationException("Required parameter 'style' is not set.");
        }
        if ("none".equalsIgnoreCase(this.styleName)) {
            this.styleName = "none";
        } else if ("hidden".equalsIgnoreCase(this.styleName)) {
            this.styleName = "hidden";
        } else {
            Pattern pattern = Pattern.compile("[\\p{Ll}\\p{Lu}\\p{Lo}\\p{Lt}\\p{Nl}_][\\p{Ll}\\p{Lu}\\p{Lo}\\p{Lt}\\p{Nl}\\p{Mc}\\p{Me}\\p{Mn}\\p{Lm}\\p{Nd}_.-]*");
            if (!pattern.matcher(this.styleName).matches()) {
                throw new HighlighterConfigurationException(String.format("%s is not a valid XML Name", this.styleName));
            }
        }
    }

    public boolean startsWith(CharIter charIter) {
        return false;
    }

    public abstract boolean highlight(CharIter var1, List<Block> var2);

    public abstract String getDefaultStyle();

    public void reset() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IgnoreCaseComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -3992873598858412249L;

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    }
}

