/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.StyledBlock;
import net.sf.xslthl.WholeHighlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainHighlighter {
    protected List<Highlighter> highlighters = new ArrayList<Highlighter>();
    protected List<WholeHighlighter> wholehighlighters = new ArrayList<WholeHighlighter>();

    public void add(Highlighter highlighter) {
        if (highlighter instanceof WholeHighlighter) {
            this.wholehighlighters.add((WholeHighlighter)highlighter);
        } else {
            this.highlighters.add(highlighter);
        }
    }

    @Deprecated
    public void addWhole(WholeHighlighter wholeHighlighter) {
        this.add(wholeHighlighter);
    }

    public List<Block> highlight(String string) {
        CharIter charIter = new CharIter(string);
        AbstractList abstractList = new ArrayList<Block>();
        if (this.highlighters.size() > 0) {
            while (!charIter.finished()) {
                boolean bl = false;
                for (Highlighter highlighter : this.highlighters) {
                    if (!highlighter.startsWith(charIter)) continue;
                    int n = charIter.getPosition();
                    int n2 = -2;
                    Block block = null;
                    if (charIter.isMarked()) {
                        n2 = charIter.getMark();
                        block = charIter.markedToBlock();
                        abstractList.add((Block)block);
                    }
                    if (bl = highlighter.highlight(charIter, abstractList)) break;
                    charIter.moveNext(n - charIter.getPosition());
                    if (block != null) {
                        abstractList.remove(block);
                    }
                    if (n2 == -2) continue;
                    charIter.setMark(n2);
                }
                if (bl) continue;
                charIter.moveNext();
            }
        } else {
            charIter.moveToEnd();
        }
        if (charIter.isMarked()) {
            abstractList.add(charIter.markedToBlock());
        }
        if (this.wholehighlighters.size() > 0) {
            for (WholeHighlighter wholeHighlighter : this.wholehighlighters) {
                ArrayList<Block> arrayList = abstractList;
                abstractList = new LinkedList();
                for (Block block : arrayList) {
                    if (block.isStyled() && (wholeHighlighter.appliesOnAllStyles() || wholeHighlighter.appliesOnStyle(((StyledBlock)block).getStyle())) || !block.isStyled() && wholeHighlighter.appliesOnEmptyStyle()) {
                        wholeHighlighter.highlight(new CharIter(block.getText()), abstractList);
                        continue;
                    }
                    abstractList.add(block);
                }
            }
        }
        for (Highlighter highlighter : this.highlighters) {
            highlighter.reset();
        }
        for (WholeHighlighter wholeHighlighter : this.wholehighlighters) {
            wholeHighlighter.reset();
        }
        return abstractList;
    }
}

