/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHighlighter
extends Highlighter {
    protected String start;
    protected String end;
    protected String valueStart;
    protected String valueEnd;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.start = params.getParam("start");
        this.end = params.getParam("end");
        this.valueStart = params.getParam("valueStart");
        this.valueEnd = params.getParam("valueEnd");
        if (this.start == null || this.start.length() == 0) {
            throw new HighlighterConfigurationException("Required parameter 'start' is not set.");
        }
    }

    @Override
    public String getDefaultStyle() {
        return "annotation";
    }

    @Override
    public boolean startsWith(CharIter charIter) {
        if (charIter.startsWith(this.start)) {
            return Character.isJavaIdentifierStart(charIter.next(this.start.length()).charValue());
        }
        return false;
    }

    @Override
    public boolean highlight(CharIter charIter, List<Block> list) {
        charIter.moveNext(this.start.length());
        int n = 0;
        boolean bl = false;
        while (!charIter.finished()) {
            if (this.valueStart != null && charIter.startsWith(this.valueStart)) {
                ++n;
            } else if (this.valueEnd != null && charIter.startsWith(this.valueEnd)) {
                --n;
            } else if (n == 0) {
                if (this.end != null && n == 0 && charIter.startsWith(this.end)) {
                    charIter.moveNext(this.end.length());
                    bl = true;
                    break;
                }
                if (this.end == null && Character.isWhitespace(charIter.current().charValue())) {
                    bl = true;
                    break;
                }
            }
            charIter.moveNext();
        }
        if (!bl) {
            return false;
        }
        list.add(charIter.markedToStyledBlock(this.styleName));
        return true;
    }
}

