/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeredocHighlighter
extends Highlighter {
    protected String start;
    protected Set<String> quoteChar;
    protected boolean noWhiteSpace;
    protected boolean looseTerminator;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.start = params.getParam("start");
        if (this.start == null || this.start.length() == 0) {
            throw new HighlighterConfigurationException("Required parameter 'start' is not set.");
        }
        this.quoteChar = new HashSet<String>();
        params.getMutliParams("quote", this.quoteChar);
        this.noWhiteSpace = params.isSet("noWhiteSpace");
        this.looseTerminator = params.isSet("looseTerminator");
    }

    @Override
    public boolean startsWith(CharIter charIter) {
        if (charIter.startsWith(this.start)) {
            if (this.noWhiteSpace) {
                return !Character.isWhitespace(charIter.next(this.start.length() + 1).charValue());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean highlight(CharIter charIter, List<Block> list) {
        int n;
        charIter.moveNext(this.start.length());
        if (!this.noWhiteSpace) {
            while (!charIter.finished() && Character.isWhitespace(charIter.current().charValue())) {
                charIter.moveNext();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        Character c = Character.valueOf('\u0000');
        if (this.quoteChar.contains(charIter.current().toString())) {
            c = charIter.current();
            charIter.moveNext();
        }
        while (!(charIter.finished() || !Character.isLetterOrDigit(charIter.current().charValue()) && charIter.current().charValue() != '_' || c.equals(charIter.current()))) {
            stringBuilder.append(charIter.current());
            charIter.moveNext();
        }
        if (c.equals(charIter.current())) {
            charIter.moveNext();
        }
        if (stringBuilder.length() == 0) {
            return false;
        }
        do {
            if ((n = charIter.indexOf(stringBuilder.toString())) < 0) {
                charIter.moveToEnd();
                continue;
            }
            charIter.moveNext(n + stringBuilder.length());
        } while (!this.looseTerminator && !HeredocHighlighter.isNewLine(charIter.prev(stringBuilder.length() + 1)) && n != -1);
        list.add(charIter.markedToStyledBlock(this.styleName));
        return true;
    }

    @Override
    public String getDefaultStyle() {
        return "string";
    }
}

