/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordsHighlighter
extends Highlighter {
    protected Collection<String> keywords;
    protected boolean ignoreCase = false;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.ignoreCase = params.isSet("ignoreCase");
        this.keywords = this.ignoreCase ? new TreeSet<String>(new Highlighter.IgnoreCaseComparator()) : new TreeSet<String>();
        params.getMutliParams("keyword", this.keywords);
    }

    @Override
    public boolean startsWith(CharIter charIter) {
        return Character.isJavaIdentifierStart(charIter.current().charValue()) && (charIter.prev() == null || !Character.isJavaIdentifierPart(charIter.prev().charValue()));
    }

    @Override
    public boolean highlight(CharIter charIter, List<Block> list) {
        while (!charIter.finished() && Character.isJavaIdentifierPart(charIter.current().charValue())) {
            charIter.moveNext();
        }
        if (this.keywords.contains(charIter.getMarked())) {
            list.add(charIter.markedToStyledBlock(this.styleName));
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultStyle() {
        return "keyword";
    }
}

