/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.ArrayList;
import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberHighlighter
extends Highlighter {
    protected String decimalPoint;
    protected String thousandSep;
    protected String exponent;
    protected List<String> suffix;
    protected String prefix;
    protected boolean ignoreCase;
    protected boolean pointStarts;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.decimalPoint = params.getParam("point");
        this.thousandSep = params.getParam("thousands");
        this.exponent = params.getParam("exponent");
        this.pointStarts = this.decimalPoint != null && params.isSet("pointStarts");
        this.ignoreCase = params.isSet("ignoreCase");
        this.suffix = new ArrayList<String>();
        params.getMutliParams("suffix", this.suffix);
        this.prefix = params.getParam("prefix");
    }

    protected boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Override
    public String getDefaultStyle() {
        return "number";
    }

    @Override
    public boolean startsWith(CharIter charIter) {
        if (charIter.getPosition() > 0 && Character.isLetter(charIter.prev().charValue())) {
            return false;
        }
        if (this.prefix != null) {
            return charIter.startsWith(this.prefix, this.ignoreCase) && this.isDigit(charIter.next(this.prefix.length()).charValue());
        }
        if (this.pointStarts && charIter.startsWith(this.decimalPoint, this.ignoreCase) && this.isDigit(charIter.next(this.decimalPoint.length()).charValue())) {
            return true;
        }
        return this.isDigit(charIter.current().charValue());
    }

    @Override
    public boolean highlight(CharIter charIter, List<Block> list) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.prefix != null && charIter.startsWith(this.prefix, this.ignoreCase)) {
            charIter.moveNext(this.prefix.length());
        }
        if (this.pointStarts && charIter.startsWith(this.decimalPoint, this.ignoreCase)) {
            charIter.moveNext(this.decimalPoint.length());
            bl = true;
        }
        while (!charIter.finished()) {
            if (!bl) {
                if (this.decimalPoint != null && charIter.startsWith(this.decimalPoint, this.ignoreCase)) {
                    bl = true;
                    charIter.moveNext(this.decimalPoint.length());
                    continue;
                }
                if (this.thousandSep != null && charIter.startsWith(this.thousandSep, this.ignoreCase)) {
                    charIter.moveNext(this.thousandSep.length());
                    continue;
                }
            }
            if (!bl2 && this.exponent != null && charIter.startsWith(this.exponent, this.ignoreCase)) {
                bl = true;
                bl2 = true;
                charIter.moveNext(this.exponent.length());
                if (!charIter.current().equals(Character.valueOf('-')) && !charIter.current().equals(Character.valueOf('+'))) continue;
                charIter.moveNext();
                continue;
            }
            if (!this.isDigit(charIter.current().charValue())) break;
            charIter.moveNext();
        }
        for (String string : this.suffix) {
            if (!charIter.startsWith(string, this.ignoreCase)) continue;
            charIter.moveNext(string.length());
            break;
        }
        if (!charIter.finished() && Character.isLetter(charIter.current().charValue())) {
            return false;
        }
        list.add(charIter.markedToStyledBlock(this.styleName));
        return true;
    }
}

