/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnelineCommentHighlighter
extends Highlighter {
    protected String start;
    protected String lineBreakEscape;
    protected boolean solitary;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        if (params.isSet("start")) {
            this.start = params.getParam("start");
            this.lineBreakEscape = params.getParam("lineBreakEscape");
        } else {
            this.start = params.getParam();
        }
        if (this.start == null || this.start.length() == 0) {
            throw new HighlighterConfigurationException("Required parameter 'start' is not set.");
        }
        this.solitary = params.isSet("solitary");
    }

    @Override
    public boolean startsWith(CharIter charIter) {
        if (charIter.startsWith(this.start)) {
            if (this.solitary) {
                for (int i = 1; i < charIter.getPosition() && Character.isWhitespace(charIter.prev(i).charValue()); ++i) {
                    if (!OnelineCommentHighlighter.isNewLine(charIter.prev(i))) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean highlight(CharIter charIter, List<Block> list) {
        int n;
        charIter.moveNext(this.start.length());
        do {
            n = charIter.indexOf("\n");
            int n2 = 1;
            if (n == -1) {
                charIter.moveToEnd();
            } else {
                charIter.moveNext(n);
                if (charIter.prev().equals(Character.valueOf('\r'))) {
                    charIter.moveNext(-1);
                    ++n2;
                }
            }
            if (this.lineBreakEscape == null || this.lineBreakEscape.length() == 0 || !charIter.startsWith(this.lineBreakEscape, -1 * this.lineBreakEscape.length())) break;
            charIter.moveNext(n2);
        } while (n != -1);
        list.add(charIter.markedToStyledBlock(this.styleName));
        return true;
    }

    @Override
    public String getDefaultStyle() {
        return "comment";
    }
}

