/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexHighlighterEx
extends Highlighter {
    protected Pattern pattern;
    protected Matcher matcher;
    protected boolean finished;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        String[] stringArray;
        super.init(params);
        int n = 0;
        for (String string : stringArray = params.getParam("flags", "").split("[;,]")) {
            if ("CASE_INSENSITIVE".equalsIgnoreCase(string = string.trim())) {
                n += 2;
                continue;
            }
            if ("DOTALL".equalsIgnoreCase(string)) {
                n += 32;
                continue;
            }
            if ("MULTILINE".equalsIgnoreCase(string)) {
                n += 8;
                continue;
            }
            if ("UNICODE_CASE".equalsIgnoreCase(string)) {
                n += 64;
                continue;
            }
            if ("LITERAL".equalsIgnoreCase(string)) {
                n += 16;
                continue;
            }
            if ("UNIX_LINES".equalsIgnoreCase(string)) {
                ++n;
                continue;
            }
            if ("COMMENTS".equalsIgnoreCase(string)) {
                n += 4;
                continue;
            }
            if (!"CANON_EQ".equalsIgnoreCase(string)) continue;
            n += 128;
        }
        String string = params.getParam("pattern");
        if (params.isSet("pattern")) {
            try {
                this.pattern = Pattern.compile(string, n);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new HighlighterConfigurationException(patternSyntaxException.getMessage(), patternSyntaxException);
            }
        }
        if (this.pattern == null) {
            throw new HighlighterConfigurationException("Required parameter 'pattern' is not set.");
        }
    }

    @Override
    public String getDefaultStyle() {
        return null;
    }

    @Override
    public void reset() {
        this.matcher = null;
        this.finished = false;
    }

    @Override
    public boolean startsWith(CharIter charIter) {
        if (this.matcher == null) {
            this.matcher = charIter.createMatcher(this.pattern);
            boolean bl = this.finished = !this.matcher.find();
        }
        while (!this.finished && this.matcher.start() < charIter.getPosition()) {
            this.finished = !this.matcher.find();
        }
        if (!this.finished) {
            return this.matcher.start() == charIter.getPosition();
        }
        return false;
    }

    @Override
    public boolean highlight(CharIter charIter, List<Block> list) {
        if (!this.finished) {
            charIter.moveNext(this.matcher.end() - this.matcher.start());
            list.add(charIter.markedToStyledBlock(this.styleName));
            this.finished = !this.matcher.find();
            return true;
        }
        return false;
    }
}

