/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHighlighter
extends Highlighter {
    private String start;
    private String end;
    private String escape;
    private boolean doubleEscapes;
    private boolean spansNewLines;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.start = params.getParam("string");
        this.end = params.getParam("endString", this.start);
        this.escape = params.getParam("escape");
        this.doubleEscapes = params.isSet("doubleEscapes");
        this.spansNewLines = params.isSet("spanNewLines");
        if (this.start == null || this.start.length() == 0) {
            throw new HighlighterConfigurationException("Required parameter 'start' is not set.");
        }
    }

    @Override
    public boolean startsWith(CharIter charIter) {
        return charIter.startsWith(this.start);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean highlight(CharIter charIter, List<Block> list) {
        charIter.moveNext(this.start.length());
        boolean bl = false;
        while (!(charIter.finished() || !this.spansNewLines && StringHighlighter.isNewLine(charIter.current()))) {
            block5: {
                if (charIter.startsWith(this.end) && !bl) {
                    if (this.doubleEscapes && charIter.startsWith(this.end, this.end.length())) {
                        charIter.moveNext();
                        break block5;
                    } else {
                        charIter.moveNext(this.end.length() - 1);
                        break;
                    }
                }
                bl = this.escape != null && charIter.startsWith(this.escape) && !bl;
            }
            charIter.moveNext();
        }
        if (!charIter.finished()) {
            charIter.moveNext();
        }
        list.add(charIter.markedToStyledBlock(this.styleName));
        return true;
    }

    @Override
    public String getDefaultStyle() {
        return "string";
    }
}

