/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.ArrayList;
import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordHighlighter
extends Highlighter {
    protected List<String> words;
    protected boolean caseInsensitive;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.words = new ArrayList<String>();
        params.getMutliParams("word", this.words);
        this.caseInsensitive = params.isSet("ignoreCase");
    }

    @Override
    public boolean startsWith(CharIter charIter) {
        for (String string : this.words) {
            if (!charIter.startsWith(string, this.caseInsensitive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultStyle() {
        return null;
    }

    @Override
    public boolean highlight(CharIter charIter, List<Block> list) {
        for (String string : this.words) {
            if (!charIter.startsWith(string, this.caseInsensitive)) continue;
            charIter.moveNext(string.length());
            if (!charIter.finished() && !Character.isWhitespace(charIter.current().charValue())) continue;
            list.add(charIter.markedToStyledBlock(this.styleName));
            return true;
        }
        return false;
    }
}

