/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;
import net.sf.xslthl.WholeHighlighter;
import net.sf.xslthl.highlighters.xml.ElementPrefix;
import net.sf.xslthl.highlighters.xml.ElementSet;
import net.sf.xslthl.highlighters.xml.RealElementSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLHighlighter
extends WholeHighlighter {
    static final Character APOSTROPHE = Character.valueOf('\'');
    static final Character EQUALS = Character.valueOf('=');
    static final Character EXCLAMATION_MARK = Character.valueOf('!');
    static final Character GREATER_THAN = Character.valueOf('>');
    static final Character HYPHEN = Character.valueOf('-');
    static final Character LESS_THAN = Character.valueOf('<');
    static final Character QUESTION_MARK = Character.valueOf('?');
    static final Character QUOTE = Character.valueOf('\"');
    static final Character SLASH = Character.valueOf('/');
    protected Collection<ElementSet> elementSets = new HashSet<ElementSet>();
    protected String styleElement = "tag";
    protected String styleAttribute = "attribute";
    protected String styleValue = "value";
    protected String stylePi = "directive";
    protected String styleComment = "comment";
    protected String styleDoctype = "doctype";

    protected String getStyleForTagName(String string) {
        for (ElementSet elementSet : this.elementSets) {
            if (!elementSet.matches(string)) continue;
            return elementSet.getStyle();
        }
        return null;
    }

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        if (params != null) {
            this.styleAttribute = params.getParam("styleAttribute", this.styleAttribute);
            this.styleComment = params.getParam("styleComment", this.styleComment);
            this.styleDoctype = params.getParam("styleDoctype", this.styleDoctype);
            this.styleElement = params.getParam("styleElement", this.styleElement);
            this.stylePi = params.getParam("stylePi", this.stylePi);
            this.styleValue = params.getParam("styleValue", this.styleValue);
            params.getMultiParams("elementSet", this.elementSets, new Params.ParamsLoader<RealElementSet>(){

                @Override
                public RealElementSet load(Params params) throws HighlighterConfigurationException {
                    return new RealElementSet(params);
                }
            });
            params.getMultiParams("elementPrefix", this.elementSets, new Params.ParamsLoader<ElementPrefix>(){

                @Override
                public ElementPrefix load(Params params) throws HighlighterConfigurationException {
                    return new ElementPrefix(params);
                }
            });
        }
    }

    void readTagContent(CharIter charIter, List<Block> list) {
        while (!(charIter.finished() || GREATER_THAN.equals(charIter.current()) || SLASH.equals(charIter.current()))) {
            if (!Character.isWhitespace(charIter.current().charValue())) {
                if (charIter.isMarked()) {
                    list.add(charIter.markedToBlock());
                }
                while (!(charIter.finished() || EQUALS.equals(charIter.current()) || Character.isWhitespace(charIter.current().charValue()))) {
                    charIter.moveNext();
                }
                list.add(charIter.markedToStyledBlock(this.styleAttribute));
                while (!charIter.finished() && Character.isWhitespace(charIter.current().charValue())) {
                    charIter.moveNext();
                }
                if (charIter.finished() || !EQUALS.equals(charIter.current())) continue;
                charIter.moveNext();
                while (!charIter.finished() && Character.isWhitespace(charIter.current().charValue())) {
                    charIter.moveNext();
                }
                list.add(charIter.markedToBlock());
                if (QUOTE.equals(charIter.current()) || APOSTROPHE.equals(charIter.current())) {
                    Character c = charIter.current();
                    charIter.moveNext();
                    while (!charIter.finished() && !c.equals(charIter.current())) {
                        charIter.moveNext();
                    }
                    if (!charIter.finished()) {
                        charIter.moveNext();
                    }
                    list.add(charIter.markedToStyledBlock(this.styleValue));
                    continue;
                }
                while (!(charIter.finished() || GREATER_THAN.equals(charIter.current()) || SLASH.equals(charIter.current()) || Character.isWhitespace(charIter.current().charValue()))) {
                    charIter.moveNext();
                }
                list.add(charIter.markedToStyledBlock(this.styleValue));
                continue;
            }
            charIter.moveNext();
        }
    }

    @Override
    public boolean highlight(CharIter charIter, List<Block> list) {
        while (!charIter.finished()) {
            if (LESS_THAN.equals(charIter.current())) {
                String string;
                list.add(charIter.markedToBlock());
                charIter.moveNext();
                if (SLASH.equals(charIter.current())) {
                    while (!charIter.finished() && !GREATER_THAN.equals(charIter.current())) {
                        charIter.moveNext();
                    }
                    string = this.getStyleForTagName(charIter.getMarked().trim().substring(2));
                    charIter.moveNext();
                    if (string != null) {
                        list.add(charIter.markedToStyledBlock(string));
                        continue;
                    }
                    list.add(charIter.markedToStyledBlock(this.styleElement));
                    continue;
                }
                if (QUESTION_MARK.equals(charIter.current())) {
                    while (!(charIter.finished() || GREATER_THAN.equals(charIter.current()) && QUESTION_MARK.equals(charIter.prev()))) {
                        charIter.moveNext();
                    }
                    charIter.moveNext();
                    list.add(charIter.markedToStyledBlock(this.stylePi));
                    continue;
                }
                if (EXCLAMATION_MARK.equals(charIter.current()) && HYPHEN.equals(charIter.next()) && HYPHEN.equals(charIter.next(2))) {
                    while (!(charIter.finished() || GREATER_THAN.equals(charIter.current()) && HYPHEN.equals(charIter.prev()) && HYPHEN.equals(charIter.prev(2)))) {
                        charIter.moveNext();
                    }
                    charIter.moveNext();
                    list.add(charIter.markedToStyledBlock(this.styleComment));
                    continue;
                }
                if (EXCLAMATION_MARK.equals(charIter.current()) && charIter.startsWith("[CDATA[", 1)) {
                    charIter.moveNext(8);
                    list.add(charIter.markedToStyledBlock(this.styleElement));
                    int n = charIter.indexOf("]]>");
                    if (n == -1) {
                        charIter.moveToEnd();
                    } else {
                        charIter.moveNext(n);
                    }
                    list.add(charIter.markedToBlock());
                    if (n == -1) continue;
                    charIter.moveNext(3);
                    list.add(charIter.markedToStyledBlock(this.styleElement));
                    continue;
                }
                if (EXCLAMATION_MARK.equals(charIter.current()) && charIter.startsWith("DOCTYPE", 1)) {
                    int n = 1;
                    while (!charIter.finished() && n > 0) {
                        if (charIter.current().equals(GREATER_THAN)) {
                            --n;
                        } else if (charIter.current().equals(LESS_THAN)) {
                            ++n;
                        }
                        charIter.moveNext();
                    }
                    list.add(charIter.markedToStyledBlock(this.styleDoctype));
                    continue;
                }
                while (!(charIter.finished() || GREATER_THAN.equals(charIter.current()) || SLASH.equals(charIter.current()) || Character.isWhitespace(charIter.current().charValue()))) {
                    charIter.moveNext();
                }
                string = this.getStyleForTagName(charIter.getMarked().trim().substring(1));
                boolean bl = false;
                int n = 0;
                while (!charIter.finished() && !GREATER_THAN.equals(charIter.current()) && !SLASH.equals(charIter.current()) && Character.isWhitespace(charIter.current().charValue())) {
                    charIter.moveNext();
                    ++n;
                }
                if (SLASH.equals(charIter.current())) {
                    charIter.moveNext();
                    ++n;
                }
                if (GREATER_THAN.equals(charIter.current())) {
                    charIter.moveNext();
                    bl = true;
                } else {
                    charIter.moveNext(-n);
                }
                if (string != null) {
                    list.add(charIter.markedToStyledBlock(string));
                } else {
                    list.add(charIter.markedToStyledBlock(this.styleElement));
                }
                if (bl || charIter.finished() || !Character.isWhitespace(charIter.current().charValue())) continue;
                this.readTagContent(charIter, list);
                if (charIter.finished()) continue;
                if (SLASH.equals(charIter.current())) {
                    charIter.moveNext();
                }
                charIter.moveNext();
                if (string != null) {
                    list.add(charIter.markedToStyledBlock(string));
                    continue;
                }
                list.add(charIter.markedToStyledBlock(this.styleElement));
                continue;
            }
            charIter.moveNext();
        }
        if (charIter.isMarked()) {
            list.add(charIter.markedToBlock());
        }
        return false;
    }

    @Override
    public String getDefaultStyle() {
        return "xml";
    }
}

