/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.cobertura.util.RegexUtil;

public class ClassPattern {
    private Set<String> includeClassesRegexes = new HashSet<String>();
    private Set<String> excludeClassesRegexes = new HashSet<String>();
    private static final String WEBINF_CLASSES = "WEB-INF/classes/";

    boolean isSpecified() {
        return this.includeClassesRegexes.size() > 0;
    }

    boolean matches(String filename) {
        boolean matches = true;
        if (this.isSpecified()) {
            matches = false;
            if (filename.endsWith(".class")) {
                filename = filename.substring(0, filename.length() - 6);
            }
            filename = filename.replace('\\', '/');
            filename = this.removeAnyWebInfClassesString(filename);
            if (RegexUtil.matches(this.includeClassesRegexes, filename = filename.replace('/', '.'))) {
                matches = true;
            }
            if (matches && RegexUtil.matches(this.excludeClassesRegexes, filename)) {
                matches = false;
            }
        }
        return matches;
    }

    private String removeAnyWebInfClassesString(String filename) {
        if (filename.startsWith(WEBINF_CLASSES)) {
            filename = filename.substring(WEBINF_CLASSES.length());
        }
        return filename;
    }

    void addIncludeClassesRegex(String regex) {
        RegexUtil.addRegex(this.includeClassesRegexes, regex);
    }

    void addExcludeClassesRegex(String regex) {
        RegexUtil.addRegex(this.excludeClassesRegexes, regex);
    }
}

