/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.instrument.CoberturaClassWriter;
import net.sourceforge.cobertura.instrument.pass1.DetectDuplicatedCodeClassVisitor;
import net.sourceforge.cobertura.instrument.pass1.DetectIgnoredCodeClassVisitor;
import net.sourceforge.cobertura.instrument.pass2.BuildClassMapClassVisitor;
import net.sourceforge.cobertura.instrument.pass3.InjectCodeClassInstrumenter;
import net.sourceforge.cobertura.util.IOUtil;
import org.apache.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaInstrumenter {
    private static final Logger logger = Logger.getLogger(CoberturaInstrumenter.class);
    private ProjectData projectData;
    private File destinationDirectory;
    private Collection<Pattern> ignoreRegexes = new Vector<Pattern>();
    private Set<String> ignoreMethodAnnotations = new HashSet<String>();
    private boolean ignoreTrivial;
    private boolean failOnError;
    private boolean threadsafeRigorous;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentationResult instrumentClass(File file) {
        InstrumentationResult instrumentationResult;
        FileInputStream inputStream = null;
        try {
            logger.debug((Object)("Working on file:" + file.getAbsolutePath()));
            inputStream = new FileInputStream(file);
            instrumentationResult = this.instrumentClass(inputStream);
        }
        catch (Throwable t) {
            InstrumentationResult instrumentationResult2;
            try {
                logger.warn((Object)("Unable to instrument file " + file.getAbsolutePath()), t);
                if (this.failOnError) {
                    throw new RuntimeException("Warning detected and failOnError is true", t);
                }
                instrumentationResult2 = null;
            }
            catch (Throwable throwable) {
                IOUtil.closeInputStream(inputStream);
                throw throwable;
            }
            IOUtil.closeInputStream(inputStream);
            return instrumentationResult2;
        }
        IOUtil.closeInputStream(inputStream);
        return instrumentationResult;
    }

    public InstrumentationResult instrumentClass(InputStream inputStream) throws IOException {
        ClassReader cr0 = new ClassReader(inputStream);
        ClassWriter cw0 = new ClassWriter(0);
        DetectIgnoredCodeClassVisitor detectIgnoredCv = new DetectIgnoredCodeClassVisitor((ClassVisitor)cw0, this.ignoreTrivial, this.ignoreMethodAnnotations);
        DetectDuplicatedCodeClassVisitor cv0 = new DetectDuplicatedCodeClassVisitor(detectIgnoredCv);
        cr0.accept((ClassVisitor)cv0, 0);
        ClassReader cr = new ClassReader(cw0.toByteArray());
        ClassWriter cw = new ClassWriter(0);
        BuildClassMapClassVisitor cv = new BuildClassMapClassVisitor((ClassVisitor)cw, this.ignoreRegexes, cv0.getDuplicatesLinesCollector(), detectIgnoredCv.getIgnoredMethodNamesAndSignatures());
        cr.accept((ClassVisitor)cv, 8);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"=============== Detected duplicated code =============");
            Map<Integer, Map<Integer, Integer>> l = cv0.getDuplicatesLinesCollector();
            for (Map.Entry<Integer, Map<Integer, Integer>> m : l.entrySet()) {
                if (m.getValue() == null) continue;
                for (Map.Entry<Integer, Integer> pair : m.getValue().entrySet()) {
                    logger.debug((Object)(cv.getClassMap().getClassName() + ":" + m.getKey() + " " + pair.getKey() + "->" + pair.getValue()));
                }
            }
            logger.debug((Object)"=============== End of detected duplicated code ======");
        }
        logger.debug((Object)("Migrating classmap in projectData to store in *.ser file: " + cv.getClassMap().getClassName()));
        cv.getClassMap().applyOnProjectData(this.projectData, cv.shouldBeInstrumented());
        if (cv.shouldBeInstrumented()) {
            ClassReader cr2 = new ClassReader(cw0.toByteArray());
            CoberturaClassWriter cw2 = new CoberturaClassWriter(2);
            cv.getClassMap().assignCounterIds();
            logger.debug((Object)("Assigned " + cv.getClassMap().getMaxCounterId() + " counters for class:" + cv.getClassMap().getClassName()));
            InjectCodeClassInstrumenter cv2 = new InjectCodeClassInstrumenter((ClassVisitor)cw2, this.ignoreRegexes, this.threadsafeRigorous, cv.getClassMap(), cv0.getDuplicatesLinesCollector(), detectIgnoredCv.getIgnoredMethodNamesAndSignatures());
            cr2.accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)cv2), 4);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            CheckClassAdapter.verify((ClassReader)new ClassReader(cw2.toByteArray()), (boolean)false, (PrintWriter)pw);
            logger.debug((Object)sw.toString());
            return new InstrumentationResult(cv.getClassMap().getClassName(), cw2.toByteArray());
        }
        logger.debug((Object)("Class shouldn't be instrumented: " + cv.getClassMap().getClassName()));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstrumentationToSingleClass(File file) {
        logger.debug((Object)("Instrumenting class " + file.getAbsolutePath()));
        InstrumentationResult instrumentationResult = this.instrumentClass(file);
        if (instrumentationResult != null) {
            FileOutputStream outputStream = null;
            try {
                File outputFile = this.destinationDirectory == null ? file : new File(this.destinationDirectory, instrumentationResult.className.replace('.', File.separatorChar) + ".class");
                logger.debug((Object)("Writing instrumented class into:" + outputFile.getAbsolutePath()));
                File parentFile = outputFile.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                outputStream = new FileOutputStream(outputFile);
                ((OutputStream)outputStream).write(instrumentationResult.content);
            }
            catch (Throwable t) {
                try {
                    logger.warn((Object)("Unable to write instrumented file " + file.getAbsolutePath()), t);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtil.closeOutputStream(outputStream);
                }
            }
            IOUtil.closeOutputStream(outputStream);
        }
    }

    public File getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public void setDestinationDirectory(File destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
    }

    public Collection<Pattern> getIgnoreRegexes() {
        return this.ignoreRegexes;
    }

    public void setIgnoreRegexes(Collection<Pattern> ignoreRegexes) {
        this.ignoreRegexes = ignoreRegexes;
    }

    public void setIgnoreTrivial(boolean ignoreTrivial) {
        this.ignoreTrivial = ignoreTrivial;
    }

    public void setIgnoreMethodAnnotations(Set<String> ignoreMethodAnnotations) {
        this.ignoreMethodAnnotations = ignoreMethodAnnotations;
    }

    public void setThreadsafeRigorous(boolean threadsafeRigorous) {
        this.threadsafeRigorous = threadsafeRigorous;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setProjectData(ProjectData projectData) {
        this.projectData = projectData;
    }

    public static class InstrumentationResult {
        private String className;
        private byte[] content;

        public InstrumentationResult(String className, byte[] content) {
            this.className = className;
            this.content = content;
        }

        public String getClassName() {
            return this.className;
        }

        public byte[] getContent() {
            return this.content;
        }
    }
}

