/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignDataset;
import net.sf.dynamicreports.design.base.DRDesignGroup;
import net.sf.dynamicreports.design.base.DRDesignHyperLink;
import net.sf.dynamicreports.design.base.chart.DRDesignChart;
import net.sf.dynamicreports.design.base.chart.DRDesignChartLegend;
import net.sf.dynamicreports.design.base.chart.DRDesignChartSubtitle;
import net.sf.dynamicreports.design.base.chart.DRDesignChartTitle;
import net.sf.dynamicreports.design.base.chart.dataset.DRDesignCategoryChartSerie;
import net.sf.dynamicreports.design.base.chart.dataset.DRDesignCategoryDataset;
import net.sf.dynamicreports.design.base.chart.dataset.DRDesignChartDataset;
import net.sf.dynamicreports.design.base.chart.dataset.DRDesignChartSerie;
import net.sf.dynamicreports.design.base.chart.dataset.DRDesignGanttChartSerie;
import net.sf.dynamicreports.design.base.chart.dataset.DRDesignHighLowDataset;
import net.sf.dynamicreports.design.base.chart.dataset.DRDesignSeriesDataset;
import net.sf.dynamicreports.design.base.chart.dataset.DRDesignTimeSeriesDataset;
import net.sf.dynamicreports.design.base.chart.dataset.DRDesignValueDataset;
import net.sf.dynamicreports.design.base.chart.dataset.DRDesignXyChartSerie;
import net.sf.dynamicreports.design.base.chart.dataset.DRDesignXyzChartSerie;
import net.sf.dynamicreports.design.base.chart.plot.AbstractDesignBasePlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignAxisFormat;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignAxisPlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignBar3DPlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignBarPlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignBubblePlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignCandlestickPlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignChartAxis;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignHighLowPlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignLinePlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignMeterInterval;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignMeterPlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignMultiAxisPlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignPie3DPlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignPiePlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignSpiderPlot;
import net.sf.dynamicreports.design.base.chart.plot.DRDesignThermometerPlot;
import net.sf.dynamicreports.design.constant.ResetType;
import net.sf.dynamicreports.design.definition.DRIDesignVariable;
import net.sf.dynamicreports.design.definition.chart.plot.DRIDesignPlot;
import net.sf.dynamicreports.design.definition.expression.DRIDesignExpression;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.design.transformation.AbstractExpressionTransform;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.chartcustomizer.DifferenceRendererCustomizer;
import net.sf.dynamicreports.design.transformation.chartcustomizer.GroupedStackedBarRendererCustomizer;
import net.sf.dynamicreports.design.transformation.chartcustomizer.LayeredBarRendererCustomizer;
import net.sf.dynamicreports.design.transformation.chartcustomizer.PieChartLabelFormatCustomizer;
import net.sf.dynamicreports.design.transformation.chartcustomizer.SeriesColorsByNameCustomizer;
import net.sf.dynamicreports.design.transformation.chartcustomizer.SeriesOrderCustomizer;
import net.sf.dynamicreports.design.transformation.chartcustomizer.ShowPercentagesCustomizer;
import net.sf.dynamicreports.design.transformation.chartcustomizer.ShowValuesCustomizer;
import net.sf.dynamicreports.design.transformation.chartcustomizer.WaterfallBarRendererCustomizer;
import net.sf.dynamicreports.design.transformation.chartcustomizer.XyBlockRendererCustomizer;
import net.sf.dynamicreports.design.transformation.chartcustomizer.XyStepRendererCustomizer;
import net.sf.dynamicreports.design.transformation.expressions.GroupedSeriesExpression;
import net.sf.dynamicreports.design.transformation.expressions.SerieValueExpression;
import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.constant.OrderType;
import net.sf.dynamicreports.report.definition.DRIDataset;
import net.sf.dynamicreports.report.definition.chart.DRIChart;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import net.sf.dynamicreports.report.definition.chart.DRIChartLegend;
import net.sf.dynamicreports.report.definition.chart.DRIChartSubtitle;
import net.sf.dynamicreports.report.definition.chart.DRIChartTitle;
import net.sf.dynamicreports.report.definition.chart.dataset.DRICategoryChartSerie;
import net.sf.dynamicreports.report.definition.chart.dataset.DRICategoryDataset;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIChartDataset;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIChartSerie;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIGanttChartSerie;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIGroupedCategoryChartSerie;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIHighLowDataset;
import net.sf.dynamicreports.report.definition.chart.dataset.DRISeriesDataset;
import net.sf.dynamicreports.report.definition.chart.dataset.DRITimeSeriesDataset;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIValueDataset;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIXyChartSerie;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIXyzChartSerie;
import net.sf.dynamicreports.report.definition.chart.plot.DRIAxisFormat;
import net.sf.dynamicreports.report.definition.chart.plot.DRIAxisPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIBar3DPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIBarPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIBasePlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIBubblePlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRICandlestickPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIChartAxis;
import net.sf.dynamicreports.report.definition.chart.plot.DRIDifferencePlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIGroupedStackedBarPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIHighLowPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRILayeredBarPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRILinePlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIMeterInterval;
import net.sf.dynamicreports.report.definition.chart.plot.DRIMeterPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIMultiAxisPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIPie3DPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIPiePlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRISpiderPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIThermometerPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIWaterfallBarPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIXyBlockPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIXyStepPlot;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;

public class ChartTransform {
    private DesignTransformAccessor accessor;

    public ChartTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
    }

    protected DRDesignChart transform(DRIChart chart, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        return this.transform(chart, null, resetType, resetGroup);
    }

    private DRDesignChart transform(DRIChart chart, DRIDataset subDataset, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignChart designChart = new DRDesignChart();
        designChart.setWidth(this.accessor.getTemplateTransform().getChartWidth(chart));
        designChart.setHeight(this.accessor.getTemplateTransform().getChartHeight(chart));
        designChart.setChartType(chart.getChartType());
        designChart.setTheme(this.accessor.getTemplateTransform().getChartTheme(chart));
        if (!(chart.getPlot() instanceof DRIMultiAxisPlot)) {
            designChart.setDataset(this.dataset(chart.getDataset(), subDataset, resetType, resetGroup));
        }
        designChart.setPlot(this.plot(chart.getPlot(), designChart.getCustomizers(), chart.getDataset().getSubDataset(), resetType, resetGroup));
        designChart.setTitle(this.title(chart.getTitle()));
        designChart.setSubtitle(this.subtitle(chart.getSubtitle()));
        designChart.setLegend(this.legend(chart.getLegend()));
        if (!chart.getCustomizers().isEmpty()) {
            designChart.getCustomizers().addAll(chart.getCustomizers());
        }
        return designChart;
    }

    private DRIDesignPlot plot(DRIPlot plot, List<DRIChartCustomizer> chartCustomizers, DRIDataset subDataset, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRIDesignPlot designPlot;
        if (plot instanceof DRIBar3DPlot) {
            designPlot = this.bar3DPlot((DRIBar3DPlot)plot, chartCustomizers);
        } else if (plot instanceof DRILayeredBarPlot) {
            designPlot = this.layeredBarPlot((DRILayeredBarPlot)plot, chartCustomizers);
        } else if (plot instanceof DRIWaterfallBarPlot) {
            designPlot = this.waterfallBarPlot((DRIWaterfallBarPlot)plot, chartCustomizers);
        } else if (plot instanceof DRIGroupedStackedBarPlot) {
            designPlot = this.groupedStackedBarPlot((DRIGroupedStackedBarPlot)plot, chartCustomizers);
        } else if (plot instanceof DRIBarPlot) {
            designPlot = this.barPlot((DRIBarPlot)plot, chartCustomizers);
        } else if (plot instanceof DRIDifferencePlot) {
            designPlot = this.differencePlot((DRIDifferencePlot)plot, chartCustomizers);
        } else if (plot instanceof DRIXyStepPlot) {
            designPlot = this.xyStepPlot((DRIXyStepPlot)plot, chartCustomizers);
        } else if (plot instanceof DRILinePlot) {
            designPlot = this.linePlot((DRILinePlot)plot, chartCustomizers);
        } else if (plot instanceof DRIMultiAxisPlot) {
            designPlot = this.multiAxisPlot((DRIMultiAxisPlot)plot, chartCustomizers, subDataset, resetType, resetGroup);
        } else if (plot instanceof DRIPie3DPlot) {
            designPlot = this.pie3DPlot((DRIPie3DPlot)plot, chartCustomizers);
        } else if (plot instanceof DRIPiePlot) {
            designPlot = this.piePlot((DRIPiePlot)plot, chartCustomizers);
        } else if (plot instanceof DRISpiderPlot) {
            designPlot = this.spiderPlot((DRISpiderPlot)plot);
        } else if (plot instanceof DRIXyBlockPlot) {
            designPlot = this.xyBlockPlot((DRIXyBlockPlot)plot, chartCustomizers);
        } else if (plot instanceof DRIBubblePlot) {
            designPlot = this.bubblePlot((DRIBubblePlot)plot, chartCustomizers);
        } else if (plot instanceof DRICandlestickPlot) {
            designPlot = this.candlestickPlot((DRICandlestickPlot)plot, chartCustomizers);
        } else if (plot instanceof DRIHighLowPlot) {
            designPlot = this.highLowPlot((DRIHighLowPlot)plot, chartCustomizers);
        } else if (plot instanceof DRIMeterPlot) {
            designPlot = this.meterPlot((DRIMeterPlot)plot);
        } else if (plot instanceof DRIThermometerPlot) {
            designPlot = this.thermometerPlot((DRIThermometerPlot)plot);
        } else if (plot instanceof DRIAxisPlot) {
            designPlot = this.axisPlot((DRIAxisPlot)plot, chartCustomizers);
        } else {
            throw new DRDesignReportException("Chart plot " + plot.getClass().getName() + " not supported");
        }
        if (plot instanceof DRIBasePlot) {
            AbstractDesignBasePlot designBasePlot = designPlot;
            DRIBasePlot basePlot = (DRIBasePlot)plot;
            designBasePlot.setOrientation(basePlot.getOrientation());
            designBasePlot.setSeriesColors(this.accessor.getTemplateTransform().getChartSeriesColors(basePlot));
            Map<String, Color> seriesColorsByName = basePlot.getSeriesColorsByName();
            if (!seriesColorsByName.isEmpty()) {
                chartCustomizers.add(new SeriesColorsByNameCustomizer(seriesColorsByName));
            }
        }
        return designPlot;
    }

    private DRDesignBar3DPlot bar3DPlot(DRIBar3DPlot bar3DPlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        DRDesignBar3DPlot designBar3DPlot = new DRDesignBar3DPlot();
        this.axisPlot(designBar3DPlot, bar3DPlot, chartCustomizers);
        designBar3DPlot.setXOffset(bar3DPlot.getXOffset());
        designBar3DPlot.setYOffset(bar3DPlot.getYOffset());
        designBar3DPlot.setShowLabels(bar3DPlot.getShowLabels());
        return designBar3DPlot;
    }

    private DRDesignBarPlot barPlot(DRIBarPlot barPlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        DRDesignBarPlot designBarPlot = new DRDesignBarPlot();
        this.axisPlot(designBarPlot, barPlot, chartCustomizers);
        designBarPlot.setShowTickMarks(barPlot.getShowTickMarks());
        designBarPlot.setShowTickLabels(barPlot.getShowTickLabels());
        designBarPlot.setShowLabels(barPlot.getShowLabels());
        return designBarPlot;
    }

    private DRDesignBarPlot groupedStackedBarPlot(DRIGroupedStackedBarPlot groupedStackedBarPlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        GroupedStackedBarRendererCustomizer renderer = new GroupedStackedBarRendererCustomizer();
        chartCustomizers.add(renderer);
        DRDesignBarPlot designBarPlot = this.barPlot(groupedStackedBarPlot, chartCustomizers);
        return designBarPlot;
    }

    private DRDesignBarPlot layeredBarPlot(DRILayeredBarPlot layeredBarPlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        chartCustomizers.add(new LayeredBarRendererCustomizer(layeredBarPlot.getSeriesBarWidths()));
        DRDesignBarPlot designBarPlot = this.barPlot(layeredBarPlot, chartCustomizers);
        return designBarPlot;
    }

    private DRDesignBarPlot waterfallBarPlot(DRIWaterfallBarPlot waterfallBarPlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        WaterfallBarRendererCustomizer waterfallBarCustomizer = new WaterfallBarRendererCustomizer(waterfallBarPlot);
        chartCustomizers.add(waterfallBarCustomizer);
        DRDesignBarPlot designBarPlot = this.barPlot(waterfallBarPlot, chartCustomizers);
        return designBarPlot;
    }

    private DRDesignLinePlot linePlot(DRILinePlot linePlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        DRDesignLinePlot designLinePlot = new DRDesignLinePlot();
        this.axisPlot(designLinePlot, linePlot, chartCustomizers);
        designLinePlot.setShowShapes(linePlot.getShowShapes());
        designLinePlot.setShowLines(linePlot.getShowLines());
        return designLinePlot;
    }

    private DRDesignLinePlot differencePlot(DRIDifferencePlot differencePlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        DRDesignLinePlot designLinePlot = new DRDesignLinePlot();
        chartCustomizers.add(new DifferenceRendererCustomizer(differencePlot));
        this.axisPlot(designLinePlot, differencePlot, chartCustomizers);
        return designLinePlot;
    }

    private DRDesignLinePlot xyStepPlot(DRIXyStepPlot xyStepPlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        DRDesignLinePlot designLinePlot = new DRDesignLinePlot();
        chartCustomizers.add(new XyStepRendererCustomizer(xyStepPlot.getStepPoint()));
        this.axisPlot(designLinePlot, xyStepPlot, chartCustomizers);
        return designLinePlot;
    }

    private DRDesignMultiAxisPlot multiAxisPlot(DRIMultiAxisPlot multiAxisPlot, List<DRIChartCustomizer> chartCustomizers, DRIDataset subDataset, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignMultiAxisPlot designMultiAxisPlot = new DRDesignMultiAxisPlot();
        this.axisPlot(designMultiAxisPlot, multiAxisPlot, chartCustomizers);
        for (DRIChartAxis axis : multiAxisPlot.getAxes()) {
            DRDesignChartAxis designAxis = new DRDesignChartAxis();
            designAxis.setPosition(axis.getPosition());
            DRDesignChart chart = this.transform(axis.getChart(), subDataset, resetType, resetGroup);
            chart.setUniqueName(ReportUtils.generateUniqueName("chart"));
            designAxis.setChart(chart);
            designMultiAxisPlot.getAxes().add(designAxis);
        }
        return designMultiAxisPlot;
    }

    private DRDesignPie3DPlot pie3DPlot(DRIPie3DPlot pie3DPlot, List<DRIChartCustomizer> chartCustomizers) {
        DRDesignPie3DPlot designPie3DPlot = new DRDesignPie3DPlot();
        this.piePlot(designPie3DPlot, pie3DPlot, chartCustomizers);
        designPie3DPlot.setDepthFactor(pie3DPlot.getDepthFactor());
        return designPie3DPlot;
    }

    private DRDesignPiePlot piePlot(DRIPiePlot piePlot, List<DRIChartCustomizer> chartCustomizers) {
        DRDesignPiePlot designPiePlot = new DRDesignPiePlot();
        this.piePlot(designPiePlot, piePlot, chartCustomizers);
        return designPiePlot;
    }

    private void piePlot(DRDesignPiePlot designPiePlot, DRIPiePlot piePlot, List<DRIChartCustomizer> chartCustomizers) {
        designPiePlot.setCircular(piePlot.getCircular());
        designPiePlot.setLabelFormat(piePlot.getLabelFormat());
        designPiePlot.setLegendLabelFormat(piePlot.getLegendLabelFormat());
        if (piePlot.getShowLabels() != null && !piePlot.getShowLabels().booleanValue()) {
            chartCustomizers.add(new PieChartLabelFormatCustomizer(null, null, null));
        } else {
            String labelFormat = piePlot.getLabelFormat();
            if (labelFormat == null) {
                labelFormat = "{0}";
            }
            if (piePlot.getShowValues() != null && piePlot.getShowValues().booleanValue()) {
                labelFormat = String.valueOf(labelFormat) + " = {1}";
            }
            if (piePlot.getShowPercentages() != null && piePlot.getShowPercentages().booleanValue()) {
                labelFormat = String.valueOf(labelFormat) + " ({2})";
            }
            String valuePattern = this.accessor.getTemplateTransform().getChartValuePattern(piePlot);
            String percentValuePattern = this.accessor.getTemplateTransform().getChartPercentValuePattern(piePlot);
            chartCustomizers.add(new PieChartLabelFormatCustomizer(labelFormat, valuePattern, percentValuePattern));
        }
    }

    private DRDesignSpiderPlot spiderPlot(DRISpiderPlot spiderPlot) throws DRException {
        DRDesignSpiderPlot designSpiderPlot = new DRDesignSpiderPlot();
        designSpiderPlot.setMaxValueExpression(this.accessor.getExpressionTransform().transformExpression(spiderPlot.getMaxValueExpression()));
        designSpiderPlot.setRotation(spiderPlot.getRotation());
        designSpiderPlot.setTableOrder(spiderPlot.getTableOrder());
        designSpiderPlot.setWebFilled(spiderPlot.getWebFilled());
        designSpiderPlot.setStartAngle(spiderPlot.getStartAngle());
        designSpiderPlot.setHeadPercent(spiderPlot.getHeadPercent());
        designSpiderPlot.setInteriorGap(spiderPlot.getInteriorGap());
        designSpiderPlot.setAxisLineColor(spiderPlot.getAxisLineColor());
        designSpiderPlot.setAxisLineWidth(spiderPlot.getAxisLineWidth());
        designSpiderPlot.setLabelFont(this.accessor.getStyleTransform().transformFont(spiderPlot.getLabelFont()));
        designSpiderPlot.setLabelGap(spiderPlot.getLabelGap());
        designSpiderPlot.setLabelColor(spiderPlot.getLabelColor());
        return designSpiderPlot;
    }

    private DRDesignAxisPlot xyBlockPlot(DRIXyBlockPlot xyBlockPlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        DRDesignBubblePlot designBubblePlot = new DRDesignBubblePlot();
        chartCustomizers.add(new XyBlockRendererCustomizer(xyBlockPlot));
        this.axisPlot(designBubblePlot, xyBlockPlot, chartCustomizers);
        return designBubblePlot;
    }

    private DRDesignBubblePlot bubblePlot(DRIBubblePlot bubblePlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        DRDesignBubblePlot designBubblePlot = new DRDesignBubblePlot();
        this.axisPlot(designBubblePlot, bubblePlot, chartCustomizers);
        designBubblePlot.setScaleType(bubblePlot.getScaleType());
        return designBubblePlot;
    }

    private DRDesignCandlestickPlot candlestickPlot(DRICandlestickPlot candlestickPlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        DRDesignCandlestickPlot designCandlestickPlot = new DRDesignCandlestickPlot();
        this.axisPlot(designCandlestickPlot, candlestickPlot, chartCustomizers);
        designCandlestickPlot.setShowVolume(candlestickPlot.getShowVolume());
        return designCandlestickPlot;
    }

    private DRDesignHighLowPlot highLowPlot(DRIHighLowPlot highLowPlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        DRDesignHighLowPlot designHighLowPlot = new DRDesignHighLowPlot();
        this.axisPlot(designHighLowPlot, highLowPlot, chartCustomizers);
        designHighLowPlot.setShowOpenTicks(highLowPlot.getShowOpenTicks());
        designHighLowPlot.setShowCloseTicks(highLowPlot.getShowCloseTicks());
        return designHighLowPlot;
    }

    private DRDesignMeterPlot meterPlot(DRIMeterPlot meterPlot) throws DRException {
        DRDesignMeterPlot designMeterPlot = new DRDesignMeterPlot();
        designMeterPlot.setDataRangeLowExpression(this.accessor.getExpressionTransform().transformExpression(meterPlot.getDataRangeLowExpression()));
        designMeterPlot.setDataRangeHighExpression(this.accessor.getExpressionTransform().transformExpression(meterPlot.getDataRangeHighExpression()));
        designMeterPlot.setValueColor(meterPlot.getValueColor());
        designMeterPlot.setValueMask(meterPlot.getValueMask());
        designMeterPlot.setValueFont(this.accessor.getStyleTransform().transformFont(meterPlot.getValueFont()));
        designMeterPlot.setShape(meterPlot.getShape());
        for (DRIMeterInterval interval : meterPlot.getIntervals()) {
            designMeterPlot.getIntervals().add(this.meterInterval(interval));
        }
        designMeterPlot.setMeterAngle(meterPlot.getMeterAngle());
        designMeterPlot.setUnits(meterPlot.getUnits());
        designMeterPlot.setTickInterval(meterPlot.getTickInterval());
        designMeterPlot.setMeterBackgroundColor(meterPlot.getMeterBackgroundColor());
        designMeterPlot.setNeedleColor(meterPlot.getNeedleColor());
        designMeterPlot.setTickColor(meterPlot.getTickColor());
        designMeterPlot.setTickLabelFont(this.accessor.getStyleTransform().transformFont(meterPlot.getTickLabelFont()));
        return designMeterPlot;
    }

    private DRDesignThermometerPlot thermometerPlot(DRIThermometerPlot thermometerPlot) throws DRException {
        DRDesignThermometerPlot designThermometerPlot = new DRDesignThermometerPlot();
        designThermometerPlot.setDataRangeLowExpression(this.accessor.getExpressionTransform().transformExpression(thermometerPlot.getDataRangeLowExpression()));
        designThermometerPlot.setDataRangeHighExpression(this.accessor.getExpressionTransform().transformExpression(thermometerPlot.getDataRangeHighExpression()));
        designThermometerPlot.setValueColor(thermometerPlot.getValueColor());
        designThermometerPlot.setValueMask(thermometerPlot.getValueMask());
        designThermometerPlot.setValueFont(this.accessor.getStyleTransform().transformFont(thermometerPlot.getValueFont()));
        designThermometerPlot.setValueLocation(this.accessor.getTemplateTransform().getChartThermometerPlotValueLocation(thermometerPlot));
        designThermometerPlot.setMercuryColor(thermometerPlot.getMercuryColor());
        designThermometerPlot.setLowDataRangeLowExpression(this.accessor.getExpressionTransform().transformExpression(thermometerPlot.getLowDataRangeLowExpression()));
        designThermometerPlot.setLowDataRangeHighExpression(this.accessor.getExpressionTransform().transformExpression(thermometerPlot.getLowDataRangeHighExpression()));
        designThermometerPlot.setMediumDataRangeLowExpression(this.accessor.getExpressionTransform().transformExpression(thermometerPlot.getMediumDataRangeLowExpression()));
        designThermometerPlot.setMediumDataRangeHighExpression(this.accessor.getExpressionTransform().transformExpression(thermometerPlot.getMediumDataRangeHighExpression()));
        designThermometerPlot.setHighDataRangeLowExpression(this.accessor.getExpressionTransform().transformExpression(thermometerPlot.getHighDataRangeLowExpression()));
        designThermometerPlot.setHighDataRangeHighExpression(this.accessor.getExpressionTransform().transformExpression(thermometerPlot.getHighDataRangeHighExpression()));
        return designThermometerPlot;
    }

    private DRDesignMeterInterval meterInterval(DRIMeterInterval interval) throws DRException {
        DRDesignMeterInterval designInterval = new DRDesignMeterInterval();
        designInterval.setLabel(interval.getLabel());
        designInterval.setBackgroundColor(interval.getBackgroundColor());
        designInterval.setAlpha(interval.getAlpha());
        designInterval.setDataRangeLowExpression(this.accessor.getExpressionTransform().transformExpression(interval.getDataRangeLowExpression()));
        designInterval.setDataRangeHighExpression(this.accessor.getExpressionTransform().transformExpression(interval.getDataRangeHighExpression()));
        return designInterval;
    }

    private DRDesignAxisPlot axisPlot(DRIAxisPlot axisPlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        DRDesignAxisPlot designAxisPlot = new DRDesignAxisPlot();
        this.axisPlot(designAxisPlot, axisPlot, chartCustomizers);
        return designAxisPlot;
    }

    private void axisPlot(DRDesignAxisPlot designAxisPlot, DRIAxisPlot axisPlot, List<DRIChartCustomizer> chartCustomizers) throws DRException {
        designAxisPlot.setXAxisFormat(this.axisFormat(axisPlot.getXAxisFormat()));
        designAxisPlot.setYAxisFormat(this.axisFormat(axisPlot.getYAxisFormat()));
        Comparator<String> seriesOrderBy = axisPlot.getSeriesOrderBy();
        OrderType seriesOrderType = axisPlot.getSeriesOrderType();
        if (seriesOrderBy != null || seriesOrderType != null) {
            chartCustomizers.add(new SeriesOrderCustomizer(seriesOrderBy, seriesOrderType));
        }
        if (axisPlot.getShowPercentages() != null && axisPlot.getShowPercentages().booleanValue()) {
            chartCustomizers.add(new ShowPercentagesCustomizer());
        }
        if (axisPlot.getShowValues() != null && axisPlot.getShowValues().booleanValue()) {
            String valuePattern = axisPlot.getShowPercentages() != null && axisPlot.getShowPercentages() != false ? this.accessor.getTemplateTransform().getChartPercentValuePattern(axisPlot) : this.accessor.getTemplateTransform().getChartValuePattern(axisPlot);
            boolean customRangeMaxValue = false;
            if (axisPlot.getYAxisFormat() != null) {
                customRangeMaxValue = axisPlot.getYAxisFormat().getRangeMaxValueExpression() != null;
            }
            chartCustomizers.add(new ShowValuesCustomizer(valuePattern, customRangeMaxValue));
        }
    }

    private DRDesignAxisFormat axisFormat(DRIAxisFormat axisFormat) throws DRException {
        DRDesignAxisFormat designAxisFormat = new DRDesignAxisFormat();
        designAxisFormat.setLabelExpression(this.accessor.getExpressionTransform().transformExpression(axisFormat.getLabelExpression()));
        designAxisFormat.setLabelFont(this.accessor.getStyleTransform().transformFont(axisFormat.getLabelFont()));
        designAxisFormat.setLabelColor(axisFormat.getLabelColor());
        designAxisFormat.setTickLabelFont(this.accessor.getStyleTransform().transformFont(axisFormat.getTickLabelFont()));
        designAxisFormat.setTickLabelColor(axisFormat.getTickLabelColor());
        designAxisFormat.setTickLabelMask(axisFormat.getTickLabelMask());
        designAxisFormat.setVerticalTickLabels(axisFormat.getVerticalTickLabels());
        designAxisFormat.setTickLabelRotation(axisFormat.getTickLabelRotation());
        designAxisFormat.setLineColor(axisFormat.getLineColor());
        designAxisFormat.setRangeMinValueExpression(this.accessor.getExpressionTransform().transformExpression(axisFormat.getRangeMinValueExpression()));
        designAxisFormat.setRangeMaxValueExpression(this.accessor.getExpressionTransform().transformExpression(axisFormat.getRangeMaxValueExpression()));
        return designAxisFormat;
    }

    private DRDesignChartTitle title(DRIChartTitle title) throws DRException {
        DRDesignChartTitle designTitle = new DRDesignChartTitle();
        this.subtitle(designTitle, title);
        designTitle.setPosition(title.getPosition());
        return designTitle;
    }

    private DRDesignChartSubtitle subtitle(DRIChartSubtitle subtitle) throws DRException {
        DRDesignChartSubtitle designSubtitle = new DRDesignChartSubtitle();
        this.subtitle(designSubtitle, subtitle);
        return designSubtitle;
    }

    private void subtitle(DRDesignChartSubtitle designSubtitle, DRIChartSubtitle subtitle) throws DRException {
        designSubtitle.setColor(subtitle.getColor());
        designSubtitle.setFont(this.accessor.getStyleTransform().transformFont(subtitle.getFont()));
        designSubtitle.setTitle(this.accessor.getExpressionTransform().transformExpression(subtitle.getTitle()));
    }

    private DRDesignChartLegend legend(DRIChartLegend legend) {
        DRDesignChartLegend designLegend = new DRDesignChartLegend();
        designLegend.setColor(legend.getColor());
        designLegend.setBackgroundColor(legend.getBackgroundColor());
        designLegend.setShowLegend(legend.getShowLegend());
        designLegend.setFont(this.accessor.getStyleTransform().transformFont(legend.getFont()));
        designLegend.setPosition(legend.getPosition());
        return designLegend;
    }

    private DRDesignChartDataset dataset(DRIChartDataset dataset, DRIDataset subDataset, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignChartDataset designDataset;
        DRDesignDataset designSubDataset = null;
        if (dataset.getSubDataset() != null) {
            designSubDataset = this.accessor.getDatasetTransform().transform(dataset.getSubDataset());
            this.accessor.transformToDataset(dataset.getSubDataset());
        } else {
            designSubDataset = this.accessor.getDatasetTransform().transform(subDataset);
            this.accessor.transformToDataset(subDataset);
        }
        if (dataset instanceof DRICategoryDataset) {
            designDataset = this.categoryDataset((DRICategoryDataset)dataset, resetType, resetGroup);
        } else if (dataset instanceof DRITimeSeriesDataset) {
            designDataset = this.timeSeriesDataset((DRITimeSeriesDataset)dataset, resetType, resetGroup);
        } else if (dataset instanceof DRISeriesDataset) {
            designDataset = this.seriesDataset((DRISeriesDataset)dataset, resetType, resetGroup);
        } else if (dataset instanceof DRIHighLowDataset) {
            designDataset = this.highLowDataset((DRIHighLowDataset)dataset);
        } else if (dataset instanceof DRIValueDataset) {
            designDataset = this.valueDataset((DRIValueDataset)dataset);
        } else {
            throw new DRDesignReportException("Dataset " + dataset.getClass().getName() + " not supported");
        }
        designDataset.setSubDataset(designSubDataset);
        if (resetType != null && resetType.equals((Object)ResetType.NONE)) {
            designDataset.setResetType(ResetType.REPORT);
        } else {
            designDataset.setResetType(resetType);
        }
        designDataset.setResetGroup(resetGroup);
        this.accessor.transformToMainDataset();
        return designDataset;
    }

    private void seriesDataset(DRISeriesDataset dataset, DRDesignSeriesDataset designDataset, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRIDesignExpression valueExpression = this.accessor.getExpressionTransform().transformExpression(dataset.getValueExpression());
        DRDesignHyperLink datasetItemHyperLink = this.accessor.getReportTransform().hyperlink(dataset.getItemHyperLink());
        designDataset.setValueExpression(valueExpression);
        int index = 0;
        for (DRIChartSerie dRIChartSerie : dataset.getSeries()) {
            DRDesignChartSerie designSerie;
            if (dRIChartSerie instanceof DRIGroupedCategoryChartSerie) {
                designSerie = this.groupedCategorySerie(dataset.getSubDataset(), (DRIGroupedCategoryChartSerie)dRIChartSerie, valueExpression, resetType, resetGroup, index++);
            } else if (dRIChartSerie instanceof DRICategoryChartSerie) {
                designSerie = this.categorySerie(dataset.getSubDataset(), (DRICategoryChartSerie)dRIChartSerie, valueExpression, resetType, resetGroup, index++);
            } else if (dRIChartSerie instanceof DRIXyChartSerie) {
                designSerie = this.xySerie(dataset.getSubDataset(), (DRIXyChartSerie)dRIChartSerie, valueExpression, resetType, resetGroup, index++);
            } else if (dRIChartSerie instanceof DRIXyzChartSerie) {
                designSerie = this.xyzSerie(dataset.getSubDataset(), (DRIXyzChartSerie)dRIChartSerie, valueExpression, resetType, resetGroup, index++);
            } else if (dRIChartSerie instanceof DRIGanttChartSerie) {
                designSerie = this.ganttSerie(dataset.getSubDataset(), (DRIGanttChartSerie)dRIChartSerie, valueExpression, resetType, resetGroup, index++);
            } else {
                throw new DRDesignReportException("Chart serie " + dRIChartSerie.getClass().getName() + " not supported");
            }
            DRDesignHyperLink itemHyperLink = this.accessor.getReportTransform().hyperlink(dRIChartSerie.getItemHyperLink());
            if (itemHyperLink == null) {
                itemHyperLink = datasetItemHyperLink;
            }
            designSerie.setItemHyperLink(itemHyperLink);
            designDataset.addSerie(designSerie);
        }
    }

    private DRDesignSeriesDataset seriesDataset(DRISeriesDataset dataset, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignSeriesDataset designDataset = new DRDesignSeriesDataset();
        this.seriesDataset(dataset, designDataset, resetType, resetGroup);
        return designDataset;
    }

    private DRDesignCategoryDataset categoryDataset(DRICategoryDataset dataset, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignCategoryDataset designDataset = new DRDesignCategoryDataset();
        this.seriesDataset(dataset, designDataset, resetType, resetGroup);
        designDataset.setUseSeriesAsCategory(this.accessor.getTemplateTransform().isChartCategoryDatasetUseSeriesAsCategory(dataset));
        return designDataset;
    }

    private DRDesignTimeSeriesDataset timeSeriesDataset(DRITimeSeriesDataset dataset, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignTimeSeriesDataset designDataset = new DRDesignTimeSeriesDataset();
        this.seriesDataset(dataset, designDataset, resetType, resetGroup);
        designDataset.setTimePeriodType(this.accessor.getTemplateTransform().getChartTimeSeriesDatasetTimePeriodType(dataset));
        return designDataset;
    }

    private DRDesignHighLowDataset highLowDataset(DRIHighLowDataset dataset) throws DRException {
        DRDesignHighLowDataset designDataset = new DRDesignHighLowDataset();
        AbstractExpressionTransform expressionTransform = this.accessor.getExpressionTransform();
        designDataset.setItemHyperLink(this.accessor.getReportTransform().hyperlink(dataset.getItemHyperLink()));
        designDataset.setSeriesExpression(expressionTransform.transformExpression(dataset.getSeriesExpression()));
        designDataset.setDateExpression(expressionTransform.transformExpression(dataset.getDateExpression()));
        designDataset.setHighExpression(expressionTransform.transformExpression(dataset.getHighExpression()));
        designDataset.setLowExpression(expressionTransform.transformExpression(dataset.getLowExpression()));
        designDataset.setOpenExpression(expressionTransform.transformExpression(dataset.getOpenExpression()));
        designDataset.setCloseExpression(expressionTransform.transformExpression(dataset.getCloseExpression()));
        designDataset.setVolumeExpression(expressionTransform.transformExpression(dataset.getVolumeExpression()));
        return designDataset;
    }

    private DRDesignValueDataset valueDataset(DRIValueDataset dataset) throws DRException {
        DRDesignValueDataset designDataset = new DRDesignValueDataset();
        AbstractExpressionTransform expressionTransform = this.accessor.getExpressionTransform();
        designDataset.setValueExpression(expressionTransform.transformExpression(dataset.getValueExpression()));
        return designDataset;
    }

    private DRDesignCategoryChartSerie categorySerie(DRIDataset dataset, DRICategoryChartSerie serie, DRIDesignExpression valueExpression, ResetType resetType, DRDesignGroup resetGroup, int index) throws DRException {
        DRDesignCategoryChartSerie designSerie = new DRDesignCategoryChartSerie();
        AbstractExpressionTransform expressionTransform = this.accessor.getExpressionTransform();
        DRIDesignExpression seriesExpression = expressionTransform.transformExpression(serie.getSeriesExpression());
        designSerie.setSeriesExpression(seriesExpression);
        DRIDesignExpression serieValueExpression = expressionTransform.transformExpression(serie.getValueExpression());
        if (serieValueExpression instanceof DRIDesignVariable) {
            designSerie.setValueExpression(serieValueExpression);
        } else if (seriesExpression == null) {
            designSerie.setValueExpression(expressionTransform.transformExpression(new SerieValueExpression(valueExpression, serieValueExpression, resetType, resetGroup, null)));
        } else {
            designSerie.setValueExpression(expressionTransform.transformExpression(new SerieValueExpression(valueExpression, serieValueExpression, resetType, resetGroup, seriesExpression.getName())));
        }
        DRIExpression<?> labelExpression = serie.getLabelExpression();
        if (labelExpression == null) {
            labelExpression = Expressions.text("serie" + index);
        }
        designSerie.setLabelExpression(expressionTransform.transformExpression(labelExpression));
        return designSerie;
    }

    private DRDesignCategoryChartSerie groupedCategorySerie(DRIDataset dataset, DRIGroupedCategoryChartSerie serie, DRIDesignExpression valueExpression, ResetType resetType, DRDesignGroup resetGroup, int index) throws DRException {
        DRDesignCategoryChartSerie designSerie = new DRDesignCategoryChartSerie();
        AbstractExpressionTransform expressionTransform = this.accessor.getExpressionTransform();
        GroupedSeriesExpression groupedSeriesExpression = new GroupedSeriesExpression(serie.getGroupExpression(), serie.getSeriesExpression(), serie.getLabelExpression(), index);
        DRIDesignExpression seriesExpression = expressionTransform.transformExpression(groupedSeriesExpression);
        designSerie.setSeriesExpression(seriesExpression);
        DRIDesignExpression serieValueExpression = expressionTransform.transformExpression(serie.getValueExpression());
        if (serieValueExpression instanceof DRIDesignVariable) {
            designSerie.setValueExpression(serieValueExpression);
        } else {
            designSerie.setValueExpression(expressionTransform.transformExpression(new SerieValueExpression(valueExpression, serieValueExpression, resetType, resetGroup, seriesExpression.getName())));
        }
        DRIExpression<?> labelExpression = serie.getLabelExpression();
        if (labelExpression == null) {
            labelExpression = Expressions.text("serie" + index);
        }
        designSerie.setLabelExpression(expressionTransform.transformExpression(labelExpression));
        return designSerie;
    }

    private DRDesignXyChartSerie xySerie(DRIDataset dataset, DRIXyChartSerie serie, DRIDesignExpression valueExpression, ResetType resetType, DRDesignGroup resetGroup, int index) throws DRException {
        DRDesignXyChartSerie designSerie = new DRDesignXyChartSerie();
        AbstractExpressionTransform expressionTransform = this.accessor.getExpressionTransform();
        designSerie.setSeriesExpression(expressionTransform.transformExpression(serie.getSeriesExpression()));
        designSerie.setXValueExpression(expressionTransform.transformExpression(serie.getXValueExpression()));
        designSerie.setYValueExpression(expressionTransform.transformExpression(serie.getYValueExpression()));
        DRIExpression<?> labelExpression = serie.getLabelExpression();
        if (labelExpression == null) {
            labelExpression = Expressions.text("serie" + index);
        }
        designSerie.setLabelExpression(expressionTransform.transformExpression(labelExpression));
        return designSerie;
    }

    private DRDesignXyzChartSerie xyzSerie(DRIDataset dataset, DRIXyzChartSerie serie, DRIDesignExpression valueExpression, ResetType resetType, DRDesignGroup resetGroup, int index) throws DRException {
        DRDesignXyzChartSerie designSerie = new DRDesignXyzChartSerie();
        AbstractExpressionTransform expressionTransform = this.accessor.getExpressionTransform();
        DRIExpression<?> seriesExpression = serie.getSeriesExpression();
        if (seriesExpression == null) {
            seriesExpression = Expressions.text("serie" + index);
        }
        designSerie.setSeriesExpression(expressionTransform.transformExpression(seriesExpression));
        designSerie.setXValueExpression(expressionTransform.transformExpression(serie.getXValueExpression()));
        designSerie.setYValueExpression(expressionTransform.transformExpression(serie.getYValueExpression()));
        designSerie.setZValueExpression(expressionTransform.transformExpression(serie.getZValueExpression()));
        return designSerie;
    }

    private DRDesignGanttChartSerie ganttSerie(DRIDataset dataset, DRIGanttChartSerie serie, DRIDesignExpression valueExpression, ResetType resetType, DRDesignGroup resetGroup, int index) throws DRException {
        DRDesignGanttChartSerie designSerie = new DRDesignGanttChartSerie();
        AbstractExpressionTransform expressionTransform = this.accessor.getExpressionTransform();
        designSerie.setSeriesExpression(expressionTransform.transformExpression(serie.getSeriesExpression()));
        designSerie.setStartDateExpression(expressionTransform.transformExpression(serie.getStartDateExpression()));
        designSerie.setEndDateExpression(expressionTransform.transformExpression(serie.getEndDateExpression()));
        designSerie.setPercentExpression(expressionTransform.transformExpression(serie.getPercentExpression()));
        DRIExpression<?> labelExpression = serie.getLabelExpression();
        if (labelExpression == null) {
            labelExpression = Expressions.text("serie" + index);
        }
        designSerie.setLabelExpression(expressionTransform.transformExpression(labelExpression));
        return designSerie;
    }
}

