/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.util.ArrayList;
import net.sf.dynamicreports.design.base.component.DRDesignComponent;
import net.sf.dynamicreports.design.base.component.DRDesignList;
import net.sf.dynamicreports.design.base.component.DRDesignListCell;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.design.transformation.StyleResolver;
import net.sf.dynamicreports.report.constant.HorizontalCellComponentAlignment;
import net.sf.dynamicreports.report.constant.ListType;
import net.sf.dynamicreports.report.constant.VerticalCellComponentAlignment;
import net.sf.dynamicreports.report.defaults.Defaults;
import net.sf.dynamicreports.report.exception.DRException;

class ComponentPosition {
    ComponentPosition() {
    }

    protected static void component(String name, DRDesignComponent component, int maxWidth, int maxHeight) throws DRException {
        if (!(component instanceof DRDesignList)) {
            throw new DRDesignReportException("Component " + component.getClass().getName() + " position not supported");
        }
        DRDesignList list = (DRDesignList)component;
        list.setX(0);
        list.setY(0);
        ComponentPosition.list(name, list, maxWidth, maxHeight, true);
        ComponentPosition.list(name, list);
    }

    private static void list(String name, DRDesignList list, int maxWidth, int maxHeight, boolean stretch) throws DRException {
        ComponentPosition.width(list);
        ComponentPosition.alignment(list);
        ComponentPosition.recalculateWidth(name, list, maxWidth - StyleResolver.getHorizontalPadding(list.getStyle()));
        ComponentPosition.height(list);
        int availableWidth = maxWidth - list.getWidth();
        if (availableWidth < 0) {
            throw new DRException(String.valueOf(name) + " components reaches outside available width, available width = " + maxWidth + ", components width = " + list.getWidth());
        }
        if (stretch) {
            list.setWidth(list.getWidth() + availableWidth);
        }
        if (maxHeight > 0) {
            int availableHeight = maxHeight - list.getHeight();
            if (availableHeight < 0) {
                throw new DRException(String.valueOf(name) + " components reaches outside available height, available height = " + maxHeight + ", components height = " + list.getHeight());
            }
            if (stretch) {
                list.setHeight(list.getHeight() + availableHeight);
            }
        }
        ComponentPosition.listCellWidth(list, availableWidth, list.getWidth() - StyleResolver.getHorizontalPadding(list.getStyle()));
        ComponentPosition.listCellX(list);
        ComponentPosition.listCellHeight(list, list.getHeight() - StyleResolver.getVerticalPadding(list.getStyle()));
        ComponentPosition.listCellY(list);
        ComponentPosition.componentX(list);
        ComponentPosition.componentY(list);
        ComponentPosition.componentWidth(list);
        ComponentPosition.componentHeight(list);
    }

    private static void list(String name, DRDesignList list) throws DRException {
        for (DRDesignComponent designComponent : list.getComponents()) {
            if (!(designComponent instanceof DRDesignList)) continue;
            DRDesignList listComponent = (DRDesignList)designComponent;
            if (!listComponent.isCalculateComponents()) {
                listComponent.setCalculateComponents(true);
                ComponentPosition.list(name, listComponent, listComponent.getWidth(), listComponent.getHeight(), false);
            }
            ComponentPosition.list(name, listComponent);
        }
    }

    private static void alignment(DRDesignList list) {
        for (DRDesignListCell listCell : list.getListCells()) {
            if (listCell.getComponent() instanceof DRDesignList) {
                DRDesignList comList = (DRDesignList)listCell.getComponent();
                ComponentPosition.alignment(comList);
                if (listCell.getHorizontalAlignment() == null) {
                    listCell.setHorizontalAlignment(ComponentPosition.detectHorizontalCellComponentAlignment(comList));
                }
                if (listCell.getVerticalAlignment() == null) {
                    listCell.setVerticalAlignment(ComponentPosition.detectVerticalCellComponentAlignment(comList));
                }
            }
            if (listCell.getHorizontalAlignment() == null) {
                listCell.setHorizontalAlignment(Defaults.getDefaults().getHorizontalCellComponentAlignment());
            }
            if (listCell.getVerticalAlignment() != null) continue;
            listCell.setVerticalAlignment(Defaults.getDefaults().getVerticalCellComponentAlignment());
        }
    }

    private static HorizontalCellComponentAlignment detectHorizontalCellComponentAlignment(DRDesignList list) {
        ListType type = list.getType();
        if (type == null) {
            return null;
        }
        switch (type) {
            case HORIZONTAL: 
            case HORIZONTAL_FLOW: {
                for (DRDesignListCell listCell : list.getListCells()) {
                    switch (listCell.getHorizontalAlignment()) {
                        case FLOAT: 
                        case EXPAND: {
                            return null;
                        }
                    }
                }
                return HorizontalCellComponentAlignment.LEFT;
            }
            case VERTICAL: {
                HorizontalCellComponentAlignment alignment = null;
                int maxWidth = 0;
                for (DRDesignComponent designComponent : list.getComponents()) {
                    if (designComponent.getWidth() <= maxWidth) continue;
                    maxWidth = designComponent.getWidth();
                }
                block13: for (DRDesignListCell listCell : list.getListCells()) {
                    switch (listCell.getHorizontalAlignment()) {
                        case EXPAND: {
                            return HorizontalCellComponentAlignment.EXPAND;
                        }
                        case FLOAT: {
                            alignment = HorizontalCellComponentAlignment.FLOAT;
                            break;
                        }
                        default: {
                            if (alignment == null) {
                                alignment = HorizontalCellComponentAlignment.LEFT;
                                break;
                            }
                            if (alignment == HorizontalCellComponentAlignment.LEFT || maxWidth != listCell.getComponent().getWidth()) continue block13;
                            return HorizontalCellComponentAlignment.EXPAND;
                        }
                    }
                }
                return alignment;
            }
        }
        throw new DRDesignReportException("List type " + type.name() + " not supported");
    }

    private static VerticalCellComponentAlignment detectVerticalCellComponentAlignment(DRDesignList list) {
        ListType type = list.getType();
        if (type == null) {
            return null;
        }
        switch (type) {
            case HORIZONTAL: 
            case HORIZONTAL_FLOW: {
                VerticalCellComponentAlignment alignment = null;
                for (DRDesignListCell listCell : list.getListCells()) {
                    switch (listCell.getVerticalAlignment()) {
                        case EXPAND: {
                            return VerticalCellComponentAlignment.EXPAND;
                        }
                    }
                    if (alignment != null) continue;
                    alignment = VerticalCellComponentAlignment.TOP;
                }
                return alignment;
            }
            case VERTICAL: {
                return null;
            }
        }
        throw new DRDesignReportException("List type " + type.name() + " not supported");
    }

    protected static void width(DRDesignList list) {
        int maxWidth;
        block15: {
            block14: {
                maxWidth = 0;
                ListType type = list.getType();
                if (type == null) break block14;
                switch (type) {
                    case HORIZONTAL: 
                    case HORIZONTAL_FLOW: {
                        for (DRDesignComponent component : list.getComponents()) {
                            if (component instanceof DRDesignList) {
                                ComponentPosition.width((DRDesignList)component);
                            }
                            if (component.getWidth() == null) {
                                throw new DRDesignReportException("Component has null width");
                            }
                            maxWidth += component.getWidth() + list.getGap();
                        }
                        if (list.getComponents().isEmpty()) break block15;
                        maxWidth -= list.getGap();
                        break block15;
                    }
                    case VERTICAL: {
                        for (DRDesignComponent component : list.getComponents()) {
                            if (component instanceof DRDesignList) {
                                ComponentPosition.width((DRDesignList)component);
                            }
                            if (component.getWidth() == null) {
                                throw new DRDesignReportException("Component has null width");
                            }
                            if (component.getWidth() <= maxWidth) continue;
                            maxWidth = component.getWidth();
                        }
                        break block15;
                    }
                    default: {
                        throw new DRDesignReportException("List type " + type.name() + " not supported");
                    }
                }
            }
            for (DRDesignComponent component : list.getComponents()) {
                if (component instanceof DRDesignList) {
                    ComponentPosition.width((DRDesignList)component);
                }
                if (component.getWidth() == null) {
                    throw new DRDesignReportException("Component has null width");
                }
                if (component.getWidth() + component.getX() <= maxWidth) continue;
                maxWidth = component.getWidth() + component.getX();
            }
        }
        maxWidth += StyleResolver.getHorizontalPadding(list.getStyle());
        if (list.getWidth() == null) {
            list.setWidth(maxWidth);
        }
    }

    private static void recalculateWidth(String name, DRDesignList list, int availableWidth) throws DRException {
        if (!list.isCalculateComponents()) {
            return;
        }
        if (list.getWidth() <= availableWidth) {
            return;
        }
        int maxWidth = 0;
        ListType type = list.getType();
        if (type == null) {
            return;
        }
        switch (type) {
            case HORIZONTAL: {
                int floatCells = 0;
                int floatCellsWidth = 0;
                for (DRDesignListCell listCell : list.getListCells()) {
                    if (!listCell.getHorizontalAlignment().equals((Object)HorizontalCellComponentAlignment.FLOAT)) continue;
                    floatCellsWidth += listCell.getComponent().getWidth().intValue();
                    ++floatCells;
                }
                if (list.getWidth() - floatCellsWidth >= availableWidth) {
                    throw new DRException(String.valueOf(name) + " components reaches outside available width, available width = " + availableWidth + ", components width = " + list.getWidth());
                }
                availableWidth -= list.getWidth() - floatCellsWidth;
                for (DRDesignListCell listCell : list.getListCells()) {
                    DRDesignComponent component = listCell.getComponent();
                    if (listCell.getHorizontalAlignment().equals((Object)HorizontalCellComponentAlignment.FLOAT)) {
                        int availableCellWidth = 0;
                        if (floatCells > 1) {
                            availableCellWidth = (int)((double)availableWidth / (double)floatCellsWidth * (double)component.getWidth().intValue());
                            floatCellsWidth -= component.getWidth().intValue();
                            availableWidth -= availableCellWidth;
                        } else if (floatCells == 1) {
                            availableCellWidth = availableWidth;
                            availableWidth = 0;
                        }
                        --floatCells;
                        if (component instanceof DRDesignList) {
                            ComponentPosition.recalculateWidth(name, (DRDesignList)component, availableCellWidth - StyleResolver.getHorizontalPadding(component.getStyle()));
                        } else {
                            component.setWidth(availableCellWidth);
                        }
                    }
                    maxWidth += component.getWidth() + list.getGap();
                }
                if (list.getComponents().isEmpty()) break;
                maxWidth -= list.getGap();
                break;
            }
            case HORIZONTAL_FLOW: {
                maxWidth = ComponentPosition.splitHorizontalListWhenOverflowWidth(name, list, availableWidth);
                break;
            }
            case VERTICAL: {
                maxWidth = availableWidth;
                for (DRDesignListCell listCell : list.getListCells()) {
                    DRDesignComponent component = listCell.getComponent();
                    if (component.getWidth() > availableWidth) {
                        if (listCell.getHorizontalAlignment().equals((Object)HorizontalCellComponentAlignment.FLOAT)) {
                            if (component instanceof DRDesignList) {
                                ComponentPosition.recalculateWidth(name, (DRDesignList)component, availableWidth - StyleResolver.getHorizontalPadding(component.getStyle()));
                            } else {
                                component.setWidth(availableWidth);
                            }
                        } else {
                            throw new DRException(String.valueOf(name) + " components reaches outside available width, available width = " + availableWidth + ", components width = " + component.getWidth());
                        }
                    }
                    if (component.getWidth() <= maxWidth) continue;
                    maxWidth = component.getWidth();
                }
                break;
            }
            default: {
                throw new DRDesignReportException("List type " + type.name() + " not supported");
            }
        }
        list.setWidth(maxWidth += StyleResolver.getHorizontalPadding(list.getStyle()));
    }

    private static int splitHorizontalListWhenOverflowWidth(String name, DRDesignList list, int availableWidth) throws DRException {
        ArrayList<DRDesignListCell> listCells = new ArrayList<DRDesignListCell>(list.getListCells());
        list.getListCells().clear();
        list.getComponents().clear();
        HorizontalCellComponentAlignment hAlignment = Defaults.getDefaults().getHorizontalCellComponentAlignment();
        VerticalCellComponentAlignment vAlignment = Defaults.getDefaults().getVerticalCellComponentAlignment();
        DRDesignList column = new DRDesignList(ListType.VERTICAL);
        list.addComponent(hAlignment, vAlignment, column);
        DRDesignList row = new DRDesignList(ListType.HORIZONTAL);
        row.setGap(list.getGap());
        column.addComponent(hAlignment, vAlignment, row);
        int maxWidth = 0;
        int rowMaxWidth = 0;
        for (DRDesignListCell listCell : listCells) {
            DRDesignComponent component = listCell.getComponent();
            if (component.getWidth() > availableWidth) {
                throw new DRException(String.valueOf(name) + " components reaches outside available width, available width = " + availableWidth + ", components width = " + component.getWidth());
            }
            if (rowMaxWidth + component.getWidth() > availableWidth) {
                int width = rowMaxWidth - list.getGap();
                if (width > maxWidth) {
                    maxWidth = width;
                }
                row.setWidth(width);
                row = new DRDesignList(ListType.HORIZONTAL);
                row.setGap(list.getGap());
                column.addComponent(hAlignment, vAlignment, row);
                rowMaxWidth = 0;
            }
            row.addComponent(listCell.getHorizontalAlignment(), listCell.getVerticalAlignment(), component);
            rowMaxWidth += component.getWidth() + list.getGap();
        }
        int width = rowMaxWidth - list.getGap();
        if (width > maxWidth) {
            maxWidth = width;
        }
        row.setWidth(width);
        column.setWidth(maxWidth);
        return maxWidth;
    }

    protected static void height(DRDesignList list) {
        int maxHeight;
        block15: {
            block14: {
                maxHeight = 0;
                ListType type = list.getType();
                if (type == null) break block14;
                switch (type) {
                    case HORIZONTAL: 
                    case HORIZONTAL_FLOW: {
                        for (DRDesignComponent component : list.getComponents()) {
                            if (component instanceof DRDesignList) {
                                ComponentPosition.height((DRDesignList)component);
                            }
                            if (component.getHeight() == null) {
                                throw new DRDesignReportException("Component has null height");
                            }
                            if (component.getHeight() <= maxHeight) continue;
                            maxHeight = component.getHeight();
                        }
                        break block15;
                    }
                    case VERTICAL: {
                        for (DRDesignComponent component : list.getComponents()) {
                            if (component instanceof DRDesignList) {
                                ComponentPosition.height((DRDesignList)component);
                            }
                            if (component.getHeight() == null) {
                                throw new DRDesignReportException("Component has null height");
                            }
                            maxHeight += component.getHeight() + list.getGap();
                        }
                        if (list.getComponents().isEmpty()) break block15;
                        maxHeight -= list.getGap();
                        break block15;
                    }
                    default: {
                        throw new DRDesignReportException("List type " + type.name() + " not supported");
                    }
                }
            }
            for (DRDesignComponent component : list.getComponents()) {
                if (component instanceof DRDesignList) {
                    ComponentPosition.height((DRDesignList)component);
                }
                if (component.getHeight() == null) {
                    throw new DRDesignReportException("Component has null height");
                }
                if (component.getHeight() + component.getY() <= maxHeight) continue;
                maxHeight = component.getHeight() + component.getY();
            }
        }
        maxHeight += StyleResolver.getVerticalPadding(list.getStyle());
        if (list.getHeight() == null) {
            list.setHeight(maxHeight);
        }
    }

    private static void listCellWidth(DRDesignList list, int availableWidth, int maxWidth) {
        block22: {
            block21: {
                if (!list.isCalculateComponents()) {
                    return;
                }
                ListType type = list.getType();
                if (type == null) break block21;
                switch (type) {
                    case HORIZONTAL: 
                    case HORIZONTAL_FLOW: {
                        int expandCellsWidth = 0;
                        int expandCells = 0;
                        for (DRDesignListCell listCell : list.getListCells()) {
                            switch (listCell.getHorizontalAlignment()) {
                                case FLOAT: 
                                case EXPAND: {
                                    expandCellsWidth += listCell.getComponent().getWidth().intValue();
                                    ++expandCells;
                                    break;
                                }
                            }
                        }
                        block14: for (DRDesignListCell listCell : list.getListCells()) {
                            DRDesignComponent component = listCell.getComponent();
                            switch (listCell.getHorizontalAlignment()) {
                                case FLOAT: 
                                case EXPAND: {
                                    int availableCellWidth = 0;
                                    if (expandCells > 1) {
                                        availableCellWidth = (int)((double)availableWidth / (double)expandCellsWidth * (double)component.getWidth().intValue());
                                        expandCellsWidth -= component.getWidth().intValue();
                                        availableWidth -= availableCellWidth;
                                    } else if (expandCells == 1) {
                                        availableCellWidth = availableWidth;
                                        availableWidth = 0;
                                    }
                                    --expandCells;
                                    listCell.setWidth(component.getWidth() + availableCellWidth);
                                    if (!(component instanceof DRDesignList)) continue block14;
                                    ComponentPosition.listCellWidth((DRDesignList)component, availableCellWidth, component.getWidth() + availableCellWidth - StyleResolver.getHorizontalPadding(component.getStyle()));
                                    break;
                                }
                                default: {
                                    listCell.setWidth(component.getWidth());
                                    if (!(component instanceof DRDesignList)) continue block14;
                                    ComponentPosition.listCellWidth((DRDesignList)component, 0, component.getWidth() - StyleResolver.getHorizontalPadding(component.getStyle()));
                                }
                            }
                        }
                        break block22;
                    }
                    case VERTICAL: {
                        block15: for (DRDesignListCell listCell : list.getListCells()) {
                            DRDesignComponent component = listCell.getComponent();
                            switch (listCell.getHorizontalAlignment()) {
                                case FLOAT: 
                                case EXPAND: {
                                    listCell.setWidth(maxWidth);
                                    if (!(component instanceof DRDesignList)) continue block15;
                                    ComponentPosition.listCellWidth((DRDesignList)component, maxWidth - component.getWidth(), maxWidth - StyleResolver.getHorizontalPadding(component.getStyle()));
                                    break;
                                }
                                default: {
                                    listCell.setWidth(maxWidth);
                                    if (!(component instanceof DRDesignList)) continue block15;
                                    ComponentPosition.listCellWidth((DRDesignList)component, 0, component.getWidth() - StyleResolver.getHorizontalPadding(component.getStyle()));
                                }
                            }
                        }
                        break block22;
                    }
                    default: {
                        throw new DRDesignReportException("List type " + type.name() + " not supported");
                    }
                }
            }
            for (DRDesignListCell listCell : list.getListCells()) {
                DRDesignComponent component = listCell.getComponent();
                listCell.setWidth(component.getWidth());
                if (!(component instanceof DRDesignList)) continue;
                ComponentPosition.listCellWidth((DRDesignList)component, 0, component.getWidth() - StyleResolver.getHorizontalPadding(component.getStyle()));
            }
        }
    }

    private static void listCellX(DRDesignList list) {
        block9: {
            block8: {
                if (!list.isCalculateComponents()) {
                    return;
                }
                ListType type = list.getType();
                if (type == null) break block8;
                switch (type) {
                    case HORIZONTAL: 
                    case HORIZONTAL_FLOW: {
                        int x = 0;
                        for (DRDesignListCell listCell : list.getListCells()) {
                            listCell.setX(x);
                            x += listCell.getWidth() + list.getGap();
                            if (!(listCell.getComponent() instanceof DRDesignList)) continue;
                            ComponentPosition.listCellX((DRDesignList)listCell.getComponent());
                        }
                        break block9;
                    }
                    case VERTICAL: {
                        for (DRDesignListCell listCell : list.getListCells()) {
                            listCell.setX(0);
                            if (!(listCell.getComponent() instanceof DRDesignList)) continue;
                            ComponentPosition.listCellX((DRDesignList)listCell.getComponent());
                        }
                        break block9;
                    }
                    default: {
                        throw new DRDesignReportException("List type " + type.name() + " not supported");
                    }
                }
            }
            for (DRDesignListCell listCell : list.getListCells()) {
                listCell.setX(listCell.getComponent().getX());
                if (!(listCell.getComponent() instanceof DRDesignList)) continue;
                ComponentPosition.listCellX((DRDesignList)listCell.getComponent());
            }
        }
    }

    private static void listCellHeight(DRDesignList list, int availableHeight) {
        block23: {
            block22: {
                if (!list.isCalculateComponents()) {
                    return;
                }
                ListType type = list.getType();
                if (type == null) break block22;
                switch (type) {
                    case HORIZONTAL: 
                    case HORIZONTAL_FLOW: {
                        int maxHeight = availableHeight;
                        for (DRDesignListCell listCell : list.getListCells()) {
                            if (listCell.getComponent().getHeight() <= maxHeight) continue;
                            maxHeight = listCell.getComponent().getHeight();
                        }
                        block14: for (DRDesignListCell listCell : list.getListCells()) {
                            DRDesignComponent component = listCell.getComponent();
                            switch (listCell.getVerticalAlignment()) {
                                case EXPAND: {
                                    listCell.setHeight(maxHeight);
                                    if (!(component instanceof DRDesignList)) continue block14;
                                    ComponentPosition.listCellHeight((DRDesignList)component, maxHeight - StyleResolver.getVerticalPadding(component.getStyle()));
                                    break;
                                }
                                default: {
                                    listCell.setHeight(maxHeight);
                                    if (!(component instanceof DRDesignList)) continue block14;
                                    ComponentPosition.listCellHeight((DRDesignList)component, component.getHeight() - StyleResolver.getVerticalPadding(component.getStyle()));
                                }
                            }
                        }
                        break block23;
                    }
                    case VERTICAL: {
                        int maxHeight = 0;
                        int expandCellsHeight = 0;
                        int expandCells = 0;
                        for (DRDesignListCell listCell : list.getListCells()) {
                            maxHeight += listCell.getComponent().getHeight().intValue();
                            switch (listCell.getVerticalAlignment()) {
                                case EXPAND: {
                                    expandCellsHeight += listCell.getComponent().getHeight().intValue();
                                    ++expandCells;
                                    break;
                                }
                            }
                        }
                        availableHeight = availableHeight - maxHeight - list.getGap() * (list.getComponents().size() - 1);
                        block16: for (DRDesignListCell listCell : list.getListCells()) {
                            DRDesignComponent component = listCell.getComponent();
                            switch (listCell.getVerticalAlignment()) {
                                case EXPAND: {
                                    int availableCellHeight = 0;
                                    if (expandCells > 1) {
                                        availableCellHeight = (int)((double)availableHeight / (double)expandCellsHeight * (double)component.getHeight().intValue());
                                        expandCellsHeight -= component.getHeight().intValue();
                                        availableHeight -= availableCellHeight;
                                    } else if (expandCells == 1) {
                                        availableCellHeight = availableHeight;
                                        availableHeight = 0;
                                    }
                                    --expandCells;
                                    listCell.setHeight(component.getHeight() + availableCellHeight);
                                    if (!(component instanceof DRDesignList)) continue block16;
                                    ComponentPosition.listCellHeight((DRDesignList)component, listCell.getHeight() - StyleResolver.getVerticalPadding(component.getStyle()));
                                    break;
                                }
                                default: {
                                    listCell.setHeight(component.getHeight());
                                    if (!(component instanceof DRDesignList)) continue block16;
                                    ComponentPosition.listCellHeight((DRDesignList)component, listCell.getHeight() - StyleResolver.getVerticalPadding(component.getStyle()));
                                }
                            }
                        }
                        break block23;
                    }
                    default: {
                        throw new DRDesignReportException("List type " + type.name() + " not supported");
                    }
                }
            }
            for (DRDesignListCell listCell : list.getListCells()) {
                DRDesignComponent component = listCell.getComponent();
                listCell.setHeight(component.getHeight());
                if (!(component instanceof DRDesignList)) continue;
                ComponentPosition.listCellHeight((DRDesignList)component, listCell.getHeight() - StyleResolver.getVerticalPadding(component.getStyle()));
            }
        }
    }

    private static void listCellY(DRDesignList list) {
        block9: {
            block8: {
                if (!list.isCalculateComponents()) {
                    return;
                }
                ListType type = list.getType();
                if (type == null) break block8;
                switch (type) {
                    case HORIZONTAL: 
                    case HORIZONTAL_FLOW: {
                        for (DRDesignListCell listCell : list.getListCells()) {
                            listCell.setY(0);
                            if (!(listCell.getComponent() instanceof DRDesignList)) continue;
                            ComponentPosition.listCellY((DRDesignList)listCell.getComponent());
                        }
                        break block9;
                    }
                    case VERTICAL: {
                        int y = 0;
                        for (DRDesignListCell listCell : list.getListCells()) {
                            listCell.setY(y);
                            y += listCell.getHeight() + list.getGap();
                            if (!(listCell.getComponent() instanceof DRDesignList)) continue;
                            ComponentPosition.listCellY((DRDesignList)listCell.getComponent());
                        }
                        break block9;
                    }
                    default: {
                        throw new DRDesignReportException("List type " + type.name() + " not supported");
                    }
                }
            }
            for (DRDesignListCell listCell : list.getListCells()) {
                listCell.setY(listCell.getComponent().getY());
                if (!(listCell.getComponent() instanceof DRDesignList)) continue;
                ComponentPosition.listCellY((DRDesignList)listCell.getComponent());
            }
        }
    }

    private static void componentX(DRDesignList list) {
        if (!list.isCalculateComponents()) {
            return;
        }
        for (DRDesignListCell listCell : list.getListCells()) {
            DRDesignComponent component = listCell.getComponent();
            HorizontalCellComponentAlignment alignment = listCell.getHorizontalAlignment();
            switch (alignment) {
                case LEFT: 
                case FLOAT: 
                case EXPAND: {
                    component.setX(listCell.getX());
                    break;
                }
                case CENTER: {
                    component.setX(listCell.getX() + listCell.getWidth() / 2 - component.getWidth() / 2);
                    break;
                }
                case RIGHT: {
                    component.setX(listCell.getX() + listCell.getWidth() - component.getWidth());
                    break;
                }
                default: {
                    throw new DRDesignReportException("Component alignment " + alignment.name() + " not supported");
                }
            }
            if (!(component instanceof DRDesignList)) continue;
            ComponentPosition.componentX((DRDesignList)component);
        }
    }

    private static void componentY(DRDesignList list) {
        if (!list.isCalculateComponents()) {
            return;
        }
        for (DRDesignListCell listCell : list.getListCells()) {
            DRDesignComponent component = listCell.getComponent();
            VerticalCellComponentAlignment alignment = listCell.getVerticalAlignment();
            switch (alignment) {
                case TOP: 
                case EXPAND: {
                    component.setY(listCell.getY());
                    break;
                }
                case MIDDLE: {
                    component.setY(listCell.getY() + listCell.getHeight() / 2 - component.getHeight() / 2);
                    break;
                }
                case BOTTOM: {
                    component.setY(listCell.getY() + listCell.getHeight() - component.getHeight());
                    break;
                }
                default: {
                    throw new DRDesignReportException("Component alignment " + alignment.name() + " not supported");
                }
            }
            if (!(component instanceof DRDesignList)) continue;
            ComponentPosition.componentY((DRDesignList)component);
        }
    }

    private static void componentWidth(DRDesignList list) {
        if (!list.isCalculateComponents()) {
            return;
        }
        for (DRDesignListCell listCell : list.getListCells()) {
            DRDesignComponent component = listCell.getComponent();
            HorizontalCellComponentAlignment alignment = listCell.getHorizontalAlignment();
            switch (alignment) {
                case FLOAT: 
                case EXPAND: {
                    component.setWidth(listCell.getWidth());
                    break;
                }
                case LEFT: 
                case CENTER: 
                case RIGHT: {
                    break;
                }
                default: {
                    throw new DRDesignReportException("Component alignment " + alignment.name() + " not supported");
                }
            }
            if (!(component instanceof DRDesignList)) continue;
            ComponentPosition.componentWidth((DRDesignList)component);
        }
    }

    private static void componentHeight(DRDesignList list) {
        if (!list.isCalculateComponents()) {
            return;
        }
        for (DRDesignListCell listCell : list.getListCells()) {
            DRDesignComponent component = listCell.getComponent();
            VerticalCellComponentAlignment alignment = listCell.getVerticalAlignment();
            switch (alignment) {
                case EXPAND: {
                    component.setHeight(listCell.getHeight());
                    break;
                }
                case TOP: 
                case MIDDLE: 
                case BOTTOM: {
                    break;
                }
                default: {
                    throw new DRDesignReportException("Component alignment " + alignment.name() + " not supported");
                }
            }
            if (!(component instanceof DRDesignList)) continue;
            ComponentPosition.componentHeight((DRDesignList)component);
        }
    }
}

