/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.util.List;
import net.sf.dynamicreports.design.base.DRDesignField;
import net.sf.dynamicreports.design.base.DRDesignGroup;
import net.sf.dynamicreports.design.constant.ResetType;
import net.sf.dynamicreports.design.definition.DRIDesignDataset;
import net.sf.dynamicreports.design.transformation.AbstractExpressionTransform;
import net.sf.dynamicreports.design.transformation.ConstantTransform;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.report.definition.DRIField;
import net.sf.dynamicreports.report.definition.DRIReport;
import net.sf.dynamicreports.report.definition.DRISort;
import net.sf.dynamicreports.report.definition.DRIVariable;
import net.sf.dynamicreports.report.exception.DRException;

public class MainDatasetExpressionTransform
extends AbstractExpressionTransform {
    public MainDatasetExpressionTransform(DesignTransformAccessor accessor) {
        super(accessor);
    }

    @Override
    public void transform() throws DRException {
        DRIReport report = this.accessor.getReport();
        List<DRIField<?>> templateDesignFields = report.getTemplateDesign().getFields();
        if (templateDesignFields != null) {
            for (DRIField<?> field : templateDesignFields) {
                DRDesignField designField = (DRDesignField)this.transformExpression(field);
                designField.setExternal(true);
            }
        }
        super.transform();
    }

    @Override
    protected ResetType getVariableResetType(DRIVariable<?> variable) {
        return ConstantTransform.variableResetType(variable.getResetType(), variable.getResetGroup(), this.accessor);
    }

    @Override
    protected DRDesignGroup getVariableResetGroup(DRIVariable<?> variable) throws DRException {
        return this.accessor.getGroupTransform().getGroup(ConstantTransform.variableResetGroup(variable.getName(), variable.getResetType(), variable.getResetGroup(), this.accessor));
    }

    @Override
    protected List<? extends DRIField<?>> transformFields() {
        return this.accessor.getReport().getFields();
    }

    @Override
    protected List<? extends DRIVariable<?>> transformVariables() {
        return this.accessor.getReport().getVariables();
    }

    @Override
    protected List<? extends DRISort> transformSorts() {
        return this.accessor.getReport().getSorts();
    }

    @Override
    protected DRIDesignDataset getDataset() {
        return null;
    }
}

