/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.util.HashMap;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignTableOfContentsHeading;
import net.sf.dynamicreports.design.base.component.DRDesignTextField;
import net.sf.dynamicreports.design.constant.DefaultStyleType;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.expressions.TocPrintWhenExpression;
import net.sf.dynamicreports.design.transformation.expressions.TocReferenceExpression;
import net.sf.dynamicreports.design.transformation.expressions.TocReferenceLinkExpression;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.definition.DRIGroup;
import net.sf.dynamicreports.report.definition.DRITableOfContentsHeading;
import net.sf.dynamicreports.report.definition.component.DRIComponent;
import net.sf.dynamicreports.report.definition.component.DRIHyperLinkComponent;
import net.sf.dynamicreports.report.definition.component.DRITextField;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;

public class TableOfContentsTransform {
    private DesignTransformAccessor accessor;
    private Map<DRITableOfContentsHeading, Integer> levels;

    public TableOfContentsTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
        this.levels = new HashMap<DRITableOfContentsHeading, Integer>();
    }

    protected DRDesignTableOfContentsHeading componentHeading(DRIComponent component) throws DRException {
        DRITableOfContentsHeading tocHeading = component.getTableOfContentsHeading();
        boolean tableOfContents = this.accessor.isTableOfContents();
        if (tableOfContents && tocHeading != null) {
            DRTextField<String> referenceField = new DRTextField<String>();
            int level = this.getLevel(tocHeading);
            DRIExpression<String> labelExpression = tocHeading.getLabelExpression();
            if (labelExpression == null && component instanceof DRITextField) {
                labelExpression = ((DRITextField)component).getValueExpression();
            }
            if (labelExpression == null) {
                labelExpression = Expressions.text("");
            }
            String expressionName = labelExpression.getName();
            DRIExpression<String> anchorNameExpression = null;
            if (component instanceof DRIHyperLinkComponent) {
                anchorNameExpression = ((DRIHyperLinkComponent)component).getAnchorNameExpression();
            }
            DRIExpression<?> customValueExpression = tocHeading.getCustomValueExpression();
            referenceField.setValueExpression(new TocReferenceExpression(level, expressionName, labelExpression, anchorNameExpression, customValueExpression));
            referenceField.setAnchorNameExpression(new TocReferenceLinkExpression(expressionName, anchorNameExpression));
            referenceField.setPrintWhenExpression(component.getPrintWhenExpression());
            DRDesignTextField designReferenceField = this.accessor.getComponentTransform().textField(referenceField, DefaultStyleType.TEXT);
            designReferenceField.setWidth(1);
            designReferenceField.setHeight(1);
            designReferenceField.setUniqueName(String.valueOf(expressionName) + ".tocReference");
            DRDesignTableOfContentsHeading designTocHeading = new DRDesignTableOfContentsHeading();
            designTocHeading.setReferenceField(designReferenceField);
            return designTocHeading;
        }
        return null;
    }

    private int getLevel(DRITableOfContentsHeading tocHeading) {
        if (this.levels.containsKey(tocHeading)) {
            return this.levels.get(tocHeading);
        }
        int level = 0;
        if (tocHeading.getParentHeading() != null) {
            level = this.getLevel(tocHeading.getParentHeading()) + 1;
        }
        this.levels.put(tocHeading, level);
        return level;
    }

    protected DRDesignTableOfContentsHeading groupHeading(DRIGroup group, int level) throws DRException {
        boolean tableOfContents = this.accessor.isTableOfContents();
        boolean isAddGroupToTableOfContents = this.accessor.getTemplateTransform().isAddGroupToTableOfContents(group);
        if (tableOfContents && isAddGroupToTableOfContents) {
            DRTextField<String> referenceField = new DRTextField<String>();
            DRITextField<?> valueField = group.getValueField();
            referenceField.setValueExpression(new TocReferenceExpression(level, group.getName(), valueField.getValueExpression(), valueField.getAnchorNameExpression(), null));
            referenceField.setAnchorNameExpression(new TocReferenceLinkExpression(group.getName(), valueField.getAnchorNameExpression()));
            referenceField.setPrintWhenExpression(new TocPrintWhenExpression(valueField.getValueExpression()));
            DRDesignTextField designReferenceField = this.accessor.getComponentTransform().textField(referenceField, DefaultStyleType.TEXT);
            designReferenceField.setWidth(0);
            designReferenceField.setHeight(0);
            designReferenceField.setUniqueName("group_" + group.getName() + ".tocReference");
            DRDesignTableOfContentsHeading designTocHeading = new DRDesignTableOfContentsHeading();
            designTocHeading.setReferenceField(designReferenceField);
            return designTocHeading;
        }
        return null;
    }
}

