/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.dynamicreports.design.base.component.DRDesignList;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstab;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabCell;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabCellContent;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabColumnGroup;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabRowGroup;
import net.sf.dynamicreports.design.base.style.DRDesignStyle;
import net.sf.dynamicreports.design.constant.DefaultStyleType;
import net.sf.dynamicreports.design.definition.DRIDesignBand;
import net.sf.dynamicreports.design.definition.DRIDesignGroup;
import net.sf.dynamicreports.design.definition.DRIDesignPage;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.design.transformation.ComponentPosition;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.StyleResolver;
import net.sf.dynamicreports.jasper.base.tableofcontents.JasperTocHeading;
import net.sf.dynamicreports.report.constant.BooleanComponentType;
import net.sf.dynamicreports.report.constant.ComponentPositionType;
import net.sf.dynamicreports.report.constant.CrosstabPercentageType;
import net.sf.dynamicreports.report.constant.CrosstabTotalPosition;
import net.sf.dynamicreports.report.constant.GroupFooterPosition;
import net.sf.dynamicreports.report.constant.GroupHeaderLayout;
import net.sf.dynamicreports.report.constant.HorizontalImageAlignment;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.constant.Orientation;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.Position;
import net.sf.dynamicreports.report.constant.RunDirection;
import net.sf.dynamicreports.report.constant.SplitType;
import net.sf.dynamicreports.report.constant.StretchType;
import net.sf.dynamicreports.report.constant.TimePeriod;
import net.sf.dynamicreports.report.constant.ValueLocation;
import net.sf.dynamicreports.report.constant.WhenNoDataType;
import net.sf.dynamicreports.report.constant.WhenResourceMissingType;
import net.sf.dynamicreports.report.defaults.Defaults;
import net.sf.dynamicreports.report.definition.DRIBand;
import net.sf.dynamicreports.report.definition.DRIField;
import net.sf.dynamicreports.report.definition.DRIGroup;
import net.sf.dynamicreports.report.definition.DRIMargin;
import net.sf.dynamicreports.report.definition.DRIReport;
import net.sf.dynamicreports.report.definition.DRIReportTemplate;
import net.sf.dynamicreports.report.definition.DRISubtotal;
import net.sf.dynamicreports.report.definition.DRITableOfContentsCustomizer;
import net.sf.dynamicreports.report.definition.DRITemplateDesign;
import net.sf.dynamicreports.report.definition.barcode.DRIBarbecue;
import net.sf.dynamicreports.report.definition.barcode.DRIBarcode;
import net.sf.dynamicreports.report.definition.chart.DRIChart;
import net.sf.dynamicreports.report.definition.chart.dataset.DRICategoryDataset;
import net.sf.dynamicreports.report.definition.chart.dataset.DRITimeSeriesDataset;
import net.sf.dynamicreports.report.definition.chart.plot.DRIAxisPlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIBasePlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIPiePlot;
import net.sf.dynamicreports.report.definition.chart.plot.DRIThermometerPlot;
import net.sf.dynamicreports.report.definition.column.DRIBooleanColumn;
import net.sf.dynamicreports.report.definition.column.DRIColumn;
import net.sf.dynamicreports.report.definition.column.DRIValueColumn;
import net.sf.dynamicreports.report.definition.component.DRIBooleanField;
import net.sf.dynamicreports.report.definition.component.DRIBreak;
import net.sf.dynamicreports.report.definition.component.DRIComponent;
import net.sf.dynamicreports.report.definition.component.DRIDimensionComponent;
import net.sf.dynamicreports.report.definition.component.DRIEllipse;
import net.sf.dynamicreports.report.definition.component.DRIFiller;
import net.sf.dynamicreports.report.definition.component.DRIGenericElement;
import net.sf.dynamicreports.report.definition.component.DRIImage;
import net.sf.dynamicreports.report.definition.component.DRILine;
import net.sf.dynamicreports.report.definition.component.DRIList;
import net.sf.dynamicreports.report.definition.component.DRIMap;
import net.sf.dynamicreports.report.definition.component.DRIMultiPageList;
import net.sf.dynamicreports.report.definition.component.DRIPageXofY;
import net.sf.dynamicreports.report.definition.component.DRIRectangle;
import net.sf.dynamicreports.report.definition.component.DRISubreport;
import net.sf.dynamicreports.report.definition.component.DRITextField;
import net.sf.dynamicreports.report.definition.component.DRIXyList;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstab;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabColumnGroup;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabMeasure;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabRowGroup;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabVariable;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import net.sf.dynamicreports.report.definition.style.DRIReportStyle;
import net.sf.dynamicreports.report.definition.style.DRISimpleStyle;
import net.sf.dynamicreports.report.definition.style.DRIStyle;
import net.sf.dynamicreports.report.exception.DRException;

public class TemplateTransform {
    private DRIReport report;
    private DesignTransformAccessor accessor;
    private DRIReportTemplate template;
    private DRITemplateDesign<?> templateDesign;

    public TemplateTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
        this.report = accessor.getReport();
        this.template = this.report.getTemplate();
        this.templateDesign = this.report.getTemplateDesign();
    }

    public String getReportName() {
        if (this.report.getReportName() != null) {
            return this.report.getReportName();
        }
        if (this.templateDesign.getReportName() != null) {
            return this.templateDesign.getReportName();
        }
        return Defaults.getDefaults().getReportName();
    }

    public Locale getLocale() {
        if (this.report.getLocale() != null) {
            return this.report.getLocale();
        }
        if (this.template.getLocale() != null) {
            return this.template.getLocale();
        }
        return Defaults.getDefaults().getLocale();
    }

    protected boolean isShowColumnTitle() {
        if (this.report.getShowColumnTitle() != null) {
            return this.report.getShowColumnTitle();
        }
        if (this.template.getShowColumnTitle() != null) {
            return this.template.getShowColumnTitle();
        }
        return Defaults.getDefaults().isShowColumnTitle();
    }

    protected boolean isShowColumnValues() {
        if (this.report.getShowColumnValues() != null) {
            return this.report.getShowColumnValues();
        }
        if (this.template.getShowColumnValues() != null) {
            return this.template.getShowColumnValues();
        }
        return Defaults.getDefaults().isShowColumnValues();
    }

    public String getResourceBundleName() {
        if (this.report.getResourceBundleName() != null) {
            return this.report.getResourceBundleName();
        }
        if (this.templateDesign.getResourceBundleName() != null) {
            return this.templateDesign.getResourceBundleName();
        }
        return null;
    }

    public boolean isIgnorePagination() {
        if (this.report.getIgnorePagination() != null) {
            return this.report.getIgnorePagination();
        }
        if (this.templateDesign.getIgnorePagination() != null) {
            return this.templateDesign.getIgnorePagination();
        }
        if (this.template.getIgnorePagination() != null) {
            return this.template.getIgnorePagination();
        }
        return Defaults.getDefaults().isIgnorePagination();
    }

    public WhenNoDataType getWhenNoDataType(boolean emptyDetail, DRIDesignBand noDataBand) {
        if (this.report.getWhenNoDataType() != null) {
            return this.report.getWhenNoDataType();
        }
        if (this.templateDesign.getWhenNoDataType() != null) {
            return this.templateDesign.getWhenNoDataType();
        }
        if (this.template.getWhenNoDataType() != null) {
            return this.template.getWhenNoDataType();
        }
        if (noDataBand != null) {
            return WhenNoDataType.NO_DATA_SECTION;
        }
        if (emptyDetail) {
            return WhenNoDataType.ALL_SECTIONS_NO_DETAIL;
        }
        return Defaults.getDefaults().getWhenNoDataType();
    }

    public WhenResourceMissingType getWhenResourceMissingType() {
        if (this.report.getWhenResourceMissingType() != null) {
            return this.report.getWhenResourceMissingType();
        }
        if (this.templateDesign.getWhenResourceMissingType() != null) {
            return this.templateDesign.getWhenResourceMissingType();
        }
        if (this.template.getWhenResourceMissingType() != null) {
            return this.template.getWhenResourceMissingType();
        }
        return Defaults.getDefaults().getWhenResourceMissingType();
    }

    public boolean isTitleOnANewPage() {
        if (this.report.getTitleOnANewPage() != null) {
            return this.report.getTitleOnANewPage();
        }
        if (this.templateDesign.getTitleOnANewPage() != null) {
            return this.templateDesign.getTitleOnANewPage();
        }
        if (this.template.getTitleOnANewPage() != null) {
            return this.template.getTitleOnANewPage();
        }
        return Defaults.getDefaults().isTitleOnANewPage();
    }

    public boolean isSummaryOnANewPage() {
        if (this.report.getSummaryOnANewPage() != null) {
            return this.report.getSummaryOnANewPage();
        }
        if (this.templateDesign.getSummaryOnANewPage() != null) {
            return this.templateDesign.getSummaryOnANewPage();
        }
        if (this.template.getSummaryOnANewPage() != null) {
            return this.template.getSummaryOnANewPage();
        }
        return Defaults.getDefaults().isSummaryOnANewPage();
    }

    public boolean isSummaryWithPageHeaderAndFooter() {
        if (this.report.getSummaryWithPageHeaderAndFooter() != null) {
            return this.report.getSummaryWithPageHeaderAndFooter();
        }
        if (this.templateDesign.getSummaryWithPageHeaderAndFooter() != null) {
            return this.templateDesign.getSummaryWithPageHeaderAndFooter();
        }
        if (this.template.getSummaryWithPageHeaderAndFooter() != null) {
            return this.template.getSummaryWithPageHeaderAndFooter();
        }
        return Defaults.getDefaults().isSummaryWithPageHeaderAndFooter();
    }

    public boolean isFloatColumnFooter() {
        if (this.report.getFloatColumnFooter() != null) {
            return this.report.getFloatColumnFooter();
        }
        if (this.templateDesign.getFloatColumnFooter() != null) {
            return this.templateDesign.getFloatColumnFooter();
        }
        if (this.template.getFloatColumnFooter() != null) {
            return this.template.getFloatColumnFooter();
        }
        return Defaults.getDefaults().isFloatColumnFooter();
    }

    public Orientation getPrintOrder() {
        if (this.report.getPrintOrder() != null) {
            return this.report.getPrintOrder();
        }
        if (this.template.getPrintOrder() != null) {
            return this.template.getPrintOrder();
        }
        return Defaults.getDefaults().getPrintOrder();
    }

    public RunDirection getColumnDirection() {
        if (this.report.getColumnDirection() != null) {
            return this.report.getColumnDirection();
        }
        if (this.template.getColumnDirection() != null) {
            return this.template.getColumnDirection();
        }
        return Defaults.getDefaults().getColumnDirection();
    }

    public String getLanguage() {
        if (this.report.getLanguage() != null) {
            return this.report.getLanguage();
        }
        if (this.template.getLanguage() != null) {
            return this.template.getLanguage();
        }
        return Defaults.getDefaults().getLanguage();
    }

    public String getFieldDescription(DRIField<?> field) {
        if (field.getDescription() != null) {
            return field.getDescription();
        }
        if (this.isUseFieldNameAsDescription()) {
            return field.getName();
        }
        return null;
    }

    private boolean isUseFieldNameAsDescription() {
        if (this.report.getUseFieldNameAsDescription() != null) {
            return this.report.getUseFieldNameAsDescription();
        }
        if (this.template.getUseFieldNameAsDescription() != null) {
            return this.template.getUseFieldNameAsDescription();
        }
        return Defaults.getDefaults().isUseFieldNameAsDescription();
    }

    public boolean isTableOfContents(Map<String, JasperTocHeading> tocHeadings) {
        if (tocHeadings != null) {
            return true;
        }
        if (this.report.getTableOfContents() != null) {
            return this.report.getTableOfContents();
        }
        if (this.template.getTableOfContents() != null) {
            return this.template.getTableOfContents();
        }
        return Defaults.getDefaults().isTableOfContents();
    }

    public DRITableOfContentsCustomizer getTableOfContentsCustomizer() {
        if (this.report.getTableOfContentsCustomizer() != null) {
            return this.report.getTableOfContentsCustomizer();
        }
        if (this.template.getTableOfContentsCustomizer() != null) {
            return this.template.getTableOfContentsCustomizer();
        }
        return Defaults.getDefaults().getTableOfContentsCustomizer();
    }

    public boolean isAddGroupToTableOfContents(DRIGroup group) {
        if (group.getAddToTableOfContents() != null) {
            return group.getAddToTableOfContents();
        }
        return Defaults.getDefaults().isAddGroupToTableOfContents();
    }

    protected DRISimpleStyle getDetailOddRowStyle() {
        if (this.isHighlightDetailOddRows()) {
            if (this.report.getDetailOddRowStyle() != null) {
                return this.report.getDetailOddRowStyle();
            }
            if (this.template.getDetailOddRowStyle() != null) {
                return this.template.getDetailOddRowStyle();
            }
            return Defaults.getDefaults().getDetailOddRowStyle();
        }
        return null;
    }

    protected DRISimpleStyle getDetailEvenRowStyle() {
        if (this.isHighlightDetailEvenRows()) {
            if (this.report.getDetailEvenRowStyle() != null) {
                return this.report.getDetailEvenRowStyle();
            }
            if (this.template.getDetailEvenRowStyle() != null) {
                return this.template.getDetailEvenRowStyle();
            }
            return Defaults.getDefaults().getDetailEvenRowStyle();
        }
        return null;
    }

    private boolean isHighlightDetailOddRows() {
        if (this.report.getHighlightDetailOddRows() != null) {
            return this.report.getHighlightDetailOddRows();
        }
        if (this.template.getHighlightDetailOddRows() != null) {
            return this.template.getHighlightDetailOddRows();
        }
        return Defaults.getDefaults().isHighlightDetailOddRows();
    }

    private boolean isHighlightDetailEvenRows() {
        if (this.report.getHighlightDetailEvenRows() != null) {
            return this.report.getHighlightDetailEvenRows();
        }
        if (this.template.getHighlightDetailEvenRows() != null) {
            return this.template.getHighlightDetailEvenRows();
        }
        return Defaults.getDefaults().isHighlightDetailEvenRows();
    }

    protected String getDefaultFontName() {
        if (this.report.getDefaultFont() != null && this.report.getDefaultFont().getFontName() != null) {
            return this.report.getDefaultFont().getFontName();
        }
        if (this.template.getDefaultFont() != null && this.template.getDefaultFont().getFontName() != null) {
            return this.template.getDefaultFont().getFontName();
        }
        return Defaults.getDefaults().getFont().getFontName();
    }

    protected Integer getDefaultFontSize() {
        if (this.report.getDefaultFont() != null && this.report.getDefaultFont().getFontSize() != null) {
            return this.report.getDefaultFont().getFontSize();
        }
        if (this.template.getDefaultFont() != null && this.template.getDefaultFont().getFontSize() != null) {
            return this.template.getDefaultFont().getFontSize();
        }
        return Defaults.getDefaults().getFont().getFontSize();
    }

    protected Boolean getDefaultFontBold() {
        if (this.report.getDefaultFont() != null && this.report.getDefaultFont().getBold() != null) {
            return this.report.getDefaultFont().getBold();
        }
        if (this.template.getDefaultFont() != null && this.template.getDefaultFont().getBold() != null) {
            return this.template.getDefaultFont().getBold();
        }
        return Defaults.getDefaults().getFont().getBold();
    }

    protected Boolean getDefaultFontItalic() {
        if (this.report.getDefaultFont() != null && this.report.getDefaultFont().getItalic() != null) {
            return this.report.getDefaultFont().getItalic();
        }
        if (this.template.getDefaultFont() != null && this.template.getDefaultFont().getItalic() != null) {
            return this.template.getDefaultFont().getItalic();
        }
        return Defaults.getDefaults().getFont().getItalic();
    }

    protected Boolean getDefaultFontUnderline() {
        if (this.report.getDefaultFont() != null && this.report.getDefaultFont().getUnderline() != null) {
            return this.report.getDefaultFont().getUnderline();
        }
        if (this.template.getDefaultFont() != null && this.template.getDefaultFont().getUnderline() != null) {
            return this.template.getDefaultFont().getUnderline();
        }
        return Defaults.getDefaults().getFont().getUnderline();
    }

    protected Boolean getDefaultFontStrikeThrough() {
        if (this.report.getDefaultFont() != null && this.report.getDefaultFont().getStrikeThrough() != null) {
            return this.report.getDefaultFont().getStrikeThrough();
        }
        if (this.template.getDefaultFont() != null && this.template.getDefaultFont().getStrikeThrough() != null) {
            return this.template.getDefaultFont().getStrikeThrough();
        }
        return Defaults.getDefaults().getFont().getStrikeThrough();
    }

    protected String getDefaultFontPdfFontName() {
        if (this.report.getDefaultFont() != null && this.report.getDefaultFont().getPdfFontName() != null) {
            return this.report.getDefaultFont().getPdfFontName();
        }
        if (this.template.getDefaultFont() != null && this.template.getDefaultFont().getPdfFontName() != null) {
            return this.template.getDefaultFont().getPdfFontName();
        }
        return Defaults.getDefaults().getFont().getPdfFontName();
    }

    protected String getDefaultFontPdfEncoding() {
        if (this.report.getDefaultFont() != null && this.report.getDefaultFont().getPdfEncoding() != null) {
            return this.report.getDefaultFont().getPdfEncoding();
        }
        if (this.template.getDefaultFont() != null && this.template.getDefaultFont().getPdfEncoding() != null) {
            return this.template.getDefaultFont().getPdfEncoding();
        }
        return Defaults.getDefaults().getFont().getPdfEncoding();
    }

    protected Boolean getDefaultFontPdfEmbedded() {
        if (this.report.getDefaultFont() != null && this.report.getDefaultFont().getPdfEmbedded() != null) {
            return this.report.getDefaultFont().getPdfEmbedded();
        }
        if (this.template.getDefaultFont() != null && this.template.getDefaultFont().getPdfEmbedded() != null) {
            return this.template.getDefaultFont().getPdfEmbedded();
        }
        return Defaults.getDefaults().getFont().getPdfEmbedded();
    }

    protected DRIReportStyle getTextStyle() {
        if (this.report.getTextStyle() != null) {
            return this.report.getTextStyle();
        }
        if (this.template.getTextStyle() != null) {
            return this.template.getTextStyle();
        }
        return Defaults.getDefaults().getTextStyle();
    }

    protected DRIReportStyle getColumnTitleStyle() {
        if (this.report.getColumnTitleStyle() != null) {
            return this.report.getColumnTitleStyle();
        }
        if (this.template.getColumnTitleStyle() != null) {
            return this.template.getColumnTitleStyle();
        }
        if (Defaults.getDefaults().getColumnTitleStyle() != null) {
            return Defaults.getDefaults().getColumnTitleStyle();
        }
        return this.getTextStyle();
    }

    protected DRIReportStyle getColumnStyle(boolean textStyle) {
        if (this.report.getColumnStyle() != null) {
            return this.report.getColumnStyle();
        }
        if (this.template.getColumnStyle() != null) {
            return this.template.getColumnStyle();
        }
        if (Defaults.getDefaults().getColumnStyle() != null) {
            return Defaults.getDefaults().getColumnStyle();
        }
        if (textStyle) {
            return this.getTextStyle();
        }
        return null;
    }

    protected DRIReportStyle getGroupTitleStyle() {
        if (this.report.getGroupTitleStyle() != null) {
            return this.report.getGroupTitleStyle();
        }
        if (this.template.getGroupTitleStyle() != null) {
            return this.template.getGroupTitleStyle();
        }
        if (Defaults.getDefaults().getGroupTitleStyle() != null) {
            return Defaults.getDefaults().getGroupTitleStyle();
        }
        return this.getTextStyle();
    }

    protected DRIReportStyle getGroupStyle() {
        if (this.report.getGroupStyle() != null) {
            return this.report.getGroupStyle();
        }
        if (this.template.getGroupStyle() != null) {
            return this.template.getGroupStyle();
        }
        if (Defaults.getDefaults().getGroupStyle() != null) {
            return Defaults.getDefaults().getGroupStyle();
        }
        return this.getTextStyle();
    }

    protected DRIReportStyle getSubtotalStyle() {
        if (this.report.getSubtotalStyle() != null) {
            return this.report.getSubtotalStyle();
        }
        if (this.template.getSubtotalStyle() != null) {
            return this.template.getSubtotalStyle();
        }
        if (Defaults.getDefaults().getSubtotalStyle() != null) {
            return Defaults.getDefaults().getSubtotalStyle();
        }
        return this.getTextStyle();
    }

    protected DRIReportStyle getImageStyle() {
        if (this.report.getImageStyle() != null) {
            return this.report.getImageStyle();
        }
        if (this.template.getImageStyle() != null) {
            return this.template.getImageStyle();
        }
        return Defaults.getDefaults().getImageStyle();
    }

    protected DRIReportStyle getChartStyle() {
        if (this.report.getChartStyle() != null) {
            return this.report.getChartStyle();
        }
        if (this.template.getChartStyle() != null) {
            return this.template.getChartStyle();
        }
        return Defaults.getDefaults().getChartStyle();
    }

    protected DRIReportStyle getBarcodeStyle() {
        if (this.report.getBarcodeStyle() != null) {
            return this.report.getBarcodeStyle();
        }
        if (this.template.getBarcodeStyle() != null) {
            return this.template.getBarcodeStyle();
        }
        return Defaults.getDefaults().getBarcodeStyle();
    }

    protected int getPageWidth() throws DRException {
        if (this.isIgnorePageWidth()) {
            return this.getDynamicPageWidth();
        }
        return this.getStaticPageWidth();
    }

    private boolean isIgnorePageWidth() {
        if (this.report.getPage().getIgnorePageWidth() != null) {
            return this.report.getPage().getIgnorePageWidth();
        }
        if (this.template.getIgnorePageWidth() != null) {
            return this.template.getIgnorePageWidth();
        }
        return Defaults.getDefaults().isIgnorePageWidth();
    }

    private int getDynamicPageWidth() throws DRException {
        int maxPageWidth = 0;
        maxPageWidth = this.getMaxBandWidth(this.accessor.getBandTransform().getTitleBand(), maxPageWidth);
        maxPageWidth = this.getMaxBandWidth(this.accessor.getBandTransform().getPageHeaderBand(), maxPageWidth);
        maxPageWidth = this.getMaxBandWidth(this.accessor.getBandTransform().getPageFooterBand(), maxPageWidth);
        maxPageWidth = this.getMaxBandWidth(this.accessor.getBandTransform().getColumnHeaderBand(), maxPageWidth);
        maxPageWidth = this.getMaxBandWidth(this.accessor.getBandTransform().getColumnFooterBand(), maxPageWidth);
        maxPageWidth = this.getMaxBandWidth(this.accessor.getBandTransform().getDetailBand(), maxPageWidth);
        maxPageWidth = this.getMaxBandWidth(this.accessor.getBandTransform().getLastPageFooterBand(), maxPageWidth);
        maxPageWidth = this.getMaxBandWidth(this.accessor.getBandTransform().getSummaryBand(), maxPageWidth);
        return maxPageWidth + this.getPageMargin().getLeft() + this.getPageMargin().getRight();
    }

    private int getMaxBandWidth(DRIDesignBand band, int maxWidth) throws DRException {
        if (band == null || band.getList() == null) {
            return maxWidth;
        }
        int bandWidth = this.detectWidth(band.getList());
        if (bandWidth > maxWidth) {
            return bandWidth;
        }
        return maxWidth;
    }

    private int getStaticPageWidth() throws DRException {
        if (this.accessor.getPageWidth() != null) {
            return this.accessor.getPageWidth();
        }
        if (this.report.getPage().getWidth() != null) {
            return this.report.getPage().getWidth();
        }
        if (this.templateDesign.getPageWidth() != null) {
            return this.templateDesign.getPageWidth();
        }
        if (this.template.getPageWidth() != null) {
            return this.template.getPageWidth();
        }
        return Defaults.getDefaults().getPageWidth();
    }

    protected int getPageHeight() throws DRException {
        if (this.report.getPage().getHeight() != null) {
            return this.report.getPage().getHeight();
        }
        if (this.templateDesign.getPageHeight() != null) {
            return this.templateDesign.getPageHeight();
        }
        if (this.template.getPageHeight() != null) {
            return this.template.getPageHeight();
        }
        return Defaults.getDefaults().getPageHeight();
    }

    protected PageOrientation getPageOrientation() throws DRException {
        if (this.report.getPage().getOrientation() != null) {
            return this.report.getPage().getOrientation();
        }
        if (this.templateDesign.getPageOrientation() != null) {
            return this.templateDesign.getPageOrientation();
        }
        if (this.template.getPageOrientation() != null) {
            return this.template.getPageOrientation();
        }
        return Defaults.getDefaults().getPageOrientation();
    }

    protected DRIMargin getPageMargin() throws DRException {
        if (this.report.getPage().getMargin() != null) {
            return this.report.getPage().getMargin();
        }
        if (this.templateDesign.getPageMargin() != null) {
            return this.templateDesign.getPageMargin();
        }
        if (this.accessor.getPageWidth() != null) {
            return Defaults.getDefaults().getSubreportPageMargin();
        }
        if (this.template.getPageMargin() != null) {
            return this.template.getPageMargin();
        }
        return Defaults.getDefaults().getPageMargin();
    }

    protected int getPageColumnsPerPage() throws DRException {
        if (this.report.getPage().getColumnsPerPage() != null) {
            return this.report.getPage().getColumnsPerPage();
        }
        if (this.templateDesign.getPageColumnsPerPage() != null) {
            return this.templateDesign.getPageColumnsPerPage();
        }
        if (this.template.getPageColumnsPerPage() != null) {
            return this.template.getPageColumnsPerPage();
        }
        return Defaults.getDefaults().getPageColumnsPerPage();
    }

    protected int getPageColumnSpace() throws DRException {
        if (this.report.getPage().getColumnSpace() != null) {
            return this.report.getPage().getColumnSpace();
        }
        if (this.templateDesign.getPageColumnSpace() != null) {
            return this.templateDesign.getPageColumnSpace();
        }
        if (this.template.getPageColumnSpace() != null) {
            return this.template.getPageColumnSpace();
        }
        return Defaults.getDefaults().getPageColumnSpace();
    }

    protected int getPageColumnWidth(DRIDesignPage page) {
        int columnWidth = page.getWidth() - page.getMargin().getLeft() - page.getMargin().getRight();
        columnWidth -= page.getColumnSpace() * (page.getColumnsPerPage() - 1);
        if (this.templateDesign.getPageColumnWidth() != null && this.templateDesign.getPageColumnWidth() > 0 && this.templateDesign.getPageColumnWidth() < (columnWidth /= page.getColumnsPerPage()) && !this.isIgnorePageWidth()) {
            return this.templateDesign.getPageColumnWidth();
        }
        return columnWidth;
    }

    protected boolean isColumnPrintRepeatedDetailValues(DRIValueColumn<?> column) {
        if (column.getPrintRepeatedDetailValues() != null) {
            return column.getPrintRepeatedDetailValues();
        }
        if (this.template.getColumnPrintRepeatedDetailValues() != null) {
            return this.template.getColumnPrintRepeatedDetailValues();
        }
        return Defaults.getDefaults().isColumnPrintRepeatedDetailValues();
    }

    protected int getColumnWidth(DRIColumn<?> column, DRDesignStyle style) throws DRException {
        DRIComponent component = this.accessor.getColumnTransform().getColumnComponent(column);
        if (component != null) {
            if (component instanceof DRIList) {
                DRDesignList list = this.accessor.getComponentTransform().list((DRIList)component, DefaultStyleType.COLUMN, null, null);
                return this.detectWidth(list);
            }
            if (component instanceof DRIDimensionComponent) {
                if (((DRIDimensionComponent)component).getWidth() != null) {
                    return ((DRIDimensionComponent)component).getWidth();
                }
                if (component instanceof DRITextField && ((DRITextField)component).getColumns() != null) {
                    return StyleResolver.getFontWidth(style, ((DRITextField)component).getColumns());
                }
            } else {
                throw new DRDesignReportException("Component " + component.getClass().getName() + " not supported");
            }
        }
        return this.getColumnWidth();
    }

    protected int getColumnWidth() {
        if (this.template.getColumnWidth() != null) {
            return this.template.getColumnWidth();
        }
        return Defaults.getDefaults().getColumnWidth();
    }

    protected boolean getRemoveLineWhenBlank(DRIComponent component) {
        if (component.getRemoveLineWhenBlank() != null) {
            return component.getRemoveLineWhenBlank();
        }
        return Defaults.getDefaults().isRemoveLineWhenBlank();
    }

    protected ComponentPositionType getPositionType(DRIComponent component) {
        if (component instanceof DRIDimensionComponent && ((DRIDimensionComponent)component).getPositionType() != null) {
            return ((DRIDimensionComponent)component).getPositionType();
        }
        return null;
    }

    protected StretchType getStretchType(DRIComponent component) {
        if (component instanceof DRIDimensionComponent && ((DRIDimensionComponent)component).getStretchType() != null) {
            return ((DRIDimensionComponent)component).getStretchType();
        }
        return null;
    }

    protected boolean getPrintInFirstWholeBand(DRIComponent component) {
        if (component instanceof DRIDimensionComponent && ((DRIDimensionComponent)component).getPrintInFirstWholeBand() != null) {
            return ((DRIDimensionComponent)component).getPrintInFirstWholeBand();
        }
        return Defaults.getDefaults().isPrintInFirstWholeBand();
    }

    protected boolean getPrintWhenDetailOverflows(DRIComponent component) {
        if (component instanceof DRIDimensionComponent && ((DRIDimensionComponent)component).getPrintWhenDetailOverflows() != null) {
            return ((DRIDimensionComponent)component).getPrintWhenDetailOverflows();
        }
        return Defaults.getDefaults().isPrintWhenDetailOverflows();
    }

    protected DRIDesignGroup getPrintWhenGroupChanges(DRIComponent component) {
        if (component instanceof DRIDimensionComponent && ((DRIDimensionComponent)component).getPrintWhenGroupChanges() != null) {
            return this.accessor.getGroupTransform().getGroup(((DRIDimensionComponent)component).getPrintWhenGroupChanges());
        }
        return null;
    }

    protected GroupHeaderLayout getGroupHeaderLayout(DRIGroup group) {
        if (group.getHeaderLayout() != null) {
            return group.getHeaderLayout();
        }
        if (this.template.getGroupHeaderLayout() != null) {
            return this.template.getGroupHeaderLayout();
        }
        return Defaults.getDefaults().getGroupHeaderLayout();
    }

    protected boolean isGroupHideColumn(DRIGroup group) {
        if (group.getHideColumn() != null) {
            return group.getHideColumn();
        }
        if (this.template.getGroupHideColumn() != null) {
            return this.template.getGroupHideColumn();
        }
        return Defaults.getDefaults().isGroupHideColumn();
    }

    protected boolean isGroupShowColumnHeaderAndFooter(DRIGroup group) {
        if (group.getShowColumnHeaderAndFooter() != null) {
            return group.getShowColumnHeaderAndFooter();
        }
        if (this.template.getGroupShowColumnHeaderAndFooter() != null) {
            return this.template.getGroupShowColumnHeaderAndFooter();
        }
        return Defaults.getDefaults().isGroupShowColumnHeaderAndFooter();
    }

    protected int getGroupPadding(DRIGroup group) {
        if (group.getPadding() != null) {
            return group.getPadding();
        }
        if (this.template.getGroupPadding() != null) {
            return this.template.getGroupPadding();
        }
        return Defaults.getDefaults().getGroupPadding();
    }

    protected boolean isGroupStartInNewPage(DRIGroup group) {
        if (group.getStartInNewPage() != null) {
            return group.getStartInNewPage();
        }
        if (this.template.getGroupStartInNewPage() != null) {
            return this.template.getGroupStartInNewPage();
        }
        return Defaults.getDefaults().isGroupStartInNewPage();
    }

    protected boolean isGroupStartInNewColumn(DRIGroup group) {
        if (group.getStartInNewColumn() != null) {
            return group.getStartInNewColumn();
        }
        if (this.template.getGroupStartInNewColumn() != null) {
            return this.template.getGroupStartInNewColumn();
        }
        return Defaults.getDefaults().isGroupStartInNewColumn();
    }

    protected boolean isGroupReprintHeaderOnEachPage(DRIGroup group) {
        if (group.getReprintHeaderOnEachPage() != null) {
            return group.getReprintHeaderOnEachPage();
        }
        if (this.template.getGroupReprintHeaderOnEachPage() != null) {
            return this.template.getGroupReprintHeaderOnEachPage();
        }
        return Defaults.getDefaults().isGroupReprintHeaderOnEachPage();
    }

    protected boolean isGroupResetPageNumber(DRIGroup group) {
        if (group.getResetPageNumber() != null) {
            return group.getResetPageNumber();
        }
        if (this.template.getGroupResetPageNumber() != null) {
            return this.template.getGroupResetPageNumber();
        }
        return Defaults.getDefaults().isGroupResetPageNumber();
    }

    protected Integer getGroupMinHeightToStartNewPage(DRIGroup group) {
        if (group.getMinHeightToStartNewPage() != null) {
            return group.getMinHeightToStartNewPage();
        }
        return Defaults.getDefaults().getGroupMinHeightToStartNewPage();
    }

    protected GroupFooterPosition getGroupFooterPosition(DRIGroup group) {
        if (group.getFooterPosition() != null) {
            return group.getFooterPosition();
        }
        if (this.template.getGroupFooterPosition() != null) {
            return this.template.getGroupFooterPosition();
        }
        return Defaults.getDefaults().getGroupFooterPosition();
    }

    protected boolean isGroupKeepTogether(DRIGroup group) {
        if (group.getKeepTogether() != null) {
            return group.getKeepTogether();
        }
        if (this.template.getGroupKeepTogether() != null) {
            return this.template.getGroupKeepTogether();
        }
        return Defaults.getDefaults().isGroupKeepTogether();
    }

    protected boolean isGroupHeaderWithSubtotal(DRIGroup group) {
        if (group.getHeaderWithSubtotal() != null) {
            return group.getHeaderWithSubtotal();
        }
        if (this.template.getGroupHeaderWithSubtotal() != null) {
            return this.template.getGroupHeaderWithSubtotal();
        }
        return Defaults.getDefaults().isGroupHeaderWithSubtotal();
    }

    protected boolean isGroupByDataType(DRIGroup group) {
        if (group.getGroupByDataType() != null) {
            return group.getGroupByDataType();
        }
        return Defaults.getDefaults().isGroupByDataType();
    }

    public Position getSubtotalLabelPosition(DRISubtotal<?> subtotal) {
        if (subtotal.getLabelPosition() != null) {
            return subtotal.getLabelPosition();
        }
        if (this.template.getSubtotalLabelPosition() != null) {
            return this.template.getSubtotalLabelPosition();
        }
        return Defaults.getDefaults().getSubtotalLabelPosition();
    }

    protected int getTextFieldWidth(DRITextField<?> textField, DRDesignStyle style) {
        if (textField.getWidth() != null) {
            return textField.getWidth();
        }
        if (textField.getColumns() != null) {
            return StyleResolver.getFontWidth(style, textField.getColumns());
        }
        if (this.template.getTextFieldWidth() != null) {
            return this.template.getTextFieldWidth();
        }
        return Defaults.getDefaults().getTextFieldWidth();
    }

    protected int getTextFieldHeight(DRITextField<?> textField, DRDesignStyle style) {
        if (textField.getHeight() != null) {
            return textField.getHeight();
        }
        if (textField.getRows() != null) {
            return StyleResolver.getFontHeight(style, textField.getRows());
        }
        return StyleResolver.getFontHeight(style, 1);
    }

    protected String getTextFieldPattern(DRITextField<?> textField, DRDesignStyle style) {
        if (textField.getPattern() != null) {
            return textField.getPattern();
        }
        if (StyleResolver.getPattern(style) != null) {
            return null;
        }
        if (textField.getDataType() != null) {
            return textField.getDataType().getPattern();
        }
        return null;
    }

    protected HorizontalTextAlignment getTextFieldHorizontalTextAlignment(DRITextField<?> textField, DRDesignStyle style) {
        if (textField.getHorizontalTextAlignment() != null) {
            return textField.getHorizontalTextAlignment();
        }
        if (StyleResolver.getHorizontalTextAlignment(style) != null) {
            return null;
        }
        if (textField.getDataType() != null) {
            return textField.getDataType().getHorizontalTextAlignment();
        }
        return null;
    }

    protected DRIValueFormatter<?, ?> getTextFieldValueFormatter(DRITextField<?> textField) {
        if (textField.getValueFormatter() != null) {
            return textField.getValueFormatter();
        }
        if (textField.getDataType() != null) {
            return textField.getDataType().getValueFormatter();
        }
        return null;
    }

    protected boolean getTextFieldStretchWithOverflow(DRITextField<?> textField) {
        if (textField.getStretchWithOverflow() != null) {
            return textField.getStretchWithOverflow();
        }
        return Defaults.getDefaults().isTextFieldStretchWithOverflow();
    }

    protected boolean isTextFieldPrintRepeatedValues(DRITextField<?> textField) {
        if (textField.getPrintRepeatedValues() != null) {
            return textField.getPrintRepeatedValues();
        }
        return Defaults.getDefaults().isTextFieldPrintRepeatedValues();
    }

    protected int getBooleanFieldWidth(DRIBooleanField booleanField, DRDesignStyle style) {
        if (booleanField.getWidth() != null) {
            return booleanField.getWidth();
        }
        if (this.template.getTextFieldWidth() != null) {
            return this.template.getTextFieldWidth();
        }
        return Defaults.getDefaults().getTextFieldWidth();
    }

    protected int getBooleanFieldHeight(DRIBooleanField booleanField, DRDesignStyle style) {
        if (booleanField.getHeight() != null) {
            return booleanField.getHeight();
        }
        return StyleResolver.getFontHeight(style, 1);
    }

    protected int getPageXofYWidth(DRIPageXofY pageXofY) {
        if (pageXofY.getWidth() != null) {
            return pageXofY.getWidth();
        }
        if (this.template.getTextFieldWidth() != null) {
            return this.template.getTextFieldWidth();
        }
        return Defaults.getDefaults().getTextFieldWidth();
    }

    protected int getPageXofYHeight(DRIPageXofY pageXofY, DRDesignStyle style) {
        if (pageXofY.getHeight() != null) {
            return pageXofY.getHeight();
        }
        return StyleResolver.getFontHeight(style, 1);
    }

    protected HorizontalTextAlignment getPageXofYHorizontalTextAlignment(DRIPageXofY pageXofY, DRDesignStyle style) {
        if (pageXofY.getHorizontalTextAlignment() != null) {
            return pageXofY.getHorizontalTextAlignment();
        }
        if (StyleResolver.getHorizontalTextAlignment(style) != null) {
            return StyleResolver.getHorizontalTextAlignment(style);
        }
        return Defaults.getDefaults().getPageXofYHorizontalTextAlignment();
    }

    protected int getImageWidth(DRIImage image) {
        if (image.getWidth() != null) {
            return image.getWidth();
        }
        if (this.template.getImageWidth() != null) {
            return this.template.getImageWidth();
        }
        return Defaults.getDefaults().getImageWidth();
    }

    protected int getImageHeight(DRIImage image, Integer imageHeight, DRDesignStyle style) {
        if (image.getHeight() != null) {
            return image.getHeight();
        }
        if (imageHeight != null) {
            return imageHeight + StyleResolver.getVerticalPadding(style);
        }
        if (this.template.getImageHeight() != null) {
            return this.template.getImageHeight();
        }
        return Defaults.getDefaults().getImageHeight();
    }

    protected int getFillerWidth(DRIFiller filler) {
        if (filler.getWidth() != null) {
            return filler.getWidth();
        }
        return Defaults.getDefaults().getFillerWidth();
    }

    protected int getFillerHeight(DRIFiller filler) {
        if (filler.getHeight() != null) {
            return filler.getHeight();
        }
        return Defaults.getDefaults().getFillerHeight();
    }

    protected int getLineWidth(DRILine line) {
        if (line.getWidth() != null) {
            return line.getWidth();
        }
        return Defaults.getDefaults().getLineWidth();
    }

    protected int getLineHeight(DRILine line) {
        if (line.getHeight() != null) {
            return line.getHeight();
        }
        return Defaults.getDefaults().getLineHeight();
    }

    protected int getEllipseWidth(DRIEllipse ellipse) {
        if (ellipse.getWidth() != null) {
            return ellipse.getWidth();
        }
        return Defaults.getDefaults().getEllipseWidth();
    }

    protected int getEllipseHeight(DRIEllipse ellipse) {
        if (ellipse.getHeight() != null) {
            return ellipse.getHeight();
        }
        return Defaults.getDefaults().getEllipseHeight();
    }

    protected Integer getRectangleRadius(DRIRectangle rectangle) {
        if (rectangle.getRadius() != null) {
            return rectangle.getRadius();
        }
        return Defaults.getDefaults().getRectangleRadius();
    }

    protected int getRectangleWidth(DRIRectangle rectangle) {
        if (rectangle.getWidth() != null) {
            return rectangle.getWidth();
        }
        return Defaults.getDefaults().getRectangleWidth();
    }

    protected int getRectangleHeight(DRIRectangle rectangle) {
        if (rectangle.getHeight() != null) {
            return rectangle.getHeight();
        }
        return Defaults.getDefaults().getRectangleHeight();
    }

    protected int getMapWidth(DRIMap map) {
        if (map.getWidth() != null) {
            return map.getWidth();
        }
        return Defaults.getDefaults().getMapWidth();
    }

    protected int getMapHeight(DRIMap map) {
        if (map.getHeight() != null) {
            return map.getHeight();
        }
        return Defaults.getDefaults().getMapHeight();
    }

    protected int getCustomComponentWidth(DRIDimensionComponent component) {
        if (component.getWidth() != null) {
            return component.getWidth();
        }
        return Defaults.getDefaults().getCustomComponentWidth();
    }

    protected int getCustomComponentHeight(DRIDimensionComponent component) {
        if (component.getHeight() != null) {
            return component.getHeight();
        }
        return Defaults.getDefaults().getCustomComponentHeight();
    }

    protected int getBreakWidth(DRIBreak breakComponent) {
        return Defaults.getDefaults().getBreakWidth();
    }

    protected int getBreakHeight(DRIBreak breakComponent) {
        return Defaults.getDefaults().getBreakHeight();
    }

    protected Integer getGenericElementWidth(DRIGenericElement genericElement) {
        if (genericElement.getWidth() != null) {
            return genericElement.getWidth();
        }
        return Defaults.getDefaults().getGenericElementWidth();
    }

    protected Integer getGenericElementHeight(DRIGenericElement genericElement) {
        if (genericElement.getHeight() != null) {
            return genericElement.getHeight();
        }
        return Defaults.getDefaults().getGenericElementHeight();
    }

    protected Integer getListWidth(DRIList list) {
        if (list.getWidth() != null) {
            return list.getWidth();
        }
        return Defaults.getDefaults().getListWidth();
    }

    protected Integer getListHeight(DRIList list) {
        if (list.getHeight() != null) {
            return list.getHeight();
        }
        return Defaults.getDefaults().getListHeight();
    }

    protected int getListGap(DRIList list) {
        if (list.getGap() != null) {
            return list.getGap();
        }
        if (this.template.getListgap() != null) {
            return this.template.getListgap();
        }
        return Defaults.getDefaults().getListgap();
    }

    protected Integer getXyListWidth(DRIXyList xyList) {
        if (xyList.getWidth() != null) {
            return xyList.getWidth();
        }
        return Defaults.getDefaults().getListWidth();
    }

    protected Integer getXyListHeight(DRIXyList xyList) {
        if (xyList.getHeight() != null) {
            return xyList.getHeight();
        }
        return Defaults.getDefaults().getListHeight();
    }

    protected int getMultiPageListWidth(DRIMultiPageList multiPageList) {
        if (multiPageList.getWidth() != null) {
            return multiPageList.getWidth();
        }
        if (this.template.getMultiPageListWidth() != null) {
            return this.template.getMultiPageListWidth();
        }
        return Defaults.getDefaults().getMultiPageListWidth();
    }

    protected int getMultiPageListHeight(DRIMultiPageList multiPageList) {
        if (multiPageList.getHeight() != null) {
            return multiPageList.getHeight();
        }
        if (this.template.getMultiPageListHeight() != null) {
            return this.template.getMultiPageListHeight();
        }
        return Defaults.getDefaults().getMultiPageListHeight();
    }

    protected int getChartWidth(DRIChart chart) {
        if (chart.getWidth() != null) {
            return chart.getWidth();
        }
        if (this.template.getChartWidth() != null) {
            return this.template.getChartWidth();
        }
        return Defaults.getDefaults().getChartWidth();
    }

    protected int getChartHeight(DRIChart chart) {
        if (chart.getHeight() != null) {
            return chart.getHeight();
        }
        if (this.template.getChartHeight() != null) {
            return this.template.getChartHeight();
        }
        return Defaults.getDefaults().getChartHeight();
    }

    protected List<Color> getChartSeriesColors(DRIBasePlot plot) {
        if (plot.getSeriesColors() != null && !plot.getSeriesColors().isEmpty()) {
            return plot.getSeriesColors();
        }
        if (this.template.getChartSeriesColors() != null && !this.template.getChartSeriesColors().isEmpty()) {
            return this.template.getChartSeriesColors();
        }
        return Defaults.getDefaults().getChartSeriesColors();
    }

    protected String getChartValuePattern(DRIAxisPlot axisPlot) {
        if (axisPlot.getValuePattern() != null) {
            return axisPlot.getValuePattern();
        }
        if (this.template.getChartValuePattern() != null) {
            return this.template.getChartValuePattern();
        }
        return Defaults.getDefaults().getChartValuePattern();
    }

    protected String getChartValuePattern(DRIPiePlot piePlot) {
        if (piePlot.getValuePattern() != null) {
            return piePlot.getValuePattern();
        }
        if (this.template.getChartValuePattern() != null) {
            return this.template.getChartValuePattern();
        }
        return Defaults.getDefaults().getChartValuePattern();
    }

    protected String getChartPercentValuePattern(DRIAxisPlot axisPlot) {
        if (axisPlot.getPercentValuePattern() != null) {
            return axisPlot.getPercentValuePattern();
        }
        if (this.template.getChartPercentValuePattern() != null) {
            return this.template.getChartPercentValuePattern();
        }
        return Defaults.getDefaults().getChartPercentValuePattern();
    }

    protected String getChartPercentValuePattern(DRIPiePlot piePlot) {
        if (piePlot.getPercentValuePattern() != null) {
            return piePlot.getPercentValuePattern();
        }
        if (this.template.getChartPercentValuePattern() != null) {
            return this.template.getChartPercentValuePattern();
        }
        return Defaults.getDefaults().getChartPercentValuePattern();
    }

    protected boolean isChartCategoryDatasetUseSeriesAsCategory(DRICategoryDataset dataset) {
        if (dataset.getUseSeriesAsCategory() != null) {
            return dataset.getUseSeriesAsCategory();
        }
        return Defaults.getDefaults().isChartCategoryDatasetUseSeriesAsCategory();
    }

    protected TimePeriod getChartTimeSeriesDatasetTimePeriodType(DRITimeSeriesDataset dataset) {
        if (dataset.getTimePeriodType() != null) {
            return dataset.getTimePeriodType();
        }
        return Defaults.getDefaults().getChartTimeSeriesDatasetTimePeriodType();
    }

    protected ValueLocation getChartThermometerPlotValueLocation(DRIThermometerPlot plot) {
        if (plot.getValueLocation() != null) {
            return plot.getValueLocation();
        }
        return Defaults.getDefaults().getChartThermometerPlotValueLocation();
    }

    protected String getChartTheme(DRIChart chart) {
        if (chart.getTheme() != null) {
            return chart.getTheme();
        }
        if (this.template.getChartTheme() != null) {
            return this.template.getChartTheme();
        }
        return Defaults.getDefaults().getChartTheme();
    }

    protected int getBarcodeWidth(DRIBarcode barcode) {
        if (barcode.getWidth() != null) {
            return barcode.getWidth();
        }
        if (this.template.getBarcodeWidth() != null) {
            return this.template.getBarcodeWidth();
        }
        return Defaults.getDefaults().getBarcodeWidth();
    }

    protected int getBarcodeHeight(DRIBarcode barcode) {
        if (barcode.getHeight() != null) {
            return barcode.getHeight();
        }
        if (this.template.getBarcodeHeight() != null) {
            return this.template.getBarcodeHeight();
        }
        return Defaults.getDefaults().getBarcodeHeight();
    }

    protected int getBarbecueWidth(DRIBarbecue barbecue) {
        if (barbecue.getWidth() != null) {
            return barbecue.getWidth();
        }
        if (this.template.getBarcodeWidth() != null) {
            return this.template.getBarcodeWidth();
        }
        return Defaults.getDefaults().getBarcodeWidth();
    }

    protected int getBarbecueHeight(DRIBarbecue barbecue) {
        if (barbecue.getHeight() != null) {
            return barbecue.getHeight();
        }
        if (this.template.getBarcodeHeight() != null) {
            return this.template.getBarcodeHeight();
        }
        return Defaults.getDefaults().getBarcodeHeight();
    }

    protected int getSubreportWidth(DRISubreport subreport) {
        if (subreport.getWidth() != null) {
            return subreport.getWidth();
        }
        if (this.template.getSubreportWidth() != null) {
            return this.template.getSubreportWidth();
        }
        return Defaults.getDefaults().getSubreportWidth();
    }

    protected int getSubreportHeight(DRISubreport subreport) {
        if (subreport.getHeight() != null) {
            return subreport.getHeight();
        }
        if (this.template.getSubreportHeight() != null) {
            return this.template.getSubreportHeight();
        }
        return Defaults.getDefaults().getSubreportHeight();
    }

    protected int getCrosstabWidth(DRICrosstab crosstab) {
        if (crosstab.getWidth() != null) {
            return crosstab.getWidth();
        }
        if (this.template.getCrosstabWidth() != null) {
            return this.template.getCrosstabWidth();
        }
        return Defaults.getDefaults().getCrosstabWidth();
    }

    protected int getCrosstabHeight(DRICrosstab crosstab, DRDesignCrosstabCellContent whenNoDataCell) {
        int height = crosstab.getHeight() != null ? crosstab.getHeight() : (this.template.getCrosstabHeight() != null ? this.template.getCrosstabHeight().intValue() : Defaults.getDefaults().getCrosstabHeight());
        int whenNoDataCellHeight = this.getCrosstabWhenNoDataCellHeight(whenNoDataCell);
        if (height == 0 && whenNoDataCellHeight > 0) {
            return whenNoDataCellHeight;
        }
        return height;
    }

    public CrosstabTotalPosition getCrosstabColumnGroupTotalPosition(DRICrosstabColumnGroup<?> columnGroup) {
        if (!this.isCrosstabColumnGroupShowTotal(columnGroup)) {
            return null;
        }
        if (columnGroup.getTotalPosition() != null) {
            return columnGroup.getTotalPosition();
        }
        return Defaults.getDefaults().getCrosstabColumnGroupTotalPosition();
    }

    public CrosstabTotalPosition getCrosstabRowGroupTotalPosition(DRICrosstabRowGroup<?> rowGroup) {
        if (!this.isCrosstabRowGroupShowTotal(rowGroup)) {
            return null;
        }
        if (rowGroup.getTotalPosition() != null) {
            return rowGroup.getTotalPosition();
        }
        return Defaults.getDefaults().getCrosstabRowGroupTotalPosition();
    }

    public boolean isCrosstabColumnGroupShowTotal(DRICrosstabColumnGroup<?> columnGroup) {
        if (columnGroup.getShowTotal() != null) {
            return columnGroup.getShowTotal();
        }
        return Defaults.getDefaults().isCrosstabColumnGroupShowTotal();
    }

    public boolean isCrosstabRowGroupShowTotal(DRICrosstabRowGroup<?> rowGroup) {
        if (rowGroup.getShowTotal() != null) {
            return rowGroup.getShowTotal();
        }
        return Defaults.getDefaults().isCrosstabRowGroupShowTotal();
    }

    public int getCrosstabColumnGroupHeaderHeight(DRICrosstabColumnGroup<?> columnGroup, DRDesignCrosstab designCrosstab, int availableHeight) {
        if (columnGroup.getHeaderHeight() != null) {
            return columnGroup.getHeaderHeight();
        }
        int maxHeight = 0;
        for (DRDesignCrosstabColumnGroup designColumnGroup : designCrosstab.getColumnGroups()) {
            if (!designColumnGroup.getName().equals(columnGroup.getName())) continue;
            int height = this.detectHeight(designColumnGroup.getHeader().getList());
            if (maxHeight < height) {
                maxHeight = height;
            }
            if (designColumnGroup.getTotalHeader() == null || maxHeight >= (height = this.detectHeight(designColumnGroup.getTotalHeader().getList())) || height <= availableHeight) break;
            maxHeight = height;
            break;
        }
        return maxHeight;
    }

    public int getCrosstabColumnGroupTotalHeaderWidth(DRICrosstabColumnGroup<?> columnGroup, Integer cellWidth, DRDesignCrosstab designCrosstab) {
        int height;
        if (columnGroup.getTotalHeaderWidth() != null) {
            return columnGroup.getTotalHeaderWidth();
        }
        if (cellWidth != null) {
            return cellWidth;
        }
        int maxWidth = 0;
        for (DRDesignCrosstabColumnGroup designColumnGroup : designCrosstab.getColumnGroups()) {
            if (!designColumnGroup.getName().equals(columnGroup.getName())) continue;
            if (designColumnGroup.getTotalHeader() == null || maxWidth >= (height = this.detectWidth(designColumnGroup.getTotalHeader().getList()))) break;
            maxWidth = height;
            break;
        }
        for (DRDesignCrosstabCell designCell : designCrosstab.getCells()) {
            if (designCell.getColumnTotalGroup() != columnGroup.getName() || maxWidth >= (height = this.detectWidth(designCell.getContent().getList()))) continue;
            maxWidth = height;
        }
        if (maxWidth > Defaults.getDefaults().getCrosstabColumnGroupTotalHeaderMaxWidth()) {
            return Defaults.getDefaults().getCrosstabColumnGroupTotalHeaderMaxWidth();
        }
        return maxWidth;
    }

    public int getCrosstabRowGroupHeaderWidth(DRICrosstabRowGroup<?> rowGroup, DRDesignCrosstab designCrosstab) {
        if (rowGroup.getHeaderWidth() != null) {
            return rowGroup.getHeaderWidth();
        }
        int maxWidth = 0;
        for (DRDesignCrosstabRowGroup designRowGroup : designCrosstab.getRowGroups()) {
            if (!designRowGroup.getName().equals(rowGroup.getName())) continue;
            int width = this.detectWidth(designRowGroup.getHeader().getList());
            if (maxWidth < width) {
                maxWidth = width;
            }
            if (designRowGroup.getTotalHeader() == null || maxWidth >= (width = this.detectWidth(designRowGroup.getTotalHeader().getList()))) break;
            maxWidth = width;
            break;
        }
        if (maxWidth > Defaults.getDefaults().getCrosstabRowGroupHeaderMaxWidth()) {
            return Defaults.getDefaults().getCrosstabRowGroupHeaderMaxWidth();
        }
        return maxWidth;
    }

    public int getCrosstabRowGroupTotalHeaderHeight(DRICrosstabRowGroup<?> rowGroup, Integer cellHeight, DRDesignCrosstab designCrosstab) {
        int height;
        if (rowGroup.getTotalHeaderHeight() != null) {
            return rowGroup.getTotalHeaderHeight();
        }
        if (cellHeight != null) {
            return cellHeight;
        }
        int maxHeight = 0;
        for (DRDesignCrosstabRowGroup designRowGroup : designCrosstab.getRowGroups()) {
            if (!designRowGroup.getName().equals(rowGroup.getName())) continue;
            if (designRowGroup.getTotalHeader() == null || maxHeight >= (height = this.detectHeight(designRowGroup.getTotalHeader().getList()))) break;
            maxHeight = height;
            break;
        }
        for (DRDesignCrosstabCell designCell : designCrosstab.getCells()) {
            if (designCell.getRowTotalGroup() != rowGroup.getName() || maxHeight >= (height = this.detectHeight(designCell.getContent().getList()))) continue;
            maxHeight = height;
        }
        return maxHeight;
    }

    public int getCrosstabCellWidth(DRICrosstab crosstab, DRDesignCrosstab designCrosstab) {
        int width;
        if (crosstab.getCellWidth() != null) {
            return crosstab.getCellWidth();
        }
        int maxWidth = 0;
        for (DRDesignCrosstabCell designCell : designCrosstab.getCells()) {
            if (designCell.getColumnTotalGroup() != null || maxWidth >= (width = this.detectWidth(designCell.getContent().getList()))) continue;
            maxWidth = width;
        }
        for (DRDesignCrosstabColumnGroup designColumnGroup : designCrosstab.getColumnGroups()) {
            width = this.detectWidth(designColumnGroup.getHeader().getList());
            if (maxWidth >= width) continue;
            maxWidth = width;
        }
        if (maxWidth > Defaults.getDefaults().getCrosstabCellMaxWidth()) {
            return Defaults.getDefaults().getCrosstabCellMaxWidth();
        }
        return maxWidth;
    }

    public int getCrosstabCellHeight(DRICrosstab crosstab, DRDesignCrosstab designCrosstab) {
        int height;
        if (crosstab.getCellHeight() != null) {
            return crosstab.getCellHeight();
        }
        int maxHeight = 0;
        for (DRDesignCrosstabCell designCell : designCrosstab.getCells()) {
            if (designCell.getRowTotalGroup() != null || maxHeight >= (height = this.detectHeight(designCell.getContent().getList()))) continue;
            maxHeight = height;
        }
        for (DRDesignCrosstabRowGroup designRowGroup : designCrosstab.getRowGroups()) {
            height = this.detectHeight(designRowGroup.getHeader().getList());
            if (maxHeight >= height) continue;
            maxHeight = height;
        }
        return maxHeight;
    }

    public int getCrosstabWhenNoDataCellHeight(DRDesignCrosstabCellContent whenNoDataCell) {
        return this.detectHeight(whenNoDataCell.getList());
    }

    protected DRISimpleStyle getCrosstabOddRowStyle(DRICrosstab crosstab) {
        if (this.isCrosstabHighlightOddRows(crosstab)) {
            if (crosstab.getOddRowStyle() != null) {
                return crosstab.getOddRowStyle();
            }
            if (this.template.getCrosstabOddRowStyle() != null) {
                return this.template.getCrosstabOddRowStyle();
            }
            return Defaults.getDefaults().getCrosstabOddRowStyle();
        }
        return null;
    }

    protected DRISimpleStyle getCrosstabEvenRowStyle(DRICrosstab crosstab) {
        if (this.isCrosstabHighlightEvenRows(crosstab)) {
            if (crosstab.getEvenRowStyle() != null) {
                return crosstab.getEvenRowStyle();
            }
            if (this.template.getCrosstabEvenRowStyle() != null) {
                return this.template.getCrosstabEvenRowStyle();
            }
            return Defaults.getDefaults().getCrosstabEvenRowStyle();
        }
        return null;
    }

    private boolean isCrosstabHighlightOddRows(DRICrosstab crosstab) {
        if (crosstab.getHighlightOddRows() != null) {
            return crosstab.getHighlightOddRows();
        }
        if (this.template.getCrosstabHighlightOddRows() != null) {
            return this.template.getCrosstabHighlightOddRows();
        }
        return Defaults.getDefaults().isCrosstabHighlightOddRows();
    }

    private boolean isCrosstabHighlightEvenRows(DRICrosstab crosstab) {
        if (crosstab.getHighlightEvenRows() != null) {
            return crosstab.getHighlightEvenRows();
        }
        if (this.template.getCrosstabHighlightEvenRows() != null) {
            return this.template.getCrosstabHighlightEvenRows();
        }
        return Defaults.getDefaults().isCrosstabHighlightEvenRows();
    }

    protected DRIReportStyle getCrosstabGroupStyle(DRICrosstab crosstab) {
        if (crosstab.getGroupStyle() != null) {
            return crosstab.getGroupStyle();
        }
        if (this.template.getCrosstabGroupStyle() != null) {
            return this.template.getCrosstabGroupStyle();
        }
        if (Defaults.getDefaults().getCrosstabGroupStyle() != null) {
            return Defaults.getDefaults().getCrosstabGroupStyle();
        }
        return this.getTextStyle();
    }

    protected DRIReportStyle getCrosstabGroupTotalStyle(DRICrosstab crosstab) {
        if (crosstab.getGroupTotalStyle() != null) {
            return crosstab.getGroupTotalStyle();
        }
        if (this.template.getCrosstabGroupTotalStyle() != null) {
            return this.template.getCrosstabGroupTotalStyle();
        }
        if (Defaults.getDefaults().getCrosstabGroupTotalStyle() != null) {
            return Defaults.getDefaults().getCrosstabGroupTotalStyle();
        }
        return this.getTextStyle();
    }

    protected DRIReportStyle getCrosstabGrandTotalStyle(DRICrosstab crosstab) {
        if (crosstab.getGrandTotalStyle() != null) {
            return crosstab.getGrandTotalStyle();
        }
        if (this.template.getCrosstabGrandTotalStyle() != null) {
            return this.template.getCrosstabGrandTotalStyle();
        }
        if (Defaults.getDefaults().getCrosstabGrandTotalStyle() != null) {
            return Defaults.getDefaults().getCrosstabGrandTotalStyle();
        }
        return this.getTextStyle();
    }

    protected DRIReportStyle getCrosstabCellStyle(DRICrosstab crosstab) {
        if (crosstab.getCellStyle() != null) {
            return crosstab.getCellStyle();
        }
        if (this.template.getCrosstabCellStyle() != null) {
            return this.template.getCrosstabCellStyle();
        }
        if (Defaults.getDefaults().getCrosstabCellStyle() != null) {
            return Defaults.getDefaults().getCrosstabCellStyle();
        }
        return this.getTextStyle();
    }

    public DRIReportStyle getCrosstabMeasureTitleStyle(DRICrosstab crosstab, DRICrosstabMeasure<?> measure) {
        if (measure.getTitleStyle() != null) {
            return measure.getTitleStyle();
        }
        if (crosstab.getMeasureTitleStyle() != null) {
            return crosstab.getMeasureTitleStyle();
        }
        if (this.template.getCrosstabMeasureTitleStyle() != null) {
            return this.template.getCrosstabMeasureTitleStyle();
        }
        return Defaults.getDefaults().getCrosstabMeasureTitleStyle();
    }

    protected CrosstabPercentageType getCrosstabPercentageType(DRICrosstabVariable<?> variable) {
        if (variable.getPercentageType() != null) {
            return variable.getPercentageType();
        }
        return Defaults.getDefaults().getCrosstabPercentageType();
    }

    public BooleanComponentType getBooleanComponentType(DRIBooleanField booleanField) {
        if (booleanField.getComponentType() != null) {
            return booleanField.getComponentType();
        }
        if (this.template.getBooleanComponentType() != null) {
            return this.template.getBooleanComponentType();
        }
        return Defaults.getDefaults().getBooleanComponentType();
    }

    public boolean getBooleanEmptyWhenNullValue(DRIBooleanField booleanField) {
        if (booleanField.getEmptyWhenNullValue() != null) {
            return booleanField.getEmptyWhenNullValue();
        }
        if (this.template.getBooleanEmptyWhenNullValue() != null) {
            return this.template.getBooleanEmptyWhenNullValue();
        }
        return Defaults.getDefaults().isBooleanEmptyWhenNullValue();
    }

    public int getBooleanImageWidth(DRIBooleanField booleanField) {
        if (booleanField.getImageWidth() != null) {
            return booleanField.getImageWidth();
        }
        if (this.template.getBooleanImageWidth() != null) {
            return this.template.getBooleanImageWidth();
        }
        return Defaults.getDefaults().getBooleanImageWidth();
    }

    public int getBooleanImageHeight(DRIBooleanField booleanField) {
        if (booleanField.getImageHeight() != null) {
            return booleanField.getImageHeight();
        }
        if (this.template.getBooleanImageHeight() != null) {
            return this.template.getBooleanImageHeight();
        }
        return Defaults.getDefaults().getBooleanImageHeight();
    }

    protected HorizontalImageAlignment getBooleanHorizontalImageAlignment(DRIBooleanField booleanField, DRDesignStyle style) {
        if (booleanField.getHorizontalImageAlignment() != null) {
            return booleanField.getHorizontalImageAlignment();
        }
        if (StyleResolver.getHorizontalImageAlignment(style) != null) {
            return null;
        }
        return Defaults.getDefaults().getBooleanHorizontalImageAlignment();
    }

    public DRIReportStyle getBooleanColumnStyle(DRIBooleanColumn column) {
        if (((DRIBooleanField)column.getComponent()).getStyle() != null) {
            return ((DRIBooleanField)column.getComponent()).getStyle();
        }
        if (this.template.getBooleanColumnStyle() != null) {
            return this.template.getBooleanColumnStyle();
        }
        return Defaults.getDefaults().getBooleanColumnStyle();
    }

    public Map<String, DRIStyle> getTemplateStyles() {
        HashMap<String, DRIStyle> templateStyles = new HashMap<String, DRIStyle>();
        for (DRIStyle style : this.template.getTemplateStyles()) {
            templateStyles.put(style.getName(), style);
        }
        for (DRIStyle style : this.report.getTemplateStyles()) {
            templateStyles.put(style.getName(), style);
        }
        return templateStyles;
    }

    protected SplitType getTitleSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getTitleSplitType(), Defaults.getDefaults().getTitleSplitType());
    }

    protected SplitType getPageHeaderSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getPageHeaderSplitType(), Defaults.getDefaults().getPageHeaderSplitType());
    }

    protected SplitType getPageFooterSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getPageFooterSplitType(), Defaults.getDefaults().getPageFooterSplitType());
    }

    protected SplitType getColumnHeaderSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getColumnHeaderSplitType(), Defaults.getDefaults().getColumnHeaderSplitType());
    }

    protected SplitType getColumnFooterSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getColumnFooterSplitType(), Defaults.getDefaults().getColumnFooterSplitType());
    }

    protected SplitType getGroupHeaderSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getGroupHeaderSplitType(), Defaults.getDefaults().getGroupHeaderSplitType());
    }

    protected SplitType getGroupFooterSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getGroupFooterSplitType(), Defaults.getDefaults().getGroupFooterSplitType());
    }

    protected SplitType getDetailHeaderSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getDetailHeaderSplitType(), Defaults.getDefaults().getDetailHeaderSplitType());
    }

    protected SplitType getDetailSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getDetailSplitType(), Defaults.getDefaults().getDetailSplitType());
    }

    protected SplitType getDetailFooterSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getDetailFooterSplitType(), Defaults.getDefaults().getDetailFooterSplitType());
    }

    protected SplitType getLastPageFooterSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getLastPageFooterSplitType(), Defaults.getDefaults().getLastPageFooterSplitType());
    }

    protected SplitType getSummarySplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getSummarySplitType(), Defaults.getDefaults().getSummarySplitType());
    }

    protected SplitType getNoDataSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getNoDataSplitType(), Defaults.getDefaults().getNoDataSplitType());
    }

    protected SplitType getBackgroundSplitType(DRIBand band) {
        return this.getSplitType(band, this.template.getBackgroundSplitType(), Defaults.getDefaults().getBackgroundSplitType());
    }

    private SplitType getSplitType(DRIBand band, SplitType templateSplitType, SplitType splitType) {
        if (band.getSplitType() != null) {
            return band.getSplitType();
        }
        if (templateSplitType != null) {
            return templateSplitType;
        }
        if (splitType != null) {
            return splitType;
        }
        if (this.template.getDefaultSplitType() != null) {
            return this.template.getDefaultSplitType();
        }
        return Defaults.getDefaults().getDefaultSplitType();
    }

    protected DRIReportStyle getTitleStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getTitleStyle());
    }

    protected DRIReportStyle getPageHeaderStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getPageHeaderStyle());
    }

    protected DRIReportStyle getPageFooterStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getPageFooterStyle());
    }

    protected DRIReportStyle getColumnHeaderStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getColumnHeaderStyle());
    }

    protected DRIReportStyle getColumnFooterStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getColumnFooterStyle());
    }

    protected DRIReportStyle getGroupHeaderStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getGroupHeaderStyle());
    }

    protected DRIReportStyle getGroupFooterStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getGroupFooterStyle());
    }

    protected DRIReportStyle getDetailHeaderStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getDetailHeaderStyle());
    }

    protected DRIReportStyle getDetailStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getDetailStyle());
    }

    protected DRIReportStyle getDetailFooterStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getDetailFooterStyle());
    }

    protected DRIReportStyle getLastPageFooterStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getLastPageFooterStyle());
    }

    protected DRIReportStyle getSummaryStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getSummaryStyle());
    }

    protected DRIReportStyle getNoDataStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getNoDataStyle());
    }

    protected DRIReportStyle getBackgroundStyle(DRIBand band) {
        return this.getBandStyle(band, this.template.getBackgroundStyle());
    }

    private DRIReportStyle getBandStyle(DRIBand band, DRIReportStyle templateStyle) {
        if (band.getList().getStyle() != null) {
            return band.getList().getStyle();
        }
        if (templateStyle != null) {
            return templateStyle;
        }
        return Defaults.getDefaults().getBandStyle();
    }

    protected DRIComponent getTitleBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getTitleBackgroundComponent());
    }

    protected DRIComponent getPageHeaderBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getPageHeaderBackgroundComponent());
    }

    protected DRIComponent getPageFooterBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getPageFooterBackgroundComponent());
    }

    protected DRIComponent getColumnHeaderBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getColumnHeaderBackgroundComponent());
    }

    protected DRIComponent getColumnFooterBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getColumnFooterBackgroundComponent());
    }

    protected DRIComponent getGroupHeaderBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getGroupHeaderBackgroundComponent());
    }

    protected DRIComponent getGroupFooterBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getGroupFooterBackgroundComponent());
    }

    protected DRIComponent getDetailHeaderBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getDetailHeaderBackgroundComponent());
    }

    protected DRIComponent getDetailBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getDetailBackgroundComponent());
    }

    protected DRIComponent getDetailFooterBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getDetailFooterBackgroundComponent());
    }

    protected DRIComponent getLastPageFooterBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getLastPageFooterBackgroundComponent());
    }

    protected DRIComponent getSummaryBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getSummaryBackgroundComponent());
    }

    protected DRIComponent getNoDataBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getNoDataBackgroundComponent());
    }

    protected DRIComponent getBackgroundBackgroundComponent(DRIBand band) {
        return this.getBandBackgroundComponent(band, this.template.getBackgroundBackgroundComponent());
    }

    private DRIComponent getBandBackgroundComponent(DRIBand band, DRIComponent templateBackgroundComponent) {
        if (band.getList().getBackgroundComponent() != null) {
            return band.getList().getBackgroundComponent();
        }
        if (templateBackgroundComponent != null) {
            return templateBackgroundComponent;
        }
        return Defaults.getDefaults().getBandBackgroundComponent();
    }

    private int detectWidth(DRDesignList designList) {
        ComponentPosition.width(designList);
        return designList.getWidth();
    }

    private int detectHeight(DRDesignList designList) {
        ComponentPosition.height(designList);
        return designList.getHeight();
    }
}

